/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.PreMetricEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.orm.EbPeriodvariable;
import kd.epm.eb.common.orm.EbPeriodvariableGroupTypeEnum;
import kd.epm.eb.common.pojo.OptionPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.rule.edit.ExecuterangePojo;
import kd.epm.eb.common.rule.edit.FormulaMembPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.InvokePojo;
import kd.epm.eb.common.rule.edit.ModelPojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.rule.edit.RuleRangMemberPojo;
import kd.epm.eb.common.rule.edit.RuleRangePojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.olap.service.LeafFeature;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleJsUtils {
    private static final Log log = LogFactory.getLog(RuleJsUtils.class);

    public static RuleManageRowPojo getEmptyRuleManageRowPojo(Long modelIdLong, long bizCtrlRangeIdLong, String currentDimNumberString) {
        RuleRangePojo ruleRangePojo;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        RuleManageRowPojo ruleManageRowPojo = new RuleManageRowPojo();
        ruleManageRowPojo.setIdString(ObjUtils.getString((Object)GlobalIdUtil.genGlobalLongId()));
        ruleManageRowPojo.setEnableBoolean(Boolean.valueOf(false));
        ruleManageRowPojo.setReadOnlyBoolean(Boolean.valueOf(false));
        ArrayList<RuleRangePojo> ruleRangePojoList = new ArrayList<RuleRangePojo>(16);
        ruleManageRowPojo.setRuleRangePojoList(ruleRangePojoList);
        ruleManageRowPojo.setModelIdLongString(ObjUtils.getString((Object)modelIdLong));
        ruleManageRowPojo.setBusinessModelIdLongString(ObjUtils.getString((Object)bizCtrlRangeIdLong));
        DynamicObject businessModelDynamicObject = BusinessModelServiceHelper.getInstance().getBusinessModel(Long.valueOf(bizCtrlRangeIdLong));
        if (businessModelDynamicObject != null) {
            ruleManageRowPojo.setBusinessModelNameString(businessModelDynamicObject.getString("name"));
        }
        ruleManageRowPojo.setDimensionNumberString(currentDimNumberString);
        ruleManageRowPojo.setSelectDimensionNumberString(ruleManageRowPojo.getDimensionNumberString());
        if (!SysDimensionEnum.Account.getNumber().equals(currentDimNumberString)) {
            Dimension accountDimension = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
            ruleRangePojo = new RuleRangePojo();
            ruleRangePojo.setIdString(accountDimension.getId().toString());
            ruleRangePojo.setNameString(accountDimension.getName());
            ruleRangePojo.setNumberString(accountDimension.getNumber());
            ruleRangePojo.setNecessaryBoolean(Boolean.valueOf(true));
            ruleRangePojoList.add(ruleRangePojo);
        }
        if (!SysDimensionEnum.Metric.getNumber().equals(currentDimNumberString)) {
            Dimension metricDimension = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
            ruleRangePojo = new RuleRangePojo();
            ruleRangePojo.setIdString(metricDimension.getId().toString());
            ruleRangePojo.setNameString(metricDimension.getName());
            ruleRangePojo.setNumberString(metricDimension.getNumber());
            ruleRangePojo.setNecessaryBoolean(Boolean.valueOf(true));
            ruleRangePojoList.add(ruleRangePojo);
            RuleRangMemberPojo monkeyRuleRangMemberPojo = RuleJsUtils.getMetricMonkeyRuleRangMemberPojo(modelCacheHelper, bizCtrlRangeIdLong);
            if (monkeyRuleRangMemberPojo != null) {
                ruleRangePojo.setRuleRangMemberPojoList(Collections.singletonList(monkeyRuleRangMemberPojo));
                if (Boolean.TRUE.equals(monkeyRuleRangMemberPojo.getHasAggBoolean())) {
                    ruleManageRowPojo.setExecuterangePojoList(RuleJsUtils.getAggExecuterangePojoList());
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)ruleManageRowPojo.getExecuterangePojoList())) {
            ruleManageRowPojo.setExecuterangePojoList(RuleUtils.getExecuterangePojoList());
        }
        ruleManageRowPojo.setExecuterangeString(RuleUtils.defaultExecuterangeString(ruleManageRowPojo));
        ruleManageRowPojo.setFormulaPojoList(new ArrayList(16));
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(Long.valueOf(bizCtrlRangeIdLong));
        List dimensionOptionPojoList = dimensionList.stream().filter(item -> !SysDimensionEnum.BudgetPeriod.getNumber().equals(item.getNumber())).map(item -> {
            OptionPojo optionPojo = new OptionPojo();
            optionPojo.setLabelString(item.getName());
            optionPojo.setValueString(item.getNumber());
            return optionPojo;
        }).collect(Collectors.toList());
        ruleManageRowPojo.setDimensionOptionPojoList(dimensionOptionPojoList);
        return ruleManageRowPojo;
    }

    public static RuleRangMemberPojo getMetricMonkeyRuleRangMemberPojo(IModelCacheHelper modelCacheHelper, Long bizCtrlRangeIdLong) {
        if (modelCacheHelper == null || bizCtrlRangeIdLong == null || bizCtrlRangeIdLong == 0L) {
            return null;
        }
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        if (dimension == null) {
            return null;
        }
        Long viewIdLong = DatasetServiceHelper.getViewIdByBusModelIdOfDim((Long)bizCtrlRangeIdLong, (String)dimension.getNumber());
        Member member = modelCacheHelper.getMember(dimension.getNumber(), viewIdLong, PreMetricEnum.Money.name());
        if (member == null) {
            return null;
        }
        RuleRangMemberPojo ruleRangMemberPojo = new RuleRangMemberPojo();
        ruleRangMemberPojo.setIdString(ObjUtils.getString((Object)member.getId()));
        ruleRangMemberPojo.setNameString(member.getName());
        ruleRangMemberPojo.setNumberString(member.getNumber());
        ruleRangMemberPojo.setShowNumberString(member.getShowNumber());
        RangeEnum onlyRangeEnum = RangeEnum.ONLY;
        ruleRangMemberPojo.setScopeString(String.valueOf(onlyRangeEnum.getIndex()));
        ruleRangMemberPojo.setRangEnumNumberString(onlyRangeEnum.getNumber());
        ruleRangMemberPojo.setRangEnumNameString(onlyRangeEnum.getName());
        ruleRangMemberPojo.setHasAggBoolean(Boolean.valueOf(member.hasAgg()));
        return ruleRangMemberPojo;
    }

    public static List<ExecuterangePojo> getAggExecuterangePojoList() {
        Map<String, ExecuterangePojo> executerangePojoMap = RuleUtils.getExecuterangePojoMap();
        executerangePojoMap.get(LeafFeature.ALL.name()).setDisabledBoolean(Boolean.valueOf(true));
        executerangePojoMap.get(LeafFeature.NOTLEAF.name()).setDisabledBoolean(Boolean.valueOf(true));
        return new ArrayList<ExecuterangePojo>(executerangePojoMap.values());
    }

    public static FormulaPojo getEqualsFormulaPojo() {
        FormulaPojo equalFormulaPojo = new FormulaPojo();
        equalFormulaPojo.setTypeString("text");
        equalFormulaPojo.setValueString("=");
        return equalFormulaPojo;
    }

    public static InvokePojo invokeCustom(CustomControl customControl, String frontMethodNameString, Object endToFrontObject, String callbackEndMethodNameString) {
        return RuleJsUtils.invokeCustom(customControl, null, frontMethodNameString, endToFrontObject, callbackEndMethodNameString);
    }

    public static InvokePojo invokeCustom(CustomControl customControl, String frontMethodNameString, Object endToFrontObject) {
        return RuleJsUtils.invokeCustom(customControl, null, frontMethodNameString, endToFrontObject, null);
    }

    public static InvokePojo invokeCustom(CustomControl customControl, String keyString, String frontMethodNameString, Object endToFrontObject, String callbackEndMethodNameString) {
        if ("updateModelPojo".equals(frontMethodNameString) && endToFrontObject instanceof ModelPojo) {
            ModelPojo modelPojo = (ModelPojo)endToFrontObject;
            Long versionLong = ObjUtils.getLong((Object)modelPojo.getVersionString());
            if (versionLong == null) {
                versionLong = 0L;
            }
            modelPojo.setVersionString(ObjUtils.getString((Object)(versionLong + 1L)));
            List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
            if (CollectionUtils.isNotEmpty((Collection)ruleManageRowPojoList)) {
                for (RuleManageRowPojo ruleManageRowPojo : ruleManageRowPojoList) {
                    RuleJsUtils.setFormulaPojoUuidString(ruleManageRowPojo.getFormulaPojoList());
                }
            }
        }
        InvokePojo invokePojo = new InvokePojo();
        invokePojo.setUuidString(StrUtils.getUuidIdWithDataString());
        invokePojo.setKeyString(keyString);
        invokePojo.setFrontMethodNameString(frontMethodNameString);
        invokePojo.setEndToFrontObject(endToFrontObject);
        invokePojo.setCallbackEndMethodNameString(callbackEndMethodNameString);
        customControl.setData((Object)invokePojo);
        return invokePojo;
    }

    public static void setFormulaPojoUuidString(Collection<FormulaPojo> formulaPojoCollection) {
        if (CollectionUtils.isEmpty(formulaPojoCollection)) {
            return;
        }
        for (FormulaPojo formulaPojo : formulaPojoCollection) {
            if (StringUtils.isNotBlank((CharSequence)formulaPojo.getUuidString())) continue;
            formulaPojo.setUuidString(StrUtils.getSimpleUuidIdString());
            RuleJsUtils.setFormulaPojoUuidString(formulaPojo.getSubFormulaPojoList());
        }
    }

    public static Long getViewId(Long modelId, Long bizCtrlRangeId, String dimNumber) {
        return BusinessModelServiceHelper.getInstance().getViewId(bizCtrlRangeId, dimNumber, modelId);
    }

    public static List<FormulaPojo> getTextFormulaPojoList(String valueString) {
        ArrayList<FormulaPojo> formulaPojoList = new ArrayList<FormulaPojo>(10);
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return formulaPojoList;
        }
        for (String itemString : valueString.split("")) {
            FormulaPojo formulaPojo = new FormulaPojo();
            formulaPojo.setTypeString("text");
            formulaPojo.setValueString(itemString);
            formulaPojoList.add(formulaPojo);
        }
        return formulaPojoList;
    }

    public static List<FormulaPojo> getTextFormulaPojoList(String name, String number, String showNumber) {
        ArrayList<FormulaPojo> formulaPojoList = new ArrayList<FormulaPojo>(10);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "";
        }
        FormulaPojo formulaPojo = new FormulaPojo();
        formulaPojo.setTypeString("text");
        formulaPojo.setValueString(name);
        formulaPojo.setNumberString(number);
        formulaPojo.setShowNumberString(showNumber);
        formulaPojoList.add(formulaPojo);
        return formulaPojoList;
    }

    public static FormulaPojo getRemoveFormulaPojo() {
        FormulaPojo formulaPojo = new FormulaPojo();
        formulaPojo.setTypeString("indivisible");
        formulaPojo.setValueString("Remove");
        StylePojo stylePojo = new StylePojo();
        stylePojo.setColorString("red");
        formulaPojo.setStylePojo(stylePojo);
        return formulaPojo;
    }

    public static List<ExecuterangePojo> getExecuterangePojoList(RuleManageRowPojo ruleManageRowPojo) {
        return RuleJsUtils.getExecuterangePojoList(ruleManageRowPojo, null);
    }

    public static List<ExecuterangePojo> getExecuterangePojoList(RuleManageRowPojo ruleManageRowPojo, String executerangeString) {
        String metricDimnumber;
        if (StringUtils.isNotBlank((CharSequence)executerangeString)) {
            if (!LeafFeature.LEAF.name().equals(executerangeString)) {
                return RuleUtils.getExecuterangePojoList();
            }
            return RuleJsUtils.getExecuterangePojoList(ruleManageRowPojo);
        }
        String metricDimMemberNumberString = RuleJsUtils.getMetricDimMemberNumberString(ruleManageRowPojo, ruleManageRowPojo.getDimensionNumberString());
        if (StringUtils.isBlank((CharSequence)metricDimMemberNumberString)) {
            return RuleUtils.getExecuterangePojoList();
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)ObjUtils.getLong((Object)ruleManageRowPojo.getModelIdLongString()));
        Member member = modelCache.getMember(metricDimnumber = SysDimensionEnum.Metric.getNumber(), null, metricDimMemberNumberString);
        if (member != null && member.hasAgg()) {
            return RuleJsUtils.getAggExecuterangePojoList();
        }
        return RuleUtils.getExecuterangePojoList();
    }

    public static String getMetricDimMemberNumberString(RuleManageRowPojo ruleManageRowPojo, String currentDimNumberString) {
        if (SysDimensionEnum.Metric.getNumber().equals(currentDimNumberString)) {
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            if (CollectionUtils.isEmpty((Collection)formulaPojoList)) {
                return null;
            }
            FormulaPojo formulaPojo = (FormulaPojo)formulaPojoList.get(0);
            if (formulaPojo != null && "member".equals(formulaPojo.getTypeString())) {
                return formulaPojo.getNumberString();
            }
            return null;
        }
        RuleRangePojo ruleRangePojo = (RuleRangePojo)LambdaUtils.getTarget((List)ruleManageRowPojo.getRuleRangePojoList(), item -> SysDimensionEnum.Metric.getNumber().equals(item.getNumberString()));
        if (ruleRangePojo == null) {
            return null;
        }
        List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
        if (CollectionUtils.isEmpty((Collection)ruleRangMemberPojoList)) {
            return null;
        }
        return ((RuleRangMemberPojo)ruleRangMemberPojoList.get(0)).getNumberString();
    }

    public static FormulaPojo ruleFunctionToFunctionFormulaPojo(IModelCacheHelper modelCache, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        RuleFunctionEnum functionEunm = RuleFunctionEnum.getFunctionEnumByName((String)functionName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("kd.epm.eb.formplugin.rulemanage.functionEdit.convert." + functionEunm.getShortName() + "FunctionConvert");
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("convertToFormulaPojo", IModelCacheHelper.class, IRuleFunction.class);
            Object returnz = method.invoke(instance, modelCache, ruleFunction);
            return (FormulaPojo)returnz;
        }
        catch (Exception e) {
            log.error("convertToFormulaPojo:", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleJsUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[]{functionEunm.getName()}));
        }
    }

    public static IRuleFunction functionFormulaPojoToRuleFunction(IModelCacheHelper modelCache, FormulaPojo formulaPojo) {
        String functionName = formulaPojo.getToolEnumKeyString();
        RuleFunctionEnum functionEunm = RuleFunctionEnum.getFunctionEnumByName((String)functionName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("kd.epm.eb.formplugin.rulemanage.functionEdit.convert." + functionEunm.getShortName() + "FunctionConvert");
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("convertToFunction", IModelCacheHelper.class, FormulaPojo.class);
            Object returnz = method.invoke(instance, modelCache, formulaPojo);
            return (IRuleFunction)returnz;
        }
        catch (Exception e) {
            log.error("convertToFunctionError:", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleJsUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[]{functionEunm.getName()}));
        }
    }

    public static FormulaPojo toFormulaPojo(IModelCacheHelper modelCacheHelper, FormulaMemberPojo accountMemberPojo) {
        FormulaPojo accountFormulaPojo = new FormulaPojo();
        accountFormulaPojo.setUuidString(StrUtils.getSimpleUuidIdString());
        accountFormulaPojo.setKeyString(accountMemberPojo.getMemberKey());
        accountFormulaPojo.setCallbackMethodNameString("showMembRange");
        ArrayList<FormulaMembPojo> notMainMemberList = new ArrayList<FormulaMembPojo>(16);
        for (DimMemberPojo refDimMember : accountMemberPojo.getRefDimMembers()) {
            Long viewId = refDimMember.getViewId();
            String dimNumber = refDimMember.getDimNumber();
            Member member = modelCacheHelper.getMember(dimNumber, viewId, refDimMember.getNumber());
            String viewIdStr = IDUtils.toString((Object)viewId);
            String viewNumber = RuleUtils.getViewNumber(modelCacheHelper, dimNumber, viewId);
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                accountFormulaPojo.setIdString(Convert.toStr((Object)DBServiceHelper.genGlobalLongId()));
                accountFormulaPojo.setMainMemberIdString(member.getId().toString());
                accountFormulaPojo.setValueString(member.getName());
                accountFormulaPojo.setNumberString(member.getNumber());
                accountFormulaPojo.setShowNumberString(member.getShowNumber());
                accountFormulaPojo.setViewIdString(viewIdStr);
                accountFormulaPojo.setViewNumberString(viewNumber);
                continue;
            }
            FormulaMembPojo formulaMembPojo = new FormulaMembPojo();
            formulaMembPojo.setMemberIdString(member.getId().toString());
            formulaMembPojo.setDimNumber(dimNumber);
            formulaMembPojo.setNumberString(member.getNumber());
            formulaMembPojo.setShowNumberString(member.getShowNumber());
            formulaMembPojo.setNameString(member.getName());
            formulaMembPojo.setViewIdString(viewIdStr);
            formulaMembPojo.setViewNumberString(viewNumber);
            LambdaUtils.run(() -> {
                if (StringUtils.isBlank((CharSequence)formulaMembPojo.getDimNumber())) {
                    return;
                }
                Dimension dimension = modelCacheHelper.getDimension(formulaMembPojo.getDimNumber());
                if (dimension == null) {
                    return;
                }
                formulaMembPojo.setDimensionNameString(dimension.getName());
            });
            notMainMemberList.add(formulaMembPojo);
        }
        accountFormulaPojo.setNotMainMemberList(notMainMemberList);
        accountFormulaPojo.setTypeString("member");
        return accountFormulaPojo;
    }

    public static FormulaPojo toFormulaPojoByMainDim(IModelCacheHelper modelCacheHelper, FormulaMemberPojo accountMemberPojo) {
        FormulaPojo accountFormulaPojo = new FormulaPojo();
        accountFormulaPojo.setUuidString(StrUtils.getSimpleUuidIdString());
        accountFormulaPojo.setKeyString(accountMemberPojo.getMemberKey());
        accountFormulaPojo.setCallbackMethodNameString("showMembRange");
        List refDimMembers = accountMemberPojo.getRefDimMembers();
        String mainDimNumber = ((DimMemberPojo)refDimMembers.get(0)).getDimNumber();
        accountFormulaPojo.setMainDimNumber(mainDimNumber);
        Long mainViewId = accountMemberPojo.getMainViewId();
        String viewIdStr = IDUtils.toString((Object)mainViewId);
        accountFormulaPojo.setViewIdString(viewIdStr);
        String mainViewNumber = RuleUtils.getViewNumber(modelCacheHelper, mainDimNumber, mainViewId);
        accountFormulaPojo.setViewNumberString(mainViewNumber);
        ArrayList<FormulaMembPojo> notMainMemberList = new ArrayList<FormulaMembPojo>(16);
        StringBuilder nameSb = new StringBuilder();
        StringBuilder numberSb = new StringBuilder();
        StringBuilder showNumberSb = new StringBuilder();
        for (DimMemberPojo refDimMember : refDimMembers) {
            Long viewId = refDimMember.getViewId();
            String dimNumber = refDimMember.getDimNumber();
            String viewNumber = RuleUtils.getViewNumber(modelCacheHelper, dimNumber, viewId);
            Member member = modelCacheHelper.getMember(dimNumber, viewId, refDimMember.getNumber());
            if (accountMemberPojo.getMainDimMemberId().equals(member.getId())) {
                accountFormulaPojo.setIdString(Convert.toStr((Object)DBServiceHelper.genGlobalLongId()));
                accountFormulaPojo.setMainMemberIdString(member.getId().toString());
                accountFormulaPojo.setShowNumberString(member.getShowNumber());
                nameSb.append(member.getName()).append("|");
                numberSb.append(member.getNumber()).append("|");
                showNumberSb.append(member.getShowNumber()).append("|");
                continue;
            }
            FormulaMembPojo formulaMembPojo = new FormulaMembPojo();
            formulaMembPojo.setMemberIdString(member.getId().toString());
            formulaMembPojo.setDimNumber(dimNumber);
            formulaMembPojo.setNumberString(member.getNumber());
            formulaMembPojo.setShowNumberString(member.getShowNumber());
            formulaMembPojo.setNameString(member.getName());
            formulaMembPojo.setViewIdString(IDUtils.toString((Object)viewId));
            formulaMembPojo.setViewNumberString(viewNumber);
            nameSb.append(member.getName()).append("|");
            numberSb.append(member.getNumber()).append("|");
            showNumberSb.append(member.getShowNumber()).append("|");
            LambdaUtils.run(() -> {
                if (StringUtils.isBlank((CharSequence)formulaMembPojo.getDimNumber())) {
                    return;
                }
                Dimension dimension = modelCacheHelper.getDimension(formulaMembPojo.getDimNumber());
                if (dimension == null) {
                    return;
                }
                formulaMembPojo.setDimensionNameString(dimension.getName());
            });
            notMainMemberList.add(formulaMembPojo);
        }
        nameSb.setLength(nameSb.length() - 1);
        numberSb.setLength(nameSb.length() - 1);
        showNumberSb.setLength(showNumberSb.length() - 1);
        accountFormulaPojo.setValueString(nameSb.toString());
        accountFormulaPojo.setNumberString(numberSb.toString());
        accountFormulaPojo.setShowNumberString(showNumberSb.toString());
        accountFormulaPojo.setNotMainMemberList(notMainMemberList);
        accountFormulaPojo.setTypeString("member");
        return accountFormulaPojo;
    }

    public static FormulaMemberPojo toFormulaMemberPojo(IModelCacheHelper modelCacheHelper, FormulaPojo accountFormulaPojo) {
        FormulaMemberPojo accountMemberPojo = new FormulaMemberPojo();
        accountMemberPojo.setMemberKey(accountFormulaPojo.getKeyString());
        ArrayList<DimMemberPojo> refDimMembers = new ArrayList<DimMemberPojo>(10);
        accountMemberPojo.setRefDimMembers(refDimMembers);
        String mainMemberNumber = accountFormulaPojo.getNumberString();
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, mainMemberNumber);
        accountMemberPojo.setMainDimMemberId(accountMember.getId());
        DimMemberPojo accountDimMemberPojo = new DimMemberPojo();
        accountDimMemberPojo.setDimNumber(SysDimensionEnum.Account.getNumber());
        accountDimMemberPojo.setDimShortNumber(SysDimensionEnum.Account.getShortNumber());
        accountDimMemberPojo.setId(accountMember.getId());
        accountDimMemberPojo.setNumber(accountMember.getNumber());
        accountDimMemberPojo.setLongNumber(accountMember.getLongNumber());
        accountDimMemberPojo.setName(accountMember.getName());
        refDimMembers.add(accountDimMemberPojo);
        List notMainMemberList = accountFormulaPojo.getNotMainMemberList();
        for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
            String dimNumber = formulaMembPojo.getDimNumber();
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            String viewNumberString = formulaMembPojo.getViewNumberString();
            Long viewId = RuleUtils.getViewIdByNumber(modelCacheHelper, dimNumber, viewNumberString);
            Member member = modelCacheHelper.getMember(dimNumber, viewId, Convert.toLong((Object)formulaMembPojo.getMemberIdString()));
            DimMemberPojo dimMemberPojo = new DimMemberPojo();
            dimMemberPojo.setDimNumber(dimNumber);
            dimMemberPojo.setDimShortNumber(dimension.getShortNumber());
            dimMemberPojo.setId(member.getId());
            dimMemberPojo.setNumber(member.getNumber());
            dimMemberPojo.setLongNumber(member.getLongNumber());
            dimMemberPojo.setName(member.getName());
            dimMemberPojo.setViewId(viewId);
            dimMemberPojo.setViewNumber(RuleUtils.getViewNumber(modelCacheHelper, dimNumber, viewId));
            refDimMembers.add(dimMemberPojo);
        }
        return accountMemberPojo;
    }

    public static FormulaMemberPojo toFormulaMemberPojoByMainDim(IModelCacheHelper modelCacheHelper, FormulaPojo accountFormulaPojo) {
        FormulaMemberPojo accountMemberPojo = new FormulaMemberPojo();
        accountMemberPojo.setMemberKey(accountFormulaPojo.getKeyString());
        ArrayList<DimMemberPojo> refDimMembers = new ArrayList<DimMemberPojo>(10);
        accountMemberPojo.setRefDimMembers(refDimMembers);
        String mainDimNumber = accountFormulaPojo.getMainDimNumber();
        if (StringUtils.isEmpty((CharSequence)mainDimNumber)) {
            mainDimNumber = SysDimensionEnum.Account.getNumber();
        }
        String viewNumberString = accountFormulaPojo.getViewNumberString();
        Long viewId = RuleUtils.getViewIdByNumber(modelCacheHelper, mainDimNumber, viewNumberString);
        accountMemberPojo.setMainViewId(viewId);
        String viewNumber = RuleUtils.getViewNumber(modelCacheHelper, mainDimNumber, viewId);
        accountMemberPojo.setMainViewNumber(viewNumber);
        Long mainMemId = IDUtils.toLong((Object)accountFormulaPojo.getMainMemberIdString());
        if (IDUtils.isEmptyLong((Long)mainMemId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"YearValue\u51fd\u6570\u65e0\u7ef4\u5ea6\u7ec4\u5408\u4e3b\u6210\u5458id\uff0c\u8bf7\u5148\u5728\u89c4\u5219\u5217\u8868\u5347\u7ea7\u65e7\u89c4\u5219", (String)"RuleJsUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Member mainMember = modelCacheHelper.getMember(mainDimNumber, viewId, mainMemId);
        accountMemberPojo.setMainDimMemberId(mainMember.getId());
        DimMemberPojo mainDimMemberPojo = new DimMemberPojo();
        mainDimMemberPojo.setDimNumber(mainDimNumber);
        Dimension mainDim = modelCacheHelper.getDimension(mainDimNumber);
        mainDimMemberPojo.setDimShortNumber(mainDim.getShortNumber());
        mainDimMemberPojo.setId(mainMember.getId());
        mainDimMemberPojo.setNumber(mainMember.getNumber());
        mainDimMemberPojo.setLongNumber(mainMember.getLongNumber());
        mainDimMemberPojo.setName(mainMember.getName());
        mainDimMemberPojo.setViewId(viewId);
        mainDimMemberPojo.setViewNumber(viewNumber);
        refDimMembers.add(mainDimMemberPojo);
        List notMainMemberList = accountFormulaPojo.getNotMainMemberList();
        for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
            String viewNumberStrNotMain = formulaMembPojo.getViewNumberString();
            String dimNumber = formulaMembPojo.getDimNumber();
            Long viewIdNotMain = RuleUtils.getViewIdByNumber(modelCacheHelper, dimNumber, viewNumberStrNotMain);
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            Member member = modelCacheHelper.getMember(dimNumber, viewIdNotMain, formulaMembPojo.getNumberString());
            DimMemberPojo dimMemberPojo = new DimMemberPojo();
            dimMemberPojo.setDimNumber(dimNumber);
            dimMemberPojo.setDimShortNumber(dimension.getShortNumber());
            dimMemberPojo.setId(member.getId());
            dimMemberPojo.setNumber(member.getNumber());
            dimMemberPojo.setLongNumber(member.getLongNumber());
            dimMemberPojo.setName(member.getName());
            dimMemberPojo.setViewId(viewIdNotMain);
            dimMemberPojo.setViewNumber(RuleUtils.getViewNumber(modelCacheHelper, dimNumber, viewIdNotMain));
            refDimMembers.add(dimMemberPojo);
        }
        return accountMemberPojo;
    }

    public static Long getLeftAccountId(RuleManageRowPojo currentRowPojo, IModelCacheHelper iModelCacheHelper) {
        RuleRangePojo ruleRangePojo = (RuleRangePojo)LambdaUtils.getTarget((List)currentRowPojo.getRuleRangePojoList(), item -> item != null && SysDimensionEnum.Account.getNumber().equals(item.getNumberString()));
        if (ruleRangePojo == null) {
            return null;
        }
        List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
        if (CollectionUtils.isEmpty((Collection)ruleRangMemberPojoList)) {
            return null;
        }
        Long datasetIdLong = null;
        Long accountMemberIdLong = null;
        for (RuleRangMemberPojo ruleRangMemberPojo : ruleRangMemberPojoList) {
            Member accountMember = iModelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, ruleRangMemberPojo.getNumberString());
            Long itemDatasetIdLong = accountMember.getDatasetId();
            if (datasetIdLong == null) {
                datasetIdLong = itemDatasetIdLong;
                accountMemberIdLong = accountMember.getId();
                continue;
            }
            if (datasetIdLong.equals(itemDatasetIdLong)) continue;
            return null;
        }
        return accountMemberIdLong;
    }

    public static Long checkCurrentRowsRangeHasAccountMember(ModelPojo modelPojo, RuleManageRowPojo currentRowPojo, IModelCacheHelper modelCacheHelper) {
        Integer targetIndexInteger = LambdaUtils.getTargetIndexInteger((List)modelPojo.getRuleManageRowPojoList(), item -> item != null && currentRowPojo != null && currentRowPojo.getIdString().equals(item.getIdString()));
        if (targetIndexInteger == null) {
            return null;
        }
        Integer orderNumberInteger = targetIndexInteger + 1;
        RuleRangePojo ruleRangePojo = (RuleRangePojo)LambdaUtils.getTarget((List)currentRowPojo.getRuleRangePojoList(), item -> item != null && SysDimensionEnum.Account.getNumber().equals(item.getNumberString()));
        if (ruleRangePojo == null || CollectionUtils.isEmpty((Collection)ruleRangePojo.getRuleRangMemberPojoList())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u5728\u7b2c%1\u884c\u89c4\u5219\u9002\u7528\u8303\u56f4\u4e2d\u9009\u62e9\u79d1\u76ee\u6210\u5458\u3002", (String)"RuleErrorInfo_37", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger}));
        }
        Long datasetIdLong = null;
        Long accountMemberIdLong = null;
        for (RuleRangMemberPojo ruleRangMemberPojo : ruleRangePojo.getRuleRangMemberPojoList()) {
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, ruleRangMemberPojo.getNumberString());
            Long itemDatasetIdLong = accountMember.getDatasetId();
            if (datasetIdLong == null) {
                datasetIdLong = itemDatasetIdLong;
                accountMemberIdLong = accountMember.getId();
                continue;
            }
            if (datasetIdLong.equals(itemDatasetIdLong)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u7b2c%1\u884c\u89c4\u5219\u9002\u7528\u8303\u56f4\u4e2d\u7684\u6240\u6709\u79d1\u76ee\u6210\u5458\u662f\u5426\u5c5e\u4e8e\u540c\u4e00\u4e2a\u6570\u636e\u96c6\u3002", (String)"RuleErrorInfo_38", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger}));
        }
        return accountMemberIdLong;
    }

    public static void checkScopeOfMember(ModelPojo modelPojo, IModelCacheHelper modelCache) {
        List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
        for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            List formulaPojoList;
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            if (ruleManageRowPojo == null || Boolean.TRUE.equals(ruleManageRowPojo.getReadOnlyBoolean())) continue;
            if (ruleManageRowPojo.getOrderNumberInteger() == null || ruleManageRowPojo.getOrderNumberInteger() <= 0) {
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
            }
            if (CollectionUtils.isEmpty((Collection)(formulaPojoList = ruleManageRowPojo.getFormulaPojoList())) || formulaPojoList.size() <= 2) continue;
            String leftAccountNumberString = RuleUtils.getLeftAccountNumberString(ruleManageRowPojo);
            Member mainAccountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, leftAccountNumberString);
            Map dimensionMap = modelCache.getDimensionMap(mainAccountMember.getDatasetId());
            HashMap leftDimensionMap = new HashMap(16);
            dimensionMap.forEach((k, v) -> {
                if (!SysDimensionEnum.Account.getNumber().equals(k)) {
                    leftDimensionMap.put(k, v);
                }
            });
            Set leftDimensionNumberStringSet = leftDimensionMap.keySet();
            Long leftMemberDatasetIdLong = mainAccountMember.getDatasetId();
            for (int j = 2; j < formulaPojoList.size(); ++j) {
                Collection subtractNumberStringSet;
                Long notMainMemberDatasetIdLong;
                Member rightAccountMember;
                String rightAccountMemberNumberString;
                boolean yearValueFunc;
                FormulaPojo formulaPojo;
                block6: {
                    FormulaPojo accFormulaPojo;
                    block7: {
                        formulaPojo = (FormulaPojo)formulaPojoList.get(j);
                        boolean bl = yearValueFunc = "function".equals(formulaPojo.getTypeString()) && RuleFunctionEnum.YearValue.getName().equals(formulaPojo.getToolEnumKeyString());
                        if (!"member".equals(formulaPojo.getTypeString()) && !yearValueFunc) continue;
                        rightAccountMemberNumberString = (String)LambdaUtils.get(() -> {
                            if (SysDimensionEnum.Account.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) {
                                return formulaPojo.getNumberString();
                            }
                            FormulaMembPojo accountFormulaMembPojo = (FormulaMembPojo)LambdaUtils.getTarget((List)formulaPojo.getNotMainMemberList(), item -> item != null && SysDimensionEnum.Account.getNumber().equals(item.getDimNumber()));
                            if (accountFormulaMembPojo == null) {
                                return null;
                            }
                            return accountFormulaMembPojo.getNumberString();
                        });
                        if (!yearValueFunc) break block6;
                        accFormulaPojo = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
                        if (!SysDimensionEnum.Account.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) break block7;
                        Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accFormulaPojo.getMainMemberIdString()));
                        if (member == null) break block6;
                        rightAccountMemberNumberString = member.getNumber();
                        break block6;
                    }
                    List notMainMemberList = accFormulaPojo.getNotMainMemberList();
                    for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                        if (!SysDimensionEnum.Account.getNumber().equals(formulaMembPojo.getDimNumber())) continue;
                        rightAccountMemberNumberString = formulaMembPojo.getNumberString();
                        break;
                    }
                }
                if (StringUtils.isBlank((CharSequence)rightAccountMemberNumberString) || (rightAccountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, rightAccountMemberNumberString)) == null || leftMemberDatasetIdLong.equals(notMainMemberDatasetIdLong = rightAccountMember.getDatasetId())) continue;
                Map rdimensionMap = modelCache.getDimensionMap(rightAccountMember.getDatasetId());
                HashMap notMainDimensionMap = new HashMap(16);
                rdimensionMap.forEach((k, v) -> {
                    if (!SysDimensionEnum.Account.getNumber().equals(k)) {
                        notMainDimensionMap.put(k, v);
                    }
                });
                Set notMainDimensionNumberStringSet = notMainDimensionMap.keySet();
                Collection intersectionNumberStringSet = CollectionUtils.intersection(leftDimensionNumberStringSet, notMainDimensionNumberStringSet);
                if (!yearValueFunc && notMainDimensionNumberStringSet.size() > intersectionNumberStringSet.size()) {
                    subtractNumberStringSet = CollectionUtils.subtract(notMainDimensionNumberStringSet, (Iterable)intersectionNumberStringSet);
                    Map subtractFormulaMembPojoMap = (Map)LambdaUtils.get(() -> {
                        if (CollectionUtils.isEmpty((Collection)formulaPojo.getNotMainMemberList())) {
                            return Collections.emptyMap();
                        }
                        return formulaPojo.getNotMainMemberList().stream().filter(notMainFormulaMembPojo -> notMainFormulaMembPojo != null && subtractNumberStringSet.contains(notMainFormulaMembPojo.getDimNumber())).collect(Collectors.toMap(FormulaMembPojo::getDimNumber, notMainFormulaMembPojo -> notMainFormulaMembPojo));
                    });
                    if (subtractNumberStringSet.size() != subtractFormulaMembPojoMap.size()) {
                        Collection unsetDimensionNumberStringSet = CollectionUtils.subtract((Iterable)subtractNumberStringSet, subtractFormulaMembPojoMap.keySet());
                        String dimensionString = notMainDimensionMap.entrySet().stream().filter(entry -> unsetDimensionNumberStringSet.contains(entry.getKey())).map(entry -> StrUtils.format((String)"{}({})", (Object[])new Object[]{((Dimension)entry.getValue()).getName(), ((Dimension)entry.getValue()).getNumber()})).sorted().collect(Collectors.joining(","));
                        String formulaPojoString = StrUtils.format((String)"{}({})", (Object[])new Object[]{formulaPojo.getValueString(), formulaPojo.getNumberString()});
                        throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u8bbe\u7f6e\u7b2c%1\u884c\u89c4\u5219\u4e2d\u53f3\u7b49\u5f0f\u201c%2\u201d\u7684\u6210\u5458\u8303\u56f4\u4e3a\u201c%3\u201d\u3002", (String)"RuleErrorInfo_54", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleManageRowPojo.getOrderNumberInteger(), formulaPojoString, dimensionString}));
                    }
                }
                if (leftDimensionNumberStringSet.size() <= intersectionNumberStringSet.size()) continue;
                subtractNumberStringSet = CollectionUtils.subtract(leftDimensionNumberStringSet, (Iterable)intersectionNumberStringSet);
                Map<String, RuleRangePojo> subtractRuleRangePojoMap = ruleManageRowPojo.getRuleRangePojoList().stream().filter(item -> item != null && subtractNumberStringSet.contains(item.getNumberString()) && CollectionUtils.isNotEmpty((Collection)item.getRuleRangMemberPojoList())).collect(Collectors.toMap(RuleRangePojo::getNumberString, item -> item));
                if (subtractRuleRangePojoMap.size() == subtractNumberStringSet.size()) continue;
                Collection unsetDimensionNumberStringSet = CollectionUtils.subtract((Iterable)subtractNumberStringSet, subtractRuleRangePojoMap.keySet());
                String dimensionString = leftDimensionMap.entrySet().stream().filter(entry -> unsetDimensionNumberStringSet.contains(entry.getKey())).map(entry -> StrUtils.format((String)"{}({})", (Object[])new Object[]{((Dimension)entry.getValue()).getName(), ((Dimension)entry.getValue()).getNumber()})).sorted().collect(Collectors.joining(","));
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u8bbe\u7f6e\u7b2c%1\u884c\u89c4\u5219\u7684\u9002\u7528\u8303\u56f4\u4e3a%2\u3002", (String)"RuleErrorInfo_55", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleManageRowPojo.getOrderNumberInteger(), dimensionString}));
            }
        }
    }

    public static void checkYearValueDimContainLeftDataSet(ModelPojo modelPojo) {
        List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
        Long modelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)ruleManageRowPojoList.get(0)).getModelIdLongString());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            List formulaPojoList;
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            if (ruleManageRowPojo == null || Boolean.TRUE.equals(ruleManageRowPojo.getReadOnlyBoolean())) continue;
            if (ruleManageRowPojo.getOrderNumberInteger() == null || ruleManageRowPojo.getOrderNumberInteger() <= 0) {
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
            }
            if (CollectionUtils.isEmpty((Collection)(formulaPojoList = ruleManageRowPojo.getFormulaPojoList())) || formulaPojoList.size() <= 2) continue;
            String leftAccountNumberString = RuleUtils.getLeftAccountNumberString(ruleManageRowPojo);
            Member mainAccountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, leftAccountNumberString);
            Map mainDimensionMap = modelCacheHelper.getDimensionMap(mainAccountMember.getDatasetId());
            HashMap leftDimensionMap = new HashMap(16);
            mainDimensionMap.forEach((k, v) -> {
                if (!SysDimensionEnum.Account.getNumber().equals(k)) {
                    leftDimensionMap.put(k, v);
                }
            });
            Set leftDimensionNumberStringSet = leftDimensionMap.keySet();
            for (int j = 2; j < formulaPojoList.size(); ++j) {
                FormulaPojo childFormulaPojo;
                List notMainMemberList;
                FormulaPojo accFormulaPojo;
                String rightAccountMemberNumberString;
                FormulaPojo formulaPojo;
                block7: {
                    block6: {
                        boolean yearValueFunc;
                        formulaPojo = (FormulaPojo)formulaPojoList.get(j);
                        boolean bl = yearValueFunc = "function".equals(formulaPojo.getTypeString()) && RuleFunctionEnum.YearValue.getName().equals(formulaPojo.getToolEnumKeyString());
                        if (!yearValueFunc) continue;
                        rightAccountMemberNumberString = "";
                        accFormulaPojo = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
                        notMainMemberList = accFormulaPojo.getNotMainMemberList();
                        if (!SysDimensionEnum.Account.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) break block6;
                        Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accFormulaPojo.getMainMemberIdString()));
                        if (member == null) break block7;
                        rightAccountMemberNumberString = member.getNumber();
                        break block7;
                    }
                    for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                        if (!SysDimensionEnum.Account.getNumber().equals(formulaMembPojo.getDimNumber())) continue;
                        rightAccountMemberNumberString = formulaMembPojo.getNumberString();
                        break;
                    }
                }
                if (!StringUtils.isBlank((CharSequence)rightAccountMemberNumberString)) continue;
                HashSet<String> selYVDimNumberSet = new HashSet<String>(16);
                String mainDimNumber = accFormulaPojo.getMainDimNumber();
                if (SysDimensionEnum.Account.getNumber().equals(mainDimNumber)) continue;
                selYVDimNumberSet.add(mainDimNumber);
                if (CollectionUtils.isNotEmpty((Collection)notMainMemberList)) {
                    selYVDimNumberSet.addAll(notMainMemberList.stream().map(FormulaMembPojo::getDimNumber).collect(Collectors.toSet()));
                }
                if ((childFormulaPojo = formulaPojo.getChildFormulaPojo()) != null) {
                    IRuleFunction childFun = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, childFormulaPojo);
                    Map allValues = childFun.getAllValues();
                    String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                    selYVDimNumberSet.add(dimNumber);
                }
                Collection intersectionNumberStringSet = CollectionUtils.intersection(leftDimensionNumberStringSet, selYVDimNumberSet);
                if (selYVDimNumberSet.size() <= intersectionNumberStringSet.size()) continue;
                Collection subtractNumberStringSet = CollectionUtils.subtract(selYVDimNumberSet, (Iterable)intersectionNumberStringSet);
                Map dimensionMap = modelCacheHelper.getDimensionMap(subtractNumberStringSet.toArray(new String[0]));
                String dimensionString = dimensionMap.entrySet().stream().filter(entry -> subtractNumberStringSet.contains(entry.getKey())).map(entry -> StrUtils.format((String)"{}({})", (Object[])new Object[]{((Dimension)entry.getValue()).getName(), ((Dimension)entry.getValue()).getNumber()})).sorted().collect(Collectors.joining(","));
                String formulaPojoString = StrUtils.format((String)"{}", (Object[])new Object[]{formulaPojo.getValueString()});
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u4e2d\u53f3\u7b49\u5f0f\u201c%2\u201d\u8bbe\u7f6e\u4e86\u5de6\u5f0f\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u7684\u7ef4\u5ea6\u201c%3\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_69", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleManageRowPojo.getOrderNumberInteger(), formulaPojoString, dimensionString}));
            }
        }
    }

    public static void checkDifferentDataSetFunc(ModelPojo modelPojo) {
        List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
        Long modelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)ruleManageRowPojoList.get(0)).getModelIdLongString());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        List ebPeriodvariableList = OrmBuilder.clazz(EbPeriodvariable.class).field(new String[]{"fid", "fnumber", "fdimensionid", "fmodelid", "fgrouptype"}).whereEqual("fmodelid", (Object)modelIdLong).toRowList();
        for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            if (ruleManageRowPojo == null || Boolean.TRUE.equals(ruleManageRowPojo.getReadOnlyBoolean())) continue;
            Integer orderNumberInteger = ruleManageRowPojo.getOrderNumberInteger();
            if (orderNumberInteger == null || orderNumberInteger <= 0) {
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
            }
            LeafFeature leafFeature = LeafFeature.of((String)ruleManageRowPojo.getExecuterangeString());
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            if (CollectionUtils.isEmpty((Collection)formulaPojoList) || formulaPojoList.size() <= 2) continue;
            String leftAccountNumberString = RuleUtils.getLeftAccountNumberString(ruleManageRowPojo);
            Member mainAccountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, leftAccountNumberString);
            Long leftDatasetId = mainAccountMember.getDatasetId();
            HashMap periodOffset = new HashMap(16);
            boolean hasDiffDataSet = false;
            String yearValueName = RuleFunctionEnum.YearValue.getName();
            for (FormulaPojo formulaPojo : ruleManageRowPojo.getFormulaPojoList()) {
                String rightAccountMemberNumberString;
                block8: {
                    List notMainMemberList;
                    block7: {
                        String typeString = formulaPojo.getTypeString();
                        if ("member".equals(typeString)) {
                            List notMainMemberList2 = formulaPojo.getNotMainMemberList();
                            if (!CollectionUtils.isNotEmpty((Collection)notMainMemberList2)) continue;
                            for (FormulaMembPojo formulaMembPojo : notMainMemberList2) {
                                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(formulaMembPojo.getDimNumber()) || !formulaMembPojo.isVariable()) continue;
                                LambdaUtils.run(() -> {
                                    Dimension dimension = modelCacheHelper.getDimension(formulaMembPojo.getDimNumber());
                                    if (dimension == null) {
                                        return;
                                    }
                                    EbPeriodvariable ebPeriodvariable = (EbPeriodvariable)LambdaUtils.getTarget((List)ebPeriodvariableList, item -> dimension.getId().equals(item.getDimensionidLong()) && item.getNumberString().equals(formulaMembPojo.getNumberString()));
                                    if (ebPeriodvariable == null) {
                                        return;
                                    }
                                    if (EbPeriodvariableGroupTypeEnum.YEAR.getValueStringList().contains(ebPeriodvariable.getGrouptypeString())) {
                                        return;
                                    }
                                    periodOffset.put(formulaPojo.getKeyString(), ebPeriodvariable.getIdLong());
                                });
                            }
                            continue;
                        }
                        if (!"function".equals(formulaPojo.getTypeString()) || !yearValueName.equals(formulaPojo.getToolEnumKeyString())) continue;
                        rightAccountMemberNumberString = "";
                        FormulaPojo accFormulaPojo = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
                        notMainMemberList = accFormulaPojo.getNotMainMemberList();
                        if (!SysDimensionEnum.Account.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) break block7;
                        Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accFormulaPojo.getMainMemberIdString()));
                        if (member == null) break block8;
                        rightAccountMemberNumberString = member.getNumber();
                        break block8;
                    }
                    for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                        if (!SysDimensionEnum.Account.getNumber().equals(formulaMembPojo.getDimNumber())) continue;
                        rightAccountMemberNumberString = formulaMembPojo.getNumberString();
                        break;
                    }
                }
                if (StringUtils.isBlank((CharSequence)rightAccountMemberNumberString)) continue;
                Member rightMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, rightAccountMemberNumberString);
                Long rightDatasetId = rightMember.getDatasetId();
                if (hasDiffDataSet || IDUtils.equals((Object)leftDatasetId, (Object)rightDatasetId)) continue;
                hasDiffDataSet = true;
            }
            if (hasDiffDataSet && (LeafFeature.NOTLEAF == leafFeature || LeafFeature.ALL == leafFeature)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u90fd\u9002\u7528\u6216\u4ec5\u975e\u660e\u7ec6\u7684\u89c4\u5219%2\u51fd\u6570\u4e0d\u5141\u8bb8\u8de8\u6570\u636e\u96c6\u3002", (String)"RuleErrorInfo_70", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, yearValueName}));
            }
            if (!hasDiffDataSet || periodOffset.isEmpty()) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u671f\u95f4\u504f\u79fb\u7684\u89c4\u5219%2\u51fd\u6570\u4e0d\u5141\u8bb8\u8de8\u6570\u636e\u96c6\u3002", (String)"RuleErrorInfo_71", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, yearValueName}));
        }
    }

    public static void checkDifferentView(ModelPojo modelPojo) {
        List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
        if (CollectionUtils.isEmpty((Collection)ruleManageRowPojoList)) {
            return;
        }
        Long modelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)ruleManageRowPojoList.get(0)).getModelIdLongString());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            HashMap<String, Set<Long>> dimViewMap = new HashMap<String, Set<Long>>(16);
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            if (ruleManageRowPojo.getOrderNumberInteger() == null || ruleManageRowPojo.getOrderNumberInteger() <= 0) {
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
            }
            Integer orderNumberInteger = ruleManageRowPojo.getOrderNumberInteger();
            String mainDimViewIdStr = ruleManageRowPojo.getMainDimViewIdString();
            String dimensionNumberStr = ruleManageRowPojo.getDimensionNumberString();
            Set viewIdSet = dimViewMap.computeIfAbsent(dimensionNumberStr, k -> Sets.newHashSetWithExpectedSize((int)16));
            Long mainView = IDUtils.toLong((Object)mainDimViewIdStr);
            if (IDUtils.isNotEmptyLong((Long)mainView).booleanValue()) {
                viewIdSet.add(mainView);
            }
            List ruleRangePojoList = ruleManageRowPojo.getRuleRangePojoList();
            HashSet<String> ruleRangeDimSet = new HashSet<String>(16);
            if (CollectionUtils.isNotEmpty((Collection)ruleRangePojoList)) {
                for (RuleRangePojo ruleRangePojo : ruleRangePojoList) {
                    List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
                    if (CollectionUtils.isEmpty((Collection)ruleRangMemberPojoList)) continue;
                    String dimNumberStr = ruleRangePojo.getNumberString();
                    ruleRangeDimSet.add(dimNumberStr);
                    for (Object ruleRangMemberPojo : ruleRangMemberPojoList) {
                        viewIdSet = dimViewMap.computeIfAbsent(dimNumberStr, k -> Sets.newHashSetWithExpectedSize((int)16));
                        Long viewId = IDUtils.toLong((Object)ruleRangMemberPojo.getViewIdString());
                        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                            viewIdSet.add(viewId);
                        }
                        if (viewIdSet.size() <= 1) continue;
                        Dimension dimension = modelCacheHelper.getDimension(dimNumberStr);
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u9002\u7528\u8303\u56f4\u7684%2\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_73", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, dimension.getName()}));
                    }
                }
            }
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            for (int j = 2; j < formulaPojoList.size(); ++j) {
                boolean hasAccount;
                FormulaPojo formulaPojo = (FormulaPojo)formulaPojoList.get(j);
                if ("member".equals(formulaPojo.getTypeString())) {
                    Object ruleRangMemberPojo;
                    viewIdSet = dimViewMap.computeIfAbsent(dimensionNumberStr, k -> Sets.newHashSetWithExpectedSize((int)16));
                    Long memViewId = IDUtils.toLong((Object)formulaPojo.getViewIdString());
                    if (IDUtils.isNotEmptyLong((Long)memViewId).booleanValue()) {
                        viewIdSet.add(memViewId);
                    }
                    if (viewIdSet.size() > 1) {
                        Dimension dimension = modelCacheHelper.getDimension(dimensionNumberStr);
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684%2\u6210\u5458%3\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_74", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, formulaPojo.getValueString(), dimension.getName()}));
                    }
                    List notMainMemberList = formulaPojo.getNotMainMemberList();
                    if (CollectionUtils.isEmpty((Collection)notMainMemberList)) continue;
                    ruleRangMemberPojo = notMainMemberList.iterator();
                    while (ruleRangMemberPojo.hasNext()) {
                        FormulaMembPojo formulaMembPojo = (FormulaMembPojo)ruleRangMemberPojo.next();
                        String dimNumber = formulaMembPojo.getDimNumber();
                        viewIdSet = dimViewMap.computeIfAbsent(dimNumber, k -> Sets.newHashSetWithExpectedSize((int)16));
                        Long viewId = IDUtils.toLong((Object)formulaMembPojo.getViewIdString());
                        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                            viewIdSet.add(viewId);
                        }
                        if (viewIdSet.size() <= 1) continue;
                        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684%2\u6210\u5458%3\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_74", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, formulaMembPojo.getNameString(), dimension.getName()}));
                    }
                    continue;
                }
                if (!"function".equals(formulaPojo.getTypeString())) continue;
                String functionName = formulaPojo.getToolEnumKeyString();
                boolean bl = hasAccount = RuleFunctionEnum.YearValue.getName().equals(functionName) || RuleFunctionEnum.RecognitionSP.getName().equals(functionName) || RuleFunctionEnum.RecognitionPC.getName().equals(functionName) || RuleFunctionEnum.RecognitionP.getName().equals(functionName);
                if (hasAccount) {
                    FormulaPojo accFormulaPojo = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
                    String mainDimNumber = accFormulaPojo.getMainDimNumber();
                    viewIdSet = dimViewMap.computeIfAbsent(mainDimNumber, k -> Sets.newHashSetWithExpectedSize((int)16));
                    Long viewId = IDUtils.toLong((Object)accFormulaPojo.getViewIdString());
                    if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                        viewIdSet.add(viewId);
                    }
                    if (viewIdSet.size() > 1) {
                        Dimension dimension = modelCacheHelper.getDimension(mainDimNumber);
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684%2\u51fd\u6570%3\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_75", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, functionName, dimension.getName()}));
                    }
                    List notMainMemberList = accFormulaPojo.getNotMainMemberList();
                    if (CollectionUtils.isNotEmpty((Collection)notMainMemberList)) {
                        for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                            String dimNumber = formulaMembPojo.getDimNumber();
                            viewIdSet = dimViewMap.computeIfAbsent(dimNumber, k -> Sets.newHashSetWithExpectedSize((int)16));
                            Long formulaMemViewId = IDUtils.toLong((Object)formulaMembPojo.getViewIdString());
                            if (IDUtils.isNotEmptyLong((Long)formulaMemViewId).booleanValue()) {
                                viewIdSet.add(formulaMemViewId);
                            }
                            if (viewIdSet.size() <= 1) continue;
                            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684%2\u51fd\u6570%3\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_75", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, functionName, dimension.getName()}));
                        }
                    }
                    RuleJsUtils.checkChildFunctionDifferentView(modelCacheHelper, dimViewMap, orderNumberInteger, ruleRangeDimSet, formulaPojo.getChildFormulaPojo());
                    continue;
                }
                RuleJsUtils.checkChildFunctionDifferentView(modelCacheHelper, dimViewMap, orderNumberInteger, ruleRangeDimSet, formulaPojo);
            }
            Map<String, String> ruleView = RuleUtils.getRuleViewMap(modelCacheHelper, dimViewMap);
            if (ruleView.isEmpty()) continue;
            ruleManageRowPojo.setRuleView(ruleView);
        }
    }

    private static void checkChildFunctionDifferentView(IModelCacheHelper modelCacheHelper, Map<String, Set<Long>> dimViewMap, Integer orderNumberInteger, Set<String> ruleRangeDimSet, FormulaPojo formulaPojo) {
        if (formulaPojo == null) {
            return;
        }
        IRuleFunction function = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, formulaPojo);
        String functionName = function.getFunctionName();
        Map allValues = function.getAllValues();
        String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (StringUtils.isBlank((CharSequence)dimNumber) || View.NoViewDimNums.contains(dimNumber)) {
            return;
        }
        if (RuleFunctionEnum.isWithScopeSameViewFunction((String)functionName) && !ruleRangeDimSet.contains(dimNumber)) {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u4f7f\u7528\u4e86%2\u51fd\u6570\uff0c\u9002\u7528\u8303\u56f4%3\u7ef4\u5ea6\u5fc5\u987b\u6307\u5b9a\u6210\u5458\u8303\u56f4\u3002", (String)"RuleErrorInfo_77", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, functionName, dimension.getName()}));
        }
        String viewIdStr = (String)allValues.get("allvals_view_id");
        Set viewIdSet = dimViewMap.computeIfAbsent(dimNumber, k -> Sets.newHashSetWithExpectedSize((int)16));
        Long viewId = IDUtils.toLong((Object)viewIdStr);
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            viewIdSet.add(viewId);
        }
        if (viewIdSet.size() > 1) {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684%2\u51fd\u6570\u7684\u5173\u7cfb\u51fd\u6570%3\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8de8\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleErrorInfo_76", (String)"epm-eb-formplugin", (Object[])new Object[]{orderNumberInteger, functionName, dimension.getName()}));
        }
        if (formulaPojo.getChildFormulaPojo() != null) {
            RuleJsUtils.checkChildFunctionDifferentView(modelCacheHelper, dimViewMap, orderNumberInteger, ruleRangeDimSet, formulaPojo.getChildFormulaPojo());
        }
    }

    public static boolean checkRuleViewNeedUpgrade(ModelPojo modelPojo) {
        List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
        if (CollectionUtils.isEmpty((Collection)ruleManageRowPojoList)) {
            return false;
        }
        boolean needUpdateRule = false;
        Long modelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)ruleManageRowPojoList.get(0)).getModelIdLongString());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        block0: for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
            if (ruleManageRowPojo.getOrderNumberInteger() == null || ruleManageRowPojo.getOrderNumberInteger() <= 0) {
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
            }
            Integer orderNumberInteger = ruleManageRowPojo.getOrderNumberInteger();
            String mainDimViewIdStr = ruleManageRowPojo.getMainDimViewIdString();
            String dimensionNumberStr = ruleManageRowPojo.getDimensionNumberString();
            Long mainView = IDUtils.toLong((Object)mainDimViewIdStr);
            if (RuleJsUtils.dimHasView(dimensionNumberStr) && IDUtils.isEmptyLong((Long)mainView).booleanValue()) {
                needUpdateRule = true;
                break;
            }
            List ruleRangePojoList = ruleManageRowPojo.getRuleRangePojoList();
            if (CollectionUtils.isNotEmpty((Collection)ruleRangePojoList)) {
                block1: for (RuleRangePojo ruleRangePojo : ruleRangePojoList) {
                    List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
                    if (CollectionUtils.isEmpty((Collection)ruleRangMemberPojoList)) continue;
                    String dimNumberStr = ruleRangePojo.getNumberString();
                    for (RuleRangMemberPojo ruleRangMemberPojo : ruleRangMemberPojoList) {
                        Long viewId = IDUtils.toLong((Object)ruleRangMemberPojo.getViewIdString());
                        if (!RuleJsUtils.dimHasView(dimNumberStr) || !IDUtils.isEmptyLong((Long)viewId).booleanValue()) continue;
                        needUpdateRule = true;
                        continue block1;
                    }
                }
            }
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            block3: for (int j = 2; j < formulaPojoList.size(); ++j) {
                boolean hasAccount;
                Long viewId;
                FormulaPojo formulaPojo = (FormulaPojo)formulaPojoList.get(j);
                if ("member".equals(formulaPojo.getTypeString())) {
                    List notMainMemberList = formulaPojo.getNotMainMemberList();
                    if (CollectionUtils.isEmpty((Collection)notMainMemberList)) continue;
                    for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                        String dimNumber = formulaMembPojo.getDimNumber();
                        viewId = IDUtils.toLong((Object)formulaMembPojo.getViewIdString());
                        if (!RuleJsUtils.dimHasView(dimNumber) || !IDUtils.isEmptyLong((Long)viewId).booleanValue()) continue;
                        needUpdateRule = true;
                        continue block3;
                    }
                    continue;
                }
                if (!"function".equals(formulaPojo.getTypeString())) continue;
                String functionName = formulaPojo.getToolEnumKeyString();
                boolean bl = hasAccount = RuleFunctionEnum.YearValue.getName().equals(functionName) || RuleFunctionEnum.RecognitionSP.getName().equals(functionName) || RuleFunctionEnum.RecognitionPC.getName().equals(functionName) || RuleFunctionEnum.RecognitionP.getName().equals(functionName);
                if (hasAccount) {
                    FormulaPojo accFormulaPojo = (FormulaPojo)formulaPojo.getSubFormulaPojoList().get(2);
                    String mainDimNumber = accFormulaPojo.getMainDimNumber();
                    viewId = IDUtils.toLong((Object)accFormulaPojo.getViewIdString());
                    if (RuleJsUtils.dimHasView(mainDimNumber) && IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                        needUpdateRule = true;
                        continue block0;
                    }
                    List notMainMemberList = accFormulaPojo.getNotMainMemberList();
                    if (CollectionUtils.isNotEmpty((Collection)notMainMemberList)) {
                        for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                            String dimNumber = formulaMembPojo.getDimNumber();
                            Long formulaMemViewId = IDUtils.toLong((Object)formulaMembPojo.getViewIdString());
                            if (!RuleJsUtils.dimHasView(dimNumber) || !IDUtils.isEmptyLong((Long)formulaMemViewId).booleanValue()) continue;
                            needUpdateRule = true;
                            break;
                        }
                    }
                    needUpdateRule = RuleJsUtils.checkChildFunctionViewNeedUpgrade(modelCacheHelper, orderNumberInteger, formulaPojo.getChildFormulaPojo(), needUpdateRule);
                    continue;
                }
                needUpdateRule = RuleJsUtils.checkChildFunctionViewNeedUpgrade(modelCacheHelper, orderNumberInteger, formulaPojo, needUpdateRule);
            }
        }
        if (needUpdateRule) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"UpdateOldRuleService", (String)"autoUpdateOldRule", (Object[])new Object[]{modelIdLong, true});
        }
        return needUpdateRule;
    }

    private static boolean checkChildFunctionViewNeedUpgrade(IModelCacheHelper modelCacheHelper, Integer orderNumberInteger, FormulaPojo formulaPojo, boolean needUpdateRule) {
        if (formulaPojo == null) {
            return needUpdateRule;
        }
        if (formulaPojo.getChildFormulaPojo() != null) {
            needUpdateRule = RuleJsUtils.checkChildFunctionViewNeedUpgrade(modelCacheHelper, orderNumberInteger, formulaPojo.getChildFormulaPojo(), needUpdateRule);
        } else {
            IRuleFunction function = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, formulaPojo);
            if (RuleFunctionEnum.CurrMBR.getName().equals(function.getFunctionName())) {
                return needUpdateRule;
            }
            Map allValues = function.getAllValues();
            String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
            if (StringUtils.isBlank((CharSequence)dimNumber) || View.NoViewDimNums.contains(dimNumber)) {
                return needUpdateRule;
            }
            if (!allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey()) && !allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                return needUpdateRule;
            }
            String viewIdStr = (String)allValues.get("allvals_view_id");
            Long viewId = IDUtils.toLong((Object)viewIdStr);
            if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                needUpdateRule = true;
            }
        }
        return needUpdateRule;
    }

    public static boolean dimHasView(String dimensionNumber) {
        if (StringUtils.isBlank((CharSequence)dimensionNumber)) {
            return false;
        }
        return !View.NoViewDimNums.contains(dimensionNumber);
    }
}

