/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.orm.EbBizrulesetTypeEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.ModelPojo;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.rule.edit.RuleAuditPojo;
import kd.epm.eb.common.rule.edit.RuleCachePojo;
import kd.epm.eb.common.rule.edit.RuleGatherPojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.CollUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleManageSaveOp {
    private static final Log log = LogFactory.getLog(RuleManageSaveOp.class);
    private AbstractListPlugin plugin;

    public RuleManageSaveOp(AbstractListPlugin plugin) {
        this.plugin = plugin;
    }

    public void saveRuleAuditPojo(RuleAuditPojo ruleAuditPojo) {
        OpenRulePojo openRulePojo = (OpenRulePojo)CacheUtils.get((IPageCache)this.plugin.getPageCache(), OpenRulePojo.class);
        LambdaUtils.run(() -> {
            ModelPojo modelPojo = ruleAuditPojo.getModelPojo();
            if (modelPojo == null) {
                return;
            }
            List ruleManageRowPojoList = modelPojo.getRuleManageRowPojoList();
            if (CollectionUtils.isEmpty((Collection)ruleManageRowPojoList)) {
                return;
            }
            ruleManageRowPojoList.forEach(item -> item.setOrderNumberInteger(null));
        });
        RuleUtils.checkAndReorganize(openRulePojo, ruleAuditPojo.getModelPojo());
        LambdaUtils.run(() -> {
            ModelPojo originModelPojo = (ModelPojo)CacheUtils.get((IPageCache)this.plugin.getPageCache(), ModelPojo.class);
            if (originModelPojo == null) {
                return;
            }
            Map<String, RuleManageRowPojo> ruleManageRowPojoMap = originModelPojo.getRuleManageRowPojoList().stream().collect(Collectors.toMap(item -> item.getIdString(), item -> item));
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)ObjUtils.getLong((Object)((RuleManageRowPojo)originModelPojo.getRuleManageRowPojoList().get(0)).getModelIdLongString()));
            List ruleManageRowPojoList = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList();
            for (int i = 0; i < ruleManageRowPojoList.size(); ++i) {
                RuleManageRowPojo originRuleManageRowPojo;
                RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)ruleManageRowPojoList.get(i);
                if (!EbBizrulesetTypeEnum.EDIT.name().equals(ruleManageRowPojo.getTypeString()) || (originRuleManageRowPojo = ruleManageRowPojoMap.get(ruleManageRowPojo.getIdString())) == null) continue;
                ruleManageRowPojo.setOrderNumberInteger(Integer.valueOf(i + 1));
                FormulaPojo originFirstFormulaPojo = (FormulaPojo)originRuleManageRowPojo.getFormulaPojoList().get(0);
                FormulaPojo firstFormulaPojo = (FormulaPojo)ruleManageRowPojo.getFormulaPojoList().get(0);
                if (!originFirstFormulaPojo.getNumberString().equals(firstFormulaPojo.getNumberString())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684\u5de6\u7b49\u5f0f\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u539f\u5de6\u7b49\u5f0f\u4e3a%2\u3002", (String)"RuleManagePlugin2_112", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleManageRowPojo.getOrderNumberInteger(), StrUtils.format((String)"{}({})", (Object[])new Object[]{originFirstFormulaPojo.getValueString(), originFirstFormulaPojo.getNumberString()})}));
                }
                if (!StringUtils.isNotBlank((CharSequence)originRuleManageRowPojo.getDimensionNumberString()) || originRuleManageRowPojo.getDimensionNumberString().equals(ruleManageRowPojo.getDimensionNumberString())) continue;
                Dimension dimension = modelCacheHelper.getDimension(originRuleManageRowPojo.getDimensionNumberString());
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u89c4\u5219\u7684\u89c4\u5219\u6240\u5c5e\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u539f\u5de6\u7b49\u5f0f\u4e3a%2\u3002", (String)"RuleManagePlugin2_113", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleManageRowPojo.getOrderNumberInteger(), StrUtils.format((String)"{}({})", (Object[])new Object[]{dimension.getName(), dimension.getNumber()})}));
            }
        });
        List editRuleManageRowPojoList = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().stream().filter(item -> item.getNumberString().endsWith(".edit")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(editRuleManageRowPojoList)) {
            Long modelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)editRuleManageRowPojoList.get(0)).getModelIdLongString());
            Long businessModelIdLong = ObjUtils.getLong((Object)((RuleManageRowPojo)editRuleManageRowPojoList.get(0)).getBusinessModelIdLongString());
            LinkedHashSet<Long> needDeleteRuleIdLongSet = new LinkedHashSet<Long>(16);
            for (RuleManageRowPojo ruleManageRowPojo2 : editRuleManageRowPojoList) {
                List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber"}).whereEqual("fmodel", (Object)modelIdLong).whereEqual("fbizctrlrangeid", (Object)businessModelIdLong).whereEqual("fnumber", (Object)ruleManageRowPojo2.getNumberString()).whereNotEqual("fid", (Object)ObjUtils.getLong((Object)ruleManageRowPojo2.getIdString())).toRowList();
                if (CollectionUtils.isEmpty((Collection)ebBizrulesetList)) continue;
                needDeleteRuleIdLongSet.addAll(ebBizrulesetList.stream().map(item -> item.getIdLong()).collect(Collectors.toSet()));
            }
            RuleUtils.deleteRule(modelIdLong, needDeleteRuleIdLongSet);
        }
        RuleGatherPojo ruleGatherPojo = RuleUtils.getRuleGatherPojo(ruleAuditPojo.getModelPojo().getRuleManageRowPojoList());
        LambdaUtils.run(() -> {
            RuleCachePojo ruleCachePojo = (RuleCachePojo)CacheUtils.get((IPageCache)this.plugin.getPageCache(), RuleCachePojo.class);
            if (ruleCachePojo == null) {
                return;
            }
            Set savedInDbRuleIdLongSet = ruleCachePojo.getSavedInDbRuleIdLongSet();
            if (CollectionUtils.isEmpty((Collection)savedInDbRuleIdLongSet)) {
                return;
            }
            Set ruleIdLongSet = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().stream().map(ruleManageRowPojo -> ObjUtils.getLong((Object)ruleManageRowPojo.getIdString())).collect(Collectors.toSet());
            HashSet<Long> needDeleteRuleIdLongSet = new HashSet<Long>(CollectionUtils.subtract((Iterable)savedInDbRuleIdLongSet, ruleIdLongSet));
            if (CollectionUtils.isNotEmpty(needDeleteRuleIdLongSet) && ruleAuditPojo.getModelPojo() != null && CollectionUtils.isNotEmpty((Collection)ruleAuditPojo.getModelPojo().getRuleManageRowPojoList())) {
                QFilter qFilter = new QFilter("id", "in", needDeleteRuleIdLongSet);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_bizruleset", (String)"number", (QFilter[])qFilter.toArray());
                HashSet<String> numbers = new HashSet<String>(16);
                dynamicObjects.forEach(e -> numbers.add(e.getString("number")));
                this.updateMainSubSign("2", IDUtils.toLong((Object)((RuleManageRowPojo)ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().get(0)).getModelIdLongString()), numbers);
            }
            RuleUtils.deleteRule(ruleCachePojo.getModelIdLong(), needDeleteRuleIdLongSet);
        });
        Set ruleIdLongSet = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().stream().filter(item -> !Boolean.TRUE.equals(item.getReadOnlyBoolean())).map(ruleManageRowPojo -> Long.valueOf(ruleManageRowPojo.getIdString())).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"eb_bizrulesetacc", (QFilter[])((QFilter[])CollUtils.getArray((Object[])new QFilter[]{new QFilter("ruleid", "in", ruleIdLongSet)})));
        DeleteServiceHelper.delete((String)"eb_rulefunctionsentity", (QFilter[])((QFilter[])CollUtils.getArray((Object[])new QFilter[]{new QFilter("ruleid", "in", ruleIdLongSet)})));
        if (ruleAuditPojo.getModelPojo() != null && CollectionUtils.isNotEmpty((Collection)ruleAuditPojo.getModelPojo().getRuleManageRowPojoList())) {
            List ruleManageRowPojoList = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList();
            HashSet<String> numbers = new HashSet<String>(16);
            ruleManageRowPojoList.forEach(e -> numbers.add(e.getNumberString()));
            this.updateMainSubSign("3", IDUtils.toLong((Object)((RuleManageRowPojo)ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().get(0)).getModelIdLongString()), numbers);
        }
        RuleUtils.saveRuleGatherPojo(ruleGatherPojo);
        LambdaUtils.run(() -> {
            if (openRulePojo != null && Boolean.TRUE.equals(openRulePojo.getReadonlyBoolean())) {
                return;
            }
            RuleCachePojo ruleCachePojo = (RuleCachePojo)CacheUtils.get((IPageCache)this.plugin.getPageCache(), RuleCachePojo.class);
            if (ruleCachePojo == null) {
                return;
            }
            Map<Long, String> ruleIdAndNumberMap = ruleAuditPojo.getModelPojo().getRuleManageRowPojoList().stream().collect(Collectors.toMap(item -> ObjUtils.getLong((Object)item.getIdString()), item -> item.getNumberString()));
            RuleUtils.setRuleMutexPojoList(ruleIdAndNumberMap);
            LinkedHashSet<Long> mutexRuleIdLongSet = ruleCachePojo.getMutexRuleIdLongSet();
            if (mutexRuleIdLongSet == null) {
                mutexRuleIdLongSet = new LinkedHashSet<Long>(16);
                ruleCachePojo.setMutexRuleIdLongSet(mutexRuleIdLongSet);
            }
            mutexRuleIdLongSet.addAll(ruleIdAndNumberMap.keySet());
            CacheUtils.put((IPageCache)this.plugin.getPageCache(), (Object)ruleCachePojo);
        });
        this.plugin.writeLog("save", new MultiLangEnumBridge("\u4e1a\u52a1\u89c4\u5219\u2014", "RuleManagePlugin2_6", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "RuleManagePlugin2_75", "epm-eb-formplugin"));
        this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RuleManagePlugin2_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void updateMainSubSign(String sign, Long modelId, Set<String> numbers) {
        BgmdMainSubControlHelper instance = BgmdMainSubControlHelper.getInstance();
        Set allSubIds = instance.getAllSubIds(modelId);
        if (CollectionUtils.isNotEmpty((Collection)allSubIds)) {
            QFilter qFilter = new QFilter("number", "in", numbers).and("model", "in", (Object)allSubIds);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_bizruleset", (String)"id", (QFilter[])qFilter.toArray());
            HashSet ids = new HashSet(16);
            dynamicObjects.forEach(e -> ids.add(e.getLong("id")));
            if (CollectionUtils.isNotEmpty(ids)) {
                instance.updateSubSign("eb_bizruleset", sign, ids);
            }
        }
    }
}

