/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.orm.EbBizrulesetStatusEnum;
import kd.epm.eb.common.pojo.RuleReleasePojo;
import kd.epm.eb.common.pojo.RuleReleaseRowPojo;
import kd.epm.eb.common.rule.edit.RuleEnlargePojo;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleReleaseUtils {
    private static final Log log = LogFactory.getLog(RuleReleaseUtils.class);
    public static final String RULE_RELEASE_PLUGIN_CLOSE_CALL_BACK_ACTION_ID_STRING = "RULE_RELEASE_PLUGIN_CLOSE_CALL_BACK_ACTION_ID_STRING";
    public static final String RULE_BATCH = "RULE_BATCH";

    public static RuleReleasePojo getRuleReleasePojo(List<Long> ruleIdLongList) {
        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fmodel", "fbizctrlrangeid", "fnumber", "fname", "fformulashow"}).whereEqual("fstatus", (Object)EbBizrulesetStatusEnum.NOT_ENABLE.getDbStatusString()).whereIn("fid", ruleIdLongList).toRowList();
        if (CollectionUtils.isEmpty((Collection)ebBizrulesetList)) {
            return null;
        }
        Map originEbBizrulesetMap = (Map)LambdaUtils.get(() -> {
            List editEbBizrulesetList = ebBizrulesetList.stream().filter(item -> item.getNumberString().endsWith(".edit")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(editEbBizrulesetList)) {
                return null;
            }
            Set originRuleNumberStringSet = editEbBizrulesetList.stream().map(item -> StringUtils.substringBeforeLast((String)item.getNumberString(), (String)".edit")).collect(Collectors.toSet());
            EbBizruleset firstEbBizruleset = (EbBizruleset)editEbBizrulesetList.get(0);
            return OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fmodel", "fbizctrlrangeid", "fnumber", "fname", "fformulashow"}).whereEqual("fmodel", (Object)firstEbBizruleset.getModelLong()).whereEqual("fbizctrlrangeid", (Object)firstEbBizruleset.getBizctrlrangeidLong()).whereIn("fnumber", originRuleNumberStringSet).toRowList().stream().collect(Collectors.toMap(item -> item.getNumberString(), item -> item));
        });
        ArrayList<RuleReleaseRowPojo> ruleReleaseRowPojoList = new ArrayList<RuleReleaseRowPojo>(16);
        QFilter qFilter = new QFilter("id", "in", ebBizrulesetList.stream().map(item -> item.getIdLong()).collect(Collectors.toSet()));
        Map ruleDtoMap = (Map)LambdaUtils.get(() -> {
            List ruleDtoList = RuleService.getInstance().listRule(qFilter, Boolean.valueOf(false), null);
            if (CollectionUtils.isEmpty((Collection)ruleDtoList)) {
                return Collections.emptyMap();
            }
            return ruleDtoList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        });
        for (EbBizruleset ebBizruleset : ebBizrulesetList) {
            RuleReleaseRowPojo ruleReleaseRowPojo = new RuleReleaseRowPojo();
            ruleReleaseRowPojoList.add(ruleReleaseRowPojo);
            ruleReleaseRowPojo.setIdLong(ebBizruleset.getIdLong());
            ruleReleaseRowPojo.setRuleNumberString(ebBizruleset.getNumberString());
            ruleReleaseRowPojo.setRuleNameString(ebBizruleset.getNameString());
            ruleReleaseRowPojo.setRuleFormulashowString(ebBizruleset.getFormulashowString());
            LambdaUtils.run(() -> {
                RuleDto ruleDto = (RuleDto)ruleDtoMap.get(ebBizruleset.getIdLong());
                if (ruleDto == null) {
                    return;
                }
                RuleEnlargePojo ruleEnlargePojo = RuleUtils.getRuleEnlargePojo(ruleDto);
                if (ruleEnlargePojo == null) {
                    return;
                }
                ruleReleaseRowPojo.setMagnificationTimesBigInteger(ruleEnlargePojo.getMagnificationTimesBigInteger());
            });
            LambdaUtils.run(() -> {
                if (!ebBizruleset.getNumberString().endsWith(".edit")) {
                    return;
                }
                if (MapUtils.isEmpty((Map)originEbBizrulesetMap)) {
                    return;
                }
                EbBizruleset originEbBizruleset = (EbBizruleset)originEbBizrulesetMap.get(StringUtils.substringBeforeLast((String)ebBizruleset.getNumberString(), (String)".edit"));
                if (originEbBizruleset == null) {
                    return;
                }
                ruleReleaseRowPojo.setOriginRuleIdLong(originEbBizruleset.getIdLong());
                ruleReleaseRowPojo.setOriginRuleFormulashowString(originEbBizruleset.getFormulashowString());
            });
        }
        RuleReleasePojo ruleReleasePojo = new RuleReleasePojo();
        ruleReleasePojo.setRuleReleaseRowPojoList(ruleReleaseRowPojoList);
        ruleReleasePojo.setModelIdLong(((EbBizruleset)ebBizrulesetList.get(0)).getModelLong());
        ruleReleasePojo.setBusinessModelIdLong(((EbBizruleset)ebBizrulesetList.get(0)).getBizctrlrangeidLong());
        return ruleReleasePojo;
    }

    public static void openRuleReleasePlugin(IFormView formView, List<Long> ruleIdLongList, CloseCallBack closeCallBack) {
        RuleReleaseUtils.openRuleReleasePlugin(formView, RuleReleaseUtils.getRuleReleasePojo(ruleIdLongList), closeCallBack);
    }

    public static void openRuleReleasePlugin(IFormView formView, RuleReleasePojo ruleReleasePojo, CloseCallBack closeCallBack) {
        if (ruleReleasePojo == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u53d1\u5e03\u7684\u89c4\u5219\u3002", (String)"RuleReleasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        Map customParamMap = formShowParameter.getCustomParams();
        customParamMap.put(RuleReleasePojo.class.getName(), JsonUtils.getJsonString((Object)ruleReleasePojo));
        formShowParameter.setFormId("eb_rule_release");
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800px");
        styleCss.setHeight("600px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }
}

