/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteReturnMsg;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.MemberCutCheckUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;

public class RuleUpdateServiceImpl {
    private static final Log log = LogFactory.getLog(RuleUpdateServiceImpl.class);
    private static final RuleUpdateServiceImpl instance = new RuleUpdateServiceImpl();

    private RuleUpdateServiceImpl() {
    }

    public static RuleUpdateServiceImpl getInstance() {
        return instance;
    }

    public void updateAfterMemberPaste(Long modelId, Long dimensionId, Set<Long> dimMemberIds) {
        if (dimMemberIds == null || dimMemberIds.isEmpty()) {
            return;
        }
        MemberQuoteReturnMsg returnMsg = MemberCutCheckUtil.checkMemberQuotes((Long)modelId, (Long)dimensionId, dimMemberIds, (MemberQuoteResourceEnum)MemberQuoteResourceEnum.BizRule);
        if (!returnMsg.getResult().isEmpty()) {
            this.afterSave(modelId, new ArrayList<Object>(returnMsg.getResult()));
        }
    }

    @Deprecated
    public void afterSave(Long modelid, List<Object> pkids) {
        DynamicObject[] functionObj;
        DynamicObject[] membDojs;
        DynamicObject[] pojoDojs = null;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelid);
        if (pkids != null && !pkids.isEmpty()) {
            pojoDojs = BusinessDataServiceHelper.load((Object[])pkids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_bizruleset"));
        }
        if (pojoDojs == null || pojoDojs.length < 1) {
            return;
        }
        HashMap<String, Map> memberMapInfo = new HashMap<String, Map>(pkids.size());
        long modelId = pojoDojs[0].getLong("model.id");
        HashMap<String, Map> functions = new HashMap<String, Map>(16);
        for (DynamicObject doj : membDojs = BusinessDataServiceHelper.load((String)"eb_bizrulesetacc", (String)"ruleid,memberkey,dimenstionjsonfix,dimenstionjsonvar", (QFilter[])new QFilter("ruleid", "in", pkids).toArray())) {
            String ruleid = doj.getString("ruleid");
            FormulaMemberPojo formulaMemberPojo = RuleManageJsonUtil.getRefDimMembers((String)doj.getString("dimenstionjsonfix"));
            formulaMemberPojo.setMemberKey(doj.getString("memberkey"));
            for (DimMemberPojo dimMemberPojo : formulaMemberPojo.getRefDimMembers()) {
                Member member;
                if (dimMemberPojo.getDimNumber().equals(SysDimensionEnum.Account.getNumber()) && StringUtils.isEmpty((String)dimMemberPojo.getDataModelNumber())) {
                    Dataset dataSet = DatasetServiceHelper.getInstance().queryDataSetByAccountId(modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, dimMemberPojo.getNumber()).getId());
                    dimMemberPojo.setDataModelNumber(dataSet.getNumber());
                }
                if ((member = modelCache.getMember(dimMemberPojo.getDimNumber(), dimMemberPojo.getViewId(), dimMemberPojo.getNumber())) == null) {
                    log.info("budget-bizrule-log : member not found. obj id is " + doj.getLong("id"));
                    continue;
                }
                dimMemberPojo.setName(member.getName());
            }
            Map members = memberMapInfo.computeIfAbsent(ruleid, k -> new HashMap(16));
            members.put(formulaMemberPojo.getMemberKey(), formulaMemberPojo);
            doj.set("dimenstionjsonfix", (Object)RuleManageJsonUtil.writeInfoAsString((FormulaMemberPojo)formulaMemberPojo));
        }
        for (DynamicObject obj : functionObj = BusinessDataServiceHelper.load((String)"eb_rulefunctionsentity", (String)"ruleid,functionshowstr,functionkey,functioninfostr,functiontype", (QFilter[])new QFilter("ruleid", "in", pkids).toArray())) {
            RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)obj.getString("functionkey"), (String)obj.getString("functioninfostr"), (String)obj.getString("functiontype"));
            Long ruleid1 = obj.getLong("ruleid");
            ruleFunction.setBizRuleId(ruleid1.longValue());
            functions.computeIfAbsent(ruleid1.toString(), v -> new HashMap(16)).put(obj.getString("functionkey"), ruleFunction);
            ruleFunction.setFunctionShowStr(obj.getString("functionshowstr"));
        }
    }
}

