/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.dynamic;

import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.DynamicEntryEntityPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class DynamicEntryEntityUtils {
    private static final Log log = LogFactory.getLog(DynamicEntryEntityUtils.class);
    public static final String entryentity = "entryentity";
    public static final String ID = "ID";
    public static final String value = "value";
    public static final String number = "number";
    public static final String name = "name";

    public static void openDynamicEntryEntity(IFormView currentFormView, DynamicEntryEntityPojo dynamicEntryEntityPojo, CloseCallBack closeCallBack) {
        if (currentFormView == null || dynamicEntryEntityPojo == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_dynamic_entry_entity");
        formShowParameter.setParentPageId(currentFormView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        String showTypeEnumString = dynamicEntryEntityPojo.getShowTypeEnumString();
        ShowType showType = (ShowType)EnumUtils.getEnum(ShowType.class, (String)showTypeEnumString);
        if (showType == null) {
            showType = ShowType.Modal;
            dynamicEntryEntityPojo.setShowTypeEnumString(showType.name());
        }
        formShowParameter.getOpenStyle().setShowType(showType);
        if (ShowType.Modal.equals((Object)showType)) {
            StylePojo stylePojo = dynamicEntryEntityPojo.getStylePojo();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth((String)LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getWidthString())) {
                    return "800px";
                }
                return stylePojo.getWidthString();
            }));
            styleCss.setHeight((String)LambdaUtils.get(() -> {
                if (stylePojo == null || StringUtils.isBlank((CharSequence)stylePojo.getHeightString())) {
                    return "600px";
                }
                return stylePojo.getHeightString();
            }));
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        }
        formShowParameter.setCustomParam(DynamicEntryEntityPojo.class.getName(), (Object)JsonUtils.getJsonString((Object)dynamicEntryEntityPojo));
        String pageTitleString = dynamicEntryEntityPojo.getPageTitleString();
        if (StringUtils.isNotBlank((CharSequence)pageTitleString)) {
            formShowParameter.setCaption(pageTitleString);
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        currentFormView.showForm(formShowParameter);
    }
}

