/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.pojo.ImportCheckPojo;
import kd.epm.eb.common.pojo.ImportPojo;
import kd.epm.eb.common.pojo.ReturnDataToParentPojo;
import kd.epm.eb.common.pojo.UploadFilePojo;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(ImportPlugin.class);
    public static final String eb_import = "eb_import";
    public static final String download_template = "download_template";
    public static final String attachmentpanelap = "attachmentpanelap";
    public static final String url = "url";
    public static final String import_type = "import_type";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(attachmentpanelap);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{"btnok", download_template});
    }

    public void afterCreateNewData(EventObject e) {
        Object contentString = this.getView().getFormShowParameter().getCustomParam(ImportPojo.class.getName());
        ImportPojo importPojo = (ImportPojo)JsonUtils.readValue((String)((String)contentString), ImportPojo.class);
        CacheUtils.put((IPageCache)this.getPageCache(), (Object)importPojo);
        if (!Boolean.TRUE.equals(importPojo.getSupportDownloadTemplateBoolean())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{download_template});
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] uploadFileMapObjectArray = evt.getUrls();
        if (ArrayUtils.isEmpty((Object[])uploadFileMapObjectArray)) {
            return;
        }
        ImportPojo importPojo = (ImportPojo)CacheUtils.get((IPageCache)this.getPageCache(), ImportPojo.class);
        ArrayList<UploadFilePojo> uploadFilePojoList = importPojo.getUploadFilePojoList();
        if (uploadFilePojoList == null) {
            uploadFilePojoList = new ArrayList<UploadFilePojo>(uploadFileMapObjectArray.length);
            importPojo.setUploadFilePojoList(uploadFilePojoList);
        }
        for (Object uploadFileMapObject : uploadFileMapObjectArray) {
            if (!(uploadFileMapObject instanceof Map)) continue;
            Map uploadFileMap = (Map)uploadFileMapObject;
            UploadFilePojo uploadFilePojo = new UploadFilePojo();
            uploadFilePojo.setNameString(ObjUtils.getString(uploadFileMap.get("name")));
            uploadFilePojo.setUrlString(ObjUtils.getString(uploadFileMap.get(url)));
            uploadFilePojoList.add(uploadFilePojo);
        }
        CacheUtils.put((IPageCache)this.getPageCache(), (Object)importPojo);
    }

    public void afterRemove(UploadEvent evt) {
        Object[] uploadFileMapObjectArray = evt.getUrls();
        if (ArrayUtils.isEmpty((Object[])uploadFileMapObjectArray)) {
            return;
        }
        Set urlStringSet = Arrays.stream(uploadFileMapObjectArray).filter(item -> item instanceof Map).map(item -> {
            Map uploadFileMap = (Map)item;
            return ObjUtils.getString(uploadFileMap.get(url));
        }).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(urlStringSet)) {
            return;
        }
        ImportPojo importPojo = (ImportPojo)CacheUtils.get((IPageCache)this.getPageCache(), ImportPojo.class);
        List uploadFilePojoList = importPojo.getUploadFilePojoList();
        if (CollectionUtils.isEmpty((Collection)uploadFilePojoList)) {
            return;
        }
        uploadFilePojoList = uploadFilePojoList.stream().filter(item -> !urlStringSet.contains(item.getUrlString())).collect(Collectors.toList());
        importPojo.setUploadFilePojoList(uploadFilePojoList);
        CacheUtils.put((IPageCache)this.getPageCache(), (Object)importPojo);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btnok": {
                LambdaUtils.run(() -> {
                    ImportPojo importPojo = (ImportPojo)CacheUtils.get((IPageCache)this.getPageCache(), ImportPojo.class);
                    if (CollectionUtils.isEmpty((Collection)importPojo.getUploadFilePojoList())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u3002", (String)"ImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    importPojo.setImportTypeString(ObjUtils.getString((Object)this.getModel().getValue(import_type)));
                    LambdaUtils.run(() -> {
                        List uploadFilePojoList = importPojo.getUploadFilePojoList();
                        if (importPojo.getMaximumQuantityInteger() != null && importPojo.getMaximumQuantityInteger() > 0 && importPojo.getMaximumQuantityInteger() < importPojo.getUploadFilePojoList().size()) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u4e0a\u4f20\u4e0d\u8d85\u8fc7\u201c%1\u201d\u4e2a\u6587\u4ef6\u3002", (String)"ImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{importPojo.getMaximumQuantityInteger()}));
                        }
                        for (UploadFilePojo uploadFilePojo : uploadFilePojoList) {
                            if (StringUtils.isBlank((CharSequence)uploadFilePojo.getNameString())) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u3002", (String)"ImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            if (CollectionUtils.isEmpty((Collection)importPojo.getSupportFileTypeStringSet())) continue;
                            String typeString = uploadFilePojo.getNameString().substring(uploadFilePojo.getNameString().lastIndexOf(".") + 1);
                            if (importPojo.getSupportFileTypeStringSet().contains(typeString)) continue;
                            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u4e0a\u4f20\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff1a%1\u3002", (String)"ImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", importPojo.getSupportFileTypeStringSet())}));
                        }
                    });
                    if (StringUtils.isNotBlank((CharSequence)importPojo.getCheckClassNameString())) {
                        try {
                            Class<?> clazz = Class.forName(importPojo.getCheckClassNameString());
                            Function importCheckPojoFunction = (Function)clazz.newInstance();
                            ImportCheckPojo importCheckPojo = new ImportCheckPojo();
                            importCheckPojo.setImportPojo(importPojo);
                            importCheckPojo.setFormView(this.getView());
                            Boolean passBoolean = (Boolean)importCheckPojoFunction.apply(importCheckPojo);
                            if (!Boolean.TRUE.equals(passBoolean)) {
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            LambdaUtils.doNothing((Object)e);
                        }
                        catch (KDBizException kdBizException) {
                            throw kdBizException;
                        }
                        catch (Throwable throwable) {
                            log.info("import_throwable", (Object)throwable);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    ReturnDataToParentPojo returnDataToParentPojo = new ReturnDataToParentPojo();
                    returnDataToParentPojo.setTypeString(control.getKey());
                    returnDataToParentPojo.setParamString(JsonUtils.getJsonString((Object)importPojo));
                    this.getView().returnDataToParent((Object)JsonUtils.getJsonString((Object)returnDataToParentPojo));
                    this.getView().close();
                });
                break;
            }
            case "download_template": {
                LambdaUtils.run(() -> {
                    ReturnDataToParentPojo returnDataToParentPojo = new ReturnDataToParentPojo();
                    returnDataToParentPojo.setTypeString(control.getKey());
                    ImportPojo importPojo = (ImportPojo)CacheUtils.get((IPageCache)this.getPageCache(), ImportPojo.class);
                    returnDataToParentPojo.setParamString(JsonUtils.getJsonString((Object)importPojo));
                    this.getView().returnDataToParent((Object)JsonUtils.getJsonString((Object)returnDataToParentPojo));
                    this.getView().close();
                });
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] uploadFileMapObjectArray = evt.getUrls();
        if (ArrayUtils.isEmpty((Object[])uploadFileMapObjectArray)) {
            return;
        }
        ImportPojo importPojo = (ImportPojo)CacheUtils.get((IPageCache)this.getPageCache(), ImportPojo.class);
        String cancelMessageString = ImportPlugin.getCancelMessageString(uploadFileMapObjectArray, importPojo);
        if (StringUtils.isBlank((CharSequence)cancelMessageString)) {
            super.upload(evt);
        } else {
            evt.setCancel(true);
            evt.setCancelMsg(cancelMessageString);
        }
    }

    public static String getCancelMessageString(Object[] uploadFileMapObjectArray, ImportPojo importPojo) {
        for (Object uploadFileMapObject : uploadFileMapObjectArray) {
            if (!(uploadFileMapObject instanceof Map)) continue;
            Map uploadFileMap = (Map)uploadFileMapObject;
            String fileNameString = ObjUtils.getString(uploadFileMap.get("name"));
            if (StringUtils.isBlank((CharSequence)fileNameString)) {
                return ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u3002", (String)"ImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if (CollectionUtils.isEmpty((Collection)importPojo.getSupportFileTypeStringSet())) continue;
            String typeString = fileNameString.substring(fileNameString.lastIndexOf(".") + 1);
            if (importPojo.getSupportFileTypeStringSet().contains(typeString)) continue;
            return ResManager.loadResFormat((String)"\u8bf7\u4e0a\u4f20\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff1a%1\u3002", (String)"ImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", importPojo.getSupportFileTypeStringSet())});
        }
        return null;
    }
}

