/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.AbstractFunctionEditPlugin;

public class ABFunctionEdit
extends AbstractFunctionEditPlugin {
    @Override
    public boolean dealPropertyChange(PropertyChangedArgs e) {
        boolean dealed = super.dealPropertyChange(e);
        if (dealed) {
            return dealed;
        }
        String key = e.getProperty().getName();
        if (key.equals(FunctionItemEnum.DIMENSIONLIST.getKey())) {
            this.updatePropList((String)e.getChangeSet()[0].getNewValue());
            this.getDataModel().setValue(FunctionItemEnum.DIMEMBERRANGE.getKey(), null);
            this.getDataModel().setValue(FunctionItemEnum.ATTRIBUTE.getKey(), null);
            this.getPageCache().remove(FunctionItemEnum.DIMEMBERRANGE.getKey());
            this.getPageCache().remove("childIsFun");
            this.getPageCache().remove("allvals_view_id");
            this.getPageCache().remove("allvals_view_number");
        } else if (key.equals(FunctionItemEnum.ATTRIBUTE.getKey())) {
            this.getDataModel().setValue(FunctionItemEnum.ATTRIBUTEVAL.getKey(), null);
            this.getPageCache().remove(FunctionItemEnum.ATTRIBUTEVAL.getKey());
            this.getPageCache().remove("childIsFunByAttributeVal");
        }
        return true;
    }

    @Override
    public void updateFunctionShow() {
        IDataModel dataModel = this.getDataModel();
        StringBuilder sb = new StringBuilder();
        sb.append(RuleFunctionEnum.Attribute.getName());
        sb.append('(');
        String dimNumber = (String)dataModel.getValue(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (StringUtils.isNotEmpty((String)dimNumber)) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Dimension dimension = modelCache.getDimension(dimNumber);
            sb.append(dimension.getName());
        }
        sb.append(',');
        sb.append((String)dataModel.getValue(FunctionItemEnum.DIMEMBERRANGE.getKey()));
        sb.append(',');
        String atNumber = (String)dataModel.getValue(FunctionItemEnum.ATTRIBUTE.getKey());
        if (StringUtils.isNotEmpty((String)atNumber)) {
            long modelId = this.getModelId();
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add(new QFilter("number", "=", (Object)atNumber));
            DynamicObject atDoj = QueryServiceHelper.queryOne((String)"eb_customproperty", (String)"id,number,name,dimension,dseq,version", (QFilter[])qf.toArray());
            sb.append(atDoj.getString("name"));
        }
        sb.append(',');
        String attributeVal = (String)dataModel.getValue(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        sb.append(attributeVal);
        sb.append(')');
        dataModel.setValue("functionresult", (Object)sb.toString());
    }

    @Override
    boolean dealCheckData() {
        String childIsFun = this.getPageCache().get("childIsFun");
        if (BgConstant.TRUE_STR.equals(childIsFun)) {
            String dimMemberRange = this.getPageCache().get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            if (StringUtils.isEmpty((String)dimMemberRange)) {
                this.getFormView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ef4\u5ea6\u6210\u5458\u201d\u3002", (String)"ABFunctionEdit_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)dimMemberRange);
            if (childFun != null && RuleFunctionEnum.Attribute.getName().equals(childFun.getFunctionName())) {
                Map allValues = childFun.getAllValues();
                String childFunAttribute = (String)allValues.get(FunctionItemEnum.ATTRIBUTE.getKey());
                String attribute = (String)this.getDataModel().getValue(FunctionItemEnum.ATTRIBUTE.getKey());
                if (attribute.equals(childFunAttribute)) {
                    this.getFormView().showTipNotification(ResManager.loadKDString((String)"Attribute\u7684\u5c5e\u6027\u4e0e\u5d4c\u5957\u7684\u5c5e\u6027\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ABFunctionEdit_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }
}

