/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.DateFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.MemberFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.RuleFunctionEditPlugin;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractFunctionEditPlugin {
    private static final Log log = LogFactory.getLog(AbstractFunctionEditPlugin.class);
    private RuleFunctionEditPlugin formPlugin;
    private String functionName;
    protected static final String functionResultKey = "functionresult";

    public void propertyChange(PropertyChangedArgs e) {
        try {
            this.dealPropertyChange(e);
            this.updateFunctionShow();
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((IFormView)this.getFormView(), (String)"AbstractFunctionEditPlugin#propertyChange", (Throwable)ex);
        }
    }

    public boolean dealPropertyChange(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (propName.equals(FunctionItemEnum.TAXRATECHECK.getKey())) {
            boolean checked = (Boolean)e.getChangeSet()[0].getNewValue();
            if (checked) {
                this.getFormView().setVisible(Boolean.valueOf(true), new String[]{FunctionItemEnum.TAXRATE.getKey()});
            } else {
                this.getFormView().setVisible(Boolean.valueOf(false), new String[]{FunctionItemEnum.TAXRATE.getKey()});
                this.getDataModel().setValue(FunctionItemEnum.TAXRATE.getKey(), (Object)0);
            }
            return true;
        }
        return false;
    }

    public void initPage(IRuleFunction ruleFunction) {
        try {
            Boolean hasViewNumber;
            Boolean childIsFunByAttributeVal;
            List items = FunctionItemEnum.getItemByFunction((RuleFunctionEnum)RuleFunctionEnum.valueOf((String)this.functionName));
            IDataModel dataModel = this.getDataModel();
            Map allVals = ruleFunction.getAllValues();
            Boolean childIsFun = allVals.containsKey("childIsFun");
            if (childIsFun.booleanValue()) {
                this.getPageCache().put("childIsFun", "true");
            }
            if ((childIsFunByAttributeVal = Boolean.valueOf(allVals.containsKey("childIsFunByAttributeVal"))).booleanValue()) {
                this.getPageCache().put("childIsFunByAttributeVal", "true");
            }
            Boolean hasViewId = allVals.containsKey("allvals_view_id");
            Long viewId = 0L;
            if (hasViewId.booleanValue()) {
                String viewIdStr = (String)allVals.get("allvals_view_id");
                this.getPageCache().put("allvals_view_id", viewIdStr);
                viewId = IDUtils.toLong((Object)viewIdStr);
            }
            if ((hasViewNumber = Boolean.valueOf(allVals.containsKey("allvals_view_number"))).booleanValue()) {
                String viewNumber = (String)allVals.get("allvals_view_number");
                this.getPageCache().put("allvals_view_number", viewNumber);
            }
            String functionName = this.getFunctionName();
            IModelCacheHelper modelCache = this.getModelCache();
            for (FunctionItemEnum item : items) {
                Object val = allVals.get(item.getKey());
                if (item.isCanInput()) {
                    Member member;
                    String dimMembNum;
                    RuleFunction childRuleFun;
                    long modelId = this.getModelId();
                    if (item.getItemType() == FunctionItemTypeEnum.F7TEXT) {
                        Object memberNames;
                        if (item == FunctionItemEnum.DIMEMBERRANGE) {
                            if (childIsFun.booleanValue()) {
                                childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                                dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                                this.getPageCache().put(item.getKey(), (String)val);
                                continue;
                            }
                            LambdaUtils.run(() -> {
                                List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)((String)val));
                                if (CollectionUtils.isEmpty((Collection)memberConditionList)) {
                                    return;
                                }
                                String functionShowString = RuleFunctionUtils.getFunctionShowString((List)memberConditionList);
                                dataModel.setValue(item.getKey(), (Object)functionShowString);
                                this.getPageCache().put(item.getKey(), (String)val);
                            });
                            continue;
                        }
                        if (item == FunctionItemEnum.RETURNPERIOD || item == FunctionItemEnum.ACCOUNT || item == FunctionItemEnum.DIMGROUP) {
                            if (val == null) continue;
                            FormulaMemberPojo formulaMemberInfo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)((String)val), FormulaMemberPojo.class);
                            boolean isMemberFun = RuleFunctionEnum.Member.getName().equals(functionName);
                            if (isMemberFun) {
                                dataModel.setValue("singleselectmemfun", (Object)MemberFunctionParamEnum.BTN_DIMGROUP.getKey());
                                this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey()});
                                this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{MemberFunctionParamEnum.BTN_STRINGFUN.getMemberKey(), MemberFunctionParamEnum.BTN_FIXSTRING.getMemberKey()});
                            }
                            if (RuleFunctionEnum.YearValue.getName().equals(functionName) || isMemberFun) {
                                List refDimMembers = formulaMemberInfo.getRefDimMembers();
                                if (CollectionUtils.isNotEmpty((Collection)refDimMembers)) {
                                    memberNames = refDimMembers.stream().map(DimMemberPojo::getName).collect(Collectors.toList());
                                    dataModel.setValue(item.getKey(), (Object)StringUtils.join((Collection)memberNames, (String)"|"));
                                }
                            } else {
                                String accountMembName = formulaMemberInfo.getRefDimMemberByDimNum(SysDimensionEnum.Account.getNumber()).getName();
                                dataModel.setValue(item.getKey(), (Object)accountMembName);
                            }
                            this.getPageCache().put(item.getKey(), (String)val);
                            continue;
                        }
                        if (item == FunctionItemEnum.DIMEMBER) {
                            if (childIsFun.booleanValue()) {
                                childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                                dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                                this.getPageCache().put(item.getKey(), (String)val);
                                continue;
                            }
                            dimMembNum = (String)val;
                            if (StringUtils.isEmpty((String)dimMembNum)) continue;
                            String dimNum = (String)allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                            if (dimMembNum.contains(",")) {
                                LinkedList names = Lists.newLinkedList();
                                memberNames = dimMembNum.split(",");
                                int n = ((String[])memberNames).length;
                                for (int i = 0; i < n; ++i) {
                                    String memberNum = memberNames[i];
                                    Member member2 = modelCache.getMember(dimNum, viewId, memberNum);
                                    if (member2 == null) continue;
                                    names.add(member2.getName());
                                }
                                dataModel.setValue(FunctionItemEnum.DIMEMBER.getKey(), (Object)org.apache.commons.lang3.StringUtils.join((Iterable)names, (String)","));
                            } else {
                                Member member3 = modelCache.getMember(dimNum, viewId, dimMembNum);
                                if (member3 != null) {
                                    dataModel.setValue(FunctionItemEnum.DIMEMBER.getKey(), (Object)member3.getName());
                                }
                            }
                            this.getPageCache().put(item.getKey(), (String)val);
                            continue;
                        }
                        if (item == FunctionItemEnum.PERIOD) {
                            if (val == null) continue;
                            dimMembNum = (String)val;
                            if (dimMembNum.contains(",")) {
                                LinkedList names = Lists.newLinkedList();
                                for (Member memberNum : dimMembNum.split(",")) {
                                    member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, (String)memberNum);
                                    if (member == null) continue;
                                    names.add(member.getName());
                                }
                                dataModel.setValue(item.getKey(), (Object)org.apache.commons.lang3.StringUtils.join((Iterable)names, (String)","));
                            } else if (TemplateVarCommonUtil.checkIsVar((String)dimMembNum, (String)SysDimensionEnum.BudgetPeriod.getNumber()).booleanValue()) {
                                DynamicObject variable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id,name", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)dimMembNum).toArray());
                                dataModel.setValue(item.getKey(), variable.get("name"));
                            } else {
                                String dimMembName = (String)CommonServiceHelper.getValueFromDB((String)SysDimensionEnum.getMemberTreemodelByNumber((String)SysDimensionEnum.BudgetPeriod.getNumber()), (String)"name", (String)"number,dimension.number,model", (Object[])new Object[]{dimMembNum, SysDimensionEnum.BudgetPeriod.getNumber(), modelId});
                                dataModel.setValue(item.getKey(), (Object)dimMembName);
                            }
                            this.getPageCache().put(item.getKey(), (String)val);
                            break;
                        }
                        if (item == FunctionItemEnum.ATTRIBUTEVAL) {
                            String propNum;
                            String dimNum;
                            if (childIsFunByAttributeVal.booleanValue()) {
                                childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                                dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                                this.getPageCache().put(item.getKey(), (String)val);
                                continue;
                            }
                            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
                            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNum = (String)allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey()), propNum = (String)allVals.get(FunctionItemEnum.ATTRIBUTE.getKey()), (String)val);
                            if (propertyValue == null) continue;
                            dataModel.setValue(item.getKey(), (Object)propertyValue.getName());
                            this.getPageCache().put(item.getKey(), (String)val);
                            continue;
                        }
                        if (item == FunctionItemEnum.RELATIONFUN) {
                            if (!childIsFun.booleanValue()) continue;
                            childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                            dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                            this.getPageCache().put(item.getKey(), (String)val);
                            continue;
                        }
                        if (item != FunctionItemEnum.STRINGFUN || val == null) continue;
                        dataModel.setValue("singleselectmemfun", (Object)MemberFunctionParamEnum.BTN_STRINGFUN.getKey());
                        this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{MemberFunctionParamEnum.BTN_STRINGFUN.getMemberKey()});
                        this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey(), MemberFunctionParamEnum.BTN_FIXSTRING.getMemberKey()});
                        if (!childIsFun.booleanValue()) continue;
                        childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                        dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                        this.getPageCache().put(item.getKey(), (String)val);
                        continue;
                    }
                    if (item == FunctionItemEnum.ATTRIBUTE) {
                        this.updatePropList((String)allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey()));
                        dataModel.setValue(item.getKey(), val);
                        continue;
                    }
                    if (item == FunctionItemEnum.MEMBERFUN) {
                        if (val == null) continue;
                        dataModel.setValue("singleselect", (Object)DateFunctionParamEnum.CurrMember.getKey());
                        this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{DateFunctionParamEnum.CurrMember.getMemberKey()});
                        this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{DateFunctionParamEnum.Date.getMemberKey(), DateFunctionParamEnum.BudgetPeriod.getMemberKey()});
                        childRuleFun = RuleFunctionFactory.fromJsonString((String)((String)val));
                        dataModel.setValue(item.getKey(), (Object)childRuleFun.getFunctionShowStr());
                        this.getPageCache().put(item.getKey(), (String)val);
                        break;
                    }
                    if (item == FunctionItemEnum.PERIOD) {
                        if (val == null) continue;
                        dataModel.setValue("singleselect", (Object)DateFunctionParamEnum.BudgetPeriod.getKey());
                        this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{DateFunctionParamEnum.BudgetPeriod.getMemberKey()});
                        this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{DateFunctionParamEnum.CurrMember.getMemberKey(), DateFunctionParamEnum.Date.getMemberKey()});
                        dimMembNum = (String)val;
                        if (dimMembNum.contains(",")) {
                            LinkedList names = Lists.newLinkedList();
                            for (String memberNum : dimMembNum.split(",")) {
                                member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), memberNum);
                                if (member == null) continue;
                                names.add(member.getName());
                            }
                            dataModel.setValue(item.getKey(), (Object)org.apache.commons.lang3.StringUtils.join((Iterable)names, (String)","));
                        } else {
                            String dimMembName = (String)CommonServiceHelper.getValueFromDB((String)SysDimensionEnum.getMemberTreemodelByNumber((String)SysDimensionEnum.BudgetPeriod.getNumber()), (String)"name", (String)"number,dimension.number,model", (Object[])new Object[]{dimMembNum, SysDimensionEnum.BudgetPeriod.getNumber(), modelId});
                            dataModel.setValue(item.getKey(), (Object)dimMembName);
                        }
                        this.getPageCache().put(item.getKey(), (String)val);
                        break;
                    }
                    if (item == FunctionItemEnum.DATETIME) {
                        if (val == null) continue;
                        dataModel.setValue("singleselect", (Object)DateFunctionParamEnum.Date.getKey());
                        this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{DateFunctionParamEnum.Date.getMemberKey()});
                        this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{DateFunctionParamEnum.CurrMember.getMemberKey(), DateFunctionParamEnum.BudgetPeriod.getMemberKey()});
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                            Date date = dateFormat.parse(val.toString());
                            dataModel.setValue(item.getKey(), (Object)date);
                            break;
                        }
                        catch (ParseException e) {
                            log.info("date format error!", (Object)e);
                            throw new KDBizException("date format error!");
                        }
                    }
                    if (item == FunctionItemEnum.SPECIFIEDPERIOD) {
                        this.updateSpecifiedPeriodPropList();
                        dataModel.setValue(item.getKey(), val);
                        continue;
                    }
                    if (item == FunctionItemEnum.FIXSTRING) {
                        if (val == null) continue;
                        dataModel.setValue("singleselectmemfun", (Object)MemberFunctionParamEnum.BTN_FIXSTRING.getKey());
                        this.formPlugin.getView().setEnable(Boolean.valueOf(true), new String[]{MemberFunctionParamEnum.BTN_FIXSTRING.getMemberKey()});
                        this.formPlugin.getView().setEnable(Boolean.valueOf(false), new String[]{MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey(), MemberFunctionParamEnum.BTN_STRINGFUN.getMemberKey()});
                        dataModel.setValue(item.getKey(), val);
                        continue;
                    }
                    dataModel.setValue(item.getKey(), val);
                    if (item != FunctionItemEnum.TAXRATE || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) continue;
                    dataModel.setValue(FunctionItemEnum.TAXRATECHECK.getKey(), (Object)Boolean.TRUE);
                    this.getFormView().setVisible(Boolean.valueOf(true), new String[]{FunctionItemEnum.TAXRATE.getKey()});
                    continue;
                }
                if (item.getItemType() != FunctionItemTypeEnum.ENTITY) continue;
                List allRowVals = (List)SerializationUtils.fromJsonString((String)((String)val), List.class);
                if (allRowVals.size() > 1) {
                    dataModel.batchCreateNewEntryRow(item.getKey(), allRowVals.size() - 1);
                }
                int rowIndex = 0;
                for (Map rowVal : allRowVals) {
                    for (Map.Entry value : rowVal.entrySet()) {
                        dataModel.setValue((String)value.getKey(), value.getValue(), rowIndex);
                    }
                    ++rowIndex;
                }
            }
            this.updateFunctionShow();
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((IFormView)this.getFormView(), (String)"AbstractFunctionEditPlugin#initPage", (Throwable)ex);
        }
    }

    public Map<String, Object> dealPageData() {
        HashMap<String, Object> allVal = new HashMap<String, Object>(16);
        List items = FunctionItemEnum.getItemByFunction((RuleFunctionEnum)RuleFunctionEnum.valueOf((String)this.functionName));
        for (FunctionItemEnum itemEnum : items) {
            switch (itemEnum.getItemType()) {
                case TEXT: 
                case NUMBER: 
                case DECIMAL: 
                case LIST: {
                    if (!itemEnum.isCanInput()) break;
                    allVal.put(itemEnum.getKey(), this.getValFromDataModel(itemEnum.getKey(), null));
                    break;
                }
                case F7: {
                    allVal.put(itemEnum.getKey(), this.getValFromDataModel(itemEnum.getKey(), "number"));
                    break;
                }
                case F7TEXT: {
                    allVal.put(itemEnum.getKey(), this.getPageCache().get(itemEnum.getKey()));
                    break;
                }
                case ENTITY: {
                    DynamicObjectCollection rows = this.getDataModel().getEntryEntity(itemEnum.getKey());
                    ArrayList rowVals = new ArrayList(rows.size());
                    for (DynamicObject row : rows) {
                        HashMap<String, String> vals = new HashMap<String, String>(16);
                        vals.put(FunctionItemEnum.RETURNCYCLE.getKey(), row.getString(FunctionItemEnum.RETURNCYCLE.getKey()));
                        vals.put(FunctionItemEnum.RETURNSCALE.getKey(), row.getString(FunctionItemEnum.RETURNSCALE.getKey()));
                        rowVals.add(vals);
                    }
                    allVal.put(itemEnum.getKey(), SerializationUtils.toJsonString(rowVals));
                }
            }
        }
        return allVal;
    }

    boolean dealCheckData() {
        return true;
    }

    public void updateFunctionShow() {
    }

    public void updatePropList(String newDimNum) {
        ComboEdit propList = (ComboEdit)this.getFormView().getControl(FunctionItemEnum.ATTRIBUTE.getKey());
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)this.getModelId());
        qb.add("dimension.number", "=", (Object)newDimNum);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"eb_customproperty", (String)"number,name", (QFilter[])qb.toArrays(), (String)"dseq");
        for (Row prop : dataSet) {
            itemList.add(new ComboItem(new LocaleString(prop.getString("name")), prop.getString("number")));
        }
        propList.setComboItems(itemList);
    }

    public void updateSpecifiedPeriodPropList() {
        ComboEdit propList = (ComboEdit)this.getFormView().getControl(FunctionItemEnum.SPECIFIEDPERIOD.getKey());
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
        for (PeriodEnum prop : PeriodEnum.values()) {
            itemList.add(new ComboItem(new LocaleString(prop.getName()), prop.getKey()));
        }
        propList.setComboItems(itemList);
    }

    public void save() {
        if (this.dealCheckData()) {
            this.doSave();
        }
    }

    public void doSave() {
        try {
            Map<String, Object> allVals = this.dealPageData();
            if (allVals != null) {
                String functionKey;
                String viewNumber;
                String viewIdStr;
                String childIsFunByAttributeVal;
                String childIsFun = this.getPageCache().get("childIsFun");
                if (StringUtils.isNotEmpty((String)childIsFun)) {
                    allVals.put("childIsFun", childIsFun);
                }
                if (StringUtils.isNotEmpty((String)(childIsFunByAttributeVal = this.getPageCache().get("childIsFunByAttributeVal")))) {
                    allVals.put("childIsFunByAttributeVal", childIsFunByAttributeVal);
                }
                if (StringUtils.isNotEmpty((String)(viewIdStr = this.getPageCache().get("allvals_view_id")))) {
                    allVals.put("allvals_view_id", viewIdStr);
                }
                if (StringUtils.isNotEmpty((String)(viewNumber = this.getPageCache().get("allvals_view_number")))) {
                    allVals.put("allvals_view_number", viewNumber);
                }
                if ((functionKey = this.getFormPlugin().getFunctionKey()) == null) {
                    functionKey = "F`" + this.getFunctionName() + "`" + DB.genGlobalLongId();
                }
                RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionKey, null, (String)this.getFunctionName());
                ruleFunction.getAllValues().putAll(allVals);
                ruleFunction.setFunctionShowStr((String)this.getValFromDataModel(functionResultKey, null));
                this.getFormView().returnDataToParent((Object)SerializationUtils.serializeToBase64((Object)ruleFunction));
                this.getFormView().close();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((IFormView)this.getFormView(), (String)"AbstractFunctionEditPlugin#doSave", (Throwable)e);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public <T> T getValFromDataModel(String key, String propName) {
        IDataModel dataModel = this.getDataModel();
        Object val = null;
        if (propName == null) {
            val = dataModel.getValue(key);
        } else {
            DynamicObject f7Val = (DynamicObject)dataModel.getValue(key);
            if (f7Val != null) {
                val = f7Val.get(propName);
            }
        }
        return (T)val;
    }

    public RuleFunctionEditPlugin getFormPlugin() {
        return this.formPlugin;
    }

    public void setFormPlugin(RuleFunctionEditPlugin formPlugin) {
        this.formPlugin = formPlugin;
    }

    public IModelCacheHelper getModelCache() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    public long getModelId() {
        return (Long)this.getFormView().getFormShowParameter().getCustomParam("MODELID");
    }

    public IFormView getFormView() {
        return this.formPlugin.getView();
    }

    public IDataModel getDataModel() {
        return this.formPlugin.getView().getModel();
    }

    List<Dimension> getDimensinoListCache() {
        long datasetId = this.formPlugin.getDatasetId();
        IModelCacheHelper modelCache = this.getModelCache();
        if (modelCache == null || ObjUtils.nullOrZero((Long[])new Long[]{datasetId})) {
            return new ArrayList<Dimension>(16);
        }
        return modelCache.getDimensionList(Long.valueOf(datasetId));
    }

    public IPageCache getPageCache() {
        return this.formPlugin.getPageCache();
    }
}

