/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.formplugin.rulemanage.functionEdit.AbstractFunctionEditPlugin;

public class RSPFunctionEdit
extends AbstractFunctionEditPlugin {
    @Override
    public void updateFunctionShow() {
        TextEdit control1 = (TextEdit)this.getFormView().getControl(FunctionItemEnum.ACCOUNT.getKey());
        Tips tips = new Tips();
        tips.setContent(new LocaleString(FunctionItemEnum.ACCOUNT.getExplain()));
        tips.setType("text");
        control1.addTips(tips);
        StringBuilder sb = new StringBuilder();
        sb.append(RuleFunctionEnum.RecognitionSP.getName());
        sb.append('(');
        IDataModel dataModel = this.getDataModel();
        String accountName = (String)dataModel.getValue(FunctionItemEnum.ACCOUNT.getKey());
        sb.append(accountName);
        sb.append(',');
        BigDecimal taxrate = (BigDecimal)dataModel.getValue(FunctionItemEnum.TAXRATE.getKey());
        taxrate = taxrate.multiply(new BigDecimal(100));
        sb.append(taxrate.setScale(2));
        sb.append('%');
        sb.append(',');
        DynamicObjectCollection entity = dataModel.getEntryEntity(FunctionItemEnum.RETURNENTITY.getKey());
        if (!entity.isEmpty()) {
            for (DynamicObject row : entity) {
                sb.append(row.getInt("returncycle"));
                sb.append('|');
                taxrate = row.getBigDecimal("returnscale");
                taxrate = taxrate.multiply(new BigDecimal(100));
                sb.append(taxrate.setScale(2));
                sb.append('%');
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        dataModel.setValue("functionresult", (Object)sb.toString());
    }

    @Override
    boolean dealCheckData() {
        DynamicObjectCollection entitys = this.getDataModel().getEntryEntity(FunctionItemEnum.RETURNENTITY.getKey());
        BigDecimal scale = new BigDecimal(0);
        HashSet<Integer> periods = new HashSet<Integer>(entitys.size());
        for (DynamicObject row : entitys) {
            BigDecimal rowScale = row.getBigDecimal(FunctionItemEnum.RETURNSCALE.getKey());
            Integer period = row.getInt(FunctionItemEnum.RETURNCYCLE.getKey());
            if (periods.contains(period)) {
                this.getFormView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u56de\u6b3e\u5468\u671f\u3002", (String)"RSPFunctionEdit_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            periods.add(period);
            scale = scale.add(rowScale);
        }
        int compare = scale.compareTo(BigDecimal.ONE);
        if (compare < 0) {
            this.getFormView().showConfirm(ResManager.loadKDString((String)"\u6240\u6709\u786e\u8ba4\u56de\u6b3e\u6570\u4e4b\u548c\u4e0e\u5f85\u786e\u8ba4\u6570\u4e0d\u7b49\uff0c\u662f\u5426\u518d\u6b21\u4fee\u6539\u51fd\u6570\uff1f", (String)"RSPFunctionEdit_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(FunctionItemEnum.RETURNENTITY.getKey(), (IFormPlugin)this.getFormPlugin()));
            return false;
        }
        if (compare > 0) {
            this.getFormView().showTipNotification(ResManager.loadKDString((String)"\u603b\u56de\u6b3e\u6bd4\u7387\u4e0d\u5141\u8bb8\u5927\u4e8e100%\u3002", (String)"RSPFunctionEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

