/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.DateFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.MemberFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.KdUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.functionEdit.AbstractFunctionEditPlugin;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RuleFunctionEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    protected static final String functionEntityKey = "entryentity";
    private static final String returnentityKey = "returnentity";
    private static final String itemexplain = "itemexplain";
    private static final String functionexplain = "functionexplain";
    private static final String BTNOK = "btnok";
    private static final String search_pre = "searchbefore";
    private static final String search_next = "searchnext";
    private static final int search_rowIndex_forGet = -1;
    protected static final int search_rowIndex_forRemove = -2;
    private static final String search_rowIndex_key = "function_search_rowIndex";
    private static final String function_search_str = "function_search_str";
    protected static final String functionType_key = "functiontype";
    private static final String SINGLESELECT = "singleselect";
    private static final String MulMembChoose = "eb_rulechoce";
    private static final String SingleMembChoose = "eb_rulechoce2";
    private static final String CLOSE_CALLBACK_ATTRIBUTEVAL_FUN = "close_callback_attributeval_fun";
    private static final String CLOSE_CALLBACK_ATTRIBUTEVAL_MEM = "close_callback_attributeval_mem";
    private AbstractFunctionEditPlugin functionEditPlugin = null;

    public void initialize() {
        try {
            super.initialize();
            EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#initialize", (Throwable)e);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addClickListeners(new String[]{FunctionItemEnum.RETURNPERIOD.getKey(), FunctionItemEnum.DIMEMBERRANGE.getKey(), FunctionItemEnum.ACCOUNT.getKey(), FunctionItemEnum.DIMEMBER.getKey(), BTNOK, search_pre, search_next, "member", "period", FunctionItemEnum.ATTRIBUTEVAL.getKey(), FunctionItemEnum.RELATIONFUN.getKey(), FunctionItemEnum.DIMGROUP.getKey(), FunctionItemEnum.STRINGFUN.getKey()});
            Search search = (Search)this.getControl("searchap");
            search.addEnterListener((SearchEnterListener)this);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#registerListener", (Throwable)ex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            this.updateFunTypeList();
            this.initFunctionList();
            String functiontype = (String)this.getModel().getValue(functionType_key);
            String functionName = this.getCurrentFunctionName();
            if ("all".equals(functiontype) || "relation".equals(functiontype) || RuleFunctionTypeEnum.String.getKey().equals(functiontype)) {
                this.initDimensionList2(functionName);
                this.initAttribute();
            } else {
                this.initDimensionList(functionName);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    protected void updateFunTypeList() {
        if (!this.isShowFiFunction()) {
            ComboEdit itemc = (ComboEdit)this.getControl(functionType_key);
            ArrayList<ComboItem> com = new ArrayList<ComboItem>(16);
            for (RuleFunctionTypeEnum functionTypeEnum : RuleFunctionTypeEnum.values()) {
                if (functionTypeEnum == RuleFunctionTypeEnum.Finance) continue;
                com.add(new ComboItem(new LocaleString(functionTypeEnum.getName()), functionTypeEnum.getKey()));
            }
            itemc.setComboItems(com);
        }
    }

    public String getFunctionKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam("functionKey");
    }

    protected void initFunctionList() {
        IRuleFunction ruleFunction;
        String functionType = (String)this.getView().getFormShowParameter().getCustomParam("functionType");
        String functionName = null;
        boolean hasFunction = this.getView().getFormShowParameter().getCustomParams().containsKey("functionKey");
        if (hasFunction) {
            ruleFunction = (IRuleFunction)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("functionInfo")));
            functionName = ruleFunction.getFunctionName();
            functionType = RuleFunctionEnum.valueOf((String)functionName).getFunctionType().getKey();
        }
        if (functionType == null) {
            functionType = RuleFunctionTypeEnum.All.getKey();
        }
        this.updateFunctionList(functionType, functionName);
        if (hasFunction) {
            ruleFunction = (IRuleFunction)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("functionInfo")));
            this.getFunctionEditPlugin().initPage(ruleFunction);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{functionType_key});
        } else if (RuleFunctionEnum.YearValue.getName().equals(functionType)) {
            this.getFunctionEditPlugin().updateSpecifiedPeriodPropList();
        }
    }

    protected void initDimensionList(String functionName) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List dims = modelCacheHelper.getDimensionList(Long.valueOf(this.getDatasetId()));
        if (!dims.isEmpty()) {
            ComboEdit dimList = (ComboEdit)this.getControl(FunctionItemEnum.DIMENSIONLIST.getKey());
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(dims.size());
            for (Dimension dim : dims) {
                itemList.add(new ComboItem(new LocaleString(dim.getName()), dim.getNumber()));
            }
            dimList.setComboItems(itemList);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
            entryGrid.selectRows(this.getOrSetSelectFunctionRowAfterInit(-1));
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#afterBindData", (Throwable)ex);
        }
    }

    protected int getOrSetSelectFunctionRowAfterInit(int rowIndex) {
        int index = -1;
        if (rowIndex < 0) {
            String cacheIndex = this.getPageCache().get("selectedFunctionRow");
            if (cacheIndex != null) {
                index = Integer.parseInt(cacheIndex);
            }
        } else {
            this.getPageCache().put("selectedFunctionRow", String.valueOf(rowIndex));
        }
        return index;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String propName;
            if (!this.checkNeedDealPropertyChange()) {
                return;
            }
            Object newVal = e.getChangeSet()[0].getNewValue();
            Object oldVal = e.getChangeSet()[0].getOldValue();
            switch (propName = e.getProperty().getName()) {
                case "functiontype": {
                    if (newVal == null || StringUtils.isEmpty((String)newVal.toString()) && oldVal != null) {
                        EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)propName, (Object)oldVal);
                        this.getView().updateView(propName);
                        break;
                    }
                    this.updateFunctionList((String)newVal, null);
                    break;
                }
                case "singleselect": {
                    this.initDateFunPan();
                    this.getFunctionEditPlugin().propertyChange(e);
                    break;
                }
                case "singleselectmemfun": {
                    this.initMemberFunPan();
                    this.getFunctionEditPlugin().propertyChange(e);
                    break;
                }
                default: {
                    FunctionItemEnum itemEnum = FunctionItemEnum.getItemByKey((String)propName);
                    if (itemEnum != null) {
                        this.getFunctionEditPlugin().propertyChange(e);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#propertyChanged", (Throwable)ex);
        }
    }

    public long getDatasetId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dataset");
    }

    public long getRangeDatasetId() {
        long rangeDatasetId = 0L;
        Object customParam = this.getView().getFormShowParameter().getCustomParam("rangedataset");
        if (customParam instanceof Long) {
            rangeDatasetId = IDUtils.toLong((Object)customParam);
        }
        return rangeDatasetId;
    }

    private long getBizCtrlRangeId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
    }

    private void updateFunctionList(String funKey, String functionName) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(functionEntityKey);
        RuleFunctionEnum ruleFun = RuleFunctionEnum.getFunctionEnumByNameNoError((String)funKey);
        RuleFunctionTypeEnum functionTypeEnum = ruleFun == null ? RuleFunctionTypeEnum.getEnumByKey((String)funKey) : ruleFun.getFunctionType();
        if (functionTypeEnum == null) {
            functionTypeEnum = RuleFunctionTypeEnum.All;
        }
        this.getModel().setValue(functionType_key, (Object)functionTypeEnum.getKey());
        List functionEnumList = RuleFunctionEnum.getFunctionsByType((RuleFunctionTypeEnum)functionTypeEnum);
        if (!this.isShowFiFunction()) {
            functionEnumList.removeIf(function -> function.getFunctionType() == RuleFunctionTypeEnum.Finance);
        }
        if (StringUtils.isNotEmpty((String)functionName)) {
            functionEnumList.removeIf(function -> !function.getName().equalsIgnoreCase(functionName));
        }
        if (functionEnumList.size() > 0) {
            dataModel.batchCreateNewEntryRow(functionEntityKey, functionEnumList.size());
            int rowIndex = 0;
            int selectRowIndex = 0;
            for (RuleFunctionEnum functionEnum : functionEnumList) {
                if (functionEnum == ruleFun) {
                    selectRowIndex = rowIndex;
                }
                if (functionEnum == null) continue;
                dataModel.setValue("functionname", (Object)functionEnum.getName(), rowIndex++);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
            entryGrid.selectRows(selectRowIndex);
            if (ruleFun == null) {
                String funName2 = ((RuleFunctionEnum)functionEnumList.get(0)).getName();
                this.doAfterFunctionSelectChange(funName2);
            } else {
                this.doAfterFunctionSelectChange(ruleFun.getName());
            }
            this.getOrSetSelectFunctionRowAfterInit(selectRowIndex);
        }
        this.getOrCacheSearchStr("");
        this.getOrSetSearchRowIndex(-2);
    }

    private boolean isShowFiFunction() {
        String mainDimNum = this.getMainDimNumber();
        return SysDimensionEnum.Account.getNumber().equals(mainDimNum);
    }

    private String getMainDimNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("mainDimNumber");
    }

    protected void updateFieldShow(String functionName) {
        boolean isMemberFun = RuleFunctionEnum.Member.getName().equals(functionName);
        if ("Date".equals(functionName)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap91"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap9"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap911"});
        } else if (isMemberFun) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap911"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap91"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap9"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap91"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap911"});
        }
        this.getView().setVisible(Boolean.valueOf(false), FunctionItemEnum.getAllItemKey());
        this.setNeedDealPropertyChange(false);
        if (functionName != null && !functionName.equals("")) {
            RuleFunctionEnum functionEnum = RuleFunctionEnum.valueOf((String)functionName);
            List itemEnums = FunctionItemEnum.getItemByFunction((RuleFunctionEnum)functionEnum);
            for (FunctionItemEnum itemEnum : itemEnums) {
                if (itemEnum == FunctionItemEnum.DIMENSIONLIST) {
                    String flexPanel1 = "flexpanelap9";
                    HashMap<String, String> ctl = new HashMap<String, String>();
                    ctl.put("id", flexPanel1);
                    ctl.put("type", "flexpanel");
                    if (isMemberFun) {
                        ctl.put("h", (String)new LocaleString("35px"));
                        ctl.put("of", (String)new LocaleString("hidden"));
                    } else {
                        ctl.put("h", (String)new LocaleString("360px"));
                        ctl.put("of", (String)new LocaleString("auto"));
                    }
                    this.getView().updateControlMetadata(flexPanel1, ctl);
                }
                if (itemEnum == FunctionItemEnum.TAXRATE) continue;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{itemEnum.getKey()});
                if (!itemEnum.isCanInput()) continue;
                if (itemEnum == FunctionItemEnum.TAXRATECHECK) {
                    this.getModel().setValue(itemEnum.getKey(), (Object)false);
                    continue;
                }
                if (itemEnum == FunctionItemEnum.LEVEL) {
                    this.getModel().setValue(itemEnum.getKey(), (Object)1);
                    continue;
                }
                this.getModel().setValue(itemEnum.getKey(), null);
            }
            this.getModel().setValue(functionexplain, (Object)functionEnum.getExplain());
            this.getModel().setValue("functionresult", null);
        } else {
            this.getModel().setValue(functionexplain, null);
            this.getModel().setValue("functionresult", null);
        }
        this.getModel().setValue("memberfun", (Object)("CurrMBR(" + SysDimensionEnum.BudgetPeriod.getChineseName() + ")"));
        this.setNeedDealPropertyChange(true);
    }

    protected void doAfterFunctionSelectChange(String functionName) {
        String dimensionList;
        this.updateFieldShow(functionName);
        if (RuleFunctionEnum.Attribute.getName().equals(functionName) || RuleFunctionEnum.GetAttribute.getName().equals(functionName) || RuleFunctionEnum.List.getName().equals(functionName) || RuleFunctionEnum.Ancestor.getName().equals(functionName) || RuleFunctionEnum.Children.getName().equals(functionName) || RuleFunctionEnum.Relative.getName().equals(functionName) || RuleFunctionEnum.Sibling.getName().equals(functionName) || RuleFunctionEnum.Parent.getName().equals(functionName) || RuleFunctionEnum.CurrMBR.getName().equals(functionName) || RuleFunctionEnum.GetNumber.getName().equals(functionName) || RuleFunctionEnum.GetName.getName().equals(functionName)) {
            this.initDimensionList2(functionName);
            if (RuleFunctionEnum.GetAttribute.getName().equals(functionName)) {
                this.initAttribute();
            }
        } else if (RuleFunctionEnum.Date.getName().equals(functionName)) {
            this.initDateFunPan();
        } else if (RuleFunctionEnum.YearValue.getName().equals(functionName)) {
            this.initDimensionList2(functionName);
            this.getFunctionEditPlugin().updateSpecifiedPeriodPropList();
        } else if (RuleFunctionEnum.Member.getName().equals(functionName)) {
            this.initDimensionList2(functionName);
            this.initMemberFunPan();
        } else {
            this.initDimensionList(functionName);
        }
        if (StringUtils.isEmpty((String)(dimensionList = (String)this.getModel().getValue(FunctionItemEnum.DIMENSIONLIST.getKey()))) && (RuleFunctionEnum.Attribute.getName().equals(functionName) || RuleFunctionEnum.GetAttribute.getName().equals(functionName) || RuleFunctionEnum.IsAttribute.getName().equals(functionName))) {
            ComboEdit propList = (ComboEdit)this.getView().getControl(FunctionItemEnum.ATTRIBUTE.getKey());
            ArrayList itemList = new ArrayList(16);
            propList.setComboItems(itemList);
        }
        this.getFunctionEditPlugin().updateFunctionShow();
        this.clearCacheInfo();
    }

    protected void initAttribute() {
    }

    private void initDateFunPan() {
        String singleSelect = (String)this.getModel().getValue(SINGLESELECT);
        for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            if (!dateFunctionParamEnum.getKey().equals(singleSelect)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{dateFunctionParamEnum.getMemberKey()});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{dateFunctionParamEnum.getMemberKey()});
        }
    }

    private void initMemberFunPan() {
        String singleSelectMemFun = (String)this.getModel().getValue("singleselectmemfun");
        for (MemberFunctionParamEnum memberFunctionParamEnum : MemberFunctionParamEnum.values()) {
            if (!memberFunctionParamEnum.getKey().equals(singleSelectMemFun)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{memberFunctionParamEnum.getMemberKey()});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{memberFunctionParamEnum.getMemberKey()});
        }
    }

    protected void initDimensionList2(String functionName) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List dims = modelCacheHelper.getDimensionList(Long.valueOf(this.getDatasetId()));
        String mainDimNumber = this.getMainDimNumber();
        if (!dims.isEmpty()) {
            ComboEdit dimList = (ComboEdit)this.getControl(FunctionItemEnum.DIMENSIONLIST.getKey());
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(dims.size());
            for (Dimension dim : dims) {
                String dimNumber = dim.getNumber();
                if (dimNumber.equals(mainDimNumber) || dimNumber.equals(SysDimensionEnum.Metric.getNumber())) continue;
                itemList.add(new ComboItem(new LocaleString(dim.getName()), dimNumber));
            }
            dimList.setComboItems(itemList);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            String key = ((Control)evt.getSource()).getKey();
            if (key.equals(FunctionItemEnum.RETURNPERIOD.getKey())) {
                this.showRangeMemberForm(key);
            } else if (key.equals(FunctionItemEnum.DIMEMBER.getKey())) {
                this.showChooseFormForSingleSel();
            } else if (key.equals(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                this.showChooseFormForMulSel();
            } else if (key.equals(BTNOK)) {
                this.checkYearValueDataset();
                this.getFunctionEditPlugin().save();
            } else if (key.equals(search_pre)) {
                this.searchPre();
            } else if (key.equals(search_next)) {
                this.searchNext();
            } else if (key.equals(FunctionItemEnum.ACCOUNT.getKey())) {
                this.showRangeMemberForm(key);
            } else if (key.equals(FunctionItemEnum.PERIOD.getKey())) {
                this.showSinglePeriodF7();
            } else if (key.equals(FunctionItemEnum.ATTRIBUTEVAL.getKey())) {
                this.showChooseFormForSingleSelByAttitudeVal();
            } else if (key.equals(FunctionItemEnum.RELATIONFUN.getKey())) {
                this.showAntherRuleFunForm(key);
            } else if (key.equals(FunctionItemEnum.DIMGROUP.getKey())) {
                this.showRangeMemberForm(key);
            } else if (key.equals(FunctionItemEnum.STRINGFUN.getKey())) {
                this.showAntherRuleFunForm(key);
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#click", (Throwable)e);
        }
    }

    private void checkYearValueDataset() {
        List dimensionList;
        Set dimNumberSet;
        if (!RuleFunctionEnum.YearValue.getName().equals(this.getCurrentFunctionName())) {
            return;
        }
        String relationStr = this.getPageCache().get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isEmpty((String)relationStr)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)relationStr);
        Map allValues = childFun.getAllValues();
        String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        long accountDatasetId = this.getDatasetId();
        String cacheStr = this.getPageCache().get(FunctionItemEnum.ACCOUNT.getKey());
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)cacheStr, FormulaMemberPojo.class);
        DimMemberPojo accountDimMem = formulaMemberPojo.getRefDimMemberByDimNum(SysDimensionEnum.Account.getNumber());
        if (accountDimMem != null) {
            Member account = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountDimMem.getId());
            accountDatasetId = account.getDatasetId();
        }
        if (!(dimNumberSet = (dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(accountDatasetId))).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).contains(dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u6240\u5728\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u5173\u7cfb\u51fd\u6570\u6307\u5b9a\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"RuleFunctionEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List leftDimensionList = modelCacheHelper.getDimensionList(Long.valueOf(this.getDatasetId()));
        Set leftDimNumberSet = leftDimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        if (!leftDimNumberSet.contains(dimNumber)) {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            throw new KDBizException(ResManager.loadResFormat((String)"YearValue\u51fd\u6570\u5d4c\u5957\u7684\u5173\u7cfb\u51fd\u6570\u4e2d\uff0c\u201c%1\u201d\u7ef4\u5728\u5de6\u7b49\u5f0f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"RuleFunctionEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
        }
        if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            return;
        }
        FunctionRefMember functionRefMember = childFun.genRefMemberFirst(new HashMap(16), modelCacheHelper, new HashMap(16));
        if (functionRefMember.isAllMember()) {
            return;
        }
        Set memberSet = functionRefMember.getMembers();
        List members = modelCacheHelper.getMembers(SysDimensionEnum.Account.getNumber(), null, (Collection)memberSet);
        for (Member member : members) {
            if (member.getDatasetId().equals(accountDatasetId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u548c\u5173\u7cfb\u51fd\u6570\u6307\u5b9a\u6210\u5458\u6240\u5728\u7684\u6570\u636e\u96c6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"RuleFunctionEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        try {
            String callBackKey = e.getCallBackId();
            MessageBoxResult result = e.getResult();
            if (callBackKey.equals(FunctionItemEnum.RETURNENTITY.getKey()) && result == MessageBoxResult.No) {
                this.getFunctionEditPlugin().doSave();
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#confirmCallBack", (Throwable)ex);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block26: {
            try {
                String backKey = closedCallBackEvent.getActionId();
                if (backKey.equals(FunctionItemEnum.RETURNPERIOD.getKey())) {
                    this.dealCloseCallBackOfRangeDimMember(closedCallBackEvent);
                    break block26;
                }
                if (backKey.equals(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                    this.dealCloseCallBackOfDimmembRange(closedCallBackEvent);
                    break block26;
                }
                if (backKey.equals(FunctionItemEnum.DIMEMBER.getKey())) {
                    this.dealCloseCallBackOfDimMember(closedCallBackEvent, backKey);
                    break block26;
                }
                if (backKey.equals(FunctionItemEnum.ACCOUNT.getKey()) || backKey.equals(FunctionItemEnum.DIMGROUP.getKey())) {
                    this.dealCloseCallBackOfRangeDimMember(closedCallBackEvent);
                    break block26;
                }
                if (backKey.equals(MulMembChoose)) {
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (returnData == null) {
                        return;
                    }
                    String chose = String.valueOf(returnData);
                    if ("1".equals(chose)) {
                        this.showMulMembForm();
                    } else {
                        this.showAntherRuleFunForm(backKey);
                    }
                    break block26;
                }
                if (backKey.equals(SingleMembChoose)) {
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (returnData == null) {
                        return;
                    }
                    String chose = String.valueOf(returnData);
                    if ("1".equals(chose)) {
                        this.showSingleMembForm();
                    } else {
                        this.showAntherRuleFunForm(backKey);
                    }
                    break block26;
                }
                if (backKey.equals("AntherRuleFun")) {
                    try {
                        this.dealCloseCallBackOfAntherRuleFun(closedCallBackEvent);
                        break block26;
                    }
                    catch (KDException e) {
                        if (e.getErrorCode() != null && "bos.redisCacheOverMaxSize".equals(e.getErrorCode().getCode())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u51fd\u6570\u6210\u5458\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u51cf\u5c11\u51fd\u6570\u6210\u5458\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u589e\u52a0\u7cfb\u7edf\u7f13\u5b58\u6700\u5927\u503c\u9650\u5236\u3002", (String)"RuleFunctionEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        break block26;
                    }
                }
                if (backKey.equals(FunctionItemEnum.PERIOD.getKey())) {
                    this.dealCloseCallBackOfDimMember(closedCallBackEvent, backKey);
                } else if (backKey.equals(CLOSE_CALLBACK_ATTRIBUTEVAL_FUN)) {
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (returnData == null) {
                        return;
                    }
                    String chose = String.valueOf(returnData);
                    if ("1".equals(chose)) {
                        this.showSingleAttributeValForm();
                    } else {
                        this.showAntherRuleFunForm(backKey);
                    }
                } else if (backKey.equals(CLOSE_CALLBACK_ATTRIBUTEVAL_MEM)) {
                    this.dealCloseCallBackOfAttributeVal(closedCallBackEvent);
                }
            }
            catch (Exception e) {
                CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#closedCallBack", (Throwable)e);
            }
        }
    }

    private void dealCloseCallBackOfAttributeVal(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            ArrayList<Long> ids = new ArrayList<Long>(returnData.size());
            for (ListSelectedRow returnDatum : returnData) {
                ids.add(IDUtils.toLong((Object)returnDatum.getPrimaryKeyValue()));
            }
            if (ids.size() > 1) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", ids.get(0));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_custompropertyvalue", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject != null) {
                this.getModel().setValue(FunctionItemEnum.ATTRIBUTEVAL.getKey(), (Object)dynamicObject.getString("name"));
                this.getPageCache().put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), dynamicObject.getString("number"));
                this.getPageCache().remove("childIsFunByAttributeVal");
            }
        }
    }

    private void showSingleAttributeValForm() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("eb_custompropertyvalue");
        showParameter.setLookUp(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ATTRIBUTEVAL_MEM));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        String dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        String propNum = (String)this.getValue(FunctionItemEnum.ATTRIBUTE.getKey(), null);
        Long propId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_customproperty", (String)"id", (String)"model,dimension.number,number", (Object[])new Object[]{this.getModelId(), dimNum, propNum});
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter("property", "=", (Object)propId));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "number"));
        showParameter.setShowTitle(false);
        showParameter.setMultiSelect(false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void dealCloseCallBackOfDimmembRange(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection selectedMemb = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        if (selectedMemb != null) {
            if (selectedMemb.isEmpty()) {
                this.getModel().setValue(FunctionItemEnum.DIMEMBERRANGE.getKey(), null);
                this.getPageCache().remove(FunctionItemEnum.DIMEMBERRANGE.getKey());
            } else {
                List memberConditionList = selectedMemb.stream().map(item -> {
                    MemberCondition memberCondition = new MemberCondition(item.getString("number"), item.getString("name"), "", item.getString("scope"));
                    memberCondition.setViewId(item.getString("viewid"));
                    memberCondition.setId(item.getString("id"));
                    memberCondition.setRemoveBoolean(Boolean.valueOf(KdUtils.getBoolean((Object)item.getString("exclude"))));
                    return memberCondition;
                }).collect(Collectors.toList());
                String functionShowString = RuleFunctionUtils.getFunctionShowString(memberConditionList);
                this.getModel().setValue(FunctionItemEnum.DIMEMBERRANGE.getKey(), (Object)functionShowString);
                this.getPageCache().put(FunctionItemEnum.DIMEMBERRANGE.getKey(), SerializationUtils.serializeToBase64(memberConditionList));
                String viewId = ((MemberCondition)memberConditionList.get(0)).getViewId();
                this.getPageCache().put("allvals_view_id", viewId);
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                String dimNumber = (String)this.getModel().getValue(FunctionItemEnum.DIMENSIONLIST.getKey());
                String viewNumber = RuleUtils.getViewNumber(modelCacheHelper, dimNumber, IDUtils.toLong((Object)viewId));
                this.getPageCache().put("allvals_view_number", viewNumber);
            }
            this.getPageCache().remove("childIsFun");
        }
    }

    private void dealCloseCallBackOfDimMember(ClosedCallBackEvent closedCallBackEvent, String key) {
        ArrayList rows = (ArrayList)closedCallBackEvent.getReturnData();
        String viewIdStr = null;
        if (rows != null && rows.size() > 0) {
            StringBuilder sbName = new StringBuilder();
            StringBuilder sbNumber = new StringBuilder();
            for (kd.epm.eb.common.model.Member row : rows) {
                sbName.append(row.getName()).append(",");
                sbNumber.append(row.getNumber()).append(",");
            }
            viewIdStr = IDUtils.toString((Object)((kd.epm.eb.common.model.Member)rows.get(0)).getViewId());
            sbName.setLength(sbName.length() - 1);
            sbNumber.setLength(sbNumber.length() - 1);
            this.getModel().setValue(key, (Object)sbName.toString());
            this.getPageCache().put(key, sbNumber.toString());
            this.getPageCache().put("allvals_view_id", viewIdStr);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            String dimNumber = (String)this.getModel().getValue(FunctionItemEnum.DIMENSIONLIST.getKey());
            this.getPageCache().put("allvals_view_number", RuleUtils.getViewNumber(modelCacheHelper, dimNumber, IDUtils.toLong((Object)viewIdStr)));
            this.getPageCache().remove("childIsFun");
        }
    }

    private void dealCloseCallBackOfAntherRuleFun(ClosedCallBackEvent closedCallBackEvent) {
        String val = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isNotEmpty((String)val)) {
            RuleFunction ruleFun = (RuleFunction)SerializationUtils.deSerializeFromBase64((String)val);
            String backKey = this.getPageCache().get("backKey");
            if (MulMembChoose.equals(backKey)) {
                this.getModel().setValue(FunctionItemEnum.DIMEMBERRANGE.getKey(), (Object)ruleFun.getFunctionShowStr());
                this.getPageCache().put(FunctionItemEnum.DIMEMBERRANGE.getKey(), JsonUtils.getJsonString((Object)ruleFun));
                this.getPageCache().put("childIsFun", "true");
            } else if (SingleMembChoose.equals(backKey)) {
                this.getModel().setValue(FunctionItemEnum.DIMEMBER.getKey(), (Object)ruleFun.getFunctionShowStr());
                this.getPageCache().put(FunctionItemEnum.DIMEMBER.getKey(), JsonUtils.getJsonString((Object)ruleFun));
                this.getPageCache().put("childIsFun", "true");
            } else if (CLOSE_CALLBACK_ATTRIBUTEVAL_FUN.equals(backKey)) {
                this.getModel().setValue(FunctionItemEnum.ATTRIBUTEVAL.getKey(), (Object)ruleFun.getFunctionShowStr());
                this.getPageCache().put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), JsonUtils.getJsonString((Object)ruleFun));
                this.getPageCache().put("childIsFunByAttributeVal", "true");
            } else if (FunctionItemEnum.RELATIONFUN.getKey().equals(backKey)) {
                this.getModel().setValue(FunctionItemEnum.RELATIONFUN.getKey(), (Object)ruleFun.getFunctionShowStr());
                this.getPageCache().put(FunctionItemEnum.RELATIONFUN.getKey(), JsonUtils.getJsonString((Object)ruleFun));
                this.getPageCache().put("childIsFun", "true");
            } else if (FunctionItemEnum.STRINGFUN.getKey().equals(backKey)) {
                this.getModel().setValue(FunctionItemEnum.STRINGFUN.getKey(), (Object)ruleFun.getFunctionShowStr());
                this.getPageCache().put(FunctionItemEnum.STRINGFUN.getKey(), JsonUtils.getJsonString((Object)ruleFun));
                this.getPageCache().put("childIsFun", "true");
            }
        }
        this.getPageCache().remove("backKey");
    }

    private void dealCloseCallBackOfRangeDimMember(ClosedCallBackEvent closedCallBackEvent) {
        String val = (String)closedCallBackEvent.getReturnData();
        if (val != null && !val.equals("")) {
            String accountStr;
            DimMemberPojo mainMemb;
            String backKey = closedCallBackEvent.getActionId();
            FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)val, FormulaMemberPojo.class);
            String currentFunctionName = this.getCurrentFunctionName();
            Long modelId = this.getModelId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            List dimNumberList = formulaMemberPojo.getRefDimMembers().stream().map(DimMemberPojo::getDimNumber).collect(Collectors.toList());
            if (StringUtils.isEmpty((String)formulaMemberPojo.getMemberKey())) {
                formulaMemberPojo.setMemberKey("formult`" + DBServiceHelper.genGlobalLongId());
                mainMemb = formulaMemberPojo.getRefDimMemberByDimNum((String)dimNumberList.get(0));
                formulaMemberPojo.setMainDimMemberId(mainMemb.getId());
                Long viewId = mainMemb.getViewId();
                formulaMemberPojo.setMainViewId(viewId);
                formulaMemberPojo.setMainViewNumber(RuleUtils.getViewNumber(modelCacheHelper, mainMemb.getDimNumber(), viewId));
                String bizRuleId = this.getPageCache().get("bizRuleId");
                if (StringUtils.isNotEmpty((String)bizRuleId)) {
                    formulaMemberPojo.setRuleId(Convert.toLong((Object)bizRuleId));
                }
            }
            if (RuleFunctionEnum.YearValue.getName().equals(currentFunctionName) || RuleFunctionEnum.Member.getName().equals(currentFunctionName)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String dimNumber : dimNumberList) {
                    DimMemberPojo memberPojo = formulaMemberPojo.getRefDimMemberByDimNum(dimNumber);
                    stringBuilder.append(memberPojo.getName()).append("|");
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                accountStr = stringBuilder.toString();
                String relationDimNumber = RuleFunctionUtils.getRelationDimNumber((String)this.getPageCache().get(FunctionItemEnum.RELATIONFUN.getKey()));
                if (dimNumberList.contains(relationDimNumber)) {
                    this.getModel().setValue(FunctionItemEnum.RELATIONFUN.getKey(), null);
                    this.getPageCache().remove(FunctionItemEnum.RELATIONFUN.getKey());
                    this.getPageCache().remove("childIsFun");
                }
            } else {
                mainMemb = formulaMemberPojo.getRefDimMemberByDimNum((String)dimNumberList.get(0));
                accountStr = mainMemb.getName();
            }
            this.getModel().setValue(backKey, (Object)accountStr);
            this.getPageCache().put(backKey, JsonUtils.getJsonString((Object)formulaMemberPojo));
        }
    }

    protected void clearCacheInfo() {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(FunctionItemEnum.RETURNPERIOD.getKey());
        pageCache.remove(FunctionItemEnum.DIMEMBERRANGE.getKey());
        pageCache.remove(FunctionItemEnum.ACCOUNT.getKey());
        pageCache.remove("childIsFun");
        pageCache.remove("childIsFunByAttributeVal");
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        try {
            int rowCount;
            String entryName = e.getEntryProp().getName();
            if (entryName.equals(returnentityKey) && (rowCount = this.getModel().getEntryRowCount(returnentityKey)) == 1) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u884c\u8bb0\u5f55\u3002", (String)"RuleFunctionEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#beforeDeleteRow", (Throwable)ex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        try {
            String entryName = e.getEntryProp().getName();
            if (entryName.equals(FunctionItemEnum.RETURNENTITY.getKey())) {
                this.getFunctionEditPlugin().updateFunctionShow();
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#afterDeleteRow", (Throwable)ex);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        try {
            int entryRowCount;
            EntryGrid entryGrid = (EntryGrid)evt.getSource();
            int[] selectRows = entryGrid.getSelectRows();
            String functionName = null;
            if (selectRows.length != 0) {
                functionName = this.getModel().getEntryRowEntity(functionEntityKey, evt.getRow()).getString("functionname");
            }
            if (1 == (entryRowCount = this.getModel().getEntryRowCount(functionEntityKey))) {
                return;
            }
            this.doAfterFunctionSelectChange(functionName);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#entryRowClick", (Throwable)e);
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        try {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam("MODELID");
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#getModelId", (Throwable)e);
        }
        return modelId;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            String f7Key = beforeF7SelectEvent.getProperty().getName();
            FunctionItemEnum f7Item = FunctionItemEnum.getItemByKey((String)f7Key);
            QFBuilder qb = new QFBuilder("model", "=", (Object)this.getModelId());
            switch (f7Item) {
                case DIMEMBER: {
                    qb.add("dimension.number", "=", this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null));
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(qb.toList());
                    break;
                }
                case PERIOD: {
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(qb.toList());
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#beforeF7Select", (Throwable)e);
        }
    }

    private void showChooseFormForMulSel() {
        String dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        if (dimNum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"RuleFunctionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentFunctionName = this.getCurrentFunctionName();
        if (RuleFunctionEnum.Attribute.getName().equals(currentFunctionName)) {
            FormShowParameter showP = new FormShowParameter();
            showP.setFormId(MulMembChoose);
            showP.getOpenStyle().setShowType(ShowType.Modal);
            showP.setCustomParam("isFun", (Object)"true");
            showP.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MulMembChoose));
            this.getView().showForm(showP);
        } else {
            this.showMulMembForm();
        }
    }

    private void showChooseFormForSingleSel() {
        String dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        if (dimNum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"RuleFunctionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentFunctionName = this.getCurrentFunctionName();
        if (RuleFunctionEnum.Sibling.getName().equals(currentFunctionName) || RuleFunctionEnum.Children.getName().equals(currentFunctionName) || RuleFunctionEnum.Relative.getName().equals(currentFunctionName) || RuleFunctionEnum.Parent.getName().equals(currentFunctionName) || RuleFunctionEnum.GetAttribute.getName().equals(currentFunctionName) || RuleFunctionEnum.Ancestor.getName().equals(currentFunctionName) || RuleFunctionEnum.GetNumber.getName().equals(currentFunctionName) || RuleFunctionEnum.GetName.getName().equals(currentFunctionName)) {
            FormShowParameter showP = new FormShowParameter();
            showP.setFormId(MulMembChoose);
            showP.getOpenStyle().setShowType(ShowType.Modal);
            showP.setCustomParam("isFun", (Object)"true");
            showP.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SingleMembChoose));
            this.getView().showForm(showP);
        } else {
            this.showSingleMembForm();
        }
    }

    private void showSingleMembForm() {
        MemberF7Parameter f7Param;
        String dimNumber = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        String memNumbers = (String)this.getValue(FunctionItemEnum.DIMEMBER.getKey(), null);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FunctionItemEnum.DIMEMBER.getKey());
        String viewIdStr = this.getPageCache().get("allvals_view_id");
        Long viewId = IDUtils.toLong((Object)viewIdStr);
        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
            viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(this.getBizCtrlRangeId()), dimNumber, this.getModelId());
        }
        String currentFunctionName = this.getCurrentFunctionName();
        if (RuleFunctionEnum.Relative.getName().equals(currentFunctionName) || RuleFunctionEnum.Children.getName().equals(currentFunctionName)) {
            f7Param = NewF7Utils.multipleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)dimNumber));
            f7Param.setBusModelId(Long.valueOf(this.getBizCtrlRangeId()));
            f7Param.setDatasetId(Long.valueOf(this.getDatasetId()));
            String selectNums = this.getPageCache().get(FunctionItemEnum.DIMEMBER.getKey());
            if (StringUtils.isNotEmpty((String)selectNums) && StringUtils.isNotEmpty((String)memNumbers)) {
                String[] split;
                LinkedHashSet seletedIds = Sets.newLinkedHashSet();
                IModelCacheHelper modelCache = this.getIModelCacheHelper();
                for (String memNumber : split = selectNums.split(",")) {
                    Member member = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (member == null) continue;
                    seletedIds.add(member.getId());
                }
                if (seletedIds.size() > 0) {
                    f7Param.setSelectIds((Set)seletedIds);
                }
            }
        } else {
            String selectNums;
            f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)dimNumber));
            f7Param.setBusModelId(Long.valueOf(this.getBizCtrlRangeId()));
            if (dimNumber.equals(SysDimensionEnum.Account.getNumber())) {
                f7Param.setDatasetId(Long.valueOf(this.getDatasetId()));
            }
            if (StringUtils.isNotEmpty((String)(selectNums = this.getPageCache().get(FunctionItemEnum.DIMEMBER.getKey()))) && StringUtils.isNotEmpty((String)memNumbers)) {
                String[] split;
                LinkedHashSet seletedIds = Sets.newLinkedHashSet();
                IModelCacheHelper modelCache = this.getIModelCacheHelper();
                for (String memNumber : split = selectNums.split(",")) {
                    Member member = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (member == null) continue;
                    seletedIds.add(member.getId());
                }
                if (seletedIds.size() > 0) {
                    f7Param.setSelectIds((Set)seletedIds);
                }
            }
        }
        f7Param.setViewId(viewId);
        f7Param.setEnableView(true);
        this.getPageCache().remove("allvals_view_id");
        this.getPageCache().remove("allvals_view_number");
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private void showChooseFormForSingleSelByAttitudeVal() {
        String attitude = (String)this.getValue(FunctionItemEnum.ATTRIBUTE.getKey(), null);
        if (attitude == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5c5e\u6027", (String)"RuleFunctionEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentFunctionName = this.getCurrentFunctionName();
        if (RuleFunctionEnum.Attribute.getName().equals(currentFunctionName)) {
            FormShowParameter showP = new FormShowParameter();
            showP.setFormId(MulMembChoose);
            showP.getOpenStyle().setShowType(ShowType.Modal);
            showP.setCustomParam("isFun", (Object)"true");
            showP.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ATTRIBUTEVAL_FUN));
            this.getView().showForm(showP);
        } else {
            this.showSingleAttributeValForm();
        }
    }

    private void showSinglePeriodF7() {
        String memNumbers = (String)this.getValue(FunctionItemEnum.PERIOD.getKey(), null);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FunctionItemEnum.PERIOD.getKey());
        Long viewId = BusinessModelServiceHelper.getInstance().getViewId(this.getModelId(), SysDimensionEnum.BudgetPeriod.getNumber(), this.getModelId());
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)SysDimensionEnum.BudgetPeriod.getNumber()));
        f7Param.setBusModelId(Long.valueOf(this.getBizCtrlRangeId()));
        String selectNums = this.getPageCache().get(FunctionItemEnum.PERIOD.getKey());
        if (StringUtils.isNotEmpty((String)selectNums) && StringUtils.isNotEmpty((String)memNumbers)) {
            String[] split;
            LinkedHashSet seletedIds = Sets.newLinkedHashSet();
            IModelCacheHelper modelCache = this.getIModelCacheHelper();
            for (String memNumber : split = selectNums.split(",")) {
                Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), viewId, memNumber);
                if (member == null) continue;
                seletedIds.add(member.getId());
            }
            if (seletedIds.size() > 0) {
                f7Param.setSelectIds((Set)seletedIds);
            }
        }
        f7Param.setShowVariable(true);
        f7Param.setVariableType(1);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private void showMulMembForm() {
        String dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        String selectedInfo = this.getPageCache().get(FunctionItemEnum.DIMEMBERRANGE.getKey());
        List memberConditionList = null;
        Long viewId = 0L;
        String childFun = this.getPageCache().get("childIsFun");
        if (StringUtils.isEmpty((String)childFun) && selectedInfo != null) {
            memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)selectedInfo);
            viewId = IDUtils.toLong((Object)((MemberCondition)memberConditionList.get(0)).getViewId());
        }
        RangeF7Param f7Param = new RangeF7Param();
        f7Param.setCon_list(memberConditionList);
        f7Param.setSingleSelect(false);
        f7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FunctionItemEnum.DIMEMBERRANGE.getKey()));
        long bizCtrlRangeId = this.getBizCtrlRangeId();
        f7Param.setBizModelId(Long.valueOf(bizCtrlRangeId));
        LambdaUtils.run(() -> {
            if (!Arrays.asList(RuleFunctionEnum.Attribute.getName(), RuleFunctionEnum.List.getName()).contains(this.getCurrentFunctionName())) {
                return;
            }
            f7Param.setShowExclude(true);
            if (CollectionUtils.isEmpty((Collection)f7Param.getCon_list())) {
                return;
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Set removeMemberIdLongSet = f7Param.getCon_list().stream().filter(item -> Boolean.TRUE.equals(item.getRemoveBoolean())).map(item -> {
                Member member = modelCacheHelper.getMember(dimNum, IDUtils.toLong((Object)item.getViewId()), item.getNumber());
                if (member == null) {
                    return null;
                }
                return member.getId();
            }).filter(item -> ObjUtils.notNullOrZero((Long[])new Long[]{item})).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(removeMemberIdLongSet)) {
                return;
            }
            f7Param.setExcludeMemberIds(removeMemberIdLongSet);
        });
        if (dimNum.equals(SysDimensionEnum.Account.getNumber())) {
            QFBuilder qb = new QFBuilder();
            List dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(Long.valueOf(bizCtrlRangeId));
            qb.add("dataset", "in", (Object)dataSetIds);
            f7Param.setqFilters(qb.getFilters());
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNum, (Long)0L, (IFormView)this.getView(), (RangeF7Param)f7Param);
        } else {
            if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(bizCtrlRangeId), dimNum, this.getModelId());
            }
            f7Param.setEnableView(true);
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNum, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)f7Param);
        }
    }

    private void showRangeMemberForm(String fieldKey) {
        String dimNum;
        if (FunctionItemEnum.DIMGROUP.getKey().equals(fieldKey) && (dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"RuleFunctionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showP = new FormShowParameter();
        showP.setFormId("eb_rulemanagememberedit");
        showP.getOpenStyle().setShowType(ShowType.Modal);
        String cacheStr = this.getPageCache().get(fieldKey);
        if (cacheStr != null) {
            showP.setCustomParam("dimMembInfo", (Object)cacheStr);
        }
        showP.setCaption(ResManager.loadKDString((String)"\u51fd\u6570\u6210\u5458\u9009\u62e9", (String)"RuleFunctionEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showP.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showP.setCustomParam("model", (Object)this.getModelId());
        showP.setCustomParam("NoNeedPeriod", (Object)"true");
        showP.setCustomParam("parentFunction", (Object)this.getCurrentFunctionName());
        if (RuleFunctionEnum.YearValue.getName().equals(this.getCurrentFunctionName()) || RuleFunctionEnum.Member.getName().equals(this.getCurrentFunctionName())) {
            showP.setCustomParam("isDimGroup", (Object)true);
            showP.setCustomParam("mainDim", (Object)this.getMainDimNumber());
            showP.setCustomParam("leftDataSet", (Object)this.getDatasetId());
            if (RuleFunctionEnum.Member.getName().equals(this.getCurrentFunctionName()) && IDUtils.isNotEmptyLong((Long)this.getRangeDatasetId()).booleanValue()) {
                showP.setCustomParam("leftDataSet", (Object)this.getRangeDatasetId());
            }
            showP.setCustomParam("relationDim", (Object)RuleFunctionUtils.getRelationDimNumber((String)this.getPageCache().get(FunctionItemEnum.RELATIONFUN.getKey())));
        }
        showP.setCustomParam("isEmpFormulaStr", (Object)false);
        showP.setCustomParam("bizModelId", (Object)this.getBizCtrlRangeId());
        this.getView().showForm(showP);
    }

    private void showAntherRuleFunForm(String backKey) {
        RuleFunction ruleFunction;
        String val;
        String dimNum;
        if (FunctionItemEnum.STRINGFUN.getKey().equals(backKey) && (dimNum = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"RuleFunctionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rulefunction");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("MODELID", (Object)this.getModelId());
        showParameter.setCustomParam("bizModelId", (Object)this.getBizCtrlRangeId());
        showParameter.setCustomParam("dataset", (Object)this.getDatasetId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "AntherRuleFun"));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"eb_rulefunction");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.rulemanage.RelationRuleFunctionEditPlugin");
        String funName = this.getCurrentFunctionName();
        if (CLOSE_CALLBACK_ATTRIBUTEVAL_FUN.equals(backKey)) {
            funName = "AttributeValFun";
            String attribute = (String)this.getValue(FunctionItemEnum.ATTRIBUTE.getKey(), null);
            showParameter.setCustomParam("parentFunAttribute", (Object)attribute);
        }
        showParameter.setCustomParam("parentFunName", (Object)funName);
        String childFun = this.getPageCache().get("childIsFun");
        if (MulMembChoose.equals(backKey)) {
            val = this.getPageCache().get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            if (StringUtils.isNotEmpty((String)childFun) && StringUtils.isNotEmpty((String)val)) {
                ruleFunction = RuleFunctionFactory.fromJsonString((String)val);
                showParameter.setCustomParam("functionKey", (Object)ruleFunction.getFunctionKey());
                showParameter.setCustomParam("functionInfo", (Object)SerializationUtils.serializeToBase64((Object)ruleFunction));
            }
        } else if (SingleMembChoose.equals(backKey)) {
            val = this.getPageCache().get(FunctionItemEnum.DIMEMBER.getKey());
            if (StringUtils.isNotEmpty((String)childFun) && StringUtils.isNotEmpty((String)val)) {
                ruleFunction = RuleFunctionFactory.fromJsonString((String)val);
                showParameter.setCustomParam("functionKey", (Object)ruleFunction.getFunctionKey());
                showParameter.setCustomParam("functionInfo", (Object)SerializationUtils.serializeToBase64((Object)ruleFunction));
            }
        } else if (CLOSE_CALLBACK_ATTRIBUTEVAL_FUN.equals(backKey)) {
            String childIsFunByAttributeVal = this.getPageCache().get("childIsFunByAttributeVal");
            String val2 = this.getPageCache().get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
            if (StringUtils.isNotEmpty((String)childIsFunByAttributeVal) && StringUtils.isNotEmpty((String)val2)) {
                RuleFunction ruleFunction2 = RuleFunctionFactory.fromJsonString((String)val2);
                showParameter.setCustomParam("functionKey", (Object)ruleFunction2.getFunctionKey());
                showParameter.setCustomParam("functionInfo", (Object)SerializationUtils.serializeToBase64((Object)ruleFunction2));
            }
        } else if (FunctionItemEnum.RELATIONFUN.getKey().equals(backKey)) {
            val = this.getPageCache().get(FunctionItemEnum.RELATIONFUN.getKey());
            if (StringUtils.isNotEmpty((String)childFun) && StringUtils.isNotEmpty((String)val)) {
                ruleFunction = RuleFunctionFactory.fromJsonString((String)val);
                showParameter.setCustomParam("functionKey", (Object)ruleFunction.getFunctionKey());
                showParameter.setCustomParam("functionInfo", (Object)SerializationUtils.serializeToBase64((Object)ruleFunction));
            }
        } else if (FunctionItemEnum.STRINGFUN.getKey().equals(backKey)) {
            val = this.getPageCache().get(FunctionItemEnum.STRINGFUN.getKey());
            if (StringUtils.isNotEmpty((String)childFun) && StringUtils.isNotEmpty((String)val)) {
                ruleFunction = RuleFunctionFactory.fromJsonString((String)val);
                showParameter.setCustomParam("functionKey", (Object)ruleFunction.getFunctionKey());
                showParameter.setCustomParam("functionInfo", (Object)SerializationUtils.serializeToBase64((Object)ruleFunction));
            }
        }
        showParameter.setCustomParam("mainDimNumber", (Object)this.getMainDimNumber());
        this.getPageCache().put("backKey", backKey);
        String dimNum2 = (String)this.getValue(FunctionItemEnum.DIMENSIONLIST.getKey(), null);
        showParameter.setCustomParam("parentFunDim", (Object)dimNum2);
        showParameter.setCustomParam("parentFunItemKey", (Object)backKey);
        String cacheStr = this.getPageCache().get(FunctionItemEnum.ACCOUNT.getKey());
        if (FunctionItemEnum.RELATIONFUN.getKey().equals(backKey) && cacheStr != null) {
            FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)cacheStr, FormulaMemberPojo.class);
            List refDimMembers = formulaMemberPojo.getRefDimMembers();
            List selDims = refDimMembers.stream().map(DimMemberPojo::getDimNumber).collect(Collectors.toList());
            showParameter.setCustomParam("parentAccSelDims", (Object)SerializationUtils.toJsonString(selDims));
            DimMemberPojo accountDimMem = formulaMemberPojo.getRefDimMemberByDimNum(SysDimensionEnum.Account.getNumber());
            if (accountDimMem != null) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Member account = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountDimMem.getId());
                showParameter.setCustomParam("dataset", (Object)account.getDatasetId());
            }
        }
        this.getView().showForm(showParameter);
    }

    private void setNeedDealPropertyChange(boolean needDeal) {
        if (needDeal) {
            this.getPageCache().put("NeedDealPropertyChange", null);
        } else {
            this.getPageCache().put("NeedDealPropertyChange", "true");
        }
    }

    private boolean checkNeedDealPropertyChange() {
        String result = this.getPageCache().get("NeedDealPropertyChange");
        return result == null;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    private String getCurrentFunctionName() {
        DynamicObject row;
        EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length > 0 && (row = this.getModel().getEntryRowEntity(functionEntityKey, selectRows[0])) != null) {
            return row.getString("functionname");
        }
        return null;
    }

    protected AbstractFunctionEditPlugin getFunctionEditPlugin() {
        String functionName = this.getCurrentFunctionName();
        if (this.functionEditPlugin == null && StringUtils.isNotEmpty((String)functionName)) {
            block6: {
                RuleFunctionEnum functionEnum = RuleFunctionEnum.valueOf((String)functionName);
                String functionEditClassName = "kd.epm.eb.formplugin.rulemanage.functionEdit." + functionEnum.getShortName() + "FunctionEdit";
                try {
                    this.functionEditPlugin = (AbstractFunctionEditPlugin)Class.forName(functionEditClassName).newInstance();
                }
                catch (Exception e) {
                    if (!(e instanceof ClassNotFoundException)) break block6;
                    try {
                        functionEditClassName = "kd.epm.eb.formplugin.rulemanage.functionEdit.AbstractFunctionEditPlugin";
                        this.functionEditPlugin = (AbstractFunctionEditPlugin)Class.forName(functionEditClassName).newInstance();
                    }
                    catch (Exception ex) {
                        throw new KDBizException(ex.toString());
                    }
                }
            }
            if (this.functionEditPlugin != null) {
                this.functionEditPlugin.setFormPlugin(this);
                this.functionEditPlugin.setFunctionName(functionName);
            }
        }
        return this.functionEditPlugin;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        try {
            QFBuilder qb = new QFBuilder("id", "=", (Object)887661850899042363L);
            Collection catalog = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,model.id,model.number,parent.id as pId", (QFilter[])qb.toArrays()).values();
            for (DynamicObject doj : catalog) {
                doj.get("parent.id");
            }
            String searchText = searchEnterEvent.getText();
            if (searchText == null || searchText.trim().equals("")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u51fd\u6570\u540d\u79f0\u3002", (String)"RuleFunctionEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            searchText = searchText.toLowerCase(Locale.getDefault());
            IDataModel dataModel = this.getModel();
            int matchIndex = -1;
            int rowCount = dataModel.getEntryRowCount(functionEntityKey);
            for (int index = 0; index < rowCount; ++index) {
                String functionName = (String)dataModel.getValue("functionname", index);
                if (!functionName.toLowerCase(Locale.getDefault()).contains(searchText)) continue;
                matchIndex = index;
                break;
            }
            if (matchIndex != -1) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
                entryGrid.selectRows(matchIndex);
                entryGrid.entryRowClick(Integer.valueOf(matchIndex));
                this.getOrCacheSearchStr(searchText);
                this.getOrSetSearchRowIndex(matchIndex);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u76f8\u5173\u6570\u636e", (String)"RuleFunctionEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getOrCacheSearchStr("");
                this.getOrSetSearchRowIndex(-2);
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleFunctionEditPlugin#search", (Throwable)e);
        }
    }

    private void searchNext() {
        String searchText = this.getOrCacheSearchStr(null);
        if (searchText == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u51fd\u6570\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"RuleFunctionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            int matchIndex = -1;
            IDataModel dataModel = this.getModel();
            int currentIndex = this.getOrSetSearchRowIndex(-1);
            int rowCount = dataModel.getEntryRowCount(functionEntityKey);
            for (int index = currentIndex + 1; index < rowCount; ++index) {
                String functionName = (String)dataModel.getValue("functionname", index);
                if (!functionName.toLowerCase(Locale.getDefault()).contains(searchText)) continue;
                matchIndex = index;
                break;
            }
            if (matchIndex != -1) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
                entryGrid.selectRows(matchIndex);
                entryGrid.entryRowClick(Integer.valueOf(matchIndex));
                this.getOrCacheSearchStr(searchText);
                this.getOrSetSearchRowIndex(matchIndex);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u5339\u914d\u7684\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"RuleFunctionEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void searchPre() {
        String searchText = this.getOrCacheSearchStr(null);
        if (searchText == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u51fd\u6570\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"RuleFunctionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            IDataModel dataModel = this.getModel();
            int currentIndex = this.getOrSetSearchRowIndex(-1);
            int matchIndex = -1;
            for (int index = currentIndex - 1; index >= 0; --index) {
                String functionName = (String)dataModel.getValue("functionname", index);
                if (!functionName.toLowerCase(Locale.getDefault()).contains(searchText)) continue;
                matchIndex = index;
                break;
            }
            if (matchIndex != -1) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(functionEntityKey);
                entryGrid.selectRows(matchIndex);
                entryGrid.entryRowClick(Integer.valueOf(matchIndex));
                this.getOrSetSearchRowIndex(matchIndex);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u5339\u914d\u7684\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"RuleFunctionEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected int getOrSetSearchRowIndex(int rowIndex) {
        if (rowIndex == -1) {
            String cache = this.getPageCache().get(search_rowIndex_key);
            if (cache != null) {
                rowIndex = Integer.parseInt(cache);
            }
        } else if (rowIndex == -2) {
            this.getPageCache().remove(search_rowIndex_key);
        } else {
            this.getPageCache().put(search_rowIndex_key, String.valueOf(rowIndex));
        }
        return rowIndex;
    }

    protected String getOrCacheSearchStr(String text) {
        if (text == null) {
            return this.getPageCache().get(function_search_str);
        }
        if (text.equals("")) {
            text = null;
        }
        this.getPageCache().put(function_search_str, text);
        return null;
    }
}

