/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.BaseEditElement;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RuleManageMemberEditPlugin
extends AbstractFormPlugin
implements DynamicPage,
BeforeF7SelectListener {
    private DynamicInfoCollection dimInfos = null;
    private FormulaMemberPojo selectedMembInfo = null;
    private static final String dimListKey = "dimInfos";
    private static final String dimMembsKey = "dimMembInfo";

    public void initialize() {
        try {
            super.initialize();
            if (this.getPage(this.getView()) != null) {
                this.getPage(this.getView()).bindCtrlMapping(this.getView());
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#initialize", (Throwable)e);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addItemClickListeners(new String[]{"toolbarap"});
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#registerListener", (Throwable)ex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            super.itemClick(evt);
            String itemKey = evt.getItemKey();
            if (itemKey.equals("barok")) {
                Long modelId = this.getModelId();
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                DynamicInfoCollection dimInfo = this.getDimInfo();
                IDataModel dataModel = this.getModel();
                String dimNum = null;
                String shortnumber = null;
                Long viewId = 0L;
                String viewNumber = "";
                FormulaMemberPojo formulaMemberPojo = new FormulaMemberPojo(null, null, null);
                for (DynamicInfoCollection.InfoObject dim : dimInfo.getValues()) {
                    DynamicObject dimension;
                    Long bizCtrlRangeId;
                    Member memberByAnyView;
                    dimNum = (String)dim.getValueByPropName("number");
                    shortnumber = (String)dim.getValueByPropName("shortnumber");
                    DynamicObject member = (DynamicObject)dataModel.getValue(dimNum);
                    viewId = IDUtils.toLong((Object)this.getPageCache().get("CACHE_ACCOUNT_DIM_VIEW_" + dimNum));
                    if (!View.NoViewDimNums.contains(dimNum) && IDUtils.isEmptyLong((Long)viewId).booleanValue() && member != null && (memberByAnyView = modelCacheHelper.getMemberByAnyView(bizCtrlRangeId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId"), dimNum, member.getString("number"))) instanceof ViewMember) {
                        viewId = ((ViewMember)memberByAnyView).getViewId();
                    }
                    viewNumber = RuleUtils.getViewNumber(modelCacheHelper, dimNum, viewId);
                    if (member == null) continue;
                    if (this.isDimGroup() && member.getDynamicObjectType().getProperties().containsKey((Object)"dimension") && !dimNum.equals((dimension = (DynamicObject)member.get("dimension")).getString("number"))) {
                        dataModel.setValue(dimNum, null);
                        continue;
                    }
                    Long id = member.getLong("id");
                    String number = member.getString("number");
                    String longnumber = member.getString("longnumber");
                    String name = member.getString("name");
                    if (dimNum.equalsIgnoreCase("account")) {
                        Dataset dataSet = DatasetServiceHelper.getInstance().queryDataSetByAccountId(id);
                        formulaMemberPojo.addRefDimMember(id, number, longnumber, name, dimNum, shortnumber, dataSet.getNumber(), viewId, viewNumber);
                        continue;
                    }
                    formulaMemberPojo.addRefDimMember(id, number, longnumber, name, dimNum, shortnumber, "", viewId, viewNumber);
                }
                LambdaUtils.run(() -> {
                    if (RuleFunctionEnum.Member.getName().equals(this.getParentFunction())) {
                        return;
                    }
                    DimMemberPojo dimMemberPojo = formulaMemberPojo.getRefDimMemberByDimNum(SysDimensionEnum.Metric.getNumber());
                    if (dimMemberPojo == null) {
                        return;
                    }
                    Member metricMember = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, dimMemberPojo.getId());
                    if (metricMember == null) {
                        return;
                    }
                    List metricDataTypeEnumIndexStringList = Stream.of(MetricDataTypeEnum.CURRENCY, MetricDataTypeEnum.NONMONETARY, MetricDataTypeEnum.RATE).map(MetricDataTypeEnum::getIndex).collect(Collectors.toList());
                    Map propertieMap = metricMember.getProperties();
                    if (MapUtils.isEmpty((Map)propertieMap) || !metricDataTypeEnumIndexStringList.contains(propertieMap.get("datatype"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u7ef4\u5ea6\u4ec5\u652f\u6301\u9009\u62e9\u201c\u8d27\u5e01\u201d\u3001\u201c\u6570\u503c\u201d\u3001\u201c\u767e\u5206\u6bd4\u201d\u7c7b\u578b\u7684\u6210\u5458\u3002", (String)"RuleErrorInfo_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                });
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaMemberPojo));
                this.getView().close();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#itemClick", (Throwable)e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            this.initDimListInfo();
            this.buildDimList();
            this.fillBackDimMember();
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    private void initDimListInfo() {
        String dimMembsInfo = (String)this.getView().getFormShowParameter().getCustomParam(dimMembsKey);
        boolean dimGroup = this.isDimGroup();
        if (dimGroup) {
            long leftDatasetId = this.getLeftDatasetId();
            this.dimInfos = this.getDimInfoByDataSet(leftDatasetId);
        } else {
            this.dimInfos = this.getAccountAndMetric();
        }
        if (dimMembsInfo != null) {
            this.selectedMembInfo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)dimMembsInfo, FormulaMemberPojo.class);
            DimMemberPojo accountMemb = this.selectedMembInfo.getRefDimMemberByDimNum(SysDimensionEnum.Account.getNumber());
            if (!dimGroup) {
                if (accountMemb == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"RuleManageMemberEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getNewDimListByAccountObj(this.dimInfos, accountMemb.getId());
            } else if (accountMemb != null) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Member accountMem = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemb.getId());
                this.dimInfos = this.getDimInfoByDataSet(accountMem.getDatasetId());
            }
        }
        this.getPageCache().put(dimListKey, SerializationUtils.serializeToBase64((Object)this.dimInfos));
    }

    private DynamicInfoCollection getDimInfoByDataSet(long datasetId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String mainDimNumber = this.getMainDimNumber();
        Dimension mainDimension = modelCacheHelper.getDimension(mainDimNumber);
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(datasetId));
        ArrayList<Dimension> sortDimensionList = new ArrayList<Dimension>(dimensionList.size());
        sortDimensionList.add(mainDimension);
        sortDimensionList.addAll(dimensionList.stream().filter(e -> !e.getNumber().equals(mainDimNumber)).collect(Collectors.toList()));
        DynamicInfoCollection otherDimInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "name", "number", "lowNumber", "shortnumber", "membermodel"});
        for (Dimension dimension : sortDimensionList) {
            otherDimInfos.addInfo(new Object[]{dimension.getId(), dimension.getName(), dimension.getNumber(), dimension.getNumber().toLowerCase(), dimension.getShortNumber(), SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getNumber())});
        }
        return otherDimInfos;
    }

    public DynamicInfoCollection getAccountAndMetric() {
        QFBuilder qb = new QFBuilder("model", "=", (Object)this.getModelId());
        ArrayList<String> in_dimNums = new ArrayList<String>(16);
        in_dimNums.add(SysDimensionEnum.Account.getNumber());
        in_dimNums.add(SysDimensionEnum.Metric.getNumber());
        qb.add("number", "in", in_dimNums);
        DynamicObjectCollection otherDims = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,shortnumber,name,membermodel", (QFilter[])qb.toArray());
        DynamicInfoCollection otherDimInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "name", "number", "lowNumber", "shortnumber", "membermodel"});
        if (!otherDims.isEmpty()) {
            for (DynamicObject dim : otherDims) {
                otherDimInfos.addInfo(new Object[]{dim.getString("id"), dim.getString("name"), dim.getString("number"), dim.getString("number").toLowerCase(), dim.getString("shortnumber"), dim.getString("memberModel")});
            }
        }
        return otherDimInfos;
    }

    public void buildDimList() {
        DynamicInfoCollection dimInfos = this.getDimInfo();
        Page page = new Page();
        Area area = new Area("flexpanelap");
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("20px");
        mg.setBottom("0");
        mg.setRight("40px");
        mg.setLeft("20px");
        sl.setMargin(mg);
        String mustInputDim = "account";
        boolean dimGroup = this.isDimGroup();
        if (dimGroup) {
            mustInputDim = this.getMainDimNumber();
        }
        for (DynamicInfoCollection.InfoObject info : dimInfos.getValues()) {
            String number = (String)info.getValueByPropName("number");
            String name = (String)info.getValueByPropName("name");
            String id = info.getValueByPropName("id").toString();
            String membermodel = (String)info.getValueByPropName("membermodel");
            BaseEditElement f7 = new BaseEditElement(name, number.toLowerCase(), membermodel);
            f7.addUserObject("id", (Object)id);
            f7.addUserObject("number", (Object)number);
            f7.setLabelDirection("v");
            if (number.equalsIgnoreCase(mustInputDim)) {
                f7.setMustInput(true);
            } else {
                f7.setMustInput(false);
            }
            if (!dimGroup && number.equalsIgnoreCase("metric")) {
                f7.setMustInput(true);
            }
            f7.setWidth(new LocaleString("215px"));
            f7.setStyle(sl);
            f7.setQuickAddNew(false);
            area.addElement((Element)f7);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    public void fillBackDimMember() {
        DynamicInfoCollection dimInfo;
        if (this.selectedMembInfo != null && (dimInfo = this.getDimInfo()) != null) {
            List dimsNum = dimInfo.getAllValOfOneProp("number");
            IDataModel dataModel = this.getModel();
            for (DimMemberPojo dimMemberPojo : this.selectedMembInfo.getRefDimMembers()) {
                String dimNum = dimMemberPojo.getDimNumber();
                if (!dimsNum.contains(dimNum)) continue;
                dataModel.setValue(dimNum, (Object)dimMemberPojo.getId());
                this.getPageCache().put("CACHE_ACCOUNT_DIM_VIEW_" + dimNum, IDUtils.toString((Object)dimMemberPojo.getViewId()));
            }
        }
    }

    public DynamicInfoCollection getDimInfo() {
        if (this.dimInfos == null) {
            String dimStr = this.getPageCache().get(dimListKey);
            this.dimInfos = dimStr != null ? (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)dimStr) : new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "name", "number", "lowNumber", "shortnumber", "membermodel"});
        }
        if (this.noNeedPeriod()) {
            this.dimInfos.removeInfoByOneProp("number", (Object)SysDimensionEnum.BudgetPeriod.getNumber());
        }
        return this.dimInfos;
    }

    public void onGetControl(OnGetControlArgs e) {
        try {
            Element c;
            super.onGetControl(e);
            if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
                BasedataEdit nus = (BasedataEdit)c.getControl(this.getView());
                nus.setQFilter(new QFilter("dimension", "=", (Object)Convert.toLong((Object)c.getUserObject("id"))));
                nus.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                e.setControl((Control)nus);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#onGetControl", (Throwable)ex);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        Element c = this.getPage(this.getView()).findElementBySign(controlKey);
        return String.valueOf(c.getUserObject("number"));
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        try {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#getModelId", (Throwable)e);
        }
        return modelId;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#getEntityType", (Throwable)ex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        try {
            Long bizCtrlRangeId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
            String accountDimNumber = SysDimensionEnum.Account.getNumber();
            String dimNumber = arg0.getProperty().getName();
            Long modelId = this.getModelId();
            if (this.isDimGroup() && accountDimNumber.equalsIgnoreCase(dimNumber)) {
                String relationDimNumber;
                List dataSetIdByBizModelId = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(bizCtrlRangeId);
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                Set mainDimDataSetIds = new HashSet(16);
                String mainDimNumber = this.getMainDimNumber();
                if (StringUtils.isNotEmpty((String)mainDimNumber) && !accountDimNumber.equals(mainDimNumber)) {
                    Dimension dimension = modelCacheHelper.getDimension(mainDimNumber);
                    mainDimDataSetIds = DatasetServiceHelper.getInstance().queryDataSetsByDimId(dimension.getId());
                }
                if (StringUtils.isNotEmpty((String)(relationDimNumber = this.getRelationDimNumber())) && !accountDimNumber.equals(relationDimNumber)) {
                    Dimension dimension = modelCacheHelper.getDimension(relationDimNumber);
                    Set relDimDataSetIds = DatasetServiceHelper.getInstance().queryDataSetsByDimId(dimension.getId());
                    if (CollectionUtils.isNotEmpty(mainDimDataSetIds)) {
                        mainDimDataSetIds.retainAll(relDimDataSetIds);
                    } else {
                        mainDimDataSetIds.addAll(relDimDataSetIds);
                    }
                }
                if (CollectionUtils.isEmpty(mainDimDataSetIds)) {
                    this.switchDimNewF7(arg0, bizCtrlRangeId);
                } else {
                    mainDimDataSetIds.retainAll(dataSetIdByBizModelId);
                    this.switchDimNewF7(arg0, bizCtrlRangeId, new ArrayList(mainDimDataSetIds));
                }
            } else {
                String currentDimNumber = this.getCurrentDimNumber(dimNumber);
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)currentDimNumber), (String)ListSelectedRow.class.getName());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, currentDimNumber);
                f7Param.setBusModelId(bizCtrlRangeId);
                f7Param.setEnableView(true);
                f7Param.setViewId(IDUtils.toLong((Object)this.getPageCache().get("CACHE_ACCOUNT_DIM_VIEW_" + currentDimNumber)));
                f7Param.setVerifyPermission(true);
                NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#beforeF7Select", (Throwable)e);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try {
            ListSelectedRowCollection selectedMembers;
            String backKey = closedCallBackEvent.getActionId();
            String dimStr = this.getPageCache().get(dimListKey);
            DynamicInfoCollection dimInfo = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)dimStr);
            Set dimNumSet = dimInfo.getValues().stream().map(e -> (String)e.getValueByPropName("number")).collect(Collectors.toSet());
            if (dimNumSet.contains(backKey) && (selectedMembers = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
                ListSelectedRow listSelectedRow = selectedMembers.get(0);
                Map dataMap = listSelectedRow.getDataMap();
                this.getPageCache().put("CACHE_ACCOUNT_DIM_VIEW_" + backKey, IDUtils.toString(dataMap.get("viewid")));
                this.getModel().setValue(backKey, listSelectedRow.getPrimaryKeyValue());
            }
        }
        catch (Exception e2) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#closedCallBack", (Throwable)e2);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String propKey = e.getProperty().getName();
            if (propKey.equals(SysDimensionEnum.Account.getNumber().toLowerCase(Locale.getDefault()))) {
                DynamicInfoCollection obj = this.isDimGroup() ? this.buildDynamicInfoCollectionByDimGroup() : this.buildDynamicInfoCollection();
                this.getPageCache().put(dimListKey, SerializationUtils.serializeToBase64((Object)obj));
                this.buildDimList();
                if (this.getModel().getProperty("Metric") == null) {
                    return;
                }
                List<Long> metricIds = this.getMatchMetricIds();
                Long newMetriId = null;
                if (metricIds != null && !metricIds.isEmpty()) {
                    if (metricIds.size() == 1) {
                        newMetriId = metricIds.get(0);
                    } else {
                        Long preMetricId = (Long)this.getView().getFormShowParameter().getCustomParam("preMetricId");
                        if (preMetricId != null && metricIds.contains(preMetricId)) {
                            newMetriId = preMetricId;
                        }
                    }
                }
                this.getModel().setValue(SysDimensionEnum.Metric.getNumber().toLowerCase(), newMetriId);
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"RuleManageMemberEditPlugin#propertyChanged", (Throwable)ex);
        }
    }

    private DynamicInfoCollection buildDynamicInfoCollectionByDimGroup() {
        DynamicInfoCollection obj = new DynamicInfoCollection(ResManager.loadKDString((String)"\u89c4\u5219\u7ba1\u7406\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "name", "number", "lowNumber", "shortnumber", "membermodel"});
        long datasetId = this.getLeftDatasetId();
        DynamicObject account = (DynamicObject)this.getModel().getValue(SysDimensionEnum.Account.getNumber().toLowerCase());
        if (account != null) {
            long accountId = account.getLong("id");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, Long.valueOf(accountId));
            datasetId = accountMember.getDatasetId();
        }
        obj = this.getDimInfoByDataSet(datasetId);
        obj.setName(ResManager.loadKDString((String)"\u89c4\u5219\u7ba1\u7406\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return obj;
    }

    private boolean noNeedPeriod() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("NoNeedPeriod");
    }

    private boolean isDimGroup() {
        Boolean isDimGroup = (Boolean)this.getView().getFormShowParameter().getCustomParam("isDimGroup");
        if (isDimGroup == null) {
            return false;
        }
        return isDimGroup;
    }

    private long getLeftDatasetId() {
        Long leftDataSet = (Long)this.getView().getFormShowParameter().getCustomParam("leftDataSet");
        if (leftDataSet == null) {
            return 0L;
        }
        return leftDataSet;
    }

    private String getMainDimNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("mainDim");
    }

    private String getParentFunction() {
        return (String)this.getView().getFormShowParameter().getCustomParam("parentFunction");
    }

    private String getRelationDimNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("relationDim");
    }

    public List<Long> getMatchMetricIds() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObject account = (DynamicObject)this.getModel().getValue(SysDimensionEnum.Account.getNumber().toLowerCase());
        if (account == null) {
            return null;
        }
        DynamicObjectCollection metrics = account.getDynamicObjectCollection("entryentity");
        metrics.forEach(m -> ids.add(m.getLong("metric.id")));
        return ids;
    }

    private DynamicInfoCollection buildDynamicInfoCollection() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        DynamicInfoCollection obj = new DynamicInfoCollection(ResManager.loadKDString((String)"\u89c4\u5219\u7ba1\u7406\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageMemberEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "name", "number", "lowNumber", "shortnumber", "membermodel"});
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        List<String> numbers = Arrays.asList(SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Metric.getNumber());
        qb.and("number", "in", numbers);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,shortnumber,name,membermodel", (QFilter[])qb.toArray());
        for (DynamicObject dim : dynamicObjects) {
            obj.addInfo(new Object[]{dim.getString("id"), dim.getString("name"), dim.getString("number"), dim.getString("number").toLowerCase(), dim.getString("shortnumber"), dim.getString("memberModel")});
        }
        boolean isEmpFormulaStr = (Boolean)this.getView().getFormShowParameter().getCustomParam("isEmpFormulaStr");
        if (isEmpFormulaStr) {
            return obj;
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue(SysDimensionEnum.Account.getNumber().toLowerCase());
        if (account == null) {
            return obj;
        }
        long accountId = account.getLong("id");
        this.getNewDimListByAccountObj(obj, accountId);
        return obj;
    }

    private void getNewDimListByAccountObj(DynamicInfoCollection obj, long accountId) {
        List dims = DatasetServiceHelper.getInstance().listDimensionByAccountId(Long.valueOf(accountId), this.getModelId());
        for (kd.epm.eb.common.model.Dimension dimension : dims) {
            if (dimension.getNumber().equals(SysDimensionEnum.Metric.getNumber())) continue;
            obj.addInfo(new Object[]{dimension.getId(), dimension.getName(), dimension.getNumber(), dimension.getNumber().toLowerCase(), dimension.getShortNumber(), dimension.getMemberModel()});
        }
    }
}

