/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.TextEdit;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.AbstractFunctionEditPlugin;

public class YVFunctionEdit
extends AbstractFunctionEditPlugin {
    @Override
    public void updateFunctionShow() {
        TextEdit control1 = (TextEdit)this.getFormView().getControl(FunctionItemEnum.ACCOUNT.getKey());
        control1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408", (String)"YVFunctionEdit_02", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Tips tips = new Tips();
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u9009\u62e9\u4e3b\u7ef4\u5ea6\u53ca\u5176\u4ed6\u7ef4\u5ea6\u7684\u6210\u5458\u3002", (String)"YVFunctionEdit_01", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        tips.setType("text");
        control1.addTips(tips);
        IDataModel dataModel = this.getDataModel();
        StringBuilder sb = new StringBuilder();
        sb.append(RuleFunctionEnum.YearValue.getName());
        sb.append('(');
        String accountName = (String)dataModel.getValue(FunctionItemEnum.ACCOUNT.getKey());
        if (accountName != null) {
            sb.append(accountName);
        }
        sb.append(',');
        Object yearoffset = dataModel.getValue("yearoffset");
        sb.append(yearoffset);
        sb.append(',');
        String specifiedperiod = (String)dataModel.getValue("specifiedperiod");
        PeriodEnum periodEnum = PeriodEnum.getEnumByKey((String)specifiedperiod);
        if (periodEnum != null) {
            sb.append(periodEnum.getName());
        }
        sb.append(',');
        sb.append((String)dataModel.getValue(FunctionItemEnum.RELATIONFUN.getKey()));
        sb.append(')');
        dataModel.setValue("functionresult", (Object)sb.toString());
    }

    @Override
    public boolean dealPropertyChange(PropertyChangedArgs e) {
        String newValue;
        boolean dealed = super.dealPropertyChange(e);
        if (dealed) {
            return dealed;
        }
        String key = e.getProperty().getName();
        if (key.equals(FunctionItemEnum.RELATIONFUN.getKey()) && StringUtils.isEmpty((String)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            this.getPageCache().remove(FunctionItemEnum.RELATIONFUN.getKey());
            this.getPageCache().remove("childIsFun");
        }
        return true;
    }

    @Override
    boolean dealCheckData() {
        String relationStr = this.getPageCache().get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isEmpty((String)relationStr)) {
            return true;
        }
        RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)relationStr);
        Map allValues = childFun.getAllValues();
        String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        String accountStr = this.getPageCache().get(FunctionItemEnum.ACCOUNT.getKey());
        FormulaMemberPojo account = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)accountStr, FormulaMemberPojo.class);
        List refDimMembers = account.getRefDimMembers();
        Set accountDims = refDimMembers.stream().map(DimMemberPojo::getDimNumber).collect(Collectors.toSet());
        if (accountDims.contains(dimNumber)) {
            this.getFormView().showTipNotification(ResManager.loadKDString((String)"\u5173\u7cfb\u51fd\u6570\u9009\u62e9\u7684\u7ef4\u5ea6\u4e0e\u7ef4\u5ea6\u7ec4\u5408\u6307\u5b9a\u6210\u5458\u7684\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u6709\u4ea4\u96c6", (String)"YVFunctionEdit_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

