/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ABFunctionConvert
implements IFunctionConvert {
    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, String> allValues = new HashMap<String, String>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        FormulaPojo dimensionFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
        String dimNumber = dimensionFormulaPojo.getNumberString();
        allValues.put("dimensionlist", dimNumber);
        if (functionFormulaPojo.getChildFormulaPojo() != null) {
            FormulaPojo childFormulaPojo = functionFormulaPojo.getChildFormulaPojo();
            IRuleFunction childFun = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, childFormulaPojo);
            allValues.put("childIsFun", "true");
            allValues.put("dimmemberrange", SerializationUtils.toJsonString((Object)childFun));
        } else {
            ArrayList<MemberCondition> memberConditionList = new ArrayList<MemberCondition>();
            int dimMemberRangeIndex = subFormulaPojoList.size() - 3;
            if (functionFormulaPojo.getDimMemberRangeIndex() != null) {
                dimMemberRangeIndex = functionFormulaPojo.getDimMemberRangeIndex();
            }
            for (int i = 4; i < dimMemberRangeIndex; ++i) {
                FormulaPojo formulaPojo = (FormulaPojo)subFormulaPojoList.get(i);
                if (!"member".equals(formulaPojo.getTypeString())) continue;
                String memberNumber = formulaPojo.getNumberString();
                int lastIndexOfInt = memberNumber.lastIndexOf(".");
                String rangeNumber = memberNumber.substring(lastIndexOfInt + 1);
                RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)rangeNumber);
                String viewNumberString = formulaPojo.getViewNumberString();
                Long viewIdByNumber = RuleUtils.getViewIdByNumber(modelCacheHelper, dimNumber, viewNumberString);
                Member member = modelCacheHelper.getMember(dimNumber, viewIdByNumber, memberNumber.substring(0, lastIndexOfInt));
                MemberCondition memberCondition = new MemberCondition();
                memberCondition.setId(IDUtils.toString((Object)member.getId()));
                memberCondition.setName(member.getName());
                memberCondition.setNumber(member.getNumber());
                memberCondition.setViewId(IDUtils.toString((Object)viewIdByNumber));
                memberCondition.setRange(Convert.toStr((Object)rangeEnum.getIndex()));
                memberCondition.setRemoveBoolean(formulaPojo.getRemoveBoolean());
                memberConditionList.add(memberCondition);
            }
            allValues.put("dimmemberrange", SerializationUtils.serializeToBase64(memberConditionList));
            if (CollectionUtils.isNotEmpty(memberConditionList)) {
                String viewId = ((MemberCondition)memberConditionList.get(0)).getViewId();
                allValues.put("allvals_view_id", viewId);
                allValues.put("allvals_view_number", RuleUtils.getViewNumber(modelCacheHelper, dimNumber, IDUtils.toLong((Object)viewId)));
            }
        }
        FormulaPojo attribute = functionFormulaPojo.getAttributePojo();
        if (attribute == null) {
            attribute = (FormulaPojo)subFormulaPojoList.get(subFormulaPojoList.size() - 4);
        }
        allValues.put("attribute", attribute.getNumberString());
        if (functionFormulaPojo.getChildFormulaPojoByAttributeVal() != null) {
            FormulaPojo childFormulaPojo = functionFormulaPojo.getChildFormulaPojoByAttributeVal();
            IRuleFunction childFun = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, childFormulaPojo);
            allValues.put("childIsFunByAttributeVal", "true");
            allValues.put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), SerializationUtils.toJsonString((Object)childFun));
        } else {
            FormulaPojo attributeVal = (FormulaPojo)subFormulaPojoList.get(subFormulaPojoList.size() - 2);
            allValues.put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), attributeVal.getNumberString());
        }
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setNewFun(true);
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        String dimNumber = (String)allValues.get("dimensionlist");
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        FormulaPojo dimensionFormulaPojo = new FormulaPojo();
        dimensionFormulaPojo.setTypeString("indivisible");
        dimensionFormulaPojo.setValueString(dimension.getName());
        dimensionFormulaPojo.setIdString(dimension.getId().toString());
        dimensionFormulaPojo.setNumberString(dimension.getNumber());
        dimensionFormulaPojo.setShowNumberString(dimension.getNumber());
        subFormulaPojoList.add(dimensionFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        if (allValues.containsKey("childIsFun")) {
            String funStr = (String)allValues.get("dimmemberrange");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            FormulaPojo childFormulaPojo = RuleJsUtils.ruleFunctionToFunctionFormulaPojo(modelCacheHelper, (IRuleFunction)childFun);
            functionFormulaPojo.setChildFormulaPojo(childFormulaPojo);
            subFormulaPojoList.addAll(childFormulaPojo.getSubFormulaPojoList());
        } else {
            LambdaUtils.run(() -> {
                String memberNumber = (String)allValues.get("dimmemberrange");
                List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
                Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair((Collection)memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
                List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
                subFormulaPojoList.addAll(RuleUtils.convertMemberConditionListToFormulaPojoList(modelCacheHelper, dimNumber, normalMemberConditionList));
                List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
                if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                    return;
                }
                subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
                subFormulaPojoList.add(RuleJsUtils.getRemoveFormulaPojo());
                subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
                subFormulaPojoList.addAll(RuleUtils.convertMemberConditionListToFormulaPojoList(modelCacheHelper, dimNumber, removeMemberConditionList));
                subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
            });
        }
        functionFormulaPojo.setDimMemberRangeIndex(Integer.valueOf(subFormulaPojoList.size()));
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCacheHelper.getModelobj().getId());
        String attribute = (String)allValues.get("attribute");
        CustomProperty property = memberPropCache.getProperty(dimNumber, attribute);
        List<FormulaPojo> propertyTextFormulaPojoList = RuleJsUtils.getTextFormulaPojoList(property.getName(), property.getNumber(), property.getNumber());
        subFormulaPojoList.addAll(propertyTextFormulaPojoList);
        functionFormulaPojo.setAttributePojo(propertyTextFormulaPojoList.get(0));
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        if (allValues.containsKey("childIsFunByAttributeVal")) {
            String funStr = (String)allValues.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            FormulaPojo childFormulaPojo = RuleJsUtils.ruleFunctionToFunctionFormulaPojo(modelCacheHelper, (IRuleFunction)childFun);
            functionFormulaPojo.setChildFormulaPojoByAttributeVal(childFormulaPojo);
            subFormulaPojoList.addAll(childFormulaPojo.getSubFormulaPojoList());
        } else {
            String attributeval = (String)allValues.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeval);
            if (propertyValue != null) {
                subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(propertyValue.getName(), propertyValue.getNumber(), property.getNumber()));
            }
        }
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

