/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CTFunctionConvert
implements IFunctionConvert {
    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, String> allValues = new HashMap<String, String>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        FormulaPojo dimensionFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
        String dimNumber = dimensionFormulaPojo.getNumberString();
        allValues.put("dimensionlist", dimNumber);
        ArrayList<MemberCondition> memberConditionList = new ArrayList<MemberCondition>();
        for (int i = 4; i < subFormulaPojoList.size(); ++i) {
            FormulaPojo formulaPojo = (FormulaPojo)subFormulaPojoList.get(i);
            if (!"member".equals(formulaPojo.getTypeString())) continue;
            String memberNumber = formulaPojo.getNumberString();
            String[] split = memberNumber.split("\\.");
            String rangeNumber = split[split.length - 1];
            RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)rangeNumber);
            String viewNumberString = formulaPojo.getViewNumberString();
            Long viewIdByNumber = RuleUtils.getViewIdByNumber(modelCacheHelper, dimNumber, viewNumberString);
            Member member = modelCacheHelper.getMember(dimNumber, viewIdByNumber, Convert.toLong((Object)formulaPojo.getMainMemberIdString()));
            MemberCondition memberCondition = new MemberCondition();
            memberCondition.setId(IDUtils.toString((Object)member.getId()));
            memberCondition.setName(member.getName());
            memberCondition.setNumber(member.getNumber());
            memberCondition.setRange(Convert.toStr((Object)rangeEnum.getIndex()));
            memberCondition.setViewId(IDUtils.toString((Object)viewIdByNumber));
            memberConditionList.add(memberCondition);
        }
        allValues.put("dimmemberrange", SerializationUtils.serializeToBase64(memberConditionList));
        if (CollectionUtils.isNotEmpty(memberConditionList)) {
            String viewId = ((MemberCondition)memberConditionList.get(0)).getViewId();
            allValues.put("allvals_view_id", viewId);
            allValues.put("allvals_view_number", RuleUtils.getViewNumber(modelCacheHelper, dimNumber, IDUtils.toLong((Object)viewId)));
        }
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        String dimNumber = (String)allValues.get("dimensionlist");
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        FormulaPojo dimensionFormulaPojo = new FormulaPojo();
        dimensionFormulaPojo.setTypeString("indivisible");
        dimensionFormulaPojo.setValueString(dimension.getName());
        dimensionFormulaPojo.setIdString(dimension.getId().toString());
        dimensionFormulaPojo.setNumberString(dimension.getNumber());
        dimensionFormulaPojo.setShowNumberString(dimension.getNumber());
        subFormulaPojoList.add(dimensionFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        String memberNumber = (String)allValues.get("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        for (MemberCondition memberCondition : memberConditionList) {
            String viewIdStr = memberCondition.getViewId();
            Member member = modelCacheHelper.getMember(dimNumber, IDUtils.toLong((Object)viewIdStr), memberCondition.getNumber());
            FormulaPojo memberFormulaPojo = new FormulaPojo();
            memberFormulaPojo.setUuidString(StrUtils.getSimpleUuidIdString());
            memberFormulaPojo.setViewIdString(viewIdStr);
            memberFormulaPojo.setViewNumberString(RuleUtils.getViewNumber(modelCacheHelper, dimNumber, IDUtils.toLong((Object)viewIdStr)));
            if (member != null) {
                RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)Convert.toInt((Object)memberCondition.getRange()));
                memberFormulaPojo.setMainMemberIdString(ObjUtils.getString((Object)member.getId()));
                memberFormulaPojo.setValueString(member.getName() + "." + rangeEnum.getName());
                memberFormulaPojo.setNumberString(member.getNumber() + "." + rangeEnum.getNumber());
                memberFormulaPojo.setShowNumberString(member.getShowNumber() + "." + rangeEnum.getNumber());
            }
            memberFormulaPojo.setTypeString("member");
            subFormulaPojoList.add(memberFormulaPojo);
            subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        }
        subFormulaPojoList.remove(subFormulaPojoList.size() - 1);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

