/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.variable.VariableDto;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.DateFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class DTFunctionConvert
implements IFunctionConvert {
    private static final Log log = LogFactory.getLog(DTFunctionConvert.class);

    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, String> allValues = new HashMap<String, String>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        if (functionFormulaPojo.getChildFormulaPojo() != null) {
            FormulaPojo childFormulaPojo = functionFormulaPojo.getChildFormulaPojo();
            IRuleFunction childFun = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, childFormulaPojo);
            allValues.put("childIsFun", "true");
            allValues.put(FunctionItemEnum.MEMBERFUN.getKey(), SerializationUtils.toJsonString((Object)childFun));
        } else {
            StringBuilder memberNumber = new StringBuilder();
            for (int i = 2; i < subFormulaPojoList.size(); ++i) {
                FormulaPojo memberFormulaPojo = (FormulaPojo)subFormulaPojoList.get(i);
                if ("member".equals(memberFormulaPojo.getTypeString())) {
                    memberNumber.append(memberFormulaPojo.getNumberString()).append(",");
                    continue;
                }
                if (!"indivisible".equals(memberFormulaPojo.getTypeString())) continue;
                allValues.put(FunctionItemEnum.DATETIME.getKey(), memberFormulaPojo.getValueString());
            }
            if (memberNumber.length() > 0) {
                memberNumber.setLength(memberNumber.length() - 1);
                allValues.put(FunctionItemEnum.PERIOD.getKey(), memberNumber.toString());
            }
        }
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setNewFun(true);
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        Map variableMap = ReportVarUtil.queryAllVariable((Long)modelCacheHelper.getModelobj().getId());
        for (DateFunctionParamEnum dateFunctionParamEnum : DateFunctionParamEnum.values()) {
            Object obj = allValues.get(dateFunctionParamEnum.getMemberKey());
            if (obj == null) continue;
            if (dateFunctionParamEnum.getKey().equals(DateFunctionParamEnum.Date.getKey())) {
                FormulaPojo indivisibleFormulaPojo3 = new FormulaPojo();
                indivisibleFormulaPojo3.setTypeString("indivisible");
                indivisibleFormulaPojo3.setValueString(obj.toString());
                subFormulaPojoList.add(indivisibleFormulaPojo3);
                break;
            }
            if (DateFunctionParamEnum.CurrMember.getKey().equals(dateFunctionParamEnum.getKey())) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)obj.toString());
                FormulaPojo childFormulaPojo = RuleJsUtils.ruleFunctionToFunctionFormulaPojo(modelCacheHelper, (IRuleFunction)childFun);
                functionFormulaPojo.setChildFormulaPojo(childFormulaPojo);
                subFormulaPojoList.addAll(childFormulaPojo.getSubFormulaPojoList());
                break;
            }
            FormulaPojo memberFormulaPojo = new FormulaPojo();
            memberFormulaPojo.setUuidString(StrUtils.getSimpleUuidIdString());
            memberFormulaPojo.setTypeString("member");
            if (TemplateVarCommonUtil.checkIsVar((String)obj.toString(), (String)SysDimensionEnum.BudgetPeriod.getNumber()).booleanValue()) {
                VariableDto dynamicObject = (VariableDto)variableMap.get(SysDimensionEnum.BudgetPeriod.getNumber() + ":" + obj);
                if (dynamicObject == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u53d8\u91cf\u6210\u5458\u201c%2\u201d\u4e0d\u5b58\u5728\u3002", (String)"EbExamineEditPlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.BudgetPeriod.getNumber(), obj.toString()}));
                }
                memberFormulaPojo.setMainMemberIdString(String.valueOf(dynamicObject.getId()));
                memberFormulaPojo.setValueString(dynamicObject.getName());
                memberFormulaPojo.setNumberString(dynamicObject.getNumber());
                memberFormulaPojo.setShowNumberString(dynamicObject.getNumber());
            } else {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, obj.toString());
                if (member != null) {
                    memberFormulaPojo.setMainMemberIdString(ObjUtils.getString((Object)member.getId()));
                    memberFormulaPojo.setValueString(member.getName());
                    memberFormulaPojo.setNumberString(member.getNumber());
                    memberFormulaPojo.setShowNumberString(member.getShowNumber());
                }
            }
            subFormulaPojoList.add(memberFormulaPojo);
            break;
        }
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

