/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;

public class RPCFunctionConvert
implements IFunctionConvert {
    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, Object> allValues = new HashMap<String, Object>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        FormulaPojo accountFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
        FormulaMemberPojo accountMemberPojo = RuleJsUtils.toFormulaMemberPojo(modelCacheHelper, accountFormulaPojo);
        FormulaPojo periodFormulaPojo = (FormulaPojo)subFormulaPojoList.get(4);
        FormulaMemberPojo periodMemberPojo = RuleJsUtils.toFormulaMemberPojo(modelCacheHelper, periodFormulaPojo);
        FormulaPojo confirmperiodFormulaPojo = (FormulaPojo)subFormulaPojoList.get(6);
        Integer confirmperiod = Convert.toInt((Object)confirmperiodFormulaPojo.getValueString());
        FormulaPojo taxrateFormulaPojo = (FormulaPojo)subFormulaPojoList.get(8);
        String replace = taxrateFormulaPojo.getValueString().replace("%", "");
        BigDecimal taxrate = new BigDecimal(replace).divide(new BigDecimal(100));
        allValues.put("taxrate", taxrate);
        allValues.put("confirmperiod", confirmperiod);
        allValues.put("returnperiod", JsonUtils.getJsonString((Object)periodMemberPojo));
        allValues.put("account", JsonUtils.getJsonString((Object)accountMemberPojo));
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        BigDecimal taxrate = (BigDecimal)allValues.get("taxrate");
        String returnperiod = (String)allValues.get("returnperiod");
        FormulaMemberPojo periodMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)returnperiod, FormulaMemberPojo.class);
        Integer confirmperiod = (Integer)allValues.get("confirmperiod");
        String account = (String)allValues.get("account");
        FormulaMemberPojo accountMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)account, FormulaMemberPojo.class);
        FormulaPojo accountFormulaPojo = RuleJsUtils.toFormulaPojo(modelCacheHelper, accountMemberPojo);
        accountFormulaPojo.setCallbackMethodNameString(null);
        subFormulaPojoList.add(accountFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo periodFormulaPojo = RuleJsUtils.toFormulaPojo(modelCacheHelper, periodMemberPojo);
        periodFormulaPojo.setCallbackMethodNameString(null);
        subFormulaPojoList.add(periodFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo confirmperiodFormulaPojo = new FormulaPojo();
        confirmperiodFormulaPojo.setTypeString("indivisible");
        confirmperiodFormulaPojo.setValueString(Convert.toStr((Object)confirmperiod));
        subFormulaPojoList.add(confirmperiodFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo taxrateFormulaPojo = new FormulaPojo();
        taxrateFormulaPojo.setTypeString("indivisible");
        taxrateFormulaPojo.setValueString(taxrate.multiply(new BigDecimal(100)).setScale(2).toString() + '%');
        subFormulaPojoList.add(taxrateFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

