/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;

public class RPFunctionConvert
implements IFunctionConvert {
    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, Object> allValues = new HashMap<String, Object>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        FormulaPojo accountFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
        FormulaMemberPojo accountMemberPojo = RuleJsUtils.toFormulaMemberPojo(modelCacheHelper, accountFormulaPojo);
        FormulaPojo periodFormulaPojo = (FormulaPojo)subFormulaPojoList.get(4);
        Integer returnperiodnum = Convert.toInt((Object)periodFormulaPojo.getValueString());
        FormulaPojo confirmperiodFormulaPojo = (FormulaPojo)subFormulaPojoList.get(6);
        Integer confirmperiod = Convert.toInt((Object)confirmperiodFormulaPojo.getValueString());
        FormulaPojo taxrateFormulaPojo = (FormulaPojo)subFormulaPojoList.get(8);
        String replace = taxrateFormulaPojo.getValueString().replace("%", "");
        BigDecimal taxrate = new BigDecimal(replace).divide(new BigDecimal(100));
        allValues.put("taxrate", taxrate);
        allValues.put("confirmperiod", confirmperiod);
        allValues.put("returnperiodnum", returnperiodnum);
        allValues.put("account", JsonUtils.getJsonString((Object)accountMemberPojo));
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        BigDecimal taxrate = Convert.toBigDecimal(allValues.get("taxrate"));
        Integer returnperiodnum = (Integer)allValues.get("returnperiodnum");
        Integer confirmperiod = (Integer)allValues.get("confirmperiod");
        String account = (String)allValues.get("account");
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)account, FormulaMemberPojo.class);
        FormulaPojo memberFormulaPojo = RuleJsUtils.toFormulaPojo(modelCacheHelper, formulaMemberPojo);
        memberFormulaPojo.setCallbackMethodNameString(null);
        subFormulaPojoList.add(memberFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo indivisibleFormulaPojo2 = new FormulaPojo();
        indivisibleFormulaPojo2.setTypeString("indivisible");
        indivisibleFormulaPojo2.setValueString(Convert.toStr((Object)returnperiodnum));
        subFormulaPojoList.add(indivisibleFormulaPojo2);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo indivisibleFormulaPojo3 = new FormulaPojo();
        indivisibleFormulaPojo3.setTypeString("indivisible");
        indivisibleFormulaPojo3.setValueString(Convert.toStr((Object)confirmperiod));
        subFormulaPojoList.add(indivisibleFormulaPojo3);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo indivisibleFormulaPojo4 = new FormulaPojo();
        indivisibleFormulaPojo4.setTypeString("indivisible");
        indivisibleFormulaPojo4.setValueString(taxrate.multiply(new BigDecimal(100)).setScale(2).toString() + '%');
        subFormulaPojoList.add(indivisibleFormulaPojo4);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

