/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.functionEdit.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.convert.IFunctionConvert;

public class YVFunctionConvert
implements IFunctionConvert {
    private static final Log log = LogFactory.getLog(YVFunctionConvert.class);

    @Override
    public IRuleFunction convertToFunction(IModelCacheHelper modelCacheHelper, FormulaPojo functionFormulaPojo) {
        RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)functionFormulaPojo.getToolEnumKeyString());
        ruleFunction.setFunctionKey(functionFormulaPojo.getKeyString());
        ruleFunction.setFunctionShowStr(functionFormulaPojo.getValueString());
        HashMap<String, String> allValues = new HashMap<String, String>();
        ruleFunction.setAllVals(allValues);
        List subFormulaPojoList = functionFormulaPojo.getSubFormulaPojoList();
        FormulaPojo accountFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
        FormulaMemberPojo accountMemberPojo = RuleJsUtils.toFormulaMemberPojoByMainDim(modelCacheHelper, accountFormulaPojo);
        FormulaPojo formulaPojo = (FormulaPojo)subFormulaPojoList.get(4);
        FormulaPojo formulaPojo1 = (FormulaPojo)subFormulaPojoList.get(6);
        if (functionFormulaPojo.getChildFormulaPojo() != null) {
            FormulaPojo childFormulaPojo = functionFormulaPojo.getChildFormulaPojo();
            IRuleFunction childFun = RuleJsUtils.functionFormulaPojoToRuleFunction(modelCacheHelper, childFormulaPojo);
            allValues.put("childIsFun", "true");
            allValues.put(FunctionItemEnum.RELATIONFUN.getKey(), SerializationUtils.toJsonString((Object)childFun));
        }
        allValues.put("yearoffset", formulaPojo.getValueString());
        allValues.put("specifiedperiod", formulaPojo1.getNumberString());
        allValues.put("account", JsonUtils.getJsonString((Object)accountMemberPojo));
        return ruleFunction;
    }

    @Override
    public FormulaPojo convertToFormulaPojo(IModelCacheHelper modelCacheHelper, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        String functionKey = ruleFunction.getFunctionKey();
        FormulaPojo functionFormulaPojo = new FormulaPojo();
        functionFormulaPojo.setUuidString(StrUtils.getUuidIdWithDataString());
        functionFormulaPojo.setTypeString("function");
        functionFormulaPojo.setNewFun(true);
        functionFormulaPojo.setToolEnumKeyString(functionName);
        functionFormulaPojo.setKeyString(functionKey);
        functionFormulaPojo.setValueString(ruleFunction.getFunctionShowStr());
        ArrayList<FormulaPojo> subFormulaPojoList = new ArrayList<FormulaPojo>();
        functionFormulaPojo.setSubFormulaPojoList(subFormulaPojoList);
        FormulaPojo indivisibleFormulaPojo = new FormulaPojo();
        indivisibleFormulaPojo.setTypeString("indivisible");
        indivisibleFormulaPojo.setCallbackMethodNameString("showFunctionEditPage");
        indivisibleFormulaPojo.setValueString("@" + functionName);
        subFormulaPojoList.add(indivisibleFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList("("));
        Map allValues = ruleFunction.getAllValues();
        String account = (String)allValues.get("account");
        FormulaMemberPojo accountMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)account, FormulaMemberPojo.class);
        FormulaPojo accountFormulaPojo = RuleJsUtils.toFormulaPojoByMainDim(modelCacheHelper, accountMemberPojo);
        accountFormulaPojo.setCallbackMethodNameString(null);
        subFormulaPojoList.add(accountFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo taxrateFormulaPojo = new FormulaPojo();
        taxrateFormulaPojo.setTypeString("indivisible");
        Object yearoffset = allValues.get("yearoffset");
        taxrateFormulaPojo.setValueString(yearoffset.toString());
        subFormulaPojoList.add(taxrateFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        FormulaPojo periodFormulaPojo = new FormulaPojo();
        periodFormulaPojo.setTypeString("indivisible");
        String specifiedperiod = (String)allValues.get("specifiedperiod");
        PeriodEnum periodEnum = PeriodEnum.getEnumByKey((String)specifiedperiod);
        periodFormulaPojo.setValueString(periodEnum.getName());
        periodFormulaPojo.setNumberString(specifiedperiod);
        periodFormulaPojo.setShowNumberString(specifiedperiod);
        subFormulaPojoList.add(periodFormulaPojo);
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(","));
        String funStr = (String)allValues.get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isNotEmpty((String)funStr)) {
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            FormulaPojo childFormulaPojo = RuleJsUtils.ruleFunctionToFunctionFormulaPojo(modelCacheHelper, (IRuleFunction)childFun);
            functionFormulaPojo.setChildFormulaPojo(childFormulaPojo);
            subFormulaPojoList.addAll(childFormulaPojo.getSubFormulaPojoList());
        }
        subFormulaPojoList.addAll(RuleJsUtils.getTextFormulaPojoList(")"));
        return functionFormulaPojo;
    }
}

