/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteStatusEnum;

public class ExecuteCaseLogPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESS = "progressbarap";

    public void afterCreateNewData(EventObject e) {
        try {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
            progressBar.start();
            long executeLogId = this.getExecuteLogId();
            if (executeLogId != 0L) {
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)executeLogId, (String)"eb_executecaserecord");
                this.getModel().setValue("executelog", (Object)record.getString("executelog"));
                String executeprogress = record.getString("executeprogress");
                String executestatus = record.getString("executestatus");
                if (!ExecuteStatusEnum.RUNNING.getIndex().equals(executestatus)) {
                    progressBar.setPercent(100, ExecuteStatusEnum.getEnumByIndex(executestatus).getName());
                } else if (executeprogress != null && executeprogress.endsWith("%")) {
                    double progress = Double.parseDouble(executeprogress.substring(0, executeprogress.length() - 1));
                    if (progress >= 100.0) {
                        progress = 100.0;
                    }
                    progressBar.setPercent((int)progress, executeprogress);
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"ExecuteCaseLogPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent e) {
        try {
            long executeLogId = this.getExecuteLogId();
            if (executeLogId != 0L) {
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)executeLogId, (String)"eb_executecaserecord");
                String executeprogress = record.getString("executeprogress");
                String executestatus = record.getString("executestatus");
                this.getModel().setValue("executelog", (Object)record.getString("executelog"));
                if (!ExecuteStatusEnum.RUNNING.getIndex().equals(executestatus)) {
                    e.setProgress(100);
                    e.setText(ExecuteStatusEnum.getEnumByIndex(executestatus).getName());
                } else {
                    e.setText(executeprogress);
                    if (executeprogress != null && executeprogress.endsWith("%")) {
                        double progress = Double.parseDouble(executeprogress.substring(0, executeprogress.length() - 1));
                        if (progress >= 100.0) {
                            progress = 100.0;
                        }
                        e.setProgress((int)progress);
                    }
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"ExecuteCaseLogPlugin#onProgress", (Throwable)ex);
        }
    }

    public long getExecuteLogId() {
        return (Long)this.getFormCustomParam("executelogid");
    }
}

