/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;

public class ExecuteRecordPlugin
extends AbstractListPlugin
implements SetFilterListener {
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        event.getQFilters().add(qFilter);
    }

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            super.itemClick(evt);
            String key = evt.getItemKey();
            if ("cancelexecute".equals(key)) {
                this.cancelexecute();
            } else if ("refresh".equals(key)) {
                this.refresh();
            } else if ("downloadlog".equals(key)) {
                this.downloadlog();
            } else if ("delete".equals(key)) {
                this.delete();
            } else if ("close".equals(key)) {
                this.getView().close();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ExecuteRecordPlugin#itemClick", (Throwable)e);
        }
    }

    private void downloadlog() {
        DynamicObject[] load;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ExecuteRecordPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)billlist.getEntityType())) {
            this.downloadLog(dynamicObject);
        }
    }

    private void downloadLog(DynamicObject doj) {
        String casename = doj.getString("casename");
        String filename = ResManager.loadKDString((String)"\u660e\u7ec6\u65e5\u5fd7\u4e0b\u8f7d", (String)"ExecuteRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)casename)) {
            filename = filename + casename;
        }
        String fileUrl = this.createFileUrl(doj.getString("executelog"), filename);
        this.getClientViewProxy().addAction("download", (Object)fileUrl);
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private String createFileUrl(String log, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(log.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".txt", (InputStream)inStream, 10000);
    }

    private void delete() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u884c", (String)"MetricSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"TemplateListPlugin_21", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        try {
            super.confirmCallBack(event);
            String callBackId = event.getCallBackId();
            if ("delete_comfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                Set collect = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("id", "in", collect);
                qFilter.and("executestatus", "!=", (Object)"0");
                DeleteServiceHelper.delete((String)"eb_executecaserecord", (QFilter[])qFilter.toArray());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FieldRegisterList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                billlist.clearSelection();
                this.refresh();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ExecuteRecordPlugin#confirmCallBack", (Throwable)e);
        }
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void cancelexecute() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"ExecuteRecordPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            String s = RuleCaseService.getInstance().setRecordCancelExecute((Long)primaryKeyValue);
            if (!StringUtils.isNotEmpty((String)s)) continue;
            stringBuilder.append(s);
        }
        if (stringBuilder.length() > 0) {
            this.getView().showTipNotification(stringBuilder.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6267\u884c\u6210\u529f", (String)"ExecuteRecordPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refresh();
    }

    @Override
    public Long getModelId() {
        return (Long)this.getFormCustomParam("MODELID");
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        BillList control = (BillList)this.getControl("billlistap");
        this.showLogPage((Long)control.getFocusRowPkId());
    }

    private void showLogPage(Long focusRowPkId) {
        HashMap<String, Object> openParameter = new HashMap<String, Object>(10);
        openParameter.put("formId", "eb_executecaselog");
        openParameter.put("executelogid", focusRowPkId);
        FormShowParameter formShowParameter = BaseShowParameter.createFormShowParameter(openParameter);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }
}

