/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteStatusEnum;

public class ExecuteRuleProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BACK_RUN = "buttonap";
    private static final String CLOSE = "close";
    private static final String PROGRESS = "progressbarap";
    private static final String CACHEKEY_PROGRESS = "cache_progress";

    public void afterCreateNewData(EventObject e) {
        String msg = this.getMsg(0);
        this.getModel().setValue("msg", (Object)msg);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BACK_RUN});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CLOSE});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"ExecuteRuleProcessPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BACK_RUN, CLOSE});
    }

    public void onProgress(ProgressEvent e) {
        try {
            long executeLogId = this.getExecuteLogId();
            if (executeLogId != 0L) {
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)executeLogId, (String)"eb_executecaserecord");
                String executeprogress = record.getString("executeprogress");
                int executeruleamount = record.getInt("executeruleamount");
                String executestatus = record.getString("executestatus");
                if (!ExecuteStatusEnum.RUNNING.getIndex().equals(executestatus)) {
                    Label label;
                    if (ExecuteStatusEnum.SUCCESS.getIndex().equals(executestatus)) {
                        e.setProgress(100);
                        label = (Label)this.getControl("percent");
                        label.setText("100%");
                        this.getModel().setValue("msg", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecuteRuleProcessPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        e.setProgress(100);
                        label = (Label)this.getControl("percent");
                        label.setText("100%");
                        this.getModel().setValue("msg", (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u65e5\u5fd7\u3002", (String)"ExecuteRuleProcessPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BACK_RUN});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{CLOSE});
                }
                if (executeprogress != null && executeprogress.endsWith("%")) {
                    String substring = executeprogress.substring(0, executeprogress.length() - 1);
                    Double progress = Double.parseDouble(substring);
                    if (progress >= 100.0) {
                        progress = 100.0;
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{BACK_RUN});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{CLOSE});
                    }
                    e.setProgress(progress.intValue());
                    Label label = (Label)this.getControl("percent");
                    label.setText(progress + "%");
                    this.getModel().setValue("msg", (Object)this.getMsg(executeruleamount));
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"ExecuteRuleProcessPlugin#onProgress", (Throwable)ex);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control control = (Control)evt.getSource();
            String key = control.getKey();
            if (BACK_RUN.equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5173\u95ed\u5f53\u524d\u9875\u9762\u5728\u540e\u53f0\u8fdb\u884c\u89c4\u5219\u8ba1\u7b97\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteRuleProcessPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_comfirm", (IFormPlugin)this));
            } else if (CLOSE.equals(key)) {
                this.getView().returnDataToParent((Object)"close_page");
                this.getView().close();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"ExecuteRuleProcessPlugin#click", (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        try {
            super.confirmCallBack(evt);
            String key = evt.getCallBackId();
            if ("close_comfirm".equals(key) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().returnDataToParent((Object)"close_page");
                this.getView().close();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((kd.bos.form.plugin.AbstractFormPlugin)this, (String)"ExecuteRuleProcessPlugin#confirmCallBack", (Throwable)e);
        }
    }

    public String getMsg(int rulecount) {
        String ruleAmount = (String)this.getFormCustomParam("ruleAmount");
        return ResManager.loadResFormat((String)"\u5171%1\u6761\u89c4\u5219\uff0c\u5df2\u6267\u884c%2\u6761\u3002", (String)"BgExecuteRulePlugin2_5", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleAmount, rulecount});
    }

    public long getExecuteLogId() {
        return (Long)this.getFormCustomParam("executelogid");
    }
}

