/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.common.params.ParamServiceHelper;
import kd.epm.eb.common.pojo.DynamicAlertPojo;
import kd.epm.eb.common.pojo.ExecuteRuleCasePojo;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCaseExecContext;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.enums.RuleExecCaseTypeEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleExecCaseListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
CommonMethod,
SetFilterListener,
CreateListDataProviderListener {
    private ListSelectedRowCollection delData;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            BillList billList = (BillList)this.getControl("billlistap");
            billList.addHyperClickListener((HyperLinkClickListener)this);
            billList.addSetFilterListener((SetFilterListener)this);
            billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            BasedataEdit modelEdit = (BasedataEdit)this.getControl("model");
            modelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            BasedataEdit bizmodel = (BasedataEdit)this.getControl("bizmodel");
            bizmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#registerListener", (Throwable)ex);
        }
    }

    public void setFilter(SetFilterEvent e) {
        try {
            Long modelId = this.getModelId();
            Long bizModelId = this.getBizModelId();
            if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
                e.getQFilters().add(new QFilter("1", "!=", (Object)1));
            } else {
                e.getQFilters().add(new QFilter("model", "=", (Object)modelId));
                e.getQFilters().add(new QFilter("bizmodel", "=", (Object)bizModelId));
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#setFilter", (Throwable)ex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String executeRuleCasePojoStr = ObjUtils.getString((Object)this.getView().getFormShowParameter().getCustomParam(ExecuteRuleCasePojo.class.getName()));
            if (StringUtils.isBlank((CharSequence)executeRuleCasePojoStr)) {
                return;
            }
            ExecuteRuleCasePojo executeRuleCasePojo = (ExecuteRuleCasePojo)JsonUtils.readValue((String)executeRuleCasePojoStr, ExecuteRuleCasePojo.class);
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)executeRuleCasePojo);
            this.getModel().setValue("model", (Object)executeRuleCasePojo.getModelIdLong());
            this.getModel().setValue("bizmodel", (Object)executeRuleCasePojo.getBusinessModelIdLong());
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            ExecuteRuleCasePojo executeRuleCasePojo = (ExecuteRuleCasePojo)CacheUtils.get((IPageCache)this.getPageCache(), ExecuteRuleCasePojo.class);
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)executeRuleCasePojo);
            if (executeRuleCasePojo == null) {
                return;
            }
            Long selectedExecuteRuleCaseIdLong = executeRuleCasePojo.getSelectedExecuteRuleCaseIdLong();
            BillList billList = (BillList)this.getControl("billlistap");
            if (billList == null || ObjUtils.nullOrZero((Long[])new Long[]{selectedExecuteRuleCaseIdLong})) {
                return;
            }
            ListSelectedRowCollection listSelectedRowCollection = billList.getCurrentListAllRowCollection();
            if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection)) {
                return;
            }
            Integer targetIndexInteger = LambdaUtils.getTargetIndexInteger((List)listSelectedRowCollection, item -> selectedExecuteRuleCaseIdLong.equals(ObjUtils.getLong((Object)item.getPrimaryKeyValue())));
            if (targetIndexInteger == null) {
                return;
            }
            billList.selectRows(new int[]{targetIndexInteger});
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#afterBindData", (Throwable)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String propertyName = e.getProperty().getName();
            if ("model".equals(propertyName) || "bizmodel".equals(propertyName)) {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.clearSelection();
                billList.refresh();
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#propertyChanged", (Throwable)ex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        try {
            String key = e.getProperty().getName();
            if (key.equals("model")) {
                PluginUtils.setModelFilter(e, this.getView());
            } else if (key.equals("bizmodel")) {
                Long modelId = this.getModelId();
                if (modelId == null) {
                    e.getCustomQFilters().add(new QFilter("1", "=", (Object)0));
                } else {
                    e.getCustomQFilters().clear();
                    e.getCustomQFilters().add(new QFilter("model", "=", (Object)modelId));
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#beforeF7Select", (Throwable)ex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            super.itemClick(evt);
            switch (evt.getItemKey()) {
                case "bar_exec": {
                    this.barExec();
                    break;
                }
                case "bar_log": {
                    this.openLogPage();
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#itemClick", (Throwable)e);
        }
    }

    private void barExec() {
        BillList billList = (BillList)this.getControl("billlistap");
        Object[] billListPk = billList.getSelectedRows().getPrimaryKeyValues();
        if (billListPk == null || billListPk.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u65b9\u6848\u3002", (String)"bizRuleGroupListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] dojColl = BusinessDataServiceHelper.load((Object[])billListPk, (DynamicObjectType)billList.getEntityType());
        Optional<CaseUpdateStatusEnum> statusEnumOptional = Arrays.stream(dojColl).map(doj -> CaseUpdateStatusEnum.getStatusByCode(doj.getString("updatestatus"))).filter(status -> CaseUpdateStatusEnum.STAGING == status || CaseUpdateStatusEnum.UPDATE_ING == status || CaseUpdateStatusEnum.UPDATE_FAIL == status).findAny();
        if (statusEnumOptional.isPresent()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u884c\u4e2d\u6709\u6682\u5b58/\u66f4\u65b0\u4e2d/\u66f4\u65b0\u5931\u8d25\u72b6\u6001\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"bizRuleGroupListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Optional<CaseUpdateStatusEnum> statusEnumOptional2 = Arrays.stream(dojColl).map(doj -> CaseUpdateStatusEnum.getStatusByCode(doj.getString("updatestatus"))).filter(status -> CaseUpdateStatusEnum.UPDATE_WAIT == status).findAny();
        if (statusEnumOptional2.isPresent()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u884c\u4e2d\u6709\u5f85\u66f4\u65b0\u72b6\u6001\u7684\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u81ea\u52a8\u66f4\u65b0\u3002", (String)"DataReleaseSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("barExec", (IFormPlugin)this));
            return;
        }
        this.execCase(dojColl);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        try {
            super.confirmCallBack(event);
            String callBackId = event.getCallBackId();
            if ("barExec".equals(callBackId)) {
                MessageBoxResult result = event.getResult();
                this.getPageCache().remove("dataChange");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    BillList billList = (BillList)this.getControl("billlistap");
                    Object[] billListPk = billList.getSelectedRows().getPrimaryKeyValues();
                    if (billListPk == null || billListPk.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u65b9\u6848\u3002", (String)"bizRuleGroupListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject[] dojColl = BusinessDataServiceHelper.load((Object[])billListPk, (DynamicObjectType)billList.getEntityType());
                    this.execCase(dojColl);
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#confirmCallBack", (Throwable)e);
        }
    }

    private void execCase(DynamicObject[] dojColl) {
        LinkedHashMap<String, Set> unReleaseRuleMap = new LinkedHashMap<String, Set>(16);
        for (DynamicObject _doj : dojColl) {
            Set unReleaseRules2;
            List<RuleRow> rowList;
            RuleCase ruleCase = RuleCase.of(_doj);
            if (!RuleExecCaseTypeEnum.RULE.getCode().equals(ruleCase.getType()) || ruleCase.getAllowDisable().booleanValue() || CollectionUtils.isEmpty(rowList = ruleCase.getRowList()) || CollectionUtils.isEmpty(unReleaseRules2 = rowList.stream().filter(e -> e.getRuleDto().getStatus() == false).map(e -> e.getRuleDto().getNumber()).collect(Collectors.toSet()))) continue;
            Set unReleaseRuleSet = unReleaseRuleMap.computeIfAbsent(ruleCase.getCaseNumber(), k -> new LinkedHashSet(16));
            unReleaseRuleSet.addAll(unReleaseRules2);
        }
        if (!unReleaseRuleMap.isEmpty()) {
            ArrayList tipNotificationStringList = new ArrayList(16);
            unReleaseRuleMap.forEach((caseNum, unReleaseRules) -> tipNotificationStringList.add(ResManager.loadResFormat((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848\uff1a%1\uff0c\u672a\u53d1\u5e03\u7684\u4e1a\u52a1\u89c4\u5219\uff1a%2", (String)"bizRuleGroupListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[]{caseNum, StringUtils.join((Iterable)unReleaseRules, (String)",")})));
            DynamicAlertPojo dynamicAlertPojo = new DynamicAlertPojo();
            dynamicAlertPojo.setPageTitleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"bizRuleGroupListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            dynamicAlertPojo.setDescriptionString(ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848\u4e2d\u5b58\u5728\u672a\u53d1\u5e03\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c", (String)"bizRuleGroupListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            dynamicAlertPojo.setMessageString(String.join((CharSequence)"\n", tipNotificationStringList));
            dynamicAlertPojo.setOperationTypeString("know");
            DynamicAlertUtils.openDynamicAlert((IFormView)this.getView(), (DynamicAlertPojo)dynamicAlertPojo);
            return;
        }
        Long modelId = this.getModelId();
        LinkedList<Long> logIds = new LinkedList<Long>();
        for (DynamicObject doj : dojColl) {
            Long jobLog = RuleExecLogService.getInstance().createJonLog(modelId, doj.getString("number") + "-" + doj.getString("name"));
            logIds.add(jobLog);
        }
        LinkedList<Long> successSubmitLogIds = new LinkedList<Long>();
        ArrayList ruleCaseExecContexts = Lists.newArrayList();
        for (int i = 0; i < dojColl.length; ++i) {
            Long logId = (Long)logIds.get(i);
            DynamicObject doj = dojColl[i];
            try {
                DynamicObject _doj = RuleCaseService.getInstance().updateCaseEntity(doj);
                RuleCase ruleCase = RuleCase.of(_doj);
                ruleCaseExecContexts.add(new RuleCaseExecContext(ruleCase, logId));
                successSubmitLogIds.add(logId);
                this.writeLog("executeScheme", new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848", "BizRuleGroupListPlugin2_54", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848[%1$s\u3001%2$s]\u6210\u529f\u3002", "BizRuleGroupListPlugin2_59", "epm-eb-formplugin"), new String[]{doj.getString("number"), doj.getString("name")});
                continue;
            }
            catch (Exception e2) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4efb\u52a1%1\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"", (String)doj.getString("number"), (Object[])new Object[0]));
                RuleExecLogService.getInstance().updateExecStatus(logId, null, ReportRuleExecStatusEnum.EXEC_FAIL.getCode(), e2.getMessage());
                this.writeLog("executeScheme", new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848", "BizRuleGroupListPlugin2_54", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848[%1$s\u3001%2$s]\u5931\u8d25\u3002", "BizRuleGroupListPlugin2_60", "epm-eb-formplugin"), new String[]{doj.getString("number"), doj.getString("name")});
            }
        }
        if (!successSubmitLogIds.isEmpty()) {
            String appId = "eb";
            String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
            DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"RuleExecCaseService", (String)"submitRuleCase", (Object[])new Object[]{ruleCaseExecContexts});
            JobInfo jobInfo = this.createJobInfo(successSubmitLogIds);
            JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo);
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c", (String)"BgExecuteRulePlugin2_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "jobClose"));
        return jobFormInfo;
    }

    private JobInfo createJobInfo(List<Long> logIdList) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.ruleexec.task.JobExecRuleTask");
        String jobName = ResManager.loadKDString((String)"\u7b49\u5f85\u6267\u884c\u4e1a\u52a1\u89c4\u5219", (String)"RuleCase_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setFailNotify(true);
        jobInfo.setSuccessNotify(true);
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("pageId", this.getView().getPageId());
        customParams.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", this.getView().getFormShowParameter().getPageId());
        customParams.put("rootPageId", this.getView().getFormShowParameter().getRootPageId());
        customParams.put("logId", JsonUtils.getJsonString(logIdList));
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    public void openLogPage() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("bos_list");
        formShowParameter.setBillFormId("eb_ruleexeccaselog");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u65b9\u6848\u6267\u884c\u65e5\u5fd7\u5217\u8868", (String)"bizRuleGroupListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            this.delData = args.getListSelectedData();
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#beforeDoOperation", (Throwable)e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            super.afterDoOperation(args);
            if (args.getSource() instanceof Delete && this.delData != null) {
                List ids = this.delData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.RuleCase.getType(), ids});
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#afterDoOperation", (Throwable)e);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent args) {
        try {
            BillShowParameter billShowParameter = args.getParameter();
            if (billShowParameter instanceof BaseShowParameter) {
                Long modelId = this.getModelId();
                Long bizModelId = this.getBizModelId();
                if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbShareDimensionList2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DiffAnalyzeSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                billShowParameter.setCustomParam("modelId", (Object)modelId);
                billShowParameter.setCustomParam("bizmodelid", (Object)this.getBizModelId());
                Object pkId = billShowParameter.getPkId();
                DynamicObject doj = QueryServiceHelper.queryOne((String)"eb_ruleexeccase", (String)"updatestatus", (QFilter[])new QFilter("id", "=", pkId).toArray());
                if (doj != null && CaseUpdateStatusEnum.UPDATE_ING.getCode().equals(doj.getString("updatestatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u66f4\u65b0\u4e2d\uff0c\u8bf7\u66f4\u65b0\u5b8c\u540e\u518d\u7f16\u8f91\u3002", (String)"EbShareDimensionList2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#beforeShowBill", (Throwable)e);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue("model", "id");
    }

    public Long getBizModelId() {
        return (Long)this.getValue("bizmodel", "id");
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        try {
            arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection allRows = super.getData(start, limit);
                    ArrayList updateParameters = new ArrayList(16);
                    allRows.forEach(row -> {
                        boolean allowDisable;
                        String type = row.getString("type");
                        if (RuleExecCaseTypeEnum.RANGE.getCode().equals(type) && (allowDisable = row.getBoolean("allowdisable"))) {
                            row.set("allowdisable", (Object)false);
                            updateParameters.add(new Object[]{"0", row.getLong("id")});
                        }
                    });
                    if (!updateParameters.isEmpty()) {
                        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_ruleexeccase set fallowdisable = ? where fid = ?", updateParameters);
                    }
                    return allRows;
                }
            });
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleExecCaseListPlugin#createListDataProvider", (Throwable)e);
        }
    }
}

