/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute.domain;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExecuteVo
implements Serializable {
    private Long ruleId;
    private RuleDto ruleDto;
    private List<FormulaCondition> conditionList;
    private Map<String, Integer> descarteMap = Maps.newHashMap();
    private Long seqLong;
    private int rowIndex;
    private Map<String, List<MemberCondition>> memberListMap = new HashMap<String, List<MemberCondition>>();

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public void setDescarteMap(Map<String, Integer> descarteMap) {
        this.descarteMap = descarteMap;
    }

    public Map<String, Integer> getDescarteMap() {
        return this.descarteMap;
    }

    public List<FormulaCondition> getConditionList() {
        if (this.conditionList == null) {
            DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.ruleId, (String)"eb_bizruleset", (String)"datasetid,number,usescope,account,metric");
            if (doj != null) {
                String usescope = doj.getString("usescope");
                this.conditionList = RuleManageJsonUtil.getConditions2((String)usescope);
            }
            if (this.conditionList == null) {
                this.conditionList = Collections.emptyList();
            }
        }
        return this.conditionList;
    }

    public void setConditionList(List<FormulaCondition> conditionList) {
        this.conditionList = conditionList;
    }

    public void setRuleDto(RuleDto ruleDto) {
        this.ruleDto = ruleDto;
    }

    public RuleDto getRuleDto() {
        return this.ruleDto;
    }

    public Long ruleDataSetId() {
        RuleDto ruleDto = this.getRuleDto();
        if (ruleDto == null) {
            return 0L;
        }
        Long dataSetId = ruleDto.getDataSetId();
        if (dataSetId == null) {
            Long modelId = ruleDto.getModelId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map leftMembers = ruleDto.getLeftMembers();
            Set accountNumbers = (Set)leftMembers.get(SysDimensionEnum.Account.getNumber());
            String tryOneAccountNumber = (String)accountNumbers.iterator().next();
            Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, tryOneAccountNumber);
            ruleDto.setDataSetId(accountMember.getDatasetId());
        }
        return ruleDto.getDataSetId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteVo vo = (ExecuteVo)o;
        return new EqualsBuilder().append((Object)vo.getRuleDto().getId(), (Object)this.ruleDto.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.ruleDto.getId()).toHashCode();
    }

    public BigInteger calcDesCartes() {
        BigInteger descartes = new BigInteger("0");
        if (this.descarteMap != null) {
            descartes = new BigInteger("1");
            for (Map.Entry<String, Integer> entry : this.descarteMap.entrySet()) {
                Integer value = entry.getValue();
                descartes = descartes.multiply(new BigInteger(value.toString()));
            }
        }
        return descartes;
    }

    public Long getSeqLong() {
        return this.seqLong;
    }

    public void setSeqLong(Long seqLong) {
        this.seqLong = seqLong;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setMemberListMap(Map<String, List<MemberCondition>> memberListMap) {
        this.memberListMap = memberListMap;
    }

    public Map<String, List<MemberCondition>> getMemberListMap() {
        return this.memberListMap;
    }
}

