/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute.task;

import com.alibaba.fastjson.JSON;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.AccountRelationTester;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections4.CollectionUtils;

public class RuleGraphCheckTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RuleGraphCheckTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u68c0\u67e5\u89c4\u5219\u5b9a\u56fe\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        if (map == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"RuleGraphCheckTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object modelNumber = map.get("modelNumber");
        QFilter modelQfilter = new QFilter("shownumber", "=", modelNumber);
        DynamicObject modelDoj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number", (QFilter[])modelQfilter.toArray());
        if (modelDoj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u7f16\u7801%1\u4e0d\u5b58\u5728\u3002", (String)"RuleGraphCheckTask_0", (String)"epm-eb-formplugin", (Object[])new Object[]{modelNumber}));
        }
        long modelId = modelDoj.getLong("id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelDoj.getLong("id")).toArray());
        for (DynamicObject dynamicObject : query) {
            long bizCtrlId = dynamicObject.getLong("id");
            List allRules = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizCtrlId)).getRuleDtoList();
            List enableRules = allRules.stream().filter(RuleDto::getStatus).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(enableRules)) {
                log.info("enableRules \u4e3a\u7a7a");
                RuleCacheService.getInstance().clearCache(Long.valueOf(bizCtrlId));
                continue;
            }
            MutableGraph oldGraph = RuleGraphService.getInstance().getDagGraphByBizmodel(enableRules);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List copyRules = RuleRelationService.getInstance().rebuildRightMember(allRules, modelCache);
            AccountRelationTester accountRelationTester = new AccountRelationTester(false);
            List enableCopyRules = copyRules.stream().filter(RuleDto::getStatus).collect(Collectors.toList());
            RuleGraphService.getInstance().checkYearValueFun(enableCopyRules, modelCache);
            List nodes = RuleGraphService.getInstance().buildAdjNodeList(enableCopyRules, modelCache, accountRelationTester);
            QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
            MutableGraph newGraph = RuleGraphService.getInstance().buildDagGraph((Collection)nodes);
            log.info("\u6784\u9020DAG\u56fe:" + newGraph);
            if (oldGraph.equals(newGraph)) continue;
            String title = ResManager.loadKDString((String)"\u89c4\u5219\u56fe\u68c0\u6d4b\u544a\u8b66", (String)"RuleGraphCheckTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String messageDate = ResManager.loadResFormat((String)"\u4f53\u7cfb\uff1a%1\uff0c\u89c4\u5219\u56fe\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u5347\u7ea7\u89c4\u5219\u4f9d\u8d56\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleGraphCheckTask_2", (String)"epm-eb-formplugin", (Object[])new Object[]{modelNumber});
            RuleExecutionService.getInstance().sendMessage(modelId, Collections.singletonList(title), title, messageDate);
        }
    }
}

