/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.ruleexecute.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.f7.MemberCondition;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecutePageDomain;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteVo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ExecuteRuleUtils {
    public static List<kd.epm.eb.common.dao.formula.MemberCondition> rebuildConditonList(List<MemberCondition> memberList, String dimNumer) {
        ArrayList<kd.epm.eb.common.dao.formula.MemberCondition> memberConditions = new ArrayList<kd.epm.eb.common.dao.formula.MemberCondition>(memberList.size());
        for (MemberCondition memberCondition : memberList) {
            kd.epm.eb.common.dao.formula.MemberCondition memberConditionCopy = new kd.epm.eb.common.dao.formula.MemberCondition();
            memberConditionCopy.setNumber(memberCondition.getNumber());
            memberConditionCopy.setName(memberCondition.getName());
            memberConditionCopy.setRange(memberCondition.getRange());
            memberConditionCopy.setLongnumber(memberCondition.getLongnumber());
            memberConditionCopy.setProp(memberCondition.isProp());
            memberConditionCopy.setRemoveBoolean(memberCondition.getRemoveBoolean());
            if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimNumer).booleanValue()) {
                memberConditionCopy.setVariable(true);
            }
            memberConditions.add(memberConditionCopy);
        }
        return memberConditions;
    }

    public static List<MemberCondition> rebuildConditonList2(List<kd.epm.eb.common.dao.formula.MemberCondition> memberList, String dimNumber) {
        ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(memberList.size());
        for (kd.epm.eb.common.dao.formula.MemberCondition memberCondition : memberList) {
            MemberCondition memberConditionCopy = new MemberCondition();
            memberConditionCopy.setNumber(memberCondition.getNumber());
            memberConditionCopy.setName(memberCondition.getName());
            memberConditionCopy.setRange(memberCondition.getRange());
            memberConditionCopy.setLongnumber(memberCondition.getLongnumber());
            memberConditionCopy.setProp(memberCondition.isProp());
            memberConditionCopy.setRemoveBoolean(memberCondition.getRemoveBoolean());
            if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimNumber).booleanValue()) {
                memberConditionCopy.setVariable(true);
            }
            memberConditions.add(memberConditionCopy);
        }
        return memberConditions;
    }

    public static String buildMemberConditionString2(List<kd.epm.eb.common.dao.formula.MemberCondition> conditions) {
        StringBuilder sb = new StringBuilder();
        for (kd.epm.eb.common.dao.formula.MemberCondition condition : conditions) {
            sb.append(condition.toString()).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String buildMemberConditionString(List<MemberCondition> conditions) {
        StringBuilder sb = new StringBuilder();
        for (MemberCondition condition : conditions) {
            sb.append(condition.toString()).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] getRightDimSort(IModelCacheHelper modeCache, long bizModelId) {
        List dimensionList = modeCache.getDimensionListByBusModel(Long.valueOf(bizModelId));
        String[] dimSort = new String[dimensionList.size() - 2];
        int index = 0;
        for (Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || SysDimensionEnum.Metric.getNumber().equals(dimNumber)) continue;
            dimSort[index++] = dimNumber;
        }
        return dimSort;
    }

    public static Status checkDomain(ExecutePageDomain pageDomain) {
        long modelId = pageDomain.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<ExecuteVo> executeVoList = pageDomain.getExecuteVoList();
        if (executeVoList == null || executeVoList.isEmpty()) {
            Status status = new Status(false);
            status.setMessage(ResManager.loadKDString((String)"\u5df2\u9009\u89c4\u5219\u4e3a\u7a7a", (String)"ExecuteRuleUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return status;
        }
        StringBuilder beginsb = new StringBuilder();
        for (ExecuteVo vo : executeVoList) {
            List dimensionList = modelCache.getDimensionList(vo.ruleDataSetId());
            List<FormulaCondition> conditionList = vo.getConditionList();
            if (conditionList == null) {
                conditionList = new ArrayList<FormulaCondition>(2);
            }
            Map<String, FormulaCondition> collect = conditionList.stream().collect(Collectors.toMap(FormulaCondition::getDimensionNumber, v -> v));
            StringBuilder sb = new StringBuilder();
            for (Dimension dimension : dimensionList) {
                if (dimension.getId().equals(vo.getRuleDto().getMainDimensionId()) || collect.containsKey(dimension.getNumber())) continue;
                if (sb.length() < 1) {
                    sb.append(ResManager.loadKDString((String)"\u89c4\u5219\uff1a", (String)"ExecuteRuleUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(vo.getRuleDto().getNumber()).append(ResManager.loadKDString((String)"\u7684", (String)"ExecuteRuleUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                sb.append(dimension.getName()).append(",");
            }
            if (sb.length() <= 0) continue;
            sb.deleteCharAt(sb.length() - 1).append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u672a\u9009\u62e9\u6210\u5458\u3002", (String)"ExecuteRuleUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (beginsb.length() > 0) {
            Status status = new Status(true);
            beginsb.append(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6267\u884c\u89c4\u5219\u9002\u7528\u8303\u56f4\u4e2d\u7684\u6240\u6709\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u77e5\u6089\u3002", (String)"ExecuteRuleUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            status.setMessage(beginsb.toString());
            return status;
        }
        return new Status(true);
    }

    public static int calcConditionRange2(IModelCacheHelper modelCache, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, Dimension dimension, List<kd.epm.eb.common.dao.formula.MemberCondition> memberConditionList, Set<String> defaultMembers, boolean hasAgg) {
        Long modelId = modelCache.getModelobj().getId();
        HashSet dimRef = new HashSet(16);
        for (kd.epm.eb.common.dao.formula.MemberCondition memberCondition : memberConditionList) {
            Long viewIdLong = IDUtils.toLong((Object)memberCondition.getViewId());
            if (memberCondition.isProp()) {
                CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimension.getNumber(), (String)memberCondition.getLongnumber());
                List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)viewIdLong, (CustomPropertyValue)customPropertyValue);
                Stream<Object> stream = propMemberList.stream();
                if (hasAgg) {
                    stream = stream.filter(Member::isLeaf);
                }
                Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
                dimRef.addAll(memberRef);
                continue;
            }
            if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimension.getNumber()).booleanValue()) {
                String msg;
                if (varValues == null) {
                    String msg2 = ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u672a\u88ab\u8d4b\u503c\u7684\u53d8\u91cf\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u8fdb\u884c\u8d4b\u503c", (String)"RuleJsUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg2);
                }
                Map<String, Set<String>> map = varValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (map == null) {
                    msg = ResManager.loadResFormat((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u672a\u88ab\u8d4b\u503c\u7684\u53d8\u91cf\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u8fdb\u884c\u8d4b\u503c", (String)"RuleJsUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                msg = ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a%1$s\u7ef4\u5ea6\u7684%2$s\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleRangeJsAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                Set memberNumbers = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memberCondition.getNumber(), (String)SysDimensionEnum.BudgetPeriod.getNumber(), varValues, (String)msg);
                for (String memberNumber : memberNumbers) {
                    String range = memberCondition.getRange();
                    List member = modelCache.getMember(dimension.getNumber(), viewIdLong, memberNumber, Integer.parseInt(range));
                    Stream<Object> stream = member.stream();
                    if (hasAgg) {
                        stream = stream.filter(Member::isLeaf);
                    }
                    Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
                    dimRef.addAll(memberRef);
                }
                continue;
            }
            String number = memberCondition.getNumber();
            String range = memberCondition.getRange();
            List member = modelCache.getMember(dimension.getNumber(), viewIdLong, number, Integer.parseInt(range));
            Stream<Object> stream = member.stream();
            if (hasAgg) {
                stream = stream.filter(Member::isLeaf);
            }
            Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
            dimRef.addAll(memberRef);
        }
        if (defaultMembers != null) {
            dimRef.retainAll(defaultMembers);
        }
        return dimRef.size();
    }

    public static int calcConditionRange(IModelCacheHelper modelCache, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, Dimension dimension, List<MemberCondition> memberConditionList, Set<String> defaultMembers, boolean hasAgg) {
        Long modelId = modelCache.getModelobj().getId();
        HashSet dimRef = new HashSet(16);
        for (MemberCondition memberCondition : memberConditionList) {
            Long viewId = memberCondition.getViewIdLong();
            if (memberCondition.isProp()) {
                CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimension.getNumber(), (String)memberCondition.getLongnumber());
                List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)viewId, (CustomPropertyValue)customPropertyValue);
                Stream<Object> stream = propMemberList.stream();
                if (hasAgg) {
                    stream = stream.filter(Member::isLeaf);
                }
                Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
                dimRef.addAll(memberRef);
                continue;
            }
            if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimension.getNumber()).booleanValue()) {
                String msg;
                if (varValues == null) {
                    String msg2 = ResManager.loadResFormat((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u672a\u88ab\u8d4b\u503c\u7684\u53d8\u91cf\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u8fdb\u884c\u8d4b\u503c", (String)"RuleJsUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg2);
                }
                Map<String, Set<String>> map = varValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (map == null) {
                    msg = ResManager.loadResFormat((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u672a\u88ab\u8d4b\u503c\u7684\u53d8\u91cf\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u8fdb\u884c\u8d4b\u503c", (String)"RuleJsUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                msg = ResManager.loadKDString((String)"\u8bf7\u5728\u89c4\u5219\u5217\u8868\u4e2d\u4e3a%1$s\u7ef4\u5ea6\u7684%2$s\u53d8\u91cf\u8d4b\u503c\u3002", (String)"RuleRangeJsAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                Set memberNumbers = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memberCondition.getNumber(), (String)SysDimensionEnum.BudgetPeriod.getNumber(), varValues, (String)msg);
                for (String memberNumber : memberNumbers) {
                    String range = memberCondition.getRange();
                    List member = modelCache.getMember(dimension.getNumber(), viewId, memberNumber, Integer.parseInt(range));
                    Stream<Object> stream = member.stream();
                    if (hasAgg) {
                        stream = stream.filter(Member::isLeaf);
                    }
                    Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
                    dimRef.addAll(memberRef);
                }
                continue;
            }
            String number = memberCondition.getNumber();
            String range = memberCondition.getRange();
            List member = modelCache.getMember(dimension.getNumber(), viewId, number, Integer.parseInt(range));
            Stream<Object> stream = member.stream();
            if (hasAgg) {
                stream = stream.filter(Member::isLeaf);
            }
            Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
            dimRef.addAll(memberRef);
        }
        if (defaultMembers != null) {
            dimRef.retainAll(defaultMembers);
        }
        return dimRef.size();
    }

    public static int calcAllDetailMembers(Dimension dimension, RuleDto ruleDto) {
        Set defaultMembers = (Set)ruleDto.getLeftMembers().get(dimension.getNumber());
        String dimensionNumber = dimension.getNumber();
        Long viewId = ruleDto.getViewMap().getOrDefault(dimensionNumber, 0L);
        List allMembers = dimension.getAllMembers(viewId);
        Set collect = allMembers.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty((Collection)defaultMembers)) {
            collect.retainAll(defaultMembers);
        }
        return collect.size();
    }

    public static class Status {
        private boolean pass;
        private String message;

        public Status(boolean pass) {
            this.pass = pass;
        }

        public boolean isPass() {
            return this.pass;
        }

        public void setPass(boolean pass) {
            this.pass = pass;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

