/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractBillPlugin;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AddVariableDimensionPlugin
extends MainSubAbstractBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener("dimension");
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("model", formShowParameter.getCustomParam("model"));
        this.getModel().setValue("dseq", formShowParameter.getCustomParam("dseq"));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
    }

    private Boolean isModify() {
        boolean isModify = false;
        Object id = this.getModel().getValue("id");
        if (id != null) {
            isModify = Long.parseLong(id.toString()) != 0L;
        }
        return isModify;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            Set dimensionIds = (Set)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("dimensionIds")), Set.class);
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
            if (dimension != null) {
                dimensionIds.remove(dimension.getString("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("dimension")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            long modelId = this.getModelId();
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
            List collect = dimensionIds.stream().map(Long::valueOf).collect(Collectors.toList());
            qFilterList.add(new QFilter("id", "not in", collect));
            if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
                qFilterList.add(new QFilter("number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()));
            }
            if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
                qFilterList.add(new QFilter("number", "!=", (Object)SysDimensionEnum.InternalCompany.getNumber()));
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "dseq asc"));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String number = this.getModel().getValue("number").toString();
            String s = NumberCheckUtils.checkNumberRule((String)number);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(s);
                return;
            }
            if (!this.isModify().booleanValue() && QueryServiceHelper.exists((String)"eb_dimensionvariable", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)number)})) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AddVariableDimensionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("name", (Object)number);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (result == null) {
            return;
        }
        if (result.isSuccess() && "save".equals(args.getOperateKey())) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BizRuleListPlugin_4", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BizRuleListPlugin_5", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
            List successPkIds = result.getSuccessPkIds();
            if (CollectionUtils.isEmpty((Collection)successPkIds)) {
                return;
            }
            Long sourceId = (Long)successPkIds.get(0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"eb_dimensionvariable");
            if (dynamicObject == null) {
                return;
            }
            ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
            Long varId = dynamicObject.getLong("id");
            long dimensionId = dynamicObject.getLong("dimension.id");
            if (IDUtils.isNotNull((Long)varId)) {
                MemberQuoteDao quote = new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(dimensionId), Long.valueOf(dimensionId), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.VarDimension, sourceId);
                quotes.add(quote);
            }
            if (quotes.size() > 0) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
        }
    }

    public String getBizAppId() {
        return CommonServiceHelper.getBizAppId4BGRP((IFormView)this.getView(), (Long)this.getModelId());
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue("model");
        return modelObj.getLong("id");
    }
}

