/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.variable;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.dao.variable.VariableCacheService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.rulemanage.RuleUpdateServiceImpl;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class AddVariableMemberPlugin
extends MainSubAbstractBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener("dimension");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("dimension", formShowParameter.getCustomParam("dimension"));
        this.getModel().setValue("model", formShowParameter.getCustomParam("model"));
        String grouptype = (String)formShowParameter.getCustomParam("grouptype");
        if (StringUtils.isNotEmpty((CharSequence)grouptype)) {
            this.getModel().setValue("grouptype", (Object)grouptype);
            this.getView().setEnable(Boolean.FALSE, new String[]{"grouptype"});
        }
        this.setOffsetVisible();
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("1".equals(formShowParameter.getCustomParam("isModify"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"offset"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"grouptype"});
        }
        this.setOffsetVisible();
    }

    private Boolean isModify() {
        boolean isModify = false;
        Object id = this.getModel().getValue("id");
        if (id != null) {
            isModify = Long.parseLong(id.toString()) != 0L;
        }
        return isModify;
    }

    private void setOffsetVisible() {
        DynamicObject dimensionObj = (DynamicObject)this.getModel().getValue("dimension");
        String grouptype = this.getModel().getValue("grouptype").toString();
        if (!"2".equals(grouptype)) {
            this.getModel().setValue("grouptype", (Object)1);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"dimension"});
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionObj.getString("number"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimension"});
            DecimalEdit text = (DecimalEdit)this.getControl("offset");
            text.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"grouptype"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"offset"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("dimension")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject modelDoj = (DynamicObject)this.getModel().getValue("model");
        return modelDoj.getLong("id");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object key = args.getSource();
        if (key instanceof Save) {
            String s;
            String name = this.getModel().getValue("name").toString();
            if (StringUtils.isEmpty((CharSequence)name)) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"AddVariableMemberPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = this.getModel().getValue("number").toString();
            if (!"1".equals(this.getView().getFormShowParameter().getCustomParam("isModify")) && StringUtils.isNotEmpty((CharSequence)(s = NumberCheckUtils.checkNumberRule((String)number)))) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(s);
                return;
            }
            if (number.contains("+") || name.contains("+") || number.contains("-") || name.contains("-")) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e2d\u4e0d\u5141\u8bb8\u5305\u542b\u201c-\u201d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AddVariableMemberPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String grouptype = this.getModel().getValue("grouptype").toString();
            if (!"2".equals(grouptype) && (number.startsWith("LastY") || number.startsWith("NextY") || number.startsWith("BaseY"))) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e2d\u4e0d\u80fd\u4ee5\u9884\u7f6e\u7f16\u7801\u5f00\u5934\u2018LastY\u2019\u3001\u2018NextY\u2019\u3001\u2018BaseY\u2019\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u91cd\u8bd5\u3002", (String)"AddVariableMemberPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.isModify().booleanValue() && QueryServiceHelper.exists((String)"eb_periodvariable", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)StringUtils.join((Object[])new String[]{"@", number}))})) {
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AddVariableMemberPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setBaseInfo();
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean isSuccess = afterDoOperationEventArgs.getOperationResult().getValidateResult().isSuccess();
        DynamicObject dimensionObj = (DynamicObject)this.getModel().getValue("dimension");
        if (isSuccess && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            String number = this.getModel().getValue("number").toString();
            if ("1".equals(this.getView().getFormShowParameter().getCustomParam("isModify"))) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionObj.getString("number"))) {
                    Long modelId = this.getModelId();
                    QFilter qFilter = new QFilter("status", "=", (Object)true);
                    qFilter.and(new QFilter("model", "=", (Object)modelId));
                    List pkids = QueryServiceHelper.queryPrimaryKeys((String)"eb_bizruleset", (QFilter[])qFilter.toArray(), null, (int)10000);
                    String traceId = RequestContext.getOrCreate().getTraceId();
                    EpmThreadPools.CommPools.execute(() -> {
                        RequestContext.getOrCreate().setTraceId(traceId);
                        RuleUpdateServiceImpl.getInstance().afterSave(modelId, pkids);
                    });
                }
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d8\u91cf\u4fee\u6539", "AddVariableMemberPlugin_6", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53d8\u91cf\uff1a%1$s\uff0c\u4fee\u6539\u6210\u529f\u3002", "ExamineListPlugin_57", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"edit", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{number});
            } else {
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d8\u91cf\u65b0\u589e", "AddVariableMemberPlugin_7", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53d8\u91cf\uff1a%1$s\uff0c\u65b0\u589e\u6210\u529f\u3002", "ExamineListPlugin_58", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"add", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{number});
            }
            VariableCacheService.getInstance().clearCache(this.getModelId());
        }
    }

    public String getBizAppId() {
        return CommonServiceHelper.getBizAppId4BGRP((IFormView)this.getView(), (Long)this.getModelId());
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    private void setBaseInfo() {
        Object offset;
        Object id = this.getModel().getValue("id");
        if (id == null || "0".equals(id.toString())) {
            this.getModel().setValue("createtime", (Object)TimeServiceHelper.now());
            this.getModel().setValue("creater", (Object)UserUtils.getUserId());
        }
        this.getModel().setValue("modifier", (Object)UserUtils.getUserId());
        this.getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
        String number = this.getModel().getValue("number").toString();
        if (!number.startsWith("@")) {
            this.getModel().setValue("number", (Object)StringUtils.join((Object[])new String[]{"@", number}));
        }
        if ((offset = this.getModel().getValue("offset")) == null) {
            this.getModel().setValue("offset", (Object)0);
        }
    }
}

