/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage.variable;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.dao.variable.VariableCacheService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.rulemanage.variable.VariableUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractListPlugin;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class VariableManagerList
extends MainSubAbstractListPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String MODELSELECT = "modelselect";
    private static final String BAR_EDIT = "bar_edit";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_ADD = "bar_add";
    private static final String BAR_UP = "bar_up";
    private static final String BAR_DOWN = "bar_down";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_MODIFY = "btn_modify";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String TREEVIEW = "treeviewap";
    private static final String SEARCH = "searchap";
    private static final String MODELCLICK = "modelclick";
    private static final String ROOT = "rootNode";
    private static final String MODEL = "model";
    private static final String SINGLE_LEVEL_PREFIX = "singlelevel:";
    private static final String MULTI_LEVEL_PREFIX = "multilevel:";
    private static final Log log = LogFactory.getLog(VariableManagerList.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{MODELSELECT, BAR_EDIT, BAR_DEL, BAR_ADD, BAR_UP, BAR_DOWN});
        Search dimensionSearch = (Search)this.getControl(SEARCH);
        dimensionSearch.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"offset"});
        if (!this.setDefaultModel()) {
            return;
        }
        this.updateModelLabel();
        this.refreshAll();
    }

    private boolean setDefaultModel() {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VariableManagerList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        return true;
    }

    private void updateModelLabel() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL);
        ((Label)this.getControl("modellabel")).setText(modelObj.getString("name"));
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL);
        if (modelObj == null) {
            return 0L;
        }
        return modelObj.getLong("id");
    }

    private void showModelForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("epm_model");
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODELCLICK));
        ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList(16);
        }
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "modelselect": {
                this.showModelForm();
                break;
            }
            case "bar_add": {
                this.showAddDimensionPage(null);
                break;
            }
            case "bar_del": {
                this.deleteDimension();
                break;
            }
            case "bar_edit": {
                TreeView treeView = (TreeView)this.getControl(TREEVIEW);
                String nodeId = treeView.getTreeState().getFocusNodeId();
                this.showAddDimensionPage(nodeId);
                break;
            }
            case "bar_up": 
            case "bar_down": {
                this.searchResultMove(key);
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": 
            case "btn_modify": {
                this.openAddNewPage(key);
                break;
            }
            case "btn_del": {
                this.delete();
                break;
            }
            case "btn_refresh": {
                this.refreshAll();
                break;
            }
            case "updatevar": {
                this.updateVar();
                break;
            }
        }
    }

    private void updateVar() {
        Object retData = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"VariableMemberUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{null, null, null, null});
        if (retData instanceof UpgradeResult) {
            UpgradeResult result = (UpgradeResult)retData;
            if (result.isSuccess()) {
                this.writeLog("update", new MultiLangEnumBridge("\u53d8\u91cf\u5347\u7ea7", "AddVariableMemberPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d8\u91cf\u5347\u7ea7\u6210\u529f", "AddVariableMemberPlugin_9", "epm-eb-formplugin"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"VariableManagerList_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                String errorInfo = result.getErrorInfo();
                if ("hasUpdated".equals(errorInfo)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u518d\u6b21\u5347\u7ea7\u3002", (String)"VariableManagerList_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VariableManagerList_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    log.info("VariableUpdateError: " + errorInfo);
                }
            }
        }
    }

    private void delete() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"VariableManagerList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet varIds = Sets.newHashSetWithExpectedSize((int)rows.length);
        Long dimensionId = 0L;
        for (int row : rows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", row);
            if ("2".equals(entryRowEntity.getString("grouptype")) && ("@BaseY".equals(entryRowEntity.get("number")) || "@NextY01".equals(entryRowEntity.get("number")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u5458\u4e0d\u53ef\u5220\u9664\u3002", (String)"VariableManagerList_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)entryRowEntity.getLong("id"), (String)"eb_periodvariable");
            if (dimensionId == 0L) {
                dimensionId = dynamicObject.getDynamicObject("dimension").getLong("id");
            }
            varIds.add(entryRowEntity.getLong("id"));
        }
        this.addAllChild(varIds, varIds);
        QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)dimensionId, (Set)varIds, (MemberTypeEnum)MemberTypeEnum.VARIABLE));
        if (quote.isHasQuote()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u91cf\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VariableManagerList_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), quote.getMsg(), MessageTypes.Default);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u53d8\u91cf\uff1f", (String)"VariableManagerList_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("VariableDelete"));
    }

    private void addAllChild(Set<Long> varIds, Set<Long> parentIds) {
        Set varStringIds = parentIds.stream().map(x -> x.toString()).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter("parentid", "in", varStringIds).toArray());
        Set<Long> childIds = query.stream().map(var -> var.getLong("id")).collect(Collectors.toSet());
        if (childIds != null && !childIds.isEmpty()) {
            varIds.addAll(childIds);
            this.addAllChild(varIds, childIds);
        }
    }

    private Map<String, String> getReferVariable(String modelNumber, String dimensionNum, List<String> selectVarNums) {
        DynamicObjectCollection results;
        HashMap<String, String> referVars = new HashMap<String, String>(16);
        QFilter qf = new QFilter("modelnumber", "=", (Object)modelNumber);
        qf.and("dimensionnumber", "=", (Object)dimensionNum);
        if (selectVarNums != null) {
            qf.and("membernumber", "in", selectVarNums);
        }
        if (!(results = QueryServiceHelper.query((String)"eb_member_quote", (String)"id,quotenumber,resource,membernumber", (QFilter[])qf.toArray())).isEmpty()) {
            results.forEach(e -> {
                String referSource = MemberQuoteResourceEnum.getEnumByIndex((int)e.getInt("resource")).getName();
                String memberNum = e.getString("membernumber");
                referVars.put(memberNum, referSource);
            });
        }
        return referVars;
    }

    private void openAddNewPage(String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (BTN_MODIFY.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"VariableManagerList_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = this.getModel().getValue("id", rows[0]).toString();
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "eb_periodvariable");
            openParameter.put("pkId", id);
            formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setCustomParam("isModify", (Object)"1");
        }
        formShowParameter.setFormId("eb_periodvariable");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addAndModifyMember"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        TreeNode node = this.getCurrentNode();
        if (node == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u3002", (String)"VariableManagerList_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (node.getId().contains(MULTI_LEVEL_PREFIX) && BTN_ADD.equals(key)) {
            formShowParameter.setFormId("eb_multivariable");
            formShowParameter.setCustomParam("grouptype", (Object)"2");
        } else if (node.getId().contains(SINGLE_LEVEL_PREFIX)) {
            formShowParameter.setCustomParam("grouptype", (Object)"1");
        }
        Map dataMap = (Map)node.getData();
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dataMap.get("dimensionNumber")) && node.getId().equals(dataMap.get("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u5206\u7ec4\u3002", (String)"VariableManagerList_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimensionId = (String)dataMap.get("dimensionId");
        formShowParameter.setCustomParam("dimension", (Object)dimensionId);
        this.getView().showForm(formShowParameter);
    }

    private void deleteDimension() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ef4\u5ea6\u3002", (String)"VariableManagerList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (nodeId.contains(MULTI_LEVEL_PREFIX) || nodeId.contains(SINGLE_LEVEL_PREFIX)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5206\u7ec4\u4e0d\u53ef\u5220\u9664\u3002", (String)"VariableManagerList_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode node = this.getCurrentNode();
        if (node != null) {
            Map dataMap = (Map)node.getData();
            String dimensionId = (String)dataMap.get("dimensionId");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number", (QFilter[])new QFilter(MODEL, "=", (Object)this.getModelId()).and("dimension", "=", (Object)Long.valueOf(dimensionId)).toArray());
            Set varIds = query.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)Long.parseLong(dimensionId), varIds, (MemberTypeEnum)MemberTypeEnum.VARIABLE));
            if (quote.isHasQuote()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u91cf\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VariableManagerList_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), quote.getMsg(), MessageTypes.Default);
                return;
            }
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u7ef4\u5ea6\u540c\u65f6\u5c06\u4f1a\u5220\u9664\u8be5\u7ef4\u5ea6\u7684\u6240\u6709\u53d8\u91cf\uff0c\u662f\u5426\u5220\u9664\u6240\u9009\u62e9\u7684\u7ef4\u5ea6\uff1f", (String)"VariableManagerList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("dimensionDelete"));
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes != result) {
            return;
        }
        String callBackId = event.getCallBackId();
        HashMap<String, String> operationResult = new HashMap<String, String>(16);
        if ("dimensionDelete".equals(callBackId)) {
            TreeNode node = this.getCurrentNode();
            if (node != null) {
                String nodeId = node.getId();
                Map dataMap = (Map)node.getData();
                String dimensionId = (String)dataMap.get("dimensionId");
                if (this.batchDeleteVariableByDim(operationResult, null, dimensionId)) {
                    DeleteServiceHelper.delete((String)"eb_dimensionvariable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nodeId))});
                    this.getPageCache().put("currentNodeId", null);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"VariableManagerList_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    HashSet<Long> ids = new HashSet<Long>(16);
                    ids.add(Long.valueOf(nodeId));
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.VarDimension.getType(), ids});
                    VariableCacheService.getInstance().clearCache(this.getModelId());
                    this.refreshAll();
                } else {
                    String message = StringUtils.join((Object[])new String[]{ResManager.loadKDString((String)"\u5220\u9664\u53d8\u91cf\u7ba1\u7406\u7684\u7ef4\u5ea6\u5931\u8d25\uff1a\n", (String)"VariableManagerList_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)operationResult.get("errMessage")});
                    String title = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"VariableManagerList_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.showOperationResult(title, message);
                }
                this.writeLog("delete", new MultiLangEnumBridge("\u53d8\u91cf\u5206\u7ec4\u5220\u9664", "VariableManagerList_38", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d8\u91cf\u5206\u7ec4\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "ExamineListPlugin_56", "epm-eb-formplugin"), new String[]{node.getText()});
            }
        } else if ("VariableDelete".equals(callBackId)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            if (this.batchDeleteVariable(operationResult, rows, rows.length)) {
                this.writeLog("delete", new MultiLangEnumBridge("\u53d8\u91cf\u5220\u9664", "VariableManagerList_39", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d8\u91cf\u5220\u9664\u6210\u529f", "VariableManagerList_40", "epm-eb-formplugin"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"VariableManagerList_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                VariableCacheService.getInstance().clearCache(this.getModelId());
                this.refreshBillList();
            } else {
                this.showOperationResult((String)operationResult.get("title"), (String)operationResult.get("errMessage"));
            }
        }
    }

    private boolean batchDeleteVariableByDim(Map<String, String> operationResult, Object o, String dimensionId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number", (QFilter[])new QFilter(MODEL, "=", (Object)this.getModelId()).and("dimension", "=", (Object)Long.valueOf(dimensionId)).toArray());
        Set varIds = query.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)Long.parseLong(dimensionId), varIds, (MemberTypeEnum)MemberTypeEnum.VARIABLE));
        if (quote.isHasQuote()) {
            operationResult.put("title", ResManager.loadKDString((String)"\u53d8\u91cf\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VariableManagerList_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            operationResult.put("errMessage", quote.getMsg());
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", varIds);
        DeleteServiceHelper.delete((String)"eb_periodvariable", (QFilter[])new QFilter[]{qFilter});
        return true;
    }

    private boolean batchDeleteVariable(Map<String, String> operationResult, int[] rows, int rowSum) {
        List<Long> selectIds = this.getSelectVarIds(rows, rowSum);
        Set<String> selectIdString = selectIds.stream().map(x -> x.toString()).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number,dimension.id", (QFilter[])new QFilter("id", "in", selectIds).toArray());
        this.queryAllChild(query, selectIdString);
        Long dimensionid = 0L;
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            dimensionid = ((DynamicObject)query.get(0)).getLong("dimension.id");
        }
        Map<Long, String> numberMap = query.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("number")));
        Set<Long> varIds = numberMap.keySet();
        QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)dimensionid, varIds, (MemberTypeEnum)MemberTypeEnum.VARIABLE));
        if (quote.isHasQuote()) {
            operationResult.put("title", ResManager.loadKDString((String)"\u53d8\u91cf\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VariableManagerList_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            operationResult.put("errMessage", quote.getMsg());
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", varIds);
        DeleteServiceHelper.delete((String)"eb_periodvariable", (QFilter[])new QFilter[]{qFilter});
        return true;
    }

    private void queryAllChild(DynamicObjectCollection baseQuery, Set<String> selectIdString) {
        DynamicObjectCollection childQuery = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number", (QFilter[])new QFilter("parentid", "in", selectIdString).toArray());
        if (childQuery != null && !childQuery.isEmpty()) {
            baseQuery.addAll((Collection)childQuery);
            Set<String> childIds = childQuery.stream().map(x -> x.getString("id")).collect(Collectors.toSet());
            this.queryAllChild(baseQuery, childIds);
        }
    }

    private List<Long> getSelectVarIds(int[] rows, int rowSum) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (int i = 0; i < rowSum; ++i) {
            Object id = this.getModel().getValue("id", rows == null ? i : rows[i]);
            if (id == null) continue;
            ids.add(Long.valueOf(id.toString()));
        }
        return ids;
    }

    private Set<Long> getVariableIdByNumber(List<String> numberList, int[] rows, int rowSum) {
        HashSet<Long> varIdList = new HashSet<Long>(16);
        for (int i = 0; i < rowSum; ++i) {
            int row = rows == null ? i : rows[i];
            String number = this.getModel().getValue("number", row).toString();
            if (!numberList.contains(number)) continue;
            varIdList.add(Long.valueOf(this.getModel().getValue("id", row).toString()));
        }
        return varIdList;
    }

    private String getErrMessage(Map<String, String> numberMap) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> info : numberMap.entrySet()) {
            str.append(ResManager.loadResFormat((String)"%1\u5f15\u7528\u4e86\u6210\u5458%2\n", (String)"VariableManagerList_15", (String)"epm-eb-formplugin", (Object[])new Object[]{info.getValue(), info.getKey()}));
        }
        return str.toString();
    }

    private void showOperationResult(String title, String errMessage) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "OperationResult"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setCustomParam("errorMsg", (Object)errMessage);
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        this.getView().showForm(showParameter);
    }

    private void showAddDimensionPage(String nodeId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            HashMap<String, String> openParameter = new HashMap<String, String>();
            openParameter.put("formId", "eb_dimensionvariable");
            openParameter.put("pkId", nodeId);
            formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        }
        formShowParameter.setFormId("eb_dimensionvariable");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addAndModifyDimension"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        String seq = this.getPageCache().get("newSeq");
        formShowParameter.setCustomParam("dseq", SerializationUtils.fromJsonString((String)seq, Integer.class));
        formShowParameter.setCustomParam("dimensionIds", (Object)this.getPageCache().get("dimensionIds"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (MODELCLICK.equals(key)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.size() != 1) {
                return;
            }
            this.getModel().setValue(MODEL, returnData.get(0).getPrimaryKeyValue());
        } else if ("addAndModifyDimension".equals(key)) {
            this.refreshAll();
        } else {
            this.refreshBillList();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            this.getModel().setDataChanged(false);
            entryGrid.setPageIndex(1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            this.updateModelLabel();
            this.getPageCache().put("currentNodeId", null);
            this.refreshAll();
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)this.getModelId());
            TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
            List selectedNodes = treeView.getTreeState().getSelectedNodes();
            if (selectedNodes.isEmpty()) {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    private void refreshAll() {
        this.refreshTree();
    }

    private void refreshTree() {
        this.initDimensionTree();
    }

    private void initDimensionTree() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.deleteAllNodes();
        String selects = "id, number,dimension.name, dimension.id, dimension.number, dseq";
        DynamicObjectCollection dimensionCollection = QueryServiceHelper.query((String)"eb_dimensionvariable", (String)selects, (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())}, (String)"dseq");
        String rootNodeId = "0";
        TreeNode root = new TreeNode();
        root.setId(rootNodeId);
        root.setParentid(null);
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"VariableManagerList_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>(16);
        HashSet<String> dimensionSet = new HashSet<String>(16);
        data.put("id", rootNodeId);
        data.put("name", root.getText());
        data.put("level", "1");
        root.setData(data);
        if (dimensionCollection != null && dimensionCollection.size() != 0) {
            for (DynamicObject dimensionObj : dimensionCollection) {
                ArrayList<TreeNode> children = root.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>(16);
                    root.setChildren(children);
                }
                TreeNode relationNode = new TreeNode();
                relationNode.setParentid(rootNodeId);
                relationNode.setId(dimensionObj.getString("id"));
                relationNode.setText(dimensionObj.getString("dimension.name") + "(" + dimensionObj.getString("number") + ")");
                HashMap<String, String> data2 = new HashMap<String, String>(16);
                data2.put("id", dimensionObj.getString("id"));
                data2.put("name", dimensionObj.getString("dimension.name"));
                data2.put("level", "2");
                data2.put("dimensionId", dimensionObj.getString("dimension.id"));
                data2.put("dimensionNumber", dimensionObj.getString("dimension.number"));
                relationNode.setData(data2);
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionObj.getString("dimension.number"))) {
                    this.initMultiTree(relationNode);
                }
                children.add(relationNode);
                dimensionSet.add(dimensionObj.getString("dimension.id"));
            }
            this.getPageCache().put("newSeq", SerializationUtils.toJsonString((Object)(((DynamicObject)dimensionCollection.get(dimensionCollection.size() - 1)).getInt("dseq") + 1)));
        } else {
            this.getPageCache().put("newSeq", SerializationUtils.toJsonString((Object)1));
        }
        treeView.addNode(root);
        treeView.expand(rootNodeId);
        this.getPageCache().put(ROOT, ObjectSerialUtil.toByteSerialized((Object)root));
        this.getPageCache().put("dimensionIds", SerializationUtils.toJsonString(dimensionSet));
        String beforeNodeId = this.getPageCache().get("currentNodeId");
        if (StringUtils.isNotEmpty((CharSequence)beforeNodeId)) {
            TreeNode treeNode = root.getTreeNode(beforeNodeId, 2);
            treeView.focusNode(treeNode);
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId()));
        } else if (root.getChildren() != null && root.getChildren().size() > 0) {
            TreeNode node = (TreeNode)root.getChildren().get(0);
            treeView.focusNode(node);
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)node.getParentid(), (Object)node.getId()));
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void initMultiTree(TreeNode relationNode) {
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>(16);
        TreeNode childNode1 = new TreeNode();
        childNode1.setParentid(relationNode.getId());
        childNode1.setId(MULTI_LEVEL_PREFIX + relationNode.getId());
        childNode1.setText(ResManager.loadKDString((String)"\u5e74\u53d8\u91cf", (String)"VariableManagerList_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        childNode1.setType("2");
        childNode1.setData(relationNode.getData());
        TreeNode childNode2 = new TreeNode();
        childNode2.setParentid(relationNode.getId());
        childNode2.setId(SINGLE_LEVEL_PREFIX + relationNode.getId());
        childNode2.setText(ResManager.loadKDString((String)"\u671f\u95f4\u53d8\u91cf", (String)"VariableManagerList_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        childNode2.setType("1");
        childNode2.setData(relationNode.getData());
        childs.add(childNode1);
        childs.add(childNode2);
        relationNode.addChildren(childs);
    }

    private void refreshBillList() {
        this.getModel().deleteEntryData("entryentity");
        TreeNode node = this.getCurrentNode();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (node == null) {
            return;
        }
        Map data = (Map)node.getData();
        qFilter.and(new QFilter("dimension.id", "=", (Object)Long.valueOf(data.get("dimensionId").toString())));
        if (node.getId().contains(SINGLE_LEVEL_PREFIX)) {
            qFilter.and(new QFilter("grouptype", "!=", (Object)Character.valueOf('2')));
        } else if (node.getId().contains(MULTI_LEVEL_PREFIX)) {
            qFilter.and(new QFilter("grouptype", "=", (Object)Character.valueOf('2')).and("periodtype", "=", (Object)Character.valueOf('0')));
        } else if (this.isBudgetPeriod().booleanValue()) {
            qFilter.and(new QFilter("grouptype", "!=", (Object)Character.valueOf('2')).or(new QFilter("grouptype", "=", (Object)Character.valueOf('2')).and("periodtype", "=", (Object)Character.valueOf('0'))));
        }
        DynamicObjectCollection variableInfos = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id, name, number, offset, description,grouptype", (QFilter[])new QFilter[]{qFilter}, (String)"number asc");
        if (variableInfos == null || variableInfos.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", variableInfos.size());
        int row = 0;
        for (DynamicObject variableInfo : variableInfos) {
            this.getModel().setValue("id", (Object)variableInfo.getString("id"), row);
            this.getModel().setValue("name", (Object)variableInfo.getString("name"), row);
            this.getModel().setValue("number", (Object)variableInfo.getString("number"), row);
            this.getModel().setValue("offset", (Object)variableInfo.getString("offset"), row);
            this.getModel().setValue("description", (Object)variableInfo.getString("description"), row);
            this.getModel().setValue("grouptype", (Object)("2".equals(variableInfo.getString("grouptype")) ? "2" : "1"), row);
            ++row;
        }
        this.getView().updateView("entryentity");
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
    }

    private TreeNode getCurrentNode() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROOT));
        return root == null ? null : root.getTreeNode(treeView.getTreeState().getFocusNodeId(), 2);
    }

    private Boolean isBudgetPeriod() {
        TreeNode node = this.getCurrentNode();
        if (node == null) {
            return false;
        }
        Map data = (Map)node.getData();
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(data.get("dimensionNumber"))) {
            this.initMultiVariable((String)data.get("dimensionId"));
            return true;
        }
        return false;
    }

    public void search(SearchEnterEvent event) {
        TreeNode root;
        List child;
        Search search = (Search)event.getSource();
        String key = search.getKey();
        String textUpper = event.getText().trim();
        String text = textUpper.toLowerCase();
        ArrayList<TreeNode> searchResult = new ArrayList<TreeNode>(16);
        if (SEARCH.equals(key) && (child = (root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(ROOT))).getChildren()) != null) {
            for (TreeNode node : child) {
                String message = node.getText();
                if (!message.contains(text) && !message.contains(textUpper)) continue;
                searchResult.add(node);
            }
        }
        if (searchResult.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u76f8\u5173\u7684\u7ef4\u5ea6\u3002", (String)"VariableManagerList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getControl(TREEVIEW);
            treeView.focusNode((TreeNode)searchResult.get(0));
            this.getPageCache().put("searchResult", ObjectSerialUtil.toByteSerialized(searchResult));
            this.refreshBillList();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put("currentNodeId", nodeId);
        if (this.isBudgetPeriod().booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"offset"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"grouptype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"grouptype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"offset"});
        }
        this.refreshBillList();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        this.getModel().setDataChanged(false);
        entryGrid.setPageIndex(1);
    }

    private void initMultiVariable(String dimensionId) {
        DynamicObject dynamicObject;
        HashSet<DynamicObject> saves = new HashSet<DynamicObject>(19);
        if (!this.checkVariable(Long.valueOf(dimensionId), "@BaseY").booleanValue()) {
            dynamicObject = this.getVariableDynamicObject("@BaseY", (ILocaleString)ResManager.getLocaleString((String)"\u57fa\u51c6\u5e74", (String)"VariableManagerList_36", (String)"epm-eb-formplugin"), dimensionId, 0, 0);
            saves.add(dynamicObject);
            VariableUtils.setChildrens("@BaseY", (ILocaleString)ResManager.getLocaleString((String)"\u57fa\u51c6\u5e74", (String)"VariableManagerList_36", (String)"epm-eb-formplugin"), dimensionId, 0, saves, this.getModelId(), this.getUserId(), dynamicObject.getLong("id"));
        }
        if (!this.checkVariable(Long.valueOf(dimensionId), "@NextY01").booleanValue()) {
            dynamicObject = this.getVariableDynamicObject("@NextY01", (ILocaleString)ResManager.getLocaleString((String)"\u5411\u540e\u504f\u79fb1\u5e74", (String)"VariableManagerList_37", (String)"epm-eb-formplugin"), dimensionId, 1, 0);
            saves.add(dynamicObject);
            VariableUtils.setChildrens("@NextY01", (ILocaleString)ResManager.getLocaleString((String)"\u5411\u540e\u504f\u79fb1\u5e74", (String)"VariableManagerList_37", (String)"epm-eb-formplugin"), dimensionId, 0, saves, this.getModelId(), this.getUserId(), dynamicObject.getLong("id"));
        }
        if (CollectionUtils.isNotEmpty(saves)) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject getVariableDynamicObject(String number, ILocaleString name, String dimensionId, int offset, int periodType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_periodvariable");
        dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("dimension", (Object)dimensionId);
        dynamicObject.set("periodtype", (Object)periodType);
        dynamicObject.set("grouptype", (Object)2);
        dynamicObject.set("offset", (Object)offset);
        dynamicObject.set("createtime", (Object)new Date(System.currentTimeMillis()));
        dynamicObject.set("creater", (Object)this.getUserId());
        dynamicObject.set(MODEL, (Object)this.getModelId());
        dynamicObject.set("parentid", (Object)Character.valueOf('0'));
        return dynamicObject;
    }

    private Boolean checkVariable(Long dimensionId, String number) {
        return QueryServiceHelper.exists((String)"eb_periodvariable", (QFilter[])new QFilter(MODEL, "=", (Object)this.getModelId()).and("dimension", "=", (Object)dimensionId).and("number", "=", (Object)number).toArray());
    }

    private void searchResultMove(String key) {
        int index = -1;
        String result = this.getPageCache().get("searchResult");
        if (StringUtils.isEmpty((CharSequence)result)) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        String currentNodeId = treeView.getTreeState().getFocusNodeId();
        List resultNodes = (List)ObjectSerialUtil.deSerializedBytes((String)result);
        for (int i = 0; i < resultNodes.size(); ++i) {
            if (!((TreeNode)resultNodes.get(i)).getId().equals(currentNodeId)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            treeView.focusNode((TreeNode)resultNodes.get(0));
            this.refreshBillList();
            return;
        }
        if (BAR_UP.equals(key)) {
            if (index == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"VariableManagerList_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            treeView.focusNode((TreeNode)resultNodes.get(index - 1));
            this.refreshBillList();
        } else {
            if (index == resultNodes.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"VariableManagerList_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            treeView.focusNode((TreeNode)resultNodes.get(index + 1));
            this.refreshBillList();
        }
    }
}

