/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.saveop;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.epm.eb.common.utils.NumberCheckUtils;

public class NameCheckSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new NameCheckValidator());
    }

    private static class NameCheckValidator
    extends AbstractValidator {
        ExtendedDataEntity extendedDataEntity;

        private NameCheckValidator() {
        }

        public void validate() {
            this.extendedDataEntity = this.getDataEntities()[0];
            DynamicObject dataEntity = this.extendedDataEntity.getDataEntity();
            String number = dataEntity.getString("name");
            this.extendedDataEntity.setBillNo(ResManager.loadResFormat((String)"\u540d\u79f0 %s", (String)"DimensionMemberSaveValidator_11", (String)"epm-eb-cube", (Object[])new Object[]{number}));
            this.codingRuleCheck(number, true);
        }

        private boolean codingRuleCheck(String name, boolean inQueue) {
            if (!NumberCheckUtils.checkName((String)name)) {
                Object pkId = this.extendedDataEntity.getBillPkId();
                int dataIndex = this.extendedDataEntity.getDataEntityIndex();
                String title = this.getOperationName();
                String content = null;
                for (int i = 0; i < 4; ++i) {
                    int index = this.getQueueIndex(i, inQueue);
                    content = index == 0 ? ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5e94\u9075\u5b88\u4ee5\u4e0b\u89c4\u5219\uff1a", (String)"DimensionMemberSaveValidator_19", (String)"epm-eb-cube", (Object[])new Object[0]) : (index == 1 ? ResManager.loadKDString((String)"1\u3001\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u5b57\u7b26\uff1b", (String)"DimensionMemberSaveValidator_2", (String)"epm-eb-cube", (Object[])new Object[0]) : (index == 2 ? ResManager.loadKDString((String)"2\u3001\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u6c49\u5b57\u3001\u51cf\u53f7\u3001\u5c0f\u62ec\u53f7\u7b49\u7ec4\u6210\uff0c\u5e76\u4e14\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u6c49\u5b57\u5f00\u5934\uff1b", (String)"DimensionMemberSaveValidator_20", (String)"epm-eb-cube", (Object[])new Object[0]) : ResManager.loadKDString((String)"3\u3001\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u7531\u5176\u5b83\u5b57\u7b26\u9694\u5f00\u3002", (String)"DimensionMemberSaveValidator_18", (String)"epm-eb-cube", (Object[])new Object[0])));
                    ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, i, "errorcode_001", title, content, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)info);
                }
                this.getFalseDataEntities().add(this.extendedDataEntity);
                return true;
            }
            return false;
        }

        private int getQueueIndex(int index, boolean inQueue) {
            int retIndex = index;
            if (!inQueue) {
                retIndex = 3 - retIndex;
            }
            return retIndex;
        }
    }
}

