/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class EbFieldSelectFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log log = LogFactory.getLog(EbFieldSelectFormPlugin.class);
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String BTN_SEARCH_NEXT = "btnnext";
    private static final String CACHE_SEARCH_INDEX = "CACHE_SEARCH_INDEX";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SEARCH_NEXT});
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.addCellClickListener(new CellClickListener(){

            public void cellDoubleClick(CellClickEvent evt) {
                int row = evt.getRow();
                EbFieldSelectFormPlugin.this.returnDataToParent(row);
            }

            public void cellClick(CellClickEvent evt) {
                int row = evt.getRow();
                if (row >= 0) {
                    EbFieldSelectFormPlugin.this.getPageCache().put(EbFieldSelectFormPlugin.CACHE_SEARCH_INDEX, String.valueOf(row));
                } else {
                    EbFieldSelectFormPlugin.this.getPageCache().remove(EbFieldSelectFormPlugin.CACHE_SEARCH_INDEX);
                }
            }
        });
        Search search = (Search)this.getControl("search");
        if (search != null) {
            search.addEnterListener(this::search);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initTreeEntiry();
    }

    private void initTreeEntiry() {
        String billnumber = (String)this.getView().getFormShowParameter().getCustomParam("billNumber");
        String billName = (String)this.getView().getFormShowParameter().getCustomParam("billName");
        try {
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billnumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
            MainEntity rootEntity = entityMeta.getRootEntity();
            List items = rootEntity.getItems();
            int newEntryRow = this.getModel().createNewEntryRow(TREEENTRYENTITY);
            DynamicObject rootDy = this.getModel().getEntryRowEntity(TREEENTRYENTITY, newEntryRow);
            rootDy.set("number", (Object)billnumber);
            rootDy.set("name", (Object)billName);
            rootDy.set("fullnumber", (Object)billnumber);
            rootDy.set("fullname", (Object)billName);
            this.initTreeEntryentity(items, rootDy, "", "");
            this.getView().updateView(TREEENTRYENTITY);
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            treeEntryGrid.setCollapse(false);
            treeEntryGrid.setDroppable(false);
        }
        catch (Exception ex) {
            log.warn("error-entity-metas:", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u5355\u636e\u5b57\u6bb5\u201d\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbFieldSelectFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void initTreeEntryentity(List<EntityItem<?>> properties, DynamicObject parentDy, String parentNum, String parentName) {
        for (EntityItem<?> property : properties) {
            String number = property.getKey();
            LocaleString displayName = property.getName();
            if (number == null || displayName == null) continue;
            String name = LanguageUtils.getLocaleValue((ILocaleString)displayName);
            String fullNum = this.getFullName(number, parentNum);
            String fullName = this.getFullName(name, parentName);
            int newEntryRow = this.getModel().createNewEntryRow(TREEENTRYENTITY);
            DynamicObject child = this.getModel().getEntryRowEntity(TREEENTRYENTITY, newEntryRow);
            child.set("pid", (Object)parentDy.getString("id"));
            child.set("number", (Object)number);
            child.set("name", (Object)name);
            child.set("fullnumber", (Object)fullNum);
            child.set("fullname", (Object)fullName);
            if (!(property instanceof EntryEntity)) continue;
            EntryEntity property1 = (EntryEntity)property;
            List items = property1.getItems();
            this.initTreeEntryentity(items, child, fullNum, fullName);
        }
    }

    private String getFullName(String curText, String parent) {
        String fullText = "";
        fullText = StringUtils.isEmpty((String)parent) ? curText : String.format("%s.%s", parent, curText);
        return fullText;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Donothing) {
            int index = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
            this.returnDataToParent(index);
        }
    }

    private void returnDataToParent(int index) {
        if (index == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"EbFieldSelectFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (index == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"EbFieldSelectFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, index);
        this.getView().returnDataToParent((Object)entryRowEntity);
        this.getView().close();
    }

    public void search(SearchEnterEvent event) {
        this.search(event.getText());
    }

    private void search(String searchText) {
        if (StringUtils.isEmpty((String)searchText)) {
            return;
        }
        int index = 0;
        boolean hasSearch = false;
        String cacheIndex = this.getPageCache().get(CACHE_SEARCH_INDEX);
        if (StringUtils.isNotEmpty((String)cacheIndex)) {
            index = Integer.parseInt(cacheIndex) + 1;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(TREEENTRYENTITY);
        int in = entries.size();
        for (int i = index; i < in; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            if ((!StringUtils.isNotEmpty((String)entry.getString("number")) || entry.getString("number").indexOf(searchText) < 0) && (!StringUtils.isNotEmpty((String)entry.getString("name")) || entry.getString("name").indexOf(searchText) < 0)) continue;
            this.getPageCache().put(CACHE_SEARCH_INDEX, String.valueOf(i));
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            treeEntryGrid.selectRows(i);
            hasSearch = true;
            break;
        }
        if (!hasSearch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            this.getPageCache().remove(CACHE_SEARCH_INDEX);
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                this.click_next(evt);
            }
        }
    }

    private void click_next(EventObject evt) {
        Search search = (Search)this.getControl("search");
        if (search != null) {
            this.search(search.getSearchKey());
        }
    }
}

