/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserSelectServiceHelperNew;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class EbIntegrationSchemeListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String ctl_schemecatalog = "schemecatalog";
    private static final String ctl_billlistap = "billlistap";
    private static final String ctl_model = "model";
    private static final String btn_addgroup = "btn_addgroup";
    private static final String btn_editgroup = "btn_editgroup";
    private static final String btn_delgroup = "btn_delgroup";
    private static final String ctl_checkbox_tree = "treecheckbox";
    private static final String openType_new = "new";
    private static final String openType_edit = "edit";
    private static final String schemeGroupForm = "eb_schemecatalog";
    private static final String schemeEntityForm = "eb_schemeentity";
    private static final String focusNodeId = "focusNodeId";
    private static final String groupRootNum = "group_root";
    private static final String CachegroupRootId = "headNodeId";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId(schemeEntityForm);
        fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5217\u8868", (String)"EbIntegrationSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_addgroup, btn_editgroup, btn_delgroup});
        TreeView treeView = (TreeView)this.getControl(ctl_schemecatalog);
        final BillList billList = (BillList)this.getControl(ctl_billlistap);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(evt -> this.refreshBillList());
        BasedataEdit modelEdit = (BasedataEdit)this.getControl(ctl_model);
        modelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                EbIntegrationSchemeListPlugin.this.getPageCache().put(EbIntegrationSchemeListPlugin.focusNodeId, evt.getNodeId().toString());
                billList.clearSelection();
                EbIntegrationSchemeListPlugin.this.refreshBillList();
            }
        });
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    private QFilter getFilter() {
        String nodeid = this.getPageCache().get(focusNodeId);
        if (nodeid == null) {
            return new QFilter("1", "=", (Object)0);
        }
        boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(ctl_checkbox_tree).toString());
        QFilter qFilter1 = new QFilter(ctl_schemecatalog, "=", (Object)IDUtils.toLong((Object)nodeid));
        QFilter qFilter2 = null;
        if (isallchild) {
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            ArrayList<String> list = new ArrayList<String>(16);
            this.queryAllChildNodeList(nodeid, treeList, list);
            if (list.size() > 0) {
                qFilter2 = new QFilter(ctl_schemecatalog, "in", (Object)IDUtils.toLongs(list));
            }
        }
        return qFilter2 == null ? qFilter1 : qFilter1.or(qFilter2);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String selecteRowId;
        super.billListHyperLinkClick(args);
        ListSelectedRow row = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        if (row != null && (selecteRowId = String.valueOf(row.getPrimaryKeyValue())) != null) {
            this.showSchemeEntityForm(selecteRowId);
        }
        args.setCancel(true);
    }

    private List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)ctl_model, (boolean)false);
        Set modelListByUser = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView()));
        if (IDUtils.isNotNull((Long)modelId)) {
            if (!modelListByUser.contains(modelId)) {
                DynamicObjectCollection dynamicObjects = UserSelectServiceHelperNew.queryUserSelectByTask((IFormView)this.getView());
                modelId = dynamicObjects.size() == 1 ? Long.valueOf(((DynamicObject)dynamicObjects.get(0)).getLong(ctl_model)) : UserSelectServiceHelperNew.strMoedlChcea((Set)modelListByUser);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbIntegrationSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(ctl_model, (Object)modelId);
        this.modelChange(modelId);
    }

    private void modelChange(Long modelid) {
        this.getPageCache().put("KEY_MODEL_ID", modelid.toString());
        this.refreshTree();
        this.refreshBillList();
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode schemecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        Long modelID = this.getModelId();
        if (modelID.equals(0L)) {
            return;
        }
        String entityName = schemeGroupForm;
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter(ctl_model, "=", (Object)modelID);
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "id";
        Long rootid = 0L;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(16);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                rootid = task.getLong("id");
                this.getPageCache().put(focusNodeId, rootid.toString());
                this.getPageCache().put(CachegroupRootId, rootid.toString());
            }
        } else {
            rootid = GlobalIdUtil.genGlobalLongId();
            EbIntegrationSchemeListPlugin.setDefaultRootNode(modelID, rootid);
            this.getPageCache().put(focusNodeId, rootid.toString());
            this.getPageCache().put(CachegroupRootId, rootid.toString());
        }
        schemecatalog.setId(rootid.toString());
        schemecatalog.setParentid("");
        schemecatalog.setText(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"EbIntegrationSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        EpmTreeUtils.setEntryNode((TreeNode)schemecatalog, treeList, (String)rootid.toString());
        EpmTreeUtils.spreadAllNode((TreeNode)schemecatalog);
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.deleteAllNodes();
        tree.addNode(schemecatalog);
        tree.focusNode(schemecatalog);
    }

    private static void setDefaultRootNode(Long modelId, Long rootid) {
        DynamicObject catalogTree = BusinessDataServiceHelper.newDynamicObject((String)schemeGroupForm);
        catalogTree.set("id", (Object)rootid);
        catalogTree.set("number", (Object)groupRootNum);
        catalogTree.set(ctl_model, (Object)modelId);
        catalogTree.set("name", (Object)new LocaleString(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"EbIntegrationSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        catalogTree.set("parent", (Object)0);
        catalogTree.set("longnumber", (Object)groupRootNum);
        catalogTree.set("masterid", (Object)rootid);
        catalogTree.set("modifier", (Object)UserUtils.getUserId());
        catalogTree.set("modifytime", (Object)TimeServiceHelper.now());
        BusinessDataWriter.save((IDataEntityType)catalogTree.getDynamicObjectType(), (Object[])new Object[]{catalogTree});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)ctl_model);
                if (modelId == null) {
                    this.getModel().setValue(ctl_model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChange(modelId);
                break;
            }
            case "treecheckbox": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addnew": {
                this.showSchemeEntityForm(null);
                break;
            }
            case "btn_delete": {
                break;
            }
            case "btn_dimmapping": {
                break;
            }
            case "btn_sync": {
                this.showSyncDataForm();
                break;
            }
        }
    }

    private void showSyncDataForm() {
        FormShowParameter showP = new FormShowParameter();
        List<String> rowIds = this.getSelectedSchemeRows();
        if (rowIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"EbIntegrationSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rowIds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u53ef\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u540c\u6b65\u3002", (String)"EbIntegrationSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        this.checkModel(modelId);
        showP.setFormId("eb_schemesycn");
        showP.setCustomParam(ctl_model, (Object)String.valueOf(modelId));
        showP.setCustomParam("schemeId", (Object)rowIds.get(0));
        showP.getOpenStyle().setShowType(ShowType.Modal);
        showP.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "schemesycn"));
        this.getView().showForm(showP);
    }

    public void click(EventObject evt) {
        String actionKey;
        super.click(evt);
        switch (actionKey = ((Control)evt.getSource()).getKey()) {
            case "btn_addgroup": {
                this.showSchemeGroupForm(openType_new);
                break;
            }
            case "btn_editgroup": {
                this.showSchemeGroupForm(openType_edit);
                break;
            }
            case "btn_delgroup": {
                this.deleteSchemeGroups();
                break;
            }
        }
    }

    public void deleteSchemeGroups() {
        String nodeId = this.getCurrentLeftTreeNodeId();
        String rootId = this.getPageCache().get(CachegroupRootId);
        if (rootId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"EbIntegrationSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rootId.equals(nodeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"EbIntegrationSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u65b9\u6848\u5206\u7c7b\u5417\uff1f", (String)"EbIntegrationSchemeListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteGroups", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionKey = messageBoxClosedEvent.getCallBackId();
        if ("deleteGroups".equals(actionKey) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.confirmDelGroup();
        }
    }

    private void confirmDelGroup() {
        String nodeId = this.getCurrentLeftTreeNodeId();
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
        ArrayList<String> list = new ArrayList<String>(16);
        this.queryAllChildNodeList(nodeId, treeList, list);
        list.add(nodeId);
        boolean isExisted = QueryServiceHelper.exists((String)schemeEntityForm, (QFilter[])new QFilter[]{new QFilter(ctl_schemecatalog, "in", (Object)IDUtils.toLongs(list))});
        if (isExisted) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u5f55\u4e0b\u5b58\u5728\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EbIntegrationSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            try (TXHandle th = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)schemeGroupForm, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)IDUtils.toLongs(list))});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"EbIntegrationSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "EbIntegrationSchemeListPlugin_9", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b9\u6848\u76ee\u5f55\u5220\u9664\u6210\u529f\u3002", "EbIntegrationSchemeListPlugin_10", "epm-eb-formplugin"));
                    this.initTree();
                    this.refreshBillList();
                }
                catch (Exception e) {
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "EbIntegrationSchemeListPlugin_9", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b9\u6848\u76ee\u5f55\u5220\u9664\u5931\u8d25\u3002", "EbIntegrationSchemeListPlugin_11", "epm-eb-formplugin"));
                    th.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    public List<String> getSelectedSchemeRows() {
        ArrayList<String> rowIds = new ArrayList<String>(16);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.getSelectedRows().forEach(row -> rowIds.add(String.valueOf(row.getPrimaryKeyValue())));
        return rowIds;
    }

    public void showSchemeEntityForm(String schemeId) {
        CloseCallBack closeCallBack = null;
        String groupId = this.getCurrentLeftTreeNodeId();
        Long modelId = this.getModelId();
        this.checkModel(modelId);
        if (groupId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u5206\u7c7b\u3002", (String)"EbIntegrationSchemeListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> paramData = new HashMap<String, Object>(16);
        paramData.put(ctl_model, String.valueOf(modelId));
        paramData.put("catalog", groupId);
        if (schemeId == null) {
            closeCallBack = new CloseCallBack((IFormPlugin)this, "newSchemeEntity");
            this.showForm(schemeEntityForm, paramData, closeCallBack, ShowType.MainNewTabPage, 0L, ResManager.loadKDString((String)"\u9884\u7b97\u96c6\u6210\u65b9\u6848\u65b0\u589e", (String)"EbIntegrationSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            closeCallBack = new CloseCallBack((IFormPlugin)this, "editSchemeEntity");
            this.showForm(schemeEntityForm, paramData, closeCallBack, ShowType.MainNewTabPage, Long.valueOf(schemeId), ResManager.loadKDString((String)"\u9884\u7b97\u96c6\u6210\u65b9\u6848\u4fee\u6539", (String)"EbIntegrationSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void showSchemeGroupForm(String openType) {
        CloseCallBack closeCallBack = null;
        HashMap<String, Object> customData = new HashMap<String, Object>(16);
        Long modelId = this.getModelId();
        this.checkModel(modelId);
        customData.put(ctl_model, String.valueOf(modelId));
        String nodeId = this.getCurrentLeftTreeNodeId();
        if (nodeId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u76ee\u5f55\u8282\u70b9\u3002", (String)"EbIntegrationSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (openType.equals(openType_new)) {
            customData.put("parent", nodeId);
            closeCallBack = new CloseCallBack((IFormPlugin)this, "newSchemeGroup");
            this.showForm(schemeGroupForm, customData, closeCallBack, ShowType.Modal, 0L, null);
        } else {
            String rootId = this.getPageCache().get(CachegroupRootId);
            if (rootId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"EbIntegrationSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (rootId.equals(nodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u66f4\u6539\u6839\u8282\u70b9\u4fe1\u606f\u3002", (String)"EbIntegrationSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            closeCallBack = new CloseCallBack((IFormPlugin)this, "editSchemeGroup");
            this.showForm(schemeGroupForm, customData, closeCallBack, ShowType.Modal, Long.valueOf(nodeId), null);
        }
    }

    private void checkModel(Long modelId) {
        if (modelId == null || modelId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbIntegrationSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = null;
        DynamicObject model = (DynamicObject)this.getModel().getValue(ctl_model);
        modelId = model != null ? Long.valueOf(model.getLong("id")) : Long.valueOf(0L);
        return modelId;
    }

    public String getCurrentLeftTreeNodeId() {
        String nodeId = this.getPageCache().get(focusNodeId);
        return nodeId;
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, Long id, String caption) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        if (caption != null) {
            param.setCaption(caption);
        }
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String backMsg;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("newSchemeEntity") || actionId.equals("editSchemeEntity")) {
            this.refreshBillList();
        } else if (actionId.equals("newSchemeGroup") || actionId.equals("editSchemeGroup")) {
            this.initTree();
            this.refreshBillList();
        } else if (actionId.equals("schemesycn") && (backMsg = (String)closedCallBackEvent.getReturnData()) != null) {
            this.getView().showSuccessNotification(backMsg, Integer.valueOf(3000));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if (propName.equals(ctl_model)) {
            PluginUtils.setModelFilter(arg0, this.getView());
        }
    }
}

