/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dimension.EbDimensionManagerList;

public class EbSchemeEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
CellClickListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit targetTableEdit = (BasedataEdit)this.getControl("targettable");
        targetTableEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimEdit = (BasedataEdit)this.getControl("dim");
        dimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (map == null || !map.containsKey("catalog")) {
                return;
            }
            String catalogId = (String)map.get("catalog");
            this.getModel().setValue("schemecatalog", (Object)catalogId);
        }
    }

    public DynamicInfoCollection getTargetTableFieldInfos(DynamicObject newTable) {
        DynamicInfoCollection infos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u8868\u7684\u5c5e\u6027\u5b57\u6bb5\u4fe1\u606f", (String)"EbSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"number", "name"});
        if (newTable != null) {
            DynamicObjectCollection props = newTable.getDynamicObjectCollection("prop_entryentity");
            for (DynamicObject prop : props) {
                String name = prop.getString("prop_label");
                String number = prop.getString("prop_name");
                infos.addInfo(new Object[]{number, name});
            }
        }
        return infos;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.updateTargetTableInfo(this.getModel().getDataEntity().getDynamicObject("targettable"), false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String checkInfo;
        super.beforeDoOperation(args);
        String opearate = ((AbstractOperate)args.getSource()).getOperateKey();
        if (opearate.equals("save") && (checkInfo = this.checkBeforeSave()) != null) {
            this.getView().showTipNotification(checkInfo);
            args.setCancel(true);
        }
    }

    public String checkBeforeSave() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            String number = dynamicObject.getString("number");
            StringBuilder errorInfo = new StringBuilder();
            String regEx = "[A-Za-z0-9_]+";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            if (!matcher.matches()) {
                errorInfo.append(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u3002", (String)"EbSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return errorInfo.toString();
            }
            QFilter qcfnumber = new QFilter("number", "=", (Object)number);
            DynamicObject schemecatalog = (DynamicObject)dynamicObject.get("schemecatalog");
            String modelId = schemecatalog.getString("model.id");
            QFilter filtermodel = new QFilter("schemecatalog.model", "=", (Object)IDUtils.toLong((Object)modelId));
            if (QueryServiceHelper.exists((String)"eb_schemeentity", (QFilter[])new QFilter[]{qcfnumber, filtermodel})) {
                errorInfo.append(ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\u3002", (String)"EbSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return errorInfo.toString();
            }
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newData = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "dim": {
                this.updateDimInfo((DynamicObject)newData, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "iscschemetrigger": {
                this.changeTargetTable((DynamicObject)newData);
                break;
            }
            case "targettable": {
                this.updateTargetTableInfo((DynamicObject)newData, true);
                break;
            }
            case "targetfieldname": {
                this.uddateTargetFieldInfo((String)newData, e.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    public void changeTargetTable(DynamicObject iscSchemeTrigger) {
        if (iscSchemeTrigger == null) {
            this.getModel().setValue("targettable", null);
            return;
        }
        String dataCopyId = iscSchemeTrigger.getString("data_copy_id");
        DynamicObject dataCopy = QueryServiceHelper.queryOne((String)"isc_data_copy", (String)"source_schema", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)dataCopyId))});
        if (dataCopy != null) {
            String targetEntryId = dataCopy.getString("source_schema");
            this.getModel().setValue("targettable", (Object)targetEntryId);
        }
    }

    private void updateDimInfo(DynamicObject newData, int currntRowIndex) {
        IDataModel dataModel = this.getModel();
        String dimNumber = null;
        if (newData != null) {
            dimNumber = newData.getString("number");
        }
        dataModel.setValue("dimnumber", (Object)dimNumber, currntRowIndex);
    }

    private void uddateTargetFieldInfo(String newData, int currntRowIndex) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("targetfieldnum", (Object)newData, currntRowIndex);
    }

    private void updateTargetTableInfo(DynamicObject newData, boolean clearOldData) {
        IDataModel dataModel = this.getModel();
        ComboEdit comboEdit = (ComboEdit)this.getControl("targetfieldname");
        DynamicInfoCollection fieldInfos = this.getTargetTableFieldInfos(newData);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(fieldInfos.getValues().size());
        for (DynamicInfoCollection.InfoObject field : fieldInfos.getValues()) {
            String name = (String)field.getValueByPropName("name");
            String number = (String)field.getValueByPropName("number");
            ComboItem item = new ComboItem(new LocaleString(name), number);
            itemList.add(item);
        }
        comboEdit.setComboItems(itemList);
        this.getView().updateView("entryentity.targetfieldname");
        int rowCounts = dataModel.getEntryRowCount("entryentity");
        if (clearOldData) {
            for (int i = 0; i < rowCounts; ++i) {
                dataModel.setValue("targetfieldname", null, i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name = arg0.getProperty().getName();
        if (!name.equals("targettable") && name.equals("dim")) {
            ListShowParameter showP = (ListShowParameter)arg0.getFormShowParameter();
            List qs = showP.getListFilterParameter().getQFilters();
            qs.add(this.getDimQFilter());
        }
    }

    public QFilter getDimQFilter() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("number", "not in", EbDimensionManagerList.hideEbDims);
        return filter;
    }

    private Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    public QFilter getTargetTalbeQFilter() {
        return null;
    }

    public void cellClick(CellClickEvent arg0) {
        String fieldName = arg0.getFieldKey();
        if (fieldName.equals("targetfieldname") && this.getValOnModel("targettable") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u7cfb\u7edf\u8868\u3002", (String)"EbSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getValOnModel(String propName) {
        Object val = this.getModel().getValue(propName);
        return val;
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

