/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.MultiBaseEditElement;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.sql.MDResultSet;
import kd.epm.eb.ebBusiness.sql.SQLBuilder;
import org.apache.commons.lang.StringUtils;

public class EbSchemeSyncPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
DynamicPage {
    protected static Log log = LogFactory.getLog(EbSchemeSyncPlugin.class);
    private static String DIM_NUMBERS_CACHE = "dimNumberForms";

    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        DynamicInfoCollection allDimension = this.getAllDimsByModel();
        String dimNum = null;
        for (DynamicInfoCollection.InfoObject dimInfo : allDimension.getValues()) {
            dimNum = (String)dimInfo.getValueByPropName("number");
            BasedataEdit dataEdit = (BasedataEdit)this.getControl(dimNum);
            if (dataEdit == null) continue;
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createDimList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private void createDimList() {
        DynamicInfoCollection dimInfos = this.getAllDimsByModel();
        Page page = new Page();
        Area area = new Area("pagepanel");
        for (DynamicInfoCollection.InfoObject info : dimInfos.getValues()) {
            String number = (String)info.getValueByPropName("number");
            String name = (String)info.getValueByPropName("name");
            String id = (String)info.getValueByPropName("id");
            String memberForm = (String)info.getValueByPropName("membermodel");
            MultiBaseEditElement f7 = new MultiBaseEditElement(name, number.toLowerCase(), memberForm);
            f7.addUserObject("id", (Object)id);
            f7.setLabelDirection("v");
            area.addElement((Element)f7);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
        QFilter qfId = new QFilter("id", "=", (Object)IDUtils.toLong((Object)schemeId));
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"eb_schemeentity", (String)"id,dimcache", (QFilter[])new QFilter[]{qfId});
        String dimCache = scheme.getString("dimcache");
        if (StringUtils.isNotBlank((String)dimCache)) {
            String[] singleDimInfos;
            Long modelId = this.getModelId();
            if (modelId == null || modelId.equals(0L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u201d\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (String singleDimInfo : singleDimInfos = dimCache.split(";")) {
                String number = singleDimInfo.split(":")[0];
                String idStr = singleDimInfo.split(":")[1];
                if (SysDimensionEnum.Scenario.getNumber().equals(number) || SysDimensionEnum.Process.getNumber().equals(number) || SysDimensionEnum.DataType.getNumber().equals(number)) continue;
                this.getModel().setValue(number, (Object)this.getMemberIds(idStr));
            }
        }
    }

    private Long[] getMemberIds(String idStr) {
        String[] memberIds = idStr.split(",");
        return (Long[])Arrays.stream(memberIds).map(id -> IDUtils.toLong((Object)id)).toArray(Long[]::new);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
            BasedataEdit nus = (BasedataEdit)c.getControl(this.getView());
            nus.setQFilter(new QFilter("dimension", "=", (Object)IDUtils.toLong((Object)c.getUserObject("id"))));
            e.setControl((Control)nus);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private DynamicInfoCollection getAllDimsByModel() {
        String cacheStr = this.getPageCache().get("allDimensionInfo");
        if (cacheStr != null) {
            return (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        }
        Long modelId = this.getModelId();
        if (modelId == null || modelId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u201d\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id,name,number,membermodel", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, (String)"dseq");
        DynamicInfoCollection dimInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5217\u8868\u4fe1\u606f", (String)"EbSchemeSyncPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "name", "membermodel"});
        for (DynamicObject dim : dims) {
            String dimNumber = dim.getString("number");
            if (SysDimensionEnum.Scenario.getNumber().equals(dimNumber) || SysDimensionEnum.Process.getNumber().equals(dimNumber) || SysDimensionEnum.DataType.getNumber().equals(dimNumber)) continue;
            Object[] vals = new Object[dimInfos.getProps().size()];
            int nums = 0;
            for (String prop : dimInfos.getProps()) {
                String val = dim.getString(prop);
                vals[nums++] = val;
            }
            dimInfos.addInfo(vals);
        }
        this.getPageCache().put("allDimensionInfo", SerializationUtils.serializeToBase64((Object)dimInfos));
        return dimInfos;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String actionKey = evt.getItemKey();
        if (actionKey.equals("btn_sync")) {
            this.beginSycnData();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5f00\u59cb\u540c\u6b65", "AbstractMultiReportPlugin_135", "epm-eb-budget");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u96c6\u6210\u65b9\u6848\u540c\u6b65\u6210\u529f", "AbstractMultiReportPlugin_136", "epm-eb-budget");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"syn", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
        }
    }

    private DynamicObject getEbSchemeInfo() {
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_schemeentity");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u96c6\u6210\u65b9\u6848\u4fe1\u606f\u51fa\u9519\u3002", (String)"EbSchemeSyncPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return scheme;
    }

    private void beginSycnData() {
        DynamicObject ebScheme = this.getEbSchemeInfo();
        DynamicInfoCollection dimMapInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u9884\u7b97\u96c6\u6210\u65b9\u6848\u5339\u914d\u4fe1\u606f-\u7ef4\u5ea6\u7f16\u7801\u3001\u7ef4\u5ea6\u5c5e\u6027\u3001\u76ee\u6807\u5b57\u6bb5\u7f16\u7801\u3001\u662f\u5426\u4e3b\u952e", (String)"EbSchemeSyncPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"dimNumber", "dimProp", "targetFieldNum", "isPk"});
        DynamicInfoCollection selectedDims = this.getSelectedDimInfos();
        String modelCubeNum = this.getModelCubeNum();
        Long modelId = this.getModelId();
        SQLBuilder sql = new SQLBuilder(modelCubeNum);
        for (DynamicInfoCollection.InfoObject selectDim : selectedDims.getValues()) {
            sql.addFilter((String)selectDim.getValueByPropName("dimNum"), ((List)selectDim.getValueByPropName("memberNums")).toArray(new String[1]));
        }
        if (sql.getFilters().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"EbSchemeSyncPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject dimMap : ebScheme.getDynamicObjectCollection("entryentity")) {
            String dimNumber = dimMap.getString("dimnumber");
            String dimProp = dimMap.getString("dimprop");
            String targetFieldNum = dimMap.getString("targetfieldnum");
            boolean isPk = dimMap.getBoolean("ispk");
            dimMapInfos.addInfo(new Object[]{dimNumber, dimProp, targetFieldNum, isPk});
        }
        for (Object dimNum : new HashSet(dimMapInfos.getAllValOfOneProp("dimNumber"))) {
            sql.addSelectField(new String[]{String.valueOf(dimNum)});
        }
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        this.writeDataLog("olap_query_prop", sql.toString());
        MDResultSet datas = OlapServiceHelper.queryData((SQLBuilder)sql);
        ArrayList syncData = new ArrayList(16);
        DynamicInfoCollection dimMemberGroups = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5206\u7ec4\u4fe1\u606f-\u7ef4\u5ea6\u7f16\u7801\u3001\u6210\u5458\u5217\u8868\u3001\u7ef4\u5ea6\u5c5e\u6027\u5217\u8868\u3001\u6210\u5458\u5177\u4f53\u4fe1\u606f", (String)"EbSchemeSyncPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"dimNum", "memberSet", "dimPropSet", "memberObjectList"});
        DynamicInfoCollection.InfoObject groupInfo = null;
        Set<String> memberSet = null;
        Set<Object> dimPropSet = null;
        while (datas.next()) {
            HashMap<String, String> rowData = new HashMap<String, String>(16);
            kd.epm.eb.ebBusiness.sql.Row row = datas.getRow();
            String val = null;
            for (DynamicInfoCollection.InfoObject dimMap : dimMapInfos.getValues()) {
                String targetFieldNum = (String)dimMap.getValueByPropName("targetFieldNum");
                String dimProp = (String)dimMap.getValueByPropName("dimProp");
                String dimNumber = (String)dimMap.getValueByPropName("dimNumber");
                val = row.getString(dimNumber);
                rowData.put(targetFieldNum, dimNumber + "!!!" + val + "!!!" + (String)dimProp);
                groupInfo = dimMemberGroups.getInfoByOneProp("dimNum", (Object)dimNumber);
                if (groupInfo == null) {
                    memberSet = new HashSet(16);
                    dimPropSet = new HashSet(16);
                    memberSet.add(val);
                    dimPropSet.add("number");
                    dimPropSet.add(dimProp);
                    dimMemberGroups.addInfo(new Object[]{dimNumber, memberSet, dimPropSet, null});
                    continue;
                }
                memberSet = (Set)groupInfo.getValueByPropName("memberSet");
                dimPropSet = (Set)groupInfo.getValueByPropName("dimPropSet");
                memberSet.add(val);
                dimPropSet.add(dimProp);
            }
            syncData.add(rowData);
        }
        log.info("olap_query_datasize : " + syncData.size());
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        QFilter qMemberNum = null;
        QFilter qDimNum = null;
        QFilter qType = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        Map<String, HashMap<String, Object>> memberValues = null;
        Map membVals = null;
        for (DynamicInfoCollection.InfoObject group : dimMemberGroups.getValues()) {
            String dimNum = (String)group.getValueByPropName("dimNum");
            Set dimProps = (Set)group.getValueByPropName("dimPropSet");
            Set memberNums = (Set)group.getValueByPropName("memberSet");
            qMemberNum = new QFilter("number", "in", (Object)memberNums);
            qDimNum = new QFilter("dimension.number", "=", (Object)dimNum);
            String form = ModelServiceHelper.getDimEntityKeyByDImNum((String)dimNum);
            Iterator<Object> dataSet = QueryServiceHelper.queryDataSet((String)"querymemb", (String)form, (String)String.join((CharSequence)",", dimProps), (QFilter[])new QFilter[]{qModel, qMemberNum, qDimNum, qType}, null);
            memberValues = new HashMap(memberNums.size());
            Object var26_28 = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                membVals = new HashMap<String, Object>(dimProps.size());
                for (String prop : dimProps) {
                    membVals.put(prop, row.get(prop));
                }
                memberValues.put(row.getString("number"), (HashMap<String, Object>)membVals);
            }
            group.setValueByPropName("memberObjectList", memberValues);
        }
        HashSet<String> errorInfos = new HashSet<String>(16);
        Iterator iterator = syncData.iterator();
        Map row = null;
        HashSet pkFields = new HashSet(dimMapInfos.getAllValOfOnePropByAnotherProp("targetFieldNum", "isPk", (Object)true));
        ArrayList<String> singleData = new ArrayList<String>(16);
        StringBuilder data = new StringBuilder();
        while (iterator.hasNext()) {
            row = (Map)iterator.next();
            data.setLength(0);
            for (Object e : pkFields) {
                data.append(row.get(e));
            }
            if (data.length() != 0) {
                if (singleData.contains(data.toString())) {
                    iterator.remove();
                    continue;
                }
                singleData.add(data.toString());
            }
            for (Map.Entry entry : row.entrySet()) {
                boolean replaceSuss = false;
                String[] val = ((String)entry.getValue()).split("!!!");
                String dimNun = val[0];
                String memberNum = val[1];
                String dimProp = val[2];
                memberValues = (Map)dimMemberGroups.getValOfOnePropByAnotherProp("memberObjectList", "dimNum", (Object)dimNun);
                if (memberValues != null && (membVals = (Map)memberValues.get(memberNum)) != null) {
                    entry.setValue(membVals.get(dimProp));
                    replaceSuss = true;
                }
                if (replaceSuss) continue;
                String msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u7684\u6210\u5458\u201c%2\u201d\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNun, memberNum});
                errorInfos.add(msg);
            }
        }
        if (!errorInfos.isEmpty()) {
            CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), new ArrayList(errorInfos), (String)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"EbSchemeSyncPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject iscSchemeNum = ebScheme.getDynamicObject("iscschemetrigger");
            if (iscSchemeNum == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u5bf9\u5e94\u96c6\u6210\u65b9\u6848\u83b7\u53d6\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.writeDataLog("bginSync_data", ((Object)syncData).toString());
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"push", (Object[])new Object[]{iscSchemeNum.getString("number"), syncData});
            if (map.get("success") != null && map.get("success").equals(true)) {
                String msg = ResManager.loadResFormat((String)"\u540c\u6b65\u5b8c\u6210\u3002\u63d0\u4ea4\u540c\u6b65%1\u884c\uff0c\u6210\u529f\u540c\u6b65%2\u884c\u3002", (String)"EbSchemeSyncPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{syncData.size(), map.get("total_count")});
                this.getView().returnDataToParent((Object)msg);
                this.saveSchemeCache(ebScheme);
                this.getView().close();
            }
            CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), Collections.singletonList((String)map.get("msg")), (String)ResManager.loadKDString((String)"\u540c\u6b65\u9519\u8bef", (String)"EbSchemeSyncPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void writeDataLog(String logKey, String logInfo) {
        try {
            int dataStringLength = logInfo.length();
            if (dataStringLength < 2000) {
                log.info(logKey + " : " + logInfo);
                return;
            }
            int i = 0;
            int j = 1;
            int z = 0;
            while (true) {
                if ((z = i + 2000) >= dataStringLength) {
                    log.info(logKey + j + " : " + logInfo.substring(i, dataStringLength));
                    break;
                }
                log.info(logKey + j + " : " + logInfo.substring(i, z));
                i = z;
                ++j;
            }
        }
        catch (Exception e) {
            log.error("write log error:", (Throwable)e);
        }
    }

    private void saveSchemeCache(DynamicObject ebScheme) {
        StringBuilder sb = new StringBuilder();
        DynamicInfoCollection allDimension = this.getAllDimsByModel();
        String dimNum = null;
        for (DynamicInfoCollection.InfoObject dimInfo : allDimension.getValues()) {
            dimNum = (String)dimInfo.getValueByPropName("number");
            DynamicObjectCollection docs = (DynamicObjectCollection)this.getModel().getValue(dimNum);
            if (docs == null || docs.size() <= 0) continue;
            if (sb.indexOf(dimNum + ":") < 0) {
                sb.append(dimNum).append(":");
            }
            for (DynamicObject doc : docs) {
                DynamicObject dim = (DynamicObject)doc.get("fbasedataid");
                sb.append(dim.getString("id")).append(",");
            }
            if (sb.lastIndexOf(",") == sb.length() - 1) {
                sb.deleteCharAt(sb.lastIndexOf(","));
            }
            sb.append(";");
        }
        if (sb.lastIndexOf(";") == sb.length() - 1) {
            sb.deleteCharAt(sb.lastIndexOf(";"));
        }
        ebScheme.set("dimcache", (Object)sb);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ebScheme});
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "EbSchemeSyncPlugin_15", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "EbSchemeSyncPlugin_16", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, null);
    }

    private DynamicInfoCollection getSelectedDimInfos() {
        Page p = this.getPage(this.getView());
        DynamicInfoCollection selectedDims = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u7ef4\u5ea6\u4fe1\u606f\u6210\u5458-\u7ef4\u5ea6\u7f16\u7801-\u7ef4\u5ea6\u7a0b\u5e8f\u7f16\u7801\u5217\u8868", (String)"EbSchemeSyncPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"dimNum", "memberNums"});
        if (p != null) {
            ArrayList dimNums = new ArrayList(16);
            p.getAreaList().forEach(area -> area.getElementListList().forEach(element -> {
                String num = element.getSign();
                dimNums.add(num);
            }));
            DynamicObjectCollection val = null;
            DynamicObject wholeEntry = this.getModel().getDataEntity();
            for (String dimNum : dimNums) {
                val = wholeEntry.getDynamicObjectCollection(dimNum);
                if (val == null || val.isEmpty()) continue;
                ArrayList memberNums = new ArrayList(16);
                val.forEach(member -> memberNums.add(member.getDynamicObject("fbasedataid").getString("number")));
                selectedDims.addInfo(new Object[]{dimNum, memberNums});
            }
        }
        return selectedDims;
    }

    public long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    private String getModelCubeNum() {
        Long modelId = this.getModelId();
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u201d\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return model.getString("number");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            FormShowParameter formParam = event.getFormShowParameter();
            if (formParam instanceof ListShowParameter) {
                DynamicInfoCollection allDimInfo = this.getAllDimsByModel();
                String number = event.getProperty().getName();
                for (DynamicInfoCollection.InfoObject dimInfo : allDimInfo.getValues()) {
                    String dimNum = (String)dimInfo.getValueByPropName("number");
                    if (!number.equals(dimNum.toLowerCase(Locale.getDefault()))) continue;
                    number = dimNum;
                    break;
                }
                long modelId = this.getModelId();
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)number), (String)ListSelectedRow.class.getName());
                f7Param.setMultiSelect(true);
                NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }
}

