/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class EbShareDimensionDataListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelEdit = (BasedataEdit)this.getControl("model");
        modelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue("model", (Object)modelId);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (key.equals("model")) {
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = parameter.getListFilterParameter().getQFilters();
            qFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            NewF7Utils.dealSelectRows((ListShowParameter)parameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qModelAndBuilder = new QFilter("model", "=", (Object)this.getModelId());
        e.addCustomQFilter(qModelAndBuilder);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        Long modelId = 0L;
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key.equals("model")) {
            Object obj = this.getModel().getValue("model");
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter showParameter = e.getParameter();
        if (showParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionDataListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btnenable": {
                this.itemClick_enable();
                break;
            }
            case "btndisable": {
                this.itemClick_disable();
            }
        }
    }

    public void itemClick_enable() {
        DynamicObject[] shareDims = this.queryData(true);
        if (this.enableAndDisable(shareDims, true)) {
            Set<String> numberSet = this.getShareDimNumberSet(shareDims);
            this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "EbShareDimensionDataListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7%1$s\u542f\u7528\u6210\u529f", "EbShareDimensionDataListPlugin_7", "epm-eb-formplugin"), new String[]{StringUtils.join(numberSet, (String)",")});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CurrencyConvertListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private Set<String> getShareDimNumberSet(DynamicObject[] shareDims) {
        HashSet<String> numberSet = new HashSet<String>(16);
        if (shareDims == null || shareDims.length == 0) {
            return numberSet;
        }
        for (DynamicObject shareDim : shareDims) {
            numberSet.add(shareDim.getString("number"));
        }
        return numberSet;
    }

    public void itemClick_disable() {
        DynamicObject[] shareDims = this.queryData(false);
        if (this.enableAndDisable(shareDims, false)) {
            Set<String> numberSet = this.getShareDimNumberSet(shareDims);
            this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "EbShareDimensionDataListPlugin_6", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7%1$s\u7981\u7528\u6210\u529f", "EbShareDimensionDataListPlugin_8", "epm-eb-formplugin"), new String[]{StringUtils.join(numberSet, (String)",")});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CurrencyConvertListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private DynamicObject[] queryData(boolean isEnable) {
        DynamicObject[] objs = null;
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            ListSelectedRowCollection rows = list.getSelectedRows();
            if (!rows.isEmpty()) {
                QFBuilder builder = new QFBuilder();
                builder.add("id", "in", (Object)rows.getPrimaryKeyValues());
                objs = BusinessDataServiceHelper.load((String)"eb_sharedimensiondata", (String)"id,number,status", (QFilter[])builder.toArray());
            } else if (isEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u8bb0\u5f55\u3002", (String)"EbShareDimensionDataListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u8bb0\u5f55\u3002", (String)"EbShareDimensionDataListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            }
        }
        return objs;
    }

    private boolean enableAndDisable(DynamicObject[] shareDims, boolean isEnable) {
        if (shareDims == null || shareDims.length == 0) {
            return false;
        }
        for (DynamicObject obj : shareDims) {
            boolean status = obj.getBoolean("status");
            if (isEnable) {
                if (status) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u542f\u7528\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u65e0\u9700\u91cd\u590d\u542f\u7528\u3002", (String)"EbShareDimensionDataListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                    return false;
                }
            } else if (!status) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7981\u7528\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u65e0\u9700\u91cd\u590d\u7981\u7528\u3002", (String)"EbShareDimensionDataListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return false;
            }
            obj.set("status", (Object)isEnable);
        }
        SaveServiceHelper.update((DynamicObject[])shareDims);
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            list.refreshData();
        }
        return true;
    }
}

