/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.scheme;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;

public class EbShareDimensionDataPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SELECTDIMENSIONRANG = "selectdimensionrang";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MODEL = "model";
    private static final String DIMENSION = "dimension";
    private static final String APP = "app";
    private static final String CLOUD = "cloud";
    private static final String BILL = "bill";
    private static final String FIELD = "field";
    private static final String DIMENSIONRANGE = "dimensionrangejson_tag";
    public static final String EB_ADDINSIDEBILL = "eb_addinsidebill";
    public static final String FIELDNUMBER = "fieldnumber";

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MODEL});
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (modelId != null) {
            this.getModel().setValue(MODEL, (Object)modelId);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            this.addDimensionFilter(model);
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
            String jsonString = (String)this.getModel().getValue(DIMENSIONRANGE);
            this.setDimensionRangeCache(dimension, jsonString);
        } else if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"saveandnew", MODEL});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SELECTDIMENSIONRANG.equals(key)) {
            this.showDimensionRangForm();
        } else if (FIELD.equals(key)) {
            this.showSelectFieldForm();
        }
    }

    private void showSelectFieldForm() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5355\u636e", (String)"EbShareDimensionDataPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_fieldselectform");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("billNumber", (Object)bill.getString("number"));
        formShowParameter.setCustomParam("billName", (Object)bill.getString("name"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectField"));
        this.getView().showForm(formShowParameter);
    }

    private void showDimensionRangForm() {
        List members;
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ef4\u5ea6", (String)"EbShareDimensionDataPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String number = dimension.getString("number");
        HashMap<String, String> dimensionMemberTreeMap = this.getDimensionMemberTreeMap();
        String memberTree = dimensionMemberTreeMap.get(number);
        if (StringUtils.isEmpty((String)memberTree)) {
            memberTree = "epm_userdefinedmembertree";
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)model.getLong("id"), (DynamicObject)NewF7Utils.getDimension((Long)model.getLong("id"), (String)number), (String)DynamicObjectCollection.class.getName());
        String rangeStr = this.getPageCache().get(memberTree + dimension.getString("dseq"));
        if (StringUtils.isNotEmpty((String)rangeStr) && (members = (List)SerializationUtils.fromJsonString((String)rangeStr, List.class)) != null) {
            LinkedHashMap memberScopeMap = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
            for (Map member : members) {
                Object scope = member.get("scope");
                if (scope instanceof Integer) {
                    memberScopeMap.put(IDUtils.toLong(member.get("id")), (Integer)scope);
                    continue;
                }
                if (!(scope instanceof String)) continue;
                memberScopeMap.put(IDUtils.toLong(member.get("id")), NewF7Utils.getScope((String)((String)scope)));
            }
            f8Param.setSelectIds((Map)memberScopeMap);
        }
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "dimrang"));
    }

    public void registerListener(EventObject e) {
        BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bill = (BasedataEdit)this.getControl(BILL);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{SELECTDIMENSIONRANG, FIELD});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getSource();
        baseShowParameter.setCustomParam("noNeedDefaultQFilter", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MODEL.equals(name)) {
            this.clearData();
            DynamicObject model = (DynamicObject)e.getProperty().getValue((Object)this.getModel().getDataEntity());
            this.addDimensionFilter(model);
        } else if (DIMENSION.equals(name)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
        } else if (BILL.equals(name)) {
            this.getModel().setValue(FIELD, (Object)"");
            this.getModel().setValue(FIELDNUMBER, (Object)"");
            this.getModel().setValue(APP, null);
            this.getModel().setValue(CLOUD, null);
            this.getModel().setDataChanged(false);
            DynamicObject dynamicObject = (DynamicObject)e.getProperty().getValue((Object)this.getModel().getDataEntity());
            if (dynamicObject != null) {
                this.dealWithBillCloseCallBack(dynamicObject.getString("id"));
            }
        }
    }

    private void addDimensionFilter(DynamicObject model) {
        if (model == null) {
            return;
        }
        BasedataEdit dimension = (BasedataEdit)this.getControl(DIMENSION);
        ArrayList<QFilter> qFilters = dimension.getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(1);
        }
        qFilters.clear();
        qFilters.add(new QFilter(MODEL, "=", (Object)IDUtils.toLong((Object)model.getPkValue())));
        dimension.setQFilters(qFilters);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (BILL.equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BILL));
            listShowParameter.setFormId(EB_ADDINSIDEBILL);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u9009\u62e9\u5217\u8868", (String)"EbShareDimensionDataPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            listShowParameter.setStatus(OperationStatus.ADDNEW);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setHeight("680");
            css.setWidth("1200");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)listShowParameter);
        } else if (DIMENSION.equals(name)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4f53\u7cfb", (String)"EbShareDimensionDataPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter(MODEL, "=", (Object)model.getLong("id")));
            HashSet<String> hideEbDims = new HashSet<String>();
            hideEbDims.add(SysDimensionEnum.Process.getNumber());
            hideEbDims.add(SysDimensionEnum.Scenario.getNumber());
            hideEbDims.add(SysDimensionEnum.DataType.getNumber());
            qFilters.add(new QFilter("number", "not in", hideEbDims));
        }
    }

    private HashMap<String, String> getDimensionMemberTreeMap() {
        String memberTreeMap1 = this.getPageCache().get("memberTreeMap");
        HashMap memberTreeMap = new HashMap(16);
        if (StringUtils.isEmpty((String)memberTreeMap1)) {
            SysDimensionEnum[] values;
            for (SysDimensionEnum value : values = SysDimensionEnum.values()) {
                memberTreeMap.put(value.getNumber(), value.getMemberTreemodel());
            }
            this.getPageCache().put("memberTreeMap", SerializationUtils.serializeToBase64((Object)memberTreeMap));
        } else {
            memberTreeMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)memberTreeMap1);
        }
        return memberTreeMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("dimrang".equals(actionId)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.dealReturnData((DynamicObjectCollection)returnData);
        } else if (BILL.equals(actionId)) {
            this.getModel().setValue(BILL, ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue());
        } else if ("selectField".equals(actionId)) {
            DynamicObject data = (DynamicObject)returnData;
            String number = data.getString("fullnumber");
            String name = data.getString("fullname");
            this.getModel().setValue(FIELDNUMBER, (Object)number);
            this.getModel().setDataChanged(false);
            this.getModel().setValue(FIELD, (Object)name);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"saveandnew"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String number;
        String checkNumber;
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey()) && StringUtils.isNotEmpty((String)(checkNumber = NumberCheckUtils.checkNumberRule((String)(number = (String)this.getModel().getValue("number")))))) {
            throw new KDBizException(checkNumber);
        }
    }

    private void dealReturnData(DynamicObjectCollection returnData) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION);
        String dimNumber = dimension.getString("number");
        Model model1 = ModelCacheContext.getOrCreate((Long)model.getLong("id")).getModelobj();
        ArrayList cacheDimensionData = new ArrayList(returnData.size());
        LinkedHashSet memberNums = Sets.newLinkedHashSetWithExpectedSize((int)returnData.size());
        for (DynamicObject dynamicObject : returnData) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            String num = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String id = dynamicObject.getString("id");
            int scope = dynamicObject.getInt("scope");
            String pid = dynamicObject.getString("pid");
            data.put("number", num);
            data.put("name", name);
            data.put("id", id);
            data.put("parent", pid);
            data.put("scope", scope);
            cacheDimensionData.add(data);
            if (scope == BigDecimal.TEN.intValue()) {
                if (!memberNums.add(num)) continue;
                int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, newEntryRow);
                entryRowEntity.set("dimensionnumber", (Object)num);
                entryRowEntity.set("dimensionname", (Object)name);
                continue;
            }
            List members = ModelCacheServiceHelper.getMember((Model)model1, (String)dimNumber, (String)num, (int)scope);
            if (members == null || members.isEmpty()) continue;
            Set _memberNums = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            _memberNums.removeAll(memberNums);
            if (_memberNums.isEmpty()) continue;
            int index = 0;
            int[] ints = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, _memberNums.size());
            for (Member _member : members) {
                if (!_memberNums.contains(_member.getNumber())) continue;
                int rowIndex = ints[index++];
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
                rowEntity.set("dimensionnumber", (Object)_member.getNumber());
                rowEntity.set("dimensionname", (Object)_member.getName());
            }
            memberNums.addAll(_memberNums);
        }
        String jsonString = SerializationUtils.toJsonString(cacheDimensionData);
        this.getModel().beginInit();
        this.getModel().setValue(DIMENSIONRANGE, (Object)jsonString);
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView(ENTRYENTITY);
        this.setDimensionRangeCache(dimension, jsonString);
    }

    private void dealWithBillCloseCallBack(String primaryKeyValue) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)};
        DynamicObject bill = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"bizappid", (QFilter[])qFilters);
        String bizappid = bill.getString("bizappid");
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)bizappid)};
        DynamicObject bizapp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])qFilters1);
        if (bizapp != null) {
            String bizcloud = bizapp.getString("bizcloud");
            this.getModel().setValue(CLOUD, (Object)bizcloud);
        }
        this.getModel().setValue(APP, (Object)bizappid);
        this.getModel().setValue(BILL, (Object)primaryKeyValue);
    }

    private void clearData() {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().setValue(DIMENSION, null);
        this.getModel().setValue(DIMENSIONRANGE, null);
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(DIMENSION);
        this.getView().updateView(DIMENSIONRANGE);
    }

    private void setDimensionRangeCache(DynamicObject dimension, String jsonString) {
        String memberTreemodelByNumber = SysDimensionEnum.getMemberTreemodelByNumber((String)dimension.getString("number"));
        if (StringUtils.isEmpty((String)memberTreemodelByNumber)) {
            memberTreemodelByNumber = "bcm_userdefinemembertree";
        }
        this.getPageCache().put(memberTreemodelByNumber + dimension.getString("dseq"), jsonString);
    }
}

