/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.sonmodel.ControlParam;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractBasePlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractBillPlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractListPlugin;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubControlMsg;
import org.apache.commons.collections.CollectionUtils;

public interface BgmdMainSubController {
    public static final Log log = LogFactory.getLog(BgmdMainSubController.class);
    public static final Set<String> mainSubPluginSetBasePlugin = Sets.newHashSet((Object[])new String[]{"eb_applicationscenario", "epm_accountmembertree", "epm_audittrialmembertree", "epm_changetypemembertree", "epm_currencymembertree", "epm_entitymembertree", "epm_metricmembertree", "epm_userdefinedmembertree", "epm_versionmembertree", "eb_templateentity", "eb_dataset", "eb_customproperty", "eb_datasetcatalog", "eb_templatecatalog", "epm_dimension", "eb_viewmember", "eb_dimensionview", "eb_dimensionview_group"});
    public static final Set<String> mainSubPluginSetBillPlugin = Sets.newHashSet((Object[])new String[]{"eb_periodvariable", "eb_dimensionvariable"});
    public static final Set<String> mainSubPluginSetFormPlugin = Sets.newHashSet((Object[])new String[]{"eb_datasetlist", "epm_dimensionmanager", "eb_setcustomproperty", "eb_addbusinessmodel", "epm_sysimport_entity", "eb_examine", "eb_appscenariolist", "eb_organizationview", "eb_examinecategory", "eb_accountupdate", "epm_sysimport_entity", "epm_sysimport_account", "epm_sysimport_userdefine"});
    public static final Set<String> mainSubPluginSetListPlugin = Sets.newHashSet((Object[])new String[]{"eb_bizrulegrouplist2", "eb_businessmodellist", "eb_examinelist", "eb_rulemanage5", "epm_variablemanager", "eb_templatelist"});

    default public Boolean isMainSubPlugin(IFormView getView) {
        Set<String> set = this.getMainSubPluginSet();
        if (CollectionUtils.isNotEmpty(set)) {
            return set.contains(this.getBaseNameByView(getView)) && this.checkIsMainSubModel() != false;
        }
        return false;
    }

    default public Set<String> getMainSubPluginSet() {
        if (this instanceof MainSubAbstractBasePlugin) {
            return mainSubPluginSetBasePlugin;
        }
        if (this instanceof MainSubAbstractBillPlugin) {
            return mainSubPluginSetBillPlugin;
        }
        if (this instanceof MainSubAbstractFormPlugin) {
            return mainSubPluginSetFormPlugin;
        }
        if (this instanceof MainSubAbstractListPlugin) {
            return mainSubPluginSetListPlugin;
        }
        return null;
    }

    default public String getBaseNameByView(IFormView getView) {
        if (getView != null && getView.getEntityId() != null) {
            return getView.getEntityId().toLowerCase();
        }
        return "";
    }

    default public Boolean checkIsMainSubModel() {
        Long modelId = this.getModelId();
        if (modelId != null && modelId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)modelId);
            qFilter.and("level", "!=", (Object)0);
            return QueryServiceHelper.exists((String)"epm_model", (QFilter[])qFilter.toArray());
        }
        return false;
    }

    default public Boolean canDoOperation(String controlType) {
        return this.canDoOperation(controlType, null);
    }

    default public Boolean canDoOperation(String controlType, Map<String, Object> otherParams) {
        Map customParams;
        if (this.getModelId() == null || this.getModelId() == 0L) {
            return true;
        }
        if (StringUtils.isEmpty((String)this.getBaseName(controlType)) || this.getControlTypeMap() == null || this.getControlTypeMap().get(controlType) == null) {
            return true;
        }
        int modelType = BgmdMainSubControlHelper.getInstance().checkModelType(this.getModelId());
        MainSubControlMsg mainSubControlMsg = this.getControlTypeMap().get(controlType);
        ControlParam controlParam = new ControlParam(this.getModelId(), this.getBaseName(controlType), mainSubControlMsg.getControlType(), Integer.valueOf(modelType), this.getControlField(controlType));
        controlParam.setModelTag(this.getModelTag());
        controlParam.setDataMete(this.getDataMeta(controlType));
        controlParam.setAddAndUpdate(this.getAddAndUpdate());
        IFormView view = this.getView();
        if (view != null && (customParams = view.getFormShowParameter().getCustomParams()) != null && (customParams.containsKey("dimensionNumber") || customParams.containsKey("dimensionId"))) {
            Dimension dimension;
            Object dimensionNumber = customParams.get("dimensionNumber");
            Object dimensionId = customParams.get("dimensionId");
            if (dimensionNumber != null) {
                controlParam.setControlDimensionNumber(String.valueOf(dimensionNumber));
            }
            if (dimensionNumber == null && dimensionId != null && (dimension = ModelCacheContext.getOrCreate((Long)this.getModelId()).getDimension(IDUtils.toLong(dimensionId))) != null) {
                controlParam.setControlDimensionNumber(dimension.getNumber());
            }
        }
        if (StringUtils.equals((String)"2", (String)mainSubControlMsg.getControlType()) || StringUtils.equals((String)"5", (String)mainSubControlMsg.getControlType())) {
            controlParam.setDeleteIds(this.getMainSubSelectRowIds(controlType));
            if (!this.deleteValidate(controlParam, controlType).booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u4e3b\u4f53\u7cfb\u5220\u9664\u3002", (String)"BgmdMainSubControlHelper_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((String)"0", (String)mainSubControlMsg.getControlType()) || StringUtils.equals((String)"1", (String)mainSubControlMsg.getControlType())) {
            Set<String> set = this.getNumbers(controlType, otherParams);
            if (CollectionUtils.isEmpty(set)) {
                return true;
            }
            Boolean needCheckNumber = this.needCheckNumber(controlType);
            if (needCheckNumber.booleanValue()) {
                QFilter qFilter = this.getCheckNumberQFilter(controlParam, controlType);
                if (!BgmdMainSubControlHelper.getInstance().checkAllMainSubNumber(qFilter, controlParam.getModelId(), controlParam.getDataMete(), set).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u6216\u5b50\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdMainSubControlHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            controlParam.setNumbers(set);
            controlParam.setAddValidateQFilter(this.addValidateQFilter(set, controlType));
            controlParam.setCustomQFilter(this.getCustomQFilter(controlParam, controlType));
        }
        if (StringUtils.equals((String)"6", (String)mainSubControlMsg.getControlType())) {
            this.importFileValidate(controlParam, otherParams, controlType);
        }
        if (StringUtils.equals((String)"4", (String)mainSubControlMsg.getControlType())) {
            this.checkSubHasData(controlParam, controlType);
        }
        return BgmdMainSubControlHelper.getInstance().canDoOperation(controlParam);
    }

    default public void updateSubSign(String controlType, String mainNumber, Set<Long> ids) {
        this.updateSubSign(controlType, Sets.newHashSet((Object[])new String[]{mainNumber}), ids);
    }

    default public void updateSubSign(String controlType, Set<String> mainNumber, Set<Long> ids) {
        this.updateSubSign(controlType, mainNumber, ids, null);
    }

    default public void updateSubSign(String controlType, Set<String> mainNumber, Set<Long> ids, QFilter qFilter) {
        if (this.getModelId() == null || this.getModelId() == 0L) {
            return;
        }
        log.info("BgmdMainSubController updateSubSign condition1 true");
        if (StringUtils.isEmpty((String)this.getBaseName(controlType)) || this.getModelId() == 0L || this.getControlTypeMap() == null || this.getControlTypeMap().isEmpty()) {
            return;
        }
        log.info("BgmdMainSubController updateSubSign condition2 true");
        if (StringUtils.isEmpty((String)controlType) || this.getControlTypeMap().get(controlType) == null) {
            return;
        }
        log.info("BgmdMainSubController updateSubSign condition3 true");
        Boolean needCheckNumber = this.needCheckNumber(controlType);
        String sign = null;
        if ("1".equals(this.getControlTypeMap().get(controlType).getControlType())) {
            if (needCheckNumber.booleanValue() && CollectionUtils.isNotEmpty(mainNumber)) {
                HashSet numbers = Sets.newHashSet(mainNumber);
                if (!BgmdMainSubControlHelper.getInstance().checkAllMainSubNumber(this.getModelId(), this.getDataMeta(controlType), (Set)numbers).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u6216\u5b50\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdMainSubControlHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            sign = "3";
        } else if ("2".equals(this.getControlTypeMap().get(controlType).getControlType())) {
            sign = "2";
        } else if ("6".equals(this.getControlTypeMap().get(controlType).getControlType())) {
            sign = "3";
        }
        log.info("BgmdMainSubController updateSubSign sign :" + sign);
        if (StringUtils.isNotEmpty((String)sign)) {
            Set subIds = BgmdMainSubControlHelper.getInstance().getAllSubIds(this.getModelId());
            log.info("BgmdMainSubController updateSubSign subIds :" + SerializationUtils.toJsonString((Object)subIds));
            if (CollectionUtils.isNotEmpty((Collection)subIds)) {
                String dataMete = this.getDataMeta(controlType) == null ? BgmdMainSubControlHelper.getInstance().getDateMete(this.getBaseName(controlType)) : this.getDataMeta(controlType);
                log.info("BgmdMainSubController updateSubSign \uff1a" + controlType + "," + SerializationUtils.toJsonString(mainNumber) + "," + SerializationUtils.toJsonString(ids) + "," + SerializationUtils.toJsonString((Object)subIds) + "," + dataMete);
                if (StringUtils.isNotEmpty((String)dataMete)) {
                    if (CollectionUtils.isEmpty(ids)) {
                        Object dimensionNumberObj;
                        Map customParams;
                        IFormView view = this.getView();
                        String dimensionNumber = "";
                        if (view != null && (customParams = view.getFormShowParameter().getCustomParams()) != null && (dimensionNumberObj = customParams.get("dimensionNumber")) != null) {
                            dimensionNumber = String.valueOf(dimensionNumberObj);
                            ids = BgmdMainSubControlHelper.getInstance().getDataIdsByNumber(dataMete, mainNumber, subIds, qFilter, dimensionNumber);
                        }
                        if (CollectionUtils.isEmpty(ids)) {
                            ids = BgmdMainSubControlHelper.getInstance().getDataIdsFromSub(dataMete, mainNumber, subIds, dimensionNumber);
                        }
                    } else {
                        ids = this.getAllChildren(controlType, ids);
                        ids = BgmdMainSubControlHelper.getInstance().getDataIdsByIds(dataMete, ids, subIds);
                    }
                    log.info("BgmdMainSubController updateSubSign ids1\uff1a" + SerializationUtils.toJsonString((Object)ids));
                    if (needCheckNumber.booleanValue()) {
                        ArrayList<String> list = new ArrayList<String>(mainNumber);
                        if (CollectionUtils.isNotEmpty(list)) {
                            String number = (String)list.get(0);
                            if (StringUtils.isNotEmpty((String)number)) {
                                number = this.getMainSubModelNumber();
                            }
                            if (StringUtils.isNotEmpty((String)number)) {
                                BgmdMainSubControlHelper.getInstance().updateSubMainNumber(dataMete, ids, number);
                            }
                        }
                        sign = null;
                    }
                    log.info("BgmdMainSubController updateSubSign ids2\uff1a" + SerializationUtils.toJsonString((Object)ids));
                    BgmdMainSubControlHelper.getInstance().updateSubSign(dataMete, sign, ids);
                }
            }
        }
    }

    public Long getModelId();

    default public String getBaseName(String controlType) {
        return null;
    }

    default public Map<String, MainSubControlMsg> getControlTypeMap() {
        return null;
    }

    default public String getControlField(String controlType) {
        return null;
    }

    default public String getEntityTag() {
        return "billlistap";
    }

    default public String getDataMeta(String controlType) {
        return null;
    }

    default public Set<Long> getMainSubSelectRowIds(String controlType) {
        Object[] selectids;
        HashSet<Long> ids = new HashSet<Long>(16);
        IFormView formView = null;
        if (this instanceof AbstractFormPlugin) {
            formView = ((AbstractFormPlugin)((Object)this)).getView();
        } else if (this instanceof AbstractListPlugin) {
            formView = ((AbstractListPlugin)((Object)this)).getView();
        }
        if (formView == null) {
            return ids;
        }
        BillList billList = (BillList)formView.getControl(this.getEntityTag());
        for (Object selectid : selectids = billList.getSelectedRows().getPrimaryKeyValues()) {
            ids.add(IDUtils.toLong((Object)selectid));
        }
        return ids;
    }

    default public String getMainNumberKey() {
        return "number";
    }

    default public String getModelTag() {
        return "model";
    }

    default public Set<String> getNumbers(String controlType, Map<String, Object> otherParams) {
        HashSet<String> numbers = new HashSet<String>(16);
        if (this instanceof AbstractFormPlugin) {
            numbers.add((String)((AbstractFormPlugin)((Object)this)).getView().getModel().getValue(this.getMainNumberKey()));
        } else if (this instanceof AbstractListPlugin) {
            numbers.add((String)((AbstractListPlugin)((Object)this)).getView().getModel().getValue(this.getMainNumberKey()));
        } else if (this instanceof AbstractBasePlugin) {
            numbers.add((String)((AbstractBasePlugin)this).getView().getModel().getValue(this.getMainNumberKey()));
        }
        return numbers;
    }

    default public QFilter addValidateQFilter(Set<String> set, String controlType) {
        return null;
    }

    default public Boolean getAddAndUpdate() {
        return false;
    }

    default public Boolean importFileValidate(ControlParam controlParam, Map<String, Object> otherParams, String controlType) {
        return true;
    }

    default public Boolean deleteValidate(ControlParam controlParam, String controlType) {
        return true;
    }

    default public Object[] checkAllDataFromMainDeleteIds(ControlParam controlParam) {
        Set subIds;
        QFilter qFilter = new QFilter("id", "in", (Object)controlParam.getDeleteIds());
        DynamicObjectCollection mains = QueryServiceHelper.query((String)controlParam.getDataMete(), (String)this.getMainNumberKey(), (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)mains) && CollectionUtils.isNotEmpty((Collection)(subIds = BgmdMainSubControlHelper.getInstance().getAllSubIds(this.getModelId())))) {
            HashSet numbers = new HashSet(16);
            mains.forEach(e -> numbers.add(e.getString(this.getMainNumberKey())));
            QFilter allSubQFilter = new QFilter("model", "in", (Object)subIds);
            allSubQFilter.and(this.getMainNumberKey(), "in", numbers);
            allSubQFilter.and("syncstatus", "!=", (Object)" ");
            DynamicObjectCollection subs = QueryServiceHelper.query((String)controlParam.getDataMete(), (String)"id", (QFilter[])allSubQFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)subs)) {
                Object[] result = new Object[subs.size()];
                for (int i = 0; i < subs.size(); ++i) {
                    result[i] = ((DynamicObject)subs.get(i)).getLong("id");
                }
                return result;
            }
        }
        return null;
    }

    default public Set<Long> getAllChildren(String controlType, Set<Long> ids) {
        return ids;
    }

    default public Boolean needCheckNumber(String controlType) {
        return false;
    }

    default public String getMainSubModelNumber() {
        return null;
    }

    default public Set<Long> getMainSubModelId() {
        return null;
    }

    default public Boolean mainSubNeedEnabled() {
        return false;
    }

    default public Boolean checkSubHasData(ControlParam controlParam, String controlType) {
        return false;
    }

    default public QFilter getCustomQFilter(ControlParam controlParam, String controlType) {
        return null;
    }

    default public QFilter getCheckNumberQFilter(ControlParam controlParam, String controlType) {
        return null;
    }

    default public IFormView getView() {
        IFormView view = null;
        if (this instanceof AbstractFormPlugin) {
            view = ((AbstractFormPlugin)((Object)this)).getView();
        } else if (this instanceof AbstractListPlugin) {
            view = ((AbstractListPlugin)((Object)this)).getView();
        } else if (this instanceof AbstractBasePlugin) {
            view = ((AbstractBasePlugin)this).getView();
        }
        return view;
    }
}

