/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.adminmode.CurrentModeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.controlprocess.replace.SimpleObject;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgmdMainSubModelList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
HyperLinkClickListener,
ItemClickListener {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String EBMODEL = "epm_model";
    private static final String TBLNEW = "tblnew";
    private static final String TBLNEWSUB = "tblnewsub";
    private static final String BAR_MODIFIER = "bar_modifier";
    private static final String TBLDEL = "tbldel";
    private static final String DISTRIBUTE = "distribute";
    private static final String BTNQUERYDATA = "btnquerydata";
    private static final String TBLREFRESH = "tblrefresh";
    private static final String TBLCLOSE = "tblclose";
    private static final String BTN_SYNC = "btn_sync";
    private static final String BTN_SYN_LOG = "btn_syn_log";
    private static final String FILTERSEARCH = "filterSearch";
    private static final Log log = LogFactory.getLog(BgmdMainSubModelList.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SYNC});
        this.initTreeView(null);
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid memberTree = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        memberTree.addCellClickListener((TreeNodeQueryListener)this);
        memberTree.addHyperClickListener((HyperLinkClickListener)this);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId(EBMODEL);
            fc.addSearchClickListener(this::filterContainerSearchClick);
        }
    }

    private void filterContainerSearchClick(SearchClickEvent searchClickEvent) {
        List fastQFilters = searchClickEvent.getFastQFilters();
        if (CollectionUtils.isNotEmpty((Collection)fastQFilters)) {
            this.getPageCache().put(FILTERSEARCH, ObjectSerialUtil.toByteSerialized((Object)fastQFilters));
            this.initTreeView(null);
            this.searchModel(fastQFilters);
        } else {
            this.getPageCache().remove(FILTERSEARCH);
            this.initTreeView(null);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        int row = hyperLinkClickEvent.getRowIndex();
        if ("perm".equals(hyperLinkClickEvent.getFieldName())) {
            this.openModelPermPage(row);
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
            DynamicObject object = (DynamicObject)entryEntity.get(row);
            if (object.getBoolean("mainsubstatus")) {
                this.openSaveModel(row);
            } else {
                String model = object.getString("model");
                if (StringUtils.isEmpty((String)model)) {
                    return;
                }
                QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)Long.parseLong(model));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_mainsubmodel_base", (String)"id,mainmodel", (QFilter[])qfBuilder.toArray());
                if (dynamicObject == null) {
                    return;
                }
                long mainmodel = dynamicObject.getLong("mainmodel");
                this.openMainSubModel(false, row, mainmodel, "modify");
            }
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject entryRowEntity;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int[] selectedRows = treeEntryGrid.getSelectRows();
        if (!("import".equals(key) || TBLNEW.equals(key) || TBLREFRESH.equals(key) || TBLCLOSE.equals(key) || "btn_close".equals(key) || "testrollback".equals(key) || "btnviewupgrade".equals(key) || StringUtils.equals((String)BTN_SYN_LOG, (String)key) || selectedRows.length >= 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6267\u884c\u6570\u636e\u3002", (String)"BgmdModelList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((String)"btn_dimcontrol", (String)key) && (entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectedRows[0])) != null) {
            QFilter qFilter = new QFilter("number", "=", (Object)entryRowEntity.getString("shownumber"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_mainsubmodel_base", (String)"id, mainmodel", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u4f53\u7cfb\u6216\u5b59\u4f53\u7cfb\u6570\u636e\u3002", (String)"BgmdMainSubModelList_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long mainModelId = 0L;
            long subModelId = 0L;
            String mainModelName = "";
            String subModelName = "";
            Set modelIds = MemberPermHelper.getLimitedModelListByUser();
            qFilter = new QFilter("id", "=", (Object)dynamicObject.getLong("mainmodel"));
            if ((dynamicObject = QueryServiceHelper.queryOne((String)EBMODEL, (String)"id,name", (QFilter[])qFilter.toArray())) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"BgmdMainSubModelList_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            mainModelId = dynamicObject.getLong("id");
            mainModelName = dynamicObject.getString("name");
            qFilter = new QFilter("shownumber", "=", (Object)entryRowEntity.getString("shownumber"));
            dynamicObject = QueryServiceHelper.queryOne((String)EBMODEL, (String)"id, name", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"BgmdMainSubModelList_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            subModelId = dynamicObject.getLong("id");
            subModelName = dynamicObject.getString("name");
            if (!modelIds.contains(mainModelId) && !modelIds.contains(subModelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5b50\u4f53\u7cfb( %1 ) \u6216\u4e3b\u4f53\u7cfb\uff08%2\uff09\u7684\u4f53\u7cfb\u7ba1\u7406\u5458\uff0c\u4e0d\u53ef\u67e5\u770b\u6216\u4fee\u6539\u7ba1\u63a7\u7b56\u7565\u3002", (String)"BgmdMainSubModelList_24", (String)"epm-eb-formplugin", (Object[])new Object[]{subModelName, mainModelName}));
                evt.setCancel(true);
            }
        }
        if ("btn_openadmin".equals(key) || "btn_closeadmin".equals(key) || "btn_announcement".equals(key) || "btn_mntscheme".equals(key) || "btn_executelog".equals(key) || "btn_executeplan".equals(key)) {
            if (selectedRows != null && selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgmdModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (selectedRows != null && selectedRows.length == 1) {
                QFilter qFilter;
                DynamicObject dynamicObject;
                Set ids = MemberPermHelper.getLimitedModelListByUser();
                DynamicObject entryRowEntity2 = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectedRows[0]);
                if (entryRowEntity2 != null && (dynamicObject = QueryServiceHelper.queryOne((String)EBMODEL, (String)"id,name", (QFilter[])(qFilter = new QFilter("id", "=", (Object)entryRowEntity2.getLong("model"))).toArray())) != null && !ids.contains(dynamicObject.getLong("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u4f53\u7cfb\u7ba1\u7406\u5458\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"BgmdModelList_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    private boolean queryExecutePlan(Long modelid) {
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        QFilter filter1 = new QFilter("status", "in", (Object)new String[]{"1", "2"});
        return QueryServiceHelper.exists((String)"eb_mnt_executeplan", (QFilter[])new QFilter[]{filter, filter1});
    }

    private boolean queryModelCurrentMode(Long modelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)EBMODEL, (String)"currentmode");
        return dynamicObject != null && CurrentModeEnum.ADMIN.getIndex().equals(dynamicObject.getString("currentmode"));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (TBLNEW.equals(key)) {
            BaseShowParameter param = new BaseShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(EBMODEL);
            param.setStatus(OperationStatus.ADDNEW);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "modelnew");
            param.setCloseCallBack(closeCallBack);
            if (this.isEb()) {
                param.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u4f53\u7cfb", (String)"BgmdModelList_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().showForm((FormShowParameter)param);
        } else if (DISTRIBUTE.equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u7ba1\u7406\u5458\u6307\u5b9a\u3002", (String)"BgmdModelList_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openModelPermPage(selectedRows[0]);
        } else if (BAR_MODIFIER.equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"TargetSchemeDimMapperListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isSave = StringUtils.equals((String)"1", (String)String.valueOf(this.getModel().getValue("mainsubstatus", selectedRows[0])));
            if (isSave) {
                Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
                if (CollectionUtils.isNotEmpty(this.checkModelPer(Sets.newHashSet((Object[])new Long[]{modelId})))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"BgmdMainSubModelList_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                CloseCallBack close = new CloseCallBack((IFormPlugin)this, "modifierclose");
                BaseShowParameter param = new BaseShowParameter();
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setFormId(EBMODEL);
                param.setPkId((Object)modelId);
                param.setStatus(OperationStatus.EDIT);
                param.setCloseCallBack(close);
                this.getView().showForm((FormShowParameter)param);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u6682\u5b58\u4f53\u7cfb,\u8bf7\u70b9\u51fb\u8d85\u94fe\u5b8c\u6210\u4f53\u7cfb\u521b\u5efa\u3002", (String)"BgmdMainSubModelList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (BTNQUERYDATA.equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgmdModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u5141\u8bb8\u8fdb\u884c\u6570\u636e\u67e5\u8be2\u3002", (String)"BgmdMainSubModelList_4", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getModel().getValue("name", selectedRows[0])}));
                return;
            }
            DynamicObjectCollection treeentryentity = this.getView().getModel().getEntryEntity(TREEENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)treeentryentity.get(selectedRows[0]);
            String shownumber = dynamicObject.getString("shownumber");
            boolean exists = QueryServiceHelper.exists((String)EBMODEL, (QFilter[])new QFilter("shownumber", "=", (Object)shownumber).toArray());
            if (exists) {
                this.openQueryData(key, modelId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002\u65e0\u6cd5\u67e5\u8be2\u6570\u636e\u3002", (String)"BgmdMainSubModelList_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (TBLDEL.equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> selectIds = new HashSet<Long>(16);
            HashMap<Long, String> map = new HashMap<Long, String>(16);
            for (int selectedRow : selectedRows) {
                if (!StringUtils.equals((String)String.valueOf(this.getModel().getValue("mainsubstatus", selectedRow)), (String)"1")) continue;
                selectIds.add(IDUtils.toLong((Object)this.getModel().getValue("model", selectedRow)));
                map.put(IDUtils.toLong((Object)this.getModel().getValue("model", selectedRow)), String.valueOf(this.getModel().getValue("name", selectedRow)));
            }
            Set<Long> notPerIds = this.checkModelPer(selectIds);
            if (CollectionUtils.isNotEmpty(notPerIds)) {
                StringBuilder sb = new StringBuilder();
                for (Long notPerId : notPerIds) {
                    if (!map.containsKey(notPerId)) continue;
                    sb.append((String)map.get(notPerId)).append("\uff0c");
                }
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1 \u4e0d\u662f\u4f53\u7cfb\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"BgmdMainSubModelList_17", (String)"epm-eb-formplugin", (Object[])new Object[]{sb.toString()}));
                return;
            }
            HashSet set = new HashSet(16);
            BgmdMainSubControlHelper.getInstance().getAllSubIds(set, selectIds);
            boolean isAll = true;
            for (Long id : set) {
                if (selectIds.contains(id)) continue;
                isAll = false;
                break;
            }
            if (!isAll) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5b58\u5728\u5b50\u4f53\u7cfb\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgmdMainSubModelList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u4f53\u7cfb\u5c06\u540c\u65f6\u5220\u9664\u5176\u5305\u542b\u7684\u6240\u6709\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\uff0c\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"BgmdMainSubModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteModel", (IFormPlugin)this));
        } else if (TBLREFRESH.equals(key)) {
            this.refreshTreeView();
        } else if (TBLNEWSUB.equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgmdModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isSave = StringUtils.equals((String)"1", (String)String.valueOf(this.getModel().getValue("mainsubstatus", selectedRows[0])));
            if (isSave) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
                long modelId = ((DynamicObject)entryEntity.get(selectedRows[0])).getLong("model");
                int level = BgmdMainSubControlHelper.getInstance().queryLevel(Long.valueOf(modelId));
                if (level == 3) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5141\u8bb8\u65b0\u589e\u7b2c3\u7ea7\u5b50\u4f53\u7cfb\u3002", (String)"BgmdMainSubModelList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (CollectionUtils.isNotEmpty(this.checkModelPer(Sets.newHashSet((Object[])new Long[]{modelId})))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u5141\u8bb8\u65b0\u589e\u5b50\u4f53\u7cfb\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BgmdMainSubModelList_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openMainSubModel(true, selectedRows[0], 0L, "addNew");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u5b58\u4f53\u7cfb\u65e0\u6cd5\u65b0\u589e\u5b50\u4f53\u7cfb\u3002", (String)"BgmdMainSubModelList_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (TBLCLOSE.equals(key)) {
            this.getView().close();
        } else if (BTN_SYNC.equals(key)) {
            this.handleModelSyncItemClick();
        } else if (BTN_SYN_LOG.equals(key)) {
            this.handleModelSyncLogItemClick();
        } else if ("test".equals(key)) {
            HashSet<Long> set = new HashSet<Long>(16);
            set.add(UserUtils.getUserId());
            BgmdMainSubControlHelper.getInstance().sendMessage(this.getView(), Long.valueOf(1371106870739330048L), set, null, null);
        } else if (BTNQUERYDATA.equals(key) || "btndeletedata".equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgmdModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isSave = StringUtils.equals((String)"1", (String)String.valueOf(this.getModel().getValue("mainsubstatus", selectedRows[0])));
            if (!isSave) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u521b\u5efa\u4f53\u7cfb\u3002", (String)"BgmdMainSubModelList_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            String modelName = String.valueOf(this.getModel().getValue("name", selectedRows[0]));
            if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\u975e%1\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"BgmdModelList_11", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName}));
                return;
            }
            this.openQueryData(key, modelId);
        } else if (StringUtils.equals((String)"btn_dimcontrol", (String)key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5b50\u4f53\u7cfb\u3002", (String)"BgmdModelList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            String number = String.valueOf(this.getModel().getValue("shownumber", selectedRows[0]));
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_mainsub_dimcontrol");
            param.setCustomParam("subModelId", (Object)modelId);
            param.setCustomParam("subModelNumber", (Object)number);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimcontrol"));
            this.getView().showForm(param);
        } else if ("btn_openadmin".equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_announcement");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("modelid", (Object)modelId);
            this.getView().showForm(formShowParameter);
        } else if ("btn_executelog".equals(key) || "btn_executeplan".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            formShowParameter.setCustomParam("model", (Object)modelId);
            formShowParameter.setFormId("btn_executelog".equals(key) ? "eb_mnt_executeloglist" : "eb_mnt_executeplanlist");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setShowTitle(true);
            this.getView().showForm(formShowParameter);
        } else if ("btn_closeadmin".equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", selectedRows[0]));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_closeadminmode");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("modelid", (Object)modelId);
            this.getView().showForm(formShowParameter);
        } else if ("btnviewupgrade".equals(key)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u4f53\u7cfb\u3002", (String)"BgmdModelList_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> modelIds = new ArrayList<Long>(16);
            for (int selectedRow : selectedRows) {
                modelIds.add(IDUtils.toLong((Object)this.getModel().getValue("model", selectedRow)));
            }
            ViewMemberUpgradeService.viewMemberUpgradeByPage(modelIds, (IFormView)this.getView());
        }
    }

    private void openSaveModel(int selectedRow) {
        IFormView toshowform;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        DynamicObject object = (DynamicObject)entryEntity.get(selectedRow);
        Long modelId = object.getLong("model");
        if (CollectionUtils.isNotEmpty(this.checkModelPer(Sets.newHashSet((Object[])new Long[]{modelId})))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"BgmdMainSubModelList_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + modelId;
        IFormView iFormView = toshowform = mainPageView == null ? null : mainPageView.getView(pageId);
        if (toshowform == null) {
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "epm_modelindexview");
            openParameter.put("pkId", modelId.toString());
            FormShowParameter param = FormShowParameter.createFormShowParameter(openParameter);
            param.setCustomParam("KEY_MODEL_ID", (Object)modelId);
            param.setCustomParam("pkId", (Object)modelId);
            param.setFormId("epm_modelindexview");
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                param.setParentPageId(parentView.getPageId());
                param.setCustomParam("parentpageid", (Object)parentView.getPageId());
            }
            param.setPageId(pageId);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCaption(this.isEb() ? ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u4f53\u7cfb\u9996\u9875", (String)"BgmdModelList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb\u9996\u9875", (String)"BgmdModelList_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setStatus(OperationStatus.VIEW);
            param.setCustomParam("reporttype", (Object)this.getReportType());
            this.getView().showForm(param);
        } else {
            toshowform.activate();
            this.getView().sendFormAction(toshowform);
        }
    }

    private void openMainSubModel(boolean isSave, int selectedRow, long mainmodel, String modify) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        DynamicObject object = (DynamicObject)entryEntity.get(selectedRow);
        long modelId = object.getLong("model");
        modelId = mainmodel == 0L ? modelId : mainmodel;
        FormShowParameter formShow = this.getFormShow(isSave, modelId);
        formShow.setPageId(this.getView().getPageId() + modify + modelId);
        if (!isSave) {
            String number = object.getString("shownumber");
            DynamicObject mainSubModelId = MainSubModelService.getInstance().getMainSubModelId(number);
            formShow.setCustomParam("modelDyn", (Object)SerializationUtils.serializeToBase64((Object)mainSubModelId));
            formShow.setCustomParam("status", (Object)modify);
        }
        formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeMainSubModelPage"));
        this.getView().showForm(formShow);
    }

    private FormShowParameter getFormShow(boolean isSave, long modelId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_mainsubmodel");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("isSave", (Object)isSave);
        formShowParameter.setCustomParam("modelId", (Object)String.valueOf(modelId));
        return formShowParameter;
    }

    private Set<Long> checkModelPer(Set<Long> modelId) {
        HashSet<Long> set = new HashSet<Long>(16);
        Set db = MemberPermHelper.getLimitedModelListByUser();
        for (Long id : modelId) {
            if (db.contains(id)) continue;
            set.add(id);
        }
        return set;
    }

    private void handleModelSyncLogItemClick() {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("bgmd_submodelsync_loglist");
        reportShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u5b50\u4f53\u7cfb\u540c\u6b65\u65e5\u5fd7\u67e5\u8be2", (String)"BgmdModelList_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private void handleModelSyncItemClick() {
        Map<Long, Long> selectedMainSubModelIdMap = this.getSelectedMainSubModelIdMap();
        this.openModelSyncDialog(selectedMainSubModelIdMap);
    }

    private void openModelSyncDialog(Map<Long, Long> selectedMainSubModelIdMap) {
        if (selectedMainSubModelIdMap == null || selectedMainSubModelIdMap.size() == 0) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u6682\u4e0d\u652f\u6301\u4f53\u7cfb\u540c\u6b65\u3002", (String)"", (String)"", (Object[])new Object[0]));
    }

    private DynamicObject queryModelDynamicObject(Long modelId) {
        try {
            return BusinessDataServiceHelper.loadSingle((Object)modelId, (String)EBMODEL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<Long, Long> getSelectedMainSubModelIdMap() {
        LinkedHashMap<Long, Long> result = new LinkedHashMap<Long, Long>(16);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        int[] selectedRows = treeEntryGrid.getSelectRows();
        if (selectedRows == null || selectedRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u540c\u6b65\u7684\u5b50\u4f53\u7cfb\u6570\u636e\u3002", (String)"BgmdMainSubModelList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        Object model = this.getModel().getValue("model", selectedRows[0]);
        Long subModelId = IDUtils.toLong((Object)model);
        DynamicObject subModelObj = this.queryModelDynamicObject(subModelId);
        if (subModelObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u4f53\u7cfb\u540c\u6b65\u3002", (String)"BgmdMainSubModelList_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        String parentnumber = subModelObj.getString("parentnumber");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentnumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u540c\u6b65\u7684\u5b50\u4f53\u7cfb\u6570\u636e\u3002", (String)"BgmdMainSubModelList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        String reportType = this.getReportType();
        QFilter qFilter = new QFilter("shownumber", "=", (Object)parentnumber);
        qFilter.and("reporttype", "=", (Object)reportType);
        DynamicObject parentModelObj = QueryServiceHelper.queryOne((String)EBMODEL, (String)"id", (QFilter[])qFilter.toArray());
        if (parentModelObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"BgmdMainSubModelList_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        long mainSubModelId = parentModelObj.getLong("id");
        Set limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser();
        if (CollectionUtils.isEmpty((Collection)limitedModelListByUser)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4f53\u7cfb\u540c\u6b65\u3002", (String)"BgmdMainSubModelList_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        if (!limitedModelListByUser.contains(mainSubModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4f53\u7cfb\u540c\u6b65\u3002", (String)"BgmdMainSubModelList_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        result.put(subModelId, mainSubModelId);
        return result;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deleteModel".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            int[] selectedRows = treeEntryGrid.getSelectRows();
            HashSet<Long> saveModel = new HashSet<Long>(16);
            HashSet<String> unSaveModel = new HashSet<String>(16);
            StringBuilder stringBuilder = new StringBuilder();
            Set manageModels = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
            for (int selectedRow : selectedRows) {
                boolean isSave = StringUtils.equals((String)"1", (String)String.valueOf(this.getModel().getValue("mainsubstatus", selectedRow)));
                if (isSave) {
                    saveModel.add(IDUtils.toLong((Object)this.getModel().getValue("model", selectedRow)));
                    unSaveModel.add(String.valueOf(this.getModel().getValue("shownumber", selectedRow)));
                    continue;
                }
                String shownumber = String.valueOf(this.getModel().getValue("shownumber", selectedRow));
                DynamicObject mainSubModelId = MainSubModelService.getInstance().getMainSubModelId(shownumber);
                long id = mainSubModelId.getLong("mainmodel_id");
                if (!manageModels.contains(id)) {
                    stringBuilder.append(shownumber).append("\u3001");
                }
                unSaveModel.add(shownumber);
            }
            if (stringBuilder.length() > 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u60a8\u6ca1\u6709%1\u4f53\u7cfb\u7684\u5220\u9664\u6743\u9650\uff0c\u4ec5\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u53ef\u4ee5\u5220\u9664\u6682\u5b58\u7684\u5b50\u4f53\u7cfb\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"BgmdMainSubModelList_26", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.deleteCharAt(stringBuilder.length() - 1)}));
                return;
            }
            boolean deleteResult = true;
            Set parentModelIds = BgmdMainSubControlHelper.getInstance().getMainModel(saveModel);
            DynamicObject[] models = new DynamicObject[]{};
            if (CollectionUtils.isNotEmpty(saveModel)) {
                QFilter qFilter = new QFilter("id", "in", saveModel);
                models = BusinessDataServiceHelper.load((String)EBMODEL, (String)"id,name,number,shownumber,version,reportType,datasource", (QFilter[])qFilter.toArray());
                OperateOption op = OperateOption.create();
                op.setVariableValue("currbizappid", ApplicationTypeEnum.BGMD.getAppnum());
                op.setVariableValue("appnumber", ApplicationTypeEnum.BGMD.getAppnum());
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"modeldel", (String)EBMODEL, (DynamicObject[])models, (OperateOption)op);
                if (!operationResult.isSuccess()) {
                    deleteResult = false;
                    if (CollectionUtils.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                        this.getView().showTipNotification(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                    }
                }
            }
            if (!deleteResult) {
                return;
            }
            if (CollectionUtils.isNotEmpty(unSaveModel)) {
                MainSubModelService.getInstance().deleteSubModel(unSaveModel);
            }
            if (CollectionUtils.isNotEmpty((Collection)parentModelIds)) {
                Set ids = BgmdMainSubControlHelper.getInstance().checkMainSubModelHasSub(parentModelIds);
                BgmdMainSubControlHelper.getInstance().updateMainSubModelLevel(ids, 0);
            }
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : models) {
                sb.append(dynamicObject.getString("number")).append(",");
            }
            for (String str : unSaveModel) {
                sb.append(str).append(",");
            }
            this.writeLog(null, "delete", new MultiLangEnumBridge("\u5220\u9664\u4f53\u7cfb", "BgmdMainSubLog_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u201c%1$s\u201d\u5df2\u6210\u529f\u5220\u9664\u3002", "BgmdMainSubLog_6", "epm-eb-formplugin"), new String[]{sb.toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataCollectionListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshTreeView();
        }
    }

    private void refreshTreeView() {
        String qfilterStr = this.getPageCache().get(FILTERSEARCH);
        if (StringUtils.isEmpty((String)qfilterStr)) {
            this.initTreeView(null);
        } else {
            List qFilter = (List)ObjectSerialUtil.deSerializedBytes((String)qfilterStr);
            this.initTreeView(null);
            this.searchModel(qFilter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "modelnew": {
                if (ObjectUtils.isEmpty((Object)e.getReturnData())) {
                    return;
                }
                this.refreshTreeView();
                FormShowParameter param = new FormShowParameter();
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getOpenStyle().setTargetKey("_submaintab_");
                param.setFormId("epm_modelindexview");
                param.setStatus(OperationStatus.VIEW);
                param.setCustomParam("KEY_MODEL_ID", e.getReturnData());
                param.setCustomParam("reporttype", (Object)this.getReportType());
                param.setCustomParam("view", this.getView().getParentView() != null ? this.getView().getParentView().getPageId() : null);
                this.getView().showForm(param);
                break;
            }
            case "closeMainSubModelPage": 
            case "distribute": 
            case "modifierclose": {
                this.refreshTreeView();
                break;
            }
            case "subModelSync": {
                Object returnData = e.getReturnData();
                if (returnData == null) {
                    return;
                }
                Map returnParamMap = (Map)returnData;
                Long mainModelId = IDUtils.toLong(returnParamMap.get("mainModelId"));
                String subModelNumber = returnParamMap.get("subModelNumber") + "";
                Object type = returnParamMap.get("type");
                if (type == null) break;
                if (StringUtils.equals((String)"add", (String)type.toString())) {
                    this.dispatch(subModelNumber, returnParamMap);
                    break;
                }
                if (!StringUtils.equals((String)"modify", (String)type.toString())) break;
                FormShowParameter formShowParameter = this.getFormShow(true, mainModelId);
                DynamicObject mainSubModelScheme = MainSubModelService.getInstance().getMainSubModelId(subModelNumber);
                formShowParameter.setCustomParam("modelDyn", (Object)SerializationUtils.serializeToBase64((Object)mainSubModelScheme));
                formShowParameter.setCustomParam("isSync", (Object)true);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifySyncScheme"));
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u5b50\u4f53\u7cfb\u540c\u6b65\u65b9\u6848\u4fee\u6539", (String)"BgmdMainSubModelList_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "modifySyncScheme": {
                Object returnData = e.getReturnData();
                if (returnData == null) break;
                Map returnDataMap = (Map)returnData;
                Object successTips = returnDataMap.get("successTips");
                Object errorTips = returnDataMap.get("errorTips");
                if (successTips != null) {
                    this.getView().showSuccessNotification(successTips.toString());
                    break;
                }
                if (errorTips == null) break;
                this.getView().showTipNotification(errorTips.toString());
                break;
            }
            case "dimcontrol": {
                Boolean dimcontrolReturn = (Boolean)e.getReturnData();
                if (dimcontrolReturn == null || !dimcontrolReturn.booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgmdMainSubModelList_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void dispatch(String subModelNumber, Map<String, Object> syncParam) {
        if (syncParam == null) {
            return;
        }
        String syncBizRule = syncParam.get("syncBizRule") + "";
        String syncExamine = syncParam.get("syncExamine") + "";
        String syncTemplate = syncParam.get("syncTemplate") + "";
        String syncAdd = syncParam.get("syncAdd") + "";
        String syncDelete = syncParam.get("syncDelete") + "";
        String syncModify = syncParam.get("syncModify") + "";
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getBizAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("BgmdMainSubModelSync job");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6b63\u5728\u4e3b\u5b50\u4f53\u7cfb\u540c\u6b65", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(0x6DDD00);
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.sonmodel.sync.schedule.BgmdMainSubModelSyncTask");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("subModelNumberList", subModelNumber);
        params.put("syncBizRule", syncBizRule);
        params.put("syncExamine", syncExamine);
        params.put("syncTemplate", syncTemplate);
        params.put("syncAdd", syncAdd);
        params.put("syncDelete", syncDelete);
        params.put("syncModify", syncModify);
        DynamicObject executeUser = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getUserId())});
        if (executeUser == null) {
            return;
        }
        params.put("executeuser", executeUser.getString("number"));
        jobInfo.setRunByUserId(this.getUserId().longValue());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.sonmodel.sync.schedule.BgmdMainSubModelSyncTaskClick");
        jobFormInfo.setCanBackground(true);
        CloseCallBack closeCallBack = new CloseCallBack("kd.epm.eb.formplugin.sonmodel.sync.schedule.BgmdMainSubModelSyncTaskCallBack", "syncSubModelCallBack");
        jobFormInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private String getReportType() {
        String reportType = "4";
        if (this.isEb()) {
            if (this.isNewEbForm()) {
                reportType = "6";
            }
        } else {
            reportType = "7";
        }
        return reportType;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        int rowNumber = evt.getRowKey();
        DynamicObject selectRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, rowNumber);
        String shownumber = selectRow.getString("shownumber");
        QFilter qFilter = new QFilter("parentnumber", "=", (Object)shownumber);
        DynamicObject[] models = this.getModelDynamicObject(qFilter);
        DynamicObject[] modelPerm = this.getModelPermDynamicObject(models);
        DynamicObjectCollection dynamicObjects = MainSubModelService.getInstance().querySubModel(selectRow.getLong("model"));
        DynamicObject[] allModels = new DynamicObject[models.length + dynamicObjects.size()];
        System.arraycopy(models, 0, allModels, 0, models.length);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            DynamicObject[] unSaveModels = this.createModelData(dynamicObjects);
            System.arraycopy(unSaveModels, 0, allModels, models.length, unSaveModels.length);
        }
        Boolean isAllPerm = this.checkHasAllPerm();
        Set<String> hasChildModel = this.hasChildModel(allModels);
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        this.getModel().batchInsertEntryRow(TREEENTRYENTITY, rowNumber, allModels.length);
        int i = 0;
        int newRow = rowNumber + 1;
        while (i < allModels.length) {
            this.renderTreeView(allModels[i], newRow, hasChildModel, false, isAllPerm, modelPerm);
            ++i;
            ++newRow;
        }
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    private DynamicObject[] createModelData(DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return new DynamicObject[0];
        }
        DynamicObject[] result = new DynamicObject[dynamicObjects.size()];
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)EBMODEL);
            model.set("id", (Object)dynamicObject.getLong("id"));
            model.set("shownumber", (Object)dynamicObject.getString("number"));
            model.set("name", (Object)dynamicObject.getString("name"));
            model.set("startfy", (Object)dynamicObject.getString("startfy"));
            model.set("mainsubstatus", (Object)"0");
            model.set("reporttype", (Object)"7");
            model.set("description", (Object)dynamicObject.getString("text"));
            result[i] = model;
        }
        return result;
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    private void initTreeView(List<QFilter> qFilters) {
        ArrayList level = Lists.newArrayList((Object[])new Integer[]{0, 1});
        QFilter qFilter = new QFilter("level", "in", (Object)level);
        if (CollectionUtils.isNotEmpty(qFilters)) {
            for (QFilter filter : qFilters) {
                qFilter.and(filter);
            }
        }
        DynamicObject[] models = this.getModelDynamicObject(this.setFilter(qFilter));
        DynamicObject[] modelPerm = this.getModelPermDynamicObject(models);
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        if (models.length > 0) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(TREEENTRYENTITY, models.length);
            Boolean isAllPerm = this.checkHasAllPerm();
            Set<String> hasChildModel = this.hasChildModel(models);
            for (int i = 0; i < models.length; ++i) {
                this.renderTreeView(models[i], i, hasChildModel, true, isAllPerm, modelPerm);
            }
            this.getModel().endInit();
            this.getView().updateView(TREEENTRYENTITY);
        }
    }

    private void renderTreeView(DynamicObject dynamicObject, int rowKey, Set<String> hasChildModel, Boolean onlyParent, Boolean isAllPerm, DynamicObject[] modelPerm) {
        String permcontrol;
        int level;
        if (dynamicObject == null) {
            return;
        }
        if (onlyParent.booleanValue() && ((level = dynamicObject.getInt("level")) == 2 || level == 3)) {
            return;
        }
        DynamicObject row = this.getModel().getEntryRowEntity(TREEENTRYENTITY, rowKey);
        long modelId = dynamicObject.getLong("id");
        row.set("model", (Object)modelId);
        row.set("shownumber", (Object)dynamicObject.getString("shownumber"));
        row.set("name", (Object)dynamicObject.getString("name"));
        row.set("mainsubstatus", (Object)(dynamicObject.containsProperty("mainsubstatus") ? "0" : "1"));
        row.set("startfy", (Object)dynamicObject.getString("startfy"));
        row.set("reporttype", (Object)dynamicObject.getString("reporttype"));
        row.set("description", (Object)dynamicObject.getString("description"));
        row.set("syncstatus", (Object)dynamicObject.getString("syncstatus"));
        row.set("syncdate", (Object)dynamicObject.getDate("syncdate"));
        row.set("lastsyncuser", (Object)dynamicObject.getString("lastsyncuser"));
        row.set("creator", (Object)dynamicObject.getString("creator.name"));
        row.set("createtime", (Object)dynamicObject.getDate("createtime"));
        Optional<DynamicObject> model = Arrays.stream(modelPerm).filter(e -> modelId == e.getLong("model.id")).findFirst();
        if (model.isPresent()) {
            DynamicObject modelDynamicObject = model.get();
            DynamicObjectCollection modelPermEntry = modelDynamicObject.getDynamicObjectCollection("modelpermentry");
            String permUserNames = modelPermEntry.stream().map(e -> e.getString("eusers.name")).collect(Collectors.joining(","));
            row.set("perm", (Object)permUserNames);
        }
        if (StringUtils.isEmpty((String)(permcontrol = dynamicObject.getString("permcontrol"))) && isAllPerm.booleanValue()) {
            dynamicObject.set("permcontrol", (Object)2);
        }
        row.set("permcontrol", (Object)dynamicObject.getString("permcontrol"));
        if (hasChildModel.contains(row.getString("shownumber"))) {
            row.set("isgroupnode", (Object)true);
        }
    }

    private Boolean checkHasAllPerm() {
        String sql = "select fid from t_perm_superuser where fuserid = " + UserUtils.getUserId();
        try (DataSet ds = DB.queryDataSet((String)"queryPerm", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            if (ds.hasNext()) {
                Boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private Set<String> hasChildModel(DynamicObject[] models) {
        HashSet<String> set = new HashSet<String>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<String> showNumbers = new HashSet<String>(16);
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : models) {
            ids.add(dynamicObject.getLong("id"));
            showNumbers.add(dynamicObject.getString("shownumber"));
            map.put(dynamicObject.getLong("id"), dynamicObject.getString("shownumber"));
        }
        set.addAll(this.getSaveHasChildModel(showNumbers));
        Set<Long> hasChildModelIds = MainSubModelService.getInstance().queryHasSubModel(ids);
        for (Long id : hasChildModelIds) {
            if (!map.containsKey(id)) continue;
            set.add((String)map.get(id));
        }
        return set;
    }

    private Set<String> getSaveHasChildModel(Set<String> shownumbers) {
        HashSet<String> set = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(shownumbers)) {
            QFilter qFilter = new QFilter("parentnumber", "in", shownumbers);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)EBMODEL, (String)"parentnumber", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                set.add(dynamicObject.getString("parentnumber"));
            }
        }
        return set;
    }

    private DynamicObject[] getModelDynamicObject(QFilter qFilter) {
        String selectStr = "id,name,shownumber,permcontrol,startfy,reporttype,description,syncstatus,syncdate,lastsyncuser,parentnumber,level,currentmode,creator.name,createtime";
        DynamicObject[] models = BusinessDataServiceHelper.load((String)EBMODEL, (String)selectStr, (QFilter[])qFilter.toArray(), (String)"modifytime desc");
        this.beforePackDate(models);
        return models;
    }

    private DynamicObject[] getModelPermDynamicObject(DynamicObject[] models) {
        List modelIds = Arrays.stream(models).map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter qcfPerm = new QFilter("model", "in", modelIds);
        return BusinessDataServiceHelper.load((String)"epm_modelperm", (String)"model, modelpermentry, modelpermentry.eusers", (QFilter[])new QFilter[]{qcfPerm});
    }

    private void openModelPermPage(int row) {
        boolean isSave = StringUtils.equals((String)"1", (String)String.valueOf(this.getModel().getValue("mainsubstatus", row)));
        if (isSave) {
            FormShowParameter showParameter;
            Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model", row));
            Set modelIds = MemberPermHelper.getLimitedModelListByUser();
            if (!modelIds.contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f%1\u7684\u4f53\u7cfb\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u8be5\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"BgmdModelList_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getModel().getValue("name", row)}));
                return;
            }
            HashMap<String, String> openParameter = new HashMap<String, String>();
            openParameter.put("formId", "epm_modelperm");
            QFilter qcfPerm = new QFilter("model", "=", (Object)modelId);
            if (!QueryServiceHelper.exists((String)"epm_modelperm", (QFilter[])new QFilter[]{qcfPerm})) {
                showParameter = FormShowParameter.createFormShowParameter(openParameter);
                showParameter.setCustomParam("model", (Object)modelId);
                showParameter.setStatus(OperationStatus.ADDNEW);
            } else {
                DynamicObject perm = QueryServiceHelper.queryOne((String)"epm_modelperm", (String)"id", (QFilter[])new QFilter[]{qcfPerm});
                openParameter.put("pkId", perm.getString("id"));
                showParameter = FormShowParameter.createFormShowParameter(openParameter);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("modelName", this.getModel().getValue("name", row));
                showParameter.setCustomParam("modelId", (Object)String.valueOf(modelId));
            }
            showParameter.setCaption(ResManager.loadKDString((String)"\u4f53\u7cfb\u7ba1\u7406\u5458", (String)"BgmdModelList_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DISTRIBUTE);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u4e0b\u65e0\u6cd5\u6307\u5b9a\u7ba1\u7406\u5458\u3002", (String)"BgmdMainSubModelList_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforePackDate(DynamicObject[] models) {
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        Set roleModel = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)EBMODEL, (ApplicationTypeEnum)application);
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        for (DynamicObject object : models) {
            object.set("permcontrol", null);
            if (manageModelIds.contains(object.getLong("id"))) {
                object.set("permcontrol", (Object)"1");
                continue;
            }
            if (!roleModel.contains(object.getLong("id"))) continue;
            object.set("permcontrol", (Object)"2");
        }
    }

    private QFilter setFilter(QFilter qFilter) {
        if (qFilter == null) {
            qFilter = new QFilter("enable", "=", (Object)true);
        } else {
            qFilter.and("enable", "=", (Object)true);
        }
        if (this.noNeedDefaultQFilter()) {
            return qFilter;
        }
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        String billNumber = this.getParentBillNumber();
        if ("epm_user_assignperm".equals(billNumber)) {
            IFormView view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (EBMODEL.equals(view.getPageCache().get("FormShowParam_CtrlType_EntityNum"))) {
                qFilter.and(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()).or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getIndex())).or(new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex())));
            }
            Set ids = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getParentView().getEntityId(), (ApplicationTypeEnum)application);
            Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
            ids.addAll(manageModelIds);
            qFilter.and(new QFilter("id", "in", (Object)ids));
        } else {
            Object appId = this.getView().getFormShowParameter().getCustomParam("special_appId");
            QFilter qcf = appId == null ? ModelUtil.getModelQfilterByApp((IFormView)this.getView()) : new QFilter("ReportType", "=", (Object)appId.toString());
            qFilter.and(qcf);
            String entityId = this.getParentBillNumber();
            Set ids = FunPermissionHelper.getEffectiveByPermModel((String)entityId, (ApplicationTypeEnum)application);
            Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
            Set perRoleids = "epm_variablemanager".equals(billNumber) ? FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)EBMODEL, (ApplicationTypeEnum)application, (String)billNumber, (String)"47150e89000000ac") : FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)EBMODEL, (ApplicationTypeEnum)application);
            ids.addAll(manageModelIds);
            ids.addAll(perRoleids);
            this.getAllModelByIds(ids, ids);
            qFilter.and(new QFilter("id", "in", (Object)ids));
        }
        return qFilter;
    }

    private void getAllModelByIds(Set<Long> ids, Set<Long> subIds) {
        if (CollectionUtils.isNotEmpty(subIds)) {
            QFilter qFilter = new QFilter("id", "in", subIds);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EBMODEL, (String)"id,parentnumber,shownumber", (QFilter[])qFilter.toArray());
            HashSet<String> set = new HashSet<String>(16);
            subIds = new HashSet<Long>(16);
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (StringUtils.isNotEmpty((String)dynamicObject.getString("parentnumber"))) {
                        set.add(dynamicObject.getString("parentnumber"));
                    }
                    ids.add(dynamicObject.getLong("id"));
                }
                QFilter sub = new QFilter("shownumber", "in", set);
                DynamicObjectCollection subs = QueryServiceHelper.query((String)EBMODEL, (String)"id,parentnumber,shownumber", (QFilter[])sub.toArray());
                for (DynamicObject dynamicObject : subs) {
                    subIds.add(dynamicObject.getLong("id"));
                }
                if (CollectionUtils.isNotEmpty((Collection)subs)) {
                    this.getAllModelByIds(ids, subIds);
                }
            }
        }
    }

    private String getParentBillNumber() {
        IFormView view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (view == null) {
            return "";
        }
        String source = view.getEntityId();
        if (view instanceof ListView && "bos_list".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_treelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        }
        return source;
    }

    private boolean noNeedDefaultQFilter() {
        return this.getView().getFormShowParameter().getCustomParam("noNeedDefaultQFilter") != null;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter listShowParameter = (FormShowParameter)e.getSource();
        String appId = listShowParameter.getAppId();
        String formId = listShowParameter.getFormId();
        String type = (String)listShowParameter.getCustomParam("modelType");
        if ("old".equals(type)) {
            return;
        }
        if ("new".equals(type)) {
            listShowParameter.setCustomParam("newEbForm", (Object)"true");
            return;
        }
        if (!"bos_list".equals(formId)) {
            return;
        }
        ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByNumber((String)appId);
        if (ApplicationTypeEnum.BGMD == app) {
            return;
        }
        QFilter qFilter = new QFilter("ReportType", "=", (Object)"4");
        qFilter.or("ReportType", "=", (Object)"6");
        DynamicObjectCollection models = QueryServiceHelper.query((String)EBMODEL, (String)"ReportType", (QFilter[])new QFilter[]{qFilter});
        if (models.size() == 0) {
            listShowParameter.setCustomParam("newEbForm", (Object)"true");
            return;
        }
        boolean isNewEb = false;
        for (DynamicObject model : models) {
            String reportType = model.getString("ReportType");
            if (!ApplicationTypeEnum.BG.getIndex().equals(reportType)) continue;
            isNewEb = true;
            break;
        }
        if (isNewEb) {
            listShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
    }

    private boolean isEb() {
        return "eb".equals(this.getView().getFormShowParameter().getAppId());
    }

    private void openQueryData(String key, Long modelId) {
        FormShowParameter formShow = new FormShowParameter();
        if (BTNQUERYDATA.equals(key)) {
            formShow.setFormId("epm_dataanalyse");
        } else if ("btndeletedata".equals(key)) {
            formShow.setFormId("eb_datadelete");
        }
        formShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShow.setCustomParam("MODELID", (Object)modelId);
        formShow.setPageId(formShow.getFormId() + "_" + modelId + "_" + this.getView().getPageId());
        this.getView().showForm(formShow);
    }

    private void searchModel(List<QFilter> fastQFilters) {
        if (CollectionUtils.isEmpty(fastQFilters)) {
            return;
        }
        String searchValue = String.valueOf(fastQFilters.get(0).getValue());
        log.info("searchValueBefore:" + searchValue);
        searchValue = searchValue.trim().substring(searchValue.indexOf("#") + 1).toLowerCase().replace("%", "");
        Set<String> matchModelNumber = this.getMatchModelNumber(searchValue);
        log.info("searchValueAfter:" + searchValue);
        log.info("matchModelNumber:" + SerializationUtils.toJsonString(matchModelNumber));
        ArrayList<Integer> needDelRows = new ArrayList<Integer>(10);
        HashSet<Long> needExpandNodeIds = new HashSet<Long>(16);
        int i = 0;
        while (this.getModel().getEntryRowEntity(TREEENTRYENTITY, i) != null) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, i);
            String curModelNumber = rowEntity.getString("shownumber");
            if (matchModelNumber.contains(curModelNumber)) {
                needExpandNodeIds.add(rowEntity.getLong("pid"));
                if (rowEntity.getBoolean("isgroupnode")) {
                    TreeNodeEvent treeNodeEvent = new TreeNodeEvent((Object)this.getControl(TREEENTRYENTITY), rowEntity.get("pid"), rowEntity.get("id"));
                    treeNodeEvent.setRowKey(i);
                    this.queryTreeNodeChildren(treeNodeEvent);
                }
            } else {
                needDelRows.add(i);
            }
            ++i;
        }
        if (CollectionUtils.isNotEmpty(needDelRows)) {
            this.getModel().deleteEntryRows(TREEENTRYENTITY, needDelRows.stream().mapToInt(Integer::valueOf).toArray());
        }
        this.getView().updateView(TREEENTRYENTITY);
        ArrayList<Integer> needExpandRows = new ArrayList<Integer>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        ArrayList<String> records = new ArrayList<String>(10);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                records.add(object.getString("shownumber") + ":" + object.getString("seq"));
                if (!object.getBoolean("isgroupnode") || !needExpandNodeIds.contains(object.getLong("id"))) continue;
                needExpandRows.add(object.getInt("seq") - 1);
            }
        }
        log.info("newRecords:" + SerializationUtils.toJsonString(records));
        log.info("needExpandRows:" + SerializationUtils.toJsonString(needExpandRows));
        if (CollectionUtils.isNotEmpty(needExpandRows)) {
            TreeEntryGrid control = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            control.expandOne(needExpandRows.stream().mapToInt(Integer::valueOf).toArray());
        }
    }

    private Set<String> getMatchModelNumber(String searchValue) {
        HashSet<String> matchMainModelNumber = new HashSet<String>(16);
        HashMap<String, SimpleObject> modelObjects = new HashMap<String, SimpleObject>(16);
        DynamicObjectCollection models = this.getModel().getEntryEntity(TREEENTRYENTITY);
        HashSet<String> mainModelNumbers = new HashSet<String>(10);
        if (CollectionUtils.isNotEmpty((Collection)models)) {
            for (DynamicObject rowEntity : models) {
                if (!"0".equals(rowEntity.getString("pid"))) continue;
                String showNumber = rowEntity.getString("shownumber");
                mainModelNumbers.add(showNumber);
                modelObjects.put(showNumber, new SimpleObject(rowEntity.getLong("id"), rowEntity.getString("name"), rowEntity.getString("shownumber")));
            }
        }
        HashMap<String, String> parentMap = new HashMap<String, String>(16);
        while (CollectionUtils.isNotEmpty(mainModelNumbers)) {
            QFilter qf = new QFilter("parentnumber", "in", mainModelNumbers);
            DynamicObjectCollection query = QueryServiceHelper.query((String)EBMODEL, (String)"id,parentnumber,shownumber,name", (QFilter[])qf.toArray());
            QFBuilder qfBuilder = new QFBuilder("mainmodel.shownumber", "in", mainModelNumbers);
            qfBuilder.and("status", "=", (Object)false);
            DynamicObjectCollection stashModels = QueryServiceHelper.query((String)"eb_mainsubmodel_base", (String)"id,name,number,mainmodel.shownumber", (QFilter[])qfBuilder.toArray());
            mainModelNumbers.clear();
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                for (DynamicObject object : query) {
                    String showNumber = object.getString("shownumber");
                    parentMap.put(showNumber, object.getString("parentnumber"));
                    modelObjects.put(showNumber, new SimpleObject(object.getLong("id"), object.getString("name"), showNumber));
                    mainModelNumbers.add(showNumber);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)stashModels)) continue;
            for (DynamicObject object : stashModels) {
                String number = object.getString("number");
                parentMap.put(number, object.getString("mainmodel.shownumber"));
                modelObjects.put(number, new SimpleObject(object.getLong("id"), object.getString("name"), number));
                mainModelNumbers.add(number);
            }
        }
        if (modelObjects.size() > 0) {
            for (Map.Entry entry : modelObjects.entrySet()) {
                SimpleObject value = (SimpleObject)entry.getValue();
                String number = value.getNumber();
                String name = value.getName();
                if (number == null || name == null || !value.getNumber().toLowerCase().contains(searchValue) && !value.getName().toLowerCase().contains(searchValue)) continue;
                String mainModelNumber = value.getNumber();
                matchMainModelNumber.add(mainModelNumber);
                while (parentMap.containsKey(mainModelNumber)) {
                    mainModelNumber = (String)parentMap.get(mainModelNumber);
                    matchMainModelNumber.add(mainModelNumber);
                }
            }
        }
        return matchMainModelNumber;
    }
}

