/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MapUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dimension.view.OrganizationViewEditPlugin;
import org.apache.commons.collections.CollectionUtils;

public class MainSubCheckUtils
extends OrganizationViewEditPlugin {
    private static final String PRESET = "1";
    private static final String CUR_LEVEL = "curlevel";
    private static final String SOURCE = "source";
    private static final String NUMBER = "vnumber";
    private static final String NAME = "vname";
    private static final String RANGE = "range";
    private static final String LEVEL = "level";
    private static final String MEMBERID = "memberid";
    private static final String VIEWTYPES = "viewTypes";
    private static final String CURVIEWID = "curViewId";
    public static final String breakLevelMemberInfo = "breakLevelMemberInfo";
    public static final String onlyVirtualMemberInfo = "onlyVirtualMemberInfo";

    @Override
    public void setView(IFormView formView) {
        super.setView(formView);
    }

    @Override
    protected void initLeftTree() {
        String selectFields;
        TreeNode rootLeft = new TreeNode();
        Long dimensionId = this.getDimensionId();
        DynamicObjectCollection members = this.getRootViewDimMembers(dimensionId, selectFields = "id,number,name,longnumber,parent,level,isleaf,aggoprt,dseq,enable,disable,status,membersource", false);
        if (members.isEmpty()) {
            return;
        }
        DynamicObject leftRoot = (DynamicObject)members.iterator().next();
        String leftRootId = leftRoot.getString("id");
        String name = leftRoot.getString("name");
        List<Map<String, String>> memberMapList = this.createMemberMapList(members, false);
        rootLeft.setId(leftRootId);
        rootLeft.setText(leftRoot.getString("number") + " " + name);
        Map<String, String> memberMap = this.createMap(leftRoot);
        rootLeft.setData(memberMap);
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootLeft));
        HashMap<String, String> leftIds = new HashMap<String, String>(16);
        this.setTreeNode(rootLeft, memberMapList, leftIds);
        this.setTreeCache("lefttreeview", rootLeft);
    }

    @Override
    protected DynamicObjectCollection getRootViewDimMembers(Long dimId, String selectFields, boolean checkDisable) {
        QFilter dimQf = new QFilter("dimension", "=", (Object)dimId);
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        if (SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber())) {
            dimQf.and(new QFilter("isoffsetentry", "=", (Object)false));
        }
        if (SysDimensionEnum.Account.getNumber().equals(this.getDimensionNumber())) {
            dimQf.and(new QFilter("dataset", "in", (Object)Sets.newHashSet((Object[])new Long[]{0L, this.getCurView()}).toArray()));
            return QueryServiceHelper.query((String)DimensionServiceHelper.getMemberKeyByDimNum((String)this.getDimensionNumber()), (String)selectFields, (QFilter[])new QFilter[]{dimQf, modelQf}, (String)"parent,dseq");
        }
        if (SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber()) || !SysDimensionEnum.include((String)this.getDimensionNumber(), (Boolean)true)) {
            selectFields = selectFields + ",simplename";
        }
        String dimensionNumber = this.getDimensionNumber();
        String viewId = this.getPageCache().get(CURVIEWID);
        if (!"0".equals(viewId)) {
            dimQf.and(new QFilter("view", "=", (Object)IDUtils.toLong((Object)viewId)));
            return QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])new QFilter[]{dimQf, modelQf}, (String)"parent,dseq");
        }
        dimQf.and(new QFilter("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex()));
        QFilter[] filters = new QFilter[]{dimQf, modelQf};
        String entity = DimensionServiceHelper.getMemberKeyByDimNum((String)dimensionNumber);
        if (entity.equals("epm_userdefinedmembertree")) {
            this.getNoneMember();
        }
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters, (String)"parent,dseq");
    }

    private Long getCurView() {
        return IDUtils.toLong((Object)this.getPageCache().get(CURVIEWID));
    }

    public List<String> checkVirtualNode(String dimensionNumber, Long viewId, Map<String, TreeNode> nodeMap) {
        ArrayList<String> result = new ArrayList<String>(16);
        if (StringUtils.isEmpty((String)dimensionNumber) || viewId == null || nodeMap == null || nodeMap.size() == 0) {
            return result;
        }
        String entity = DimensionServiceHelper.getMemberKeyByDimNum((String)dimensionNumber);
        if ((entity.equals("epm_entitymembertree") || entity.equals("epm_userdefinedmembertree")) && viewId.compareTo(0L) > 0) {
            for (Map.Entry<String, TreeNode> nodeEntry : nodeMap.entrySet()) {
                String membersource = (String)((Map)nodeEntry.getValue().getData()).get("membersource");
                if (PRESET.compareTo(membersource) != 0) continue;
                boolean isExist = false;
                List childrens = nodeEntry.getValue().getChildren();
                if (childrens == null || childrens.size() == 0) {
                    result.add(nodeEntry.getValue().getId() + "&:" + nodeEntry.getValue().getText());
                    continue;
                }
                for (TreeNode children : childrens) {
                    if (!nodeMap.containsKey(children.getId())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                result.add(nodeEntry.getValue().getId() + "&:" + nodeEntry.getValue().getText());
            }
        }
        return result;
    }

    public List<String> checkTreeLevelBreak(IFormView formView, String dimensionNumber, Long viewId, Set<Long> selectedIds) {
        ArrayList<String> result = new ArrayList<String>(16);
        this.setView(formView);
        this.getPageCache().put("dimensionNumber", dimensionNumber);
        this.getPageCache().put(CURVIEWID, viewId.toString());
        this.initLeftTree();
        DynamicObjectCollection members = this.getSelectedMembers(selectedIds, dimensionNumber, viewId);
        Map<String, Map<String, TreeNode>> breakLevelAndOnlyVirtualMemberInfo = this.getBreakLevelAndOnlyVirtualMemberInfo(members);
        Map<String, TreeNode> breakLevelMemberInfoMap = breakLevelAndOnlyVirtualMemberInfo.get(breakLevelMemberInfo);
        if (CollectionUtils.isEmpty(result) && breakLevelMemberInfoMap != null && members.size() != breakLevelMemberInfoMap.size()) {
            for (Map.Entry<String, TreeNode> entry : breakLevelMemberInfoMap.entrySet()) {
                TreeNode value = entry.getValue();
                result.add(value.getId() + ":" + value.getText());
            }
        }
        return result;
    }

    private Map<String, Map<String, TreeNode>> getBreakLevelAndOnlyVirtualMemberInfo(DynamicObjectCollection dynamicObjects) {
        HashMap<String, Map<String, TreeNode>> result = new HashMap<String, Map<String, TreeNode>>(16);
        Map breakLevelMemberInfoMap = result.computeIfAbsent(breakLevelMemberInfo, t -> new HashMap(16));
        Map onlyVirtualMemberInfoMap = result.computeIfAbsent(onlyVirtualMemberInfo, t -> new HashMap(16));
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return new LinkedHashMap<String, Map<String, TreeNode>>(16);
        }
        TreeNode leftRoot = this.getCacheTree("lefttreeview");
        HashMap<String, Integer> levelMap = new HashMap<String, Integer>(dynamicObjects.size());
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(dynamicObjects.size());
        boolean rootIsSelf = false;
        boolean isUserDim = this.isUserDimension();
        String noneMemberId = null;
        String rootId = "";
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (isUserDim && 2 == dynamicObject.getInt(CUR_LEVEL) && PRESET.equals(dynamicObject.getString(SOURCE))) {
                noneMemberId = dynamicObject.getString(MEMBERID);
                continue;
            }
            levelMap.put(dynamicObject.getString(MEMBERID), dynamicObject.getInt(CUR_LEVEL));
            if (StringUtils.isEmpty((String)dynamicObject.getString(LEVEL))) {
                if (!rootIsSelf && PRESET.equals(dynamicObject.getString(SOURCE))) {
                    rootIsSelf = true;
                    rootId = dynamicObject.getString(MEMBERID);
                }
                rangeMap.put(dynamicObject.getString(MEMBERID), 0);
                continue;
            }
            rangeMap.put(dynamicObject.getString(MEMBERID), dynamicObject.getInt(LEVEL));
        }
        LinkedHashMap<String, TreeNode> nodeMap = new LinkedHashMap<String, TreeNode>();
        Map mapLevelOrder = MapUtils.sortByValueAsc(levelMap);
        int secondLevel = -1;
        if (rootIsSelf && mapLevelOrder.size() > 1) {
            int i = 2;
            for (Map.Entry entry : mapLevelOrder.entrySet()) {
                if (i > 0 && (Integer)entry.getValue() > 2) {
                    secondLevel = (Integer)entry.getValue();
                    break;
                }
                --i;
            }
        }
        for (Map.Entry entry : mapLevelOrder.entrySet()) {
            String memberId = (String)entry.getKey();
            TreeNode node = leftRoot.getTreeNode(memberId);
            if (secondLevel == (Integer)entry.getValue() && node != null) {
                ((Map)node.getData()).put("parent", rootId);
            }
            int level = (Integer)rangeMap.get(memberId);
            Map<String, TreeNode> map = this.getNodesByLevel(node, level);
            if (nodeMap.size() == 0) {
                nodeMap.putAll(map);
                continue;
            }
            for (Map.Entry<String, TreeNode> nodeEntry : map.entrySet()) {
                Map dataMap = (Map)nodeEntry.getValue().getData();
                if (nodeMap.containsKey(nodeEntry.getKey())) continue;
                if (dataMap != null && nodeMap.containsKey(dataMap.get("parent"))) {
                    nodeMap.put(nodeEntry.getKey(), nodeEntry.getValue());
                    continue;
                }
                breakLevelMemberInfoMap.put(nodeEntry.getKey(), nodeEntry.getValue());
            }
        }
        if (StringUtils.isNotEmpty(noneMemberId)) {
            TreeNode noneNode = leftRoot.getTreeNode(noneMemberId);
            LinkedHashMap nodeMap1 = new LinkedHashMap();
            if (nodeMap.entrySet().iterator().hasNext()) {
                Map.Entry rootEntry = nodeMap.entrySet().iterator().next();
                nodeMap1.put(rootEntry.getKey(), rootEntry.getValue());
                nodeMap1.put(noneMemberId, noneNode);
                nodeMap.remove(rootEntry.getKey());
                nodeMap1.putAll(nodeMap);
                onlyVirtualMemberInfoMap.putAll(nodeMap1);
            }
        } else {
            onlyVirtualMemberInfoMap.putAll(nodeMap);
        }
        onlyVirtualMemberInfoMap.putAll(breakLevelMemberInfoMap);
        return result;
    }

    private DynamicObjectCollection getSelectedMembers(Set<Long> selectedIds, String dimensionNumber, Long viewId) {
        TreeNode leftRoot = this.getCacheTree("lefttreeview");
        ArrayList<TreeNode> actSelectNodes = new ArrayList<TreeNode>(16);
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber) && !selectedIds.contains(Long.parseLong(leftRoot.getId()))) {
            actSelectNodes.add(leftRoot.getTreeNode(leftRoot.getId()));
        }
        for (Long id : selectedIds) {
            TreeNode selectNode = leftRoot.getTreeNode(id.toString(), 20);
            actSelectNodes.add(selectNode);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)viewId).toArray());
        String viewNumber = "";
        if (dynamicObject != null) {
            viewNumber = dynamicObject.getString("number");
        }
        int index = 1;
        DynamicObject dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_organizationview"));
        DynamicObjectCollection dyCols = (DynamicObjectCollection)dy.get("entryentity");
        if (actSelectNodes.size() > 0) {
            for (TreeNode actSelectNode : actSelectNodes) {
                if (actSelectNode == null) continue;
                DynamicObject addNew = dyCols.addNew();
                Map map = (Map)actSelectNode.getData();
                addNew.set("seq", (Object)index);
                addNew.set(MEMBERID, map.get("id"));
                addNew.set(NUMBER, map.get("number"));
                addNew.set(NAME, map.get("name"));
                addNew.set(RANGE, (Object)"0");
                addNew.set(LEVEL, null);
                addNew.set(CUR_LEVEL, map.get(LEVEL));
                addNew.set(SOURCE, (Object)(this.getDimensionNumber().equals(map.get("number")) || (this.getDimensionNumber() + "_" + viewNumber).equals(map.get("number")) ? PRESET : "0"));
                ++index;
            }
        }
        return dyCols;
    }
}

