/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelThread;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractListPlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubListDataFilterUtil;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import kd.epm.eb.formplugin.sonmodel.sync.service.BgmdMainSubModelSyncService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MainSubModelBizrulePlugin
extends MainSubAbstractListPlugin
implements TreeNodeClickListener,
EBPermission,
CreateListDataProviderListener {
    private static final Log log = LogFactory.getLog(MainSubModelBizrulePlugin.class);
    private static final String BILLLISTKEY = "billlistap";
    private static final String TREE_VIEW_AP = "treeviewap";
    protected static final String MODEL_KEY = "model";
    private static final String LEFT_TREE = "lefttree";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView leftTree = (TreeView)this.getControl(TREE_VIEW_AP);
        leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    protected TreeView getLeftTreeView() {
        return (TreeView)this.getControl(TREE_VIEW_AP);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long modelId = this.getModelId();
        e.getQFilters().add(new QFilter(MODEL_KEY, "=", (Object)modelId));
        TreeNode currentNode = this.getClickNodeFromCache();
        if (currentNode != null) {
            log.info("currentNode:" + SerializationUtils.toJsonString((Object)currentNode));
            String id = currentNode.getParentid();
            if (!"0".equals(id) && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)id)) {
                ArrayList bizrulesetIds = new ArrayList(16);
                LinkedHashSet<String> templateIds = new LinkedHashSet<String>();
                this.getAllChildrenIds(templateIds, currentNode);
                Set<Long> collect = templateIds.stream().mapToLong(Long::parseLong).boxed().collect(Collectors.toSet());
                ConcurrentHashMap<Long, List<Long>> tempRules = DataModelThread.getInstance().getBizByTemplate(collect, modelId);
                for (Map.Entry<Long, List<Long>> entry : tempRules.entrySet()) {
                    bizrulesetIds.addAll(entry.getValue());
                }
                e.getQFilters().add(new QFilter("id", "in", bizrulesetIds));
            }
            if (MainSubModelService.getInstance().isMainModel(this.getView())) {
                e.getQFilters().add(new QFilter("rulebatch", "=", (Object)0L));
            }
        }
    }

    private void getAllChildrenIds(Set<String> ids, TreeNode curNode) {
        List children;
        Map data;
        String type;
        if (curNode == null) {
            return;
        }
        if (curNode.getData() != null && "1".equals(type = (String)(data = (Map)curNode.getData()).get("type"))) {
            ids.add(curNode.getId());
        }
        if (CollectionUtils.isEmpty((Collection)(children = curNode.getChildren()))) {
            return;
        }
        for (TreeNode child : children) {
            Map data2;
            String type2;
            if (child.getData() != null && "1".equals(type2 = (String)(data2 = (Map)child.getData()).get("type"))) {
                ids.add(child.getId());
            }
            this.getAllChildrenIds(ids, child);
        }
    }

    private TreeNode getClickNodeFromCache() {
        String treeNode = this.getPageCache().get("clickNodeCache");
        return StringUtils.isBlank((String)treeNode) ? null : (TreeNode)SerializationUtils.fromJsonString((String)treeNode, TreeNode.class);
    }

    private void putClickNodeToCache(TreeNode clickNode) {
        this.getPageCache().put("clickNodeCache", SerializationUtils.toJsonString((Object)clickNode));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String id = evt.getNodeId().toString();
        TreeNode root = this.getLeftRootFromCache();
        if (root != null) {
            this.putClickNodeToCache(root.getTreeNode(id, 20));
        }
        this.initBillList();
    }

    private TreeNode getLeftRootFromCache() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(LEFT_TREE), TreeNode.class);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getModelId();
        if (!IDUtils.isNotNull((Long)this.getModelId()) && !this.isSubModelSync()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"MainSubModelBizrulePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.pageRefresh();
        this.setMainSubModelSyncVisible();
    }

    private void setMainSubModelSyncVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isSubModelSync()), new String[]{"syncdate", "syncstatus"});
    }

    private boolean isSubModelSync() {
        Object isSync = this.getView().getFormShowParameter().getCustomParam("isSync");
        if (isSync instanceof Boolean) {
            return (Boolean)isSync;
        }
        return false;
    }

    private void pageRefresh() {
        this.initLeftTemplateTree();
        this.initBillList();
    }

    @Override
    public Long getModelId() {
        return MainSubModelService.getInstance().getSourceModelId(this.getView());
    }

    private void initLeftTemplateTree() {
        LinkedHashMap<String, String> nodeData;
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        HashSet<Long> catalogIds = new HashSet<Long>(16);
        LinkedHashMap<Long, TreeNode> catalogMap = new LinkedHashMap<Long, TreeNode>(16);
        TreeNode rootNode = null;
        String orderBys = "sequence";
        DynamicObjectCollection templateCatalogCollection = QueryServiceHelper.query((String)"eb_templatecatalog", (String)"id, name, parent", (QFilter[])qFilter.toArray(), (String)orderBys);
        for (DynamicObject dynamicObject : templateCatalogCollection) {
            catalogIds.add(dynamicObject.getLong("id"));
            String parent = dynamicObject.getString("parent");
            TreeNode catalogTreeNode = catalogMap.computeIfAbsent(dynamicObject.getLong("id"), t -> new TreeNode());
            catalogTreeNode.setId(dynamicObject.getString("id"));
            catalogTreeNode.setText(dynamicObject.getString("name"));
            catalogTreeNode.setParentid(parent);
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                rootNode = catalogTreeNode;
            }
            nodeData = new LinkedHashMap<String, String>(16);
            nodeData.put("type", "0");
            catalogTreeNode.setData(nodeData);
        }
        qFilter.and("dataset.businessmodel", "in", this.getBizModels());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"templatecatalog, id, number, name", (QFilter[])qFilter.toArray());
        LinkedHashMap<Long, List> templateMap = new LinkedHashMap<Long, List>(16);
        for (Object dynamicObject : query) {
            long l = dynamicObject.getLong("templatecatalog");
            if (!catalogIds.contains(l)) continue;
            List templateNodes = templateMap.computeIfAbsent(dynamicObject.getLong("templatecatalog"), t -> new ArrayList(16));
            TreeNode template = new TreeNode();
            template.setId(dynamicObject.getString("id"));
            template.setText(dynamicObject.getString("name"));
            template.setParentid(l + "");
            nodeData = new LinkedHashMap(16);
            nodeData.put("type", "1");
            template.setData(nodeData);
            templateNodes.add(template);
        }
        if (rootNode == null) {
            rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList treeNodesInRoot = new ArrayList(16);
        for (Map.Entry entry : catalogMap.entrySet()) {
            Long key = (Long)entry.getKey();
            TreeNode value = (TreeNode)entry.getValue();
            String parentid = value.getParentid();
            TreeNode treeNode = (TreeNode)catalogMap.get(IDUtils.toLong((Object)parentid));
            if (treeNode == null) {
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)parentid) || "0".equals(parentid)) {
                    rootNode = value;
                } else {
                    rootNode.addChild(value);
                }
            } else {
                treeNode.addChild(value);
            }
            List treeNodes = (List)templateMap.get(key);
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)parentid) || "0".equals(parentid)) {
                if (!CollectionUtils.isNotEmpty((Collection)treeNodes)) continue;
                treeNodesInRoot.addAll(treeNodes);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)treeNodes)) continue;
            value.addChildren(treeNodes);
        }
        if (CollectionUtils.isNotEmpty(treeNodesInRoot)) {
            rootNode.addChildren(treeNodesInRoot);
        }
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        if (Objects.equal((Object)0L, (Object)this.getCurModelId())) {
            treeLeft.deleteAllNodes();
            this.getPageCache().remove("clickNodeCache");
            return;
        }
        treeLeft.deleteAllNodes();
        rootNode.setParentid("");
        treeLeft.addNode(rootNode);
        treeLeft.updateNode(rootNode);
        this.spreadAllNode(rootNode);
        this.putLeftRootToCache(rootNode);
        if (CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            treeLeft.focusNode((TreeNode)rootNode.getChildren().get(0));
            this.putClickNodeToCache((TreeNode)rootNode.getChildren().get(0));
        }
    }

    private void initLeftTree() {
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        if (Objects.equal((Object)0L, (Object)this.getCurModelId())) {
            treeLeft.deleteAllNodes();
            this.getPageCache().remove("clickNodeCache");
            return;
        }
        TreeNode leftNode = this.generateTree();
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(leftNode);
        treeLeft.addNode(leftNode);
        this.spreadAllNode(leftNode);
        this.putLeftRootToCache(leftNode);
        TreeNode lastNode = this.getClickNodeFromCache();
        lastNode = lastNode != null ? leftNode.getTreeNode(lastNode.getId(), 20) : (leftNode.getChildren() != null && !leftNode.getChildren().isEmpty() ? (TreeNode)leftNode.getChildren().get(0) : leftNode);
        if (lastNode != null) {
            treeLeft.focusNode(lastNode);
            this.putClickNodeToCache(lastNode);
        } else {
            this.getPageCache().remove("clickNodeCache");
        }
    }

    private Long getCurModelId() {
        DynamicObject curModel = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (curModel == null) {
            return 0L;
        }
        return curModel.getLong("id");
    }

    private void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                this.spreadAllNode(t);
            }
        }
    }

    private void putLeftRootToCache(TreeNode rootleft) {
        this.getPageCache().put(LEFT_TREE, SerializationUtils.toJsonString((Object)rootleft));
    }

    private List<Long> getBizModels() {
        return (List)this.getView().getFormShowParameter().getCustomParam("bizmodel");
    }

    private TreeNode generateTree() {
        QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        List bizmodel = (List)this.getView().getFormShowParameter().getCustomParam("bizmodel");
        if (bizmodel != null && bizmodel.size() > 0) {
            qFilter.and(new QFilter("id", "in", (Object)bizmodel));
        }
        DynamicObjectCollection businessModels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,name", (QFilter[])qFilter.toArray(), (String)"number,createdate");
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setParentid("");
        ArrayList<TreeNode> level2Nodes = new ArrayList<TreeNode>(16);
        ArrayList<Long> businessId = new ArrayList<Long>(businessModels.size());
        for (DynamicObject businessModel : businessModels) {
            businessId.add(businessModel.getLong("id"));
            TreeNode node = new TreeNode();
            String nodeText = businessModel.getString("name");
            node.setId(businessModel.getString("id"));
            node.setText(nodeText);
            node.setParentid("0");
            level2Nodes.add(node);
        }
        root.setChildren(level2Nodes);
        HashMap<String, ArrayList<DynamicObject>> levelNode3 = new HashMap<String, ArrayList<DynamicObject>>(16);
        QFilter qFilter1 = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        qFilter1.and(new QFilter("businessmodel", "in", businessId));
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"eb_dataset", (String)"id,name,businessmodel", (QFilter[])qFilter1.toArray());
        for (DynamicObject dynamicObject : dataSet) {
            String businessmodel = String.valueOf(dynamicObject.getLong("businessmodel"));
            ArrayList<DynamicObject> buss = (ArrayList<DynamicObject>)levelNode3.get(businessmodel);
            if (buss == null) {
                buss = new ArrayList<DynamicObject>(16);
                buss.add(dynamicObject);
                levelNode3.put(businessmodel, buss);
                continue;
            }
            buss.add(dynamicObject);
            levelNode3.put(businessmodel, buss);
        }
        for (TreeNode nonRootNode : level2Nodes) {
            TreeNode node = null;
            String id = nonRootNode.getId();
            List objectList = (List)levelNode3.get(id);
            if (objectList == null) continue;
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
            for (DynamicObject object : objectList) {
                node = new TreeNode();
                node.setId(String.valueOf(object.getLong("id")));
                node.setText(object.getString("name"));
                node.setParentid(id);
                nodes.add(node);
            }
            nonRootNode.setChildren(nodes);
        }
        return root;
    }

    private String getSubModelNumber() {
        Object subModelNumber = this.getView().getFormShowParameter().getCustomParam("subModelNumber");
        if (subModelNumber == null) {
            return "";
        }
        return subModelNumber.toString();
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        List<Long> bizModels = this.getBizModels();
        QFilter qFilter = new QFilter("businessmodel", "in", bizModels);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> datasetIds = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                datasetIds.add(dynamicObject.getLong("id"));
            }
        }
        if (this.isSubModelSync()) {
            args.setListDataProvider((IListDataProvider)new MainSubModelBizRuleCreateListDataProvider(this.getSubModelNumber(), datasetIds));
        } else {
            args.setListDataProvider((IListDataProvider)new MainSubModelBizRuleCreateListDataProvider(datasetIds));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("number".equals(fieldName)) {
            BillList list = (BillList)this.getControl(BILLLISTKEY);
            Long focusRowPkId = (Long)list.getFocusRowPkId();
            Map<Long, DynamicObject> ruleMap = this.getSelectRuleIdAndName(list);
            this.editBizRule(ruleMap, focusRowPkId);
        }
        args.setCancel(true);
    }

    private Map<Long, DynamicObject> getSelectRuleIdAndName(BillList list) {
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> ruleMap = new HashMap<Long, DynamicObject>(16);
        Object[] idObjectArray = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        Map objectMap = list.getModel().loadReferenceDataBatch((DynamicObjectType)list.getEntityType(), idObjectArray);
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            ruleMap.put(value.getLong("id"), value);
        }
        return ruleMap;
    }

    private void editBizRule(Map<Long, DynamicObject> ruleMap, Long ruleId) {
        if (ruleMap.size() == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5728\u4f9d\u8d56\u8ba1\u7b97\u4e2d\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"BizRuleGroupListPlugin2_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("refresh_comfirm", (IFormPlugin)this));
        } else {
            DynamicObject rule;
            if (ruleId == null || ruleId == 0L) {
                ruleId = ruleMap.entrySet().iterator().next().getKey();
            }
            if ((rule = ruleMap.get(ruleId)).getString("syncstatus").compareTo("2") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e3b\u4f53\u7cfb\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u3002", (String)"MainSubModelDataSetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String rulename = rule.getString("name");
            this.editBizRule(ruleId, rulename);
        }
    }

    private void editBizRule(Long bizRuleId, String bizRuleName) {
        HashMap<String, Object> openParameter = new HashMap<String, Object>(16);
        openParameter.put("formId", "eb_rulemanage5");
        openParameter.put("pkid", String.valueOf(bizRuleId));
        openParameter.put("MODELID", this.getModelId());
        List rowMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fgroupid,fbizctrlrangeid from t_eb_bizruleset where fid = ?", (Object[])ObjUtils.getObjectArray((Object[])new Object[]{bizRuleId}));
        Long groupIdLong = null;
        Long bizCtrlRangeId = null;
        if (!CollectionUtils.isNotEmpty((Collection)rowMapList)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5728\u4f9d\u8d56\u8ba1\u7b97\u4e2d\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"BizRuleGroupListPlugin2_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("refresh_comfirm", (IFormPlugin)this));
            return;
        }
        groupIdLong = ObjUtils.getLong(((Map)rowMapList.get(0)).get("fgroupid"));
        bizCtrlRangeId = ObjUtils.getLong(((Map)rowMapList.get(0)).get("fbizctrlrangeid"));
        String pageKeyString = groupIdLong != null && groupIdLong != 0L ? this.getView().getPageId() + groupIdLong : this.getView().getPageId() + bizRuleId;
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        IFormView parentView = this.getView().getParentView();
        showParameter.setParentPageId(parentView == null ? "" : parentView.getPageId());
        showParameter.setPageId(pageKeyString);
        OpenRulePojo openRulePojo = new OpenRulePojo();
        openRulePojo.setModelIdLong(this.getModelId());
        openRulePojo.setRuleIdLongList((List)Lists.newArrayList((Object[])new Long[]{bizRuleId}));
        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber"}).whereIn("fid", (Collection)openRulePojo.getRuleIdLongList()).toRowList();
        Set existRuleIdLongSet = ebBizrulesetList.stream().map(EbBizruleset::getIdLong).collect(Collectors.toSet());
        Collection subtractCollection = CollectionUtils.subtract((Iterable)openRulePojo.getRuleIdLongList(), existRuleIdLongSet);
        if (CollectionUtils.isNotEmpty((Collection)subtractCollection)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"RuleManagePlugin3_9", (String)"epm-eb-formplugin", (Object[])new Object[]{StrUtils.join((String)",", (Collection)subtractCollection)}));
        }
        showParameter.setCustomParam(OpenRulePojo.class.getName(), (Object)JsonUtils.getJsonString((Object)openRulePojo));
        showParameter.setCustomParam("RealParentPageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("!sign_main_sub_model", (Object)"1");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219-%1", (String)"BizRuleGroupListPlugin2_34", (String)"epm-eb-formplugin", (Object[])new Object[]{bizRuleName}));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "eb_bizruleset");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam("parentpageid", (Object)this.getView().getPageId());
        showParameter.setCustomParam("bizModelId", (Object)bizCtrlRangeId);
        this.getView().showForm(showParameter);
    }

    @Override
    protected TreeNode getLeftTreeViewRootNode() {
        String lefttreeStr = this.getPageCache().get(LEFT_TREE);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)lefttreeStr)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)lefttreeStr, TreeNode.class);
    }

    public void setUserSelect(DynamicObjectCollection data, int startIndex) {
        this.getMainSubModelCacheHelper().setUserSelect(data, this.getBillList(), this.getMainSubModelCacheHelper(), startIndex);
    }

    class MainSubModelBizRuleCreateListDataProvider
    extends ListDataProvider {
        private String subModelNumber;
        private final Set<Long> dataSetIds;

        public MainSubModelBizRuleCreateListDataProvider(String subModelNumber, Set<Long> dataSetIds) {
            this.subModelNumber = subModelNumber;
            this.dataSetIds = dataSetIds;
        }

        public MainSubModelBizRuleCreateListDataProvider(Set<Long> dataSetIds) {
            this.dataSetIds = dataSetIds;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = this.getQFilters();
            ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(qFilters.size());
            ArrayList<QFilter> userFilter = new ArrayList<QFilter>(10);
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                if (MainSubListDataFilterUtil.templateProperties.contains(property)) {
                    userFilter.add(qFilter);
                    continue;
                }
                baseFilter.add(qFilter);
            }
            DynamicObjectCollection allRows = super.getData(start, 10000);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
                this.setQFilters(baseFilter);
            } else {
                this.setQFilters(qFilters);
            }
            QueryBuilder queryBuilder = this.getQueryBuilder();
            queryBuilder.setFilters(baseFilter.toArray(new QFilter[0]));
            this.setQueryBuilder(queryBuilder);
            if (CollectionUtils.isNotEmpty(userFilter)) {
                allRows = super.getData(0, this.getRealCount());
            }
            if (allRows == null) {
                MainSubModelBizrulePlugin.this.getMainSubModelCacheHelper().cacheBillListIdAndIndexMap(allRows);
                return null;
            }
            MainSubModelBizrulePlugin.this.getMainSubModelCacheHelper().cacheBillListIdAndIndexMap(allRows);
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)this.subModelNumber)) {
                new BgmdMainSubModelSyncService().renderSyncInfoToBillList(allRows, this.subModelNumber, "eb_bizruleset", userFilter);
            }
            MainSubModelBizrulePlugin.this.setUserSelect(allRows, start);
            Iterator iterator = allRows.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                String bizmodels = next.getString("bizmodels");
                if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)bizmodels) && !this.dataSetIds.contains(IDUtils.toLong((Object)bizmodels)) && !"2".equals(next.getString("syncstatus"))) {
                    iterator.remove();
                }
                next.set("periodoffset", (Object)"");
            }
            this.getQueryResult().setDataCount(allRows.size());
            MainSubModelBizrulePlugin.this.getView().getPageCache().put("realCount", allRows.size() + "");
            return allRows;
        }

        public int getRealCount() {
            String realCount = MainSubModelBizrulePlugin.this.getView().getPageCache().get("realCount");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)realCount)) {
                return Integer.parseInt(realCount);
            }
            return super.getRealCount();
        }
    }
}

