/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.examine.ExamineListPlugin;
import kd.epm.eb.formplugin.sonmodel.MainSubListDataFilterUtil;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import kd.epm.eb.formplugin.sonmodel.sync.service.BgmdMainSubModelSyncService;
import org.apache.commons.collections4.CollectionUtils;

public class MainSubModelExaminePlugin
extends ExamineListPlugin {
    private static final String BILLLISTKEY = "billlistap";
    protected static final String TREE_VIEW_AP = "treeviewap";
    protected static final String CATEGORY_ROOT_CODE = "kingdeeVirtualRoot";

    @Override
    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        this.addTreeNodeClickListener(this, TREE_VIEW_AP);
    }

    @Override
    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        if (this.isSubModelSync()) {
            arg0.setListDataProvider((IListDataProvider)new ExamineListDataProvider(this.getSubModelNumber()));
        } else {
            arg0.setListDataProvider((IListDataProvider)new ExamineListDataProvider());
        }
    }

    private String getSubModelNumber() {
        Object subModelNumber = this.getView().getFormShowParameter().getCustomParam("subModelNumber");
        if (subModelNumber == null) {
            return "";
        }
        return subModelNumber.toString();
    }

    private void setOtherFilter(QFilter qf) {
        List bizmodel;
        if (MainSubModelService.getInstance().isMainModel(this.getView()) && (bizmodel = (List)this.getView().getFormShowParameter().getCustomParam("bizmodel")) != null && bizmodel.size() > 0) {
            qf.and(new QFilter("id", "in", (Object)bizmodel));
        }
    }

    @Override
    protected TreeView getLeftTreeView() {
        return (TreeView)this.getControl(TREE_VIEW_AP);
    }

    @Override
    protected TreeNode getLeftTreeViewRootNode() {
        String lefttreeStr = this.getPageCache().get("lefttree");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)lefttreeStr)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)lefttreeStr, TreeNode.class);
    }

    public void setUserSelect(DynamicObjectCollection data, int startIndex) {
        this.getMainSubModelCacheHelper().setUserSelect(data, this.getBillList(), this.getMainSubModelCacheHelper(), startIndex);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        this.examineGroupTabFilter(e);
        e.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        if (MainSubModelService.getInstance().isMainModel(this.getView())) {
            String dataSet = (String)this.getView().getFormShowParameter().getCustomParam("dataSet");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dataSet)) {
                Set set = (Set)SerializationUtils.fromJsonString((String)dataSet, Set.class);
                e.getQFilters().add(new QFilter("id", "in", (Object)set));
            } else {
                e.getQFilters().add(new QFilter("1", "!=", (Object)1));
            }
        }
    }

    @Override
    protected Long getModelIdAfterCreateNewData() {
        MainSubModelService.getInstance().checkSource(this.getView(), "flexpanelap1", "flexpanel_treebtn");
        if (MainSubModelService.getInstance().isMainModel(this.getView()) || this.isSubModelSync()) {
            return MainSubModelService.getInstance().getSourceModelId(this.getView());
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelIdAfterCreateNewData();
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
        this.pageRefresh();
        this.setMainSubModelSyncVisible();
    }

    @Override
    protected void pageRefresh() {
        this.initExamineGroupTree();
        this.initBillList();
    }

    private void initExamineGroupTree() {
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        TreeNode leftNode = this.generateExamineGroupTree();
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(leftNode);
        treeLeft.addNode(leftNode);
        this.spreadAllNode(leftNode);
        this.putLeftRootToCache(leftNode, false);
        TreeNode lastNode = null;
        lastNode = leftNode.getChildren() != null && !leftNode.getChildren().isEmpty() ? (TreeNode)leftNode.getChildren().get(0) : leftNode;
        if (lastNode != null) {
            treeLeft.focusNode(lastNode);
            this.putClickNodeToCache(lastNode.getId(), false);
        }
    }

    private TreeNode generateExamineGroupTree() {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        String categorysFields = "id,name,code,parent.id,isleaf,level,businessmodel,modifier.name,parent.name,modifydate";
        DynamicObjectCollection categorys = QueryServiceHelper.query((String)"eb_examinecategory", (String)categorysFields, (QFilter[])qf.toArray(), (String)"level,parent,createdate");
        this.setOtherFilter(qf);
        DynamicObjectCollection businessModels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,name, number", (QFilter[])qf.toArray(), (String)"number,createdate");
        ArrayList<TreeNode> level2Nodes = new ArrayList<TreeNode>(16);
        boolean isNewEb = this.isNewEbForm();
        String level2NodeText = ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExamineListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String rootId = "0";
        TreeNode rootLeft = new TreeNode("", rootId, level2NodeText);
        HashMap<Long, DynamicObjectCollection> cataMap = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject category : categorys) {
            long businessmodel = category.getLong("businessmodel");
            DynamicObjectCollection dynamicObjects = cataMap.computeIfAbsent(businessmodel, t -> new DynamicObjectCollection());
            dynamicObjects.add((Object)category);
        }
        for (DynamicObject businessModel : businessModels) {
            TreeNode node = new TreeNode();
            String nodeText = isNewEb ? level2NodeText : businessModel.getString("name");
            node.setId(businessModel.getString("id"));
            node.setText(nodeText);
            node.setParentid(rootId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", nodeText);
            data.put("level", "2");
            data.put("id", businessModel.getLong("id"));
            data.put("businessModelId", businessModel.getLong("id"));
            node.setData(data);
            TreeNode node1 = MainSubModelExaminePlugin.generateExamineGroupTree(businessModel.getLong("id"), (DynamicObjectCollection)cataMap.get(businessModel.getLong("id")));
            List children = node1.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                for (TreeNode child : children) {
                    child.setParentid(businessModel.getString("id"));
                }
            }
            node.addChildren(node1.getChildren());
            level2Nodes.add(node);
        }
        rootLeft.addChildren(level2Nodes);
        return rootLeft;
    }

    private TreeNode setRootLeft(DynamicObject rootObj) {
        TreeNode rootLeft = new TreeNode();
        rootLeft.setId(rootObj.getString("id"));
        rootLeft.setText(rootObj.getString("name"));
        rootLeft.setParentid(rootObj.getString("parent.id"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("name", rootObj.getString("name"));
        data.put("level", rootObj.getString("level"));
        data.put("id", rootObj.getLong("id"));
        rootLeft.setParentid(null);
        rootLeft.setData(data);
        return rootLeft;
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.putClickNodeToCache(nodeId, false);
        this.initBillList();
    }

    private void setMainSubModelSyncVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isSubModelSync()), new String[]{"syncdate", "syncstatus"});
    }

    private boolean isSubModelSync() {
        Object isSync = this.getView().getFormShowParameter().getCustomParam("isSync");
        if (isSync instanceof Boolean) {
            return (Boolean)isSync;
        }
        return false;
    }

    class ExamineListDataProvider
    extends ListDataProvider {
        private String subModelNumber;

        public ExamineListDataProvider(String subModelNumber) {
            this.subModelNumber = subModelNumber;
        }

        public ExamineListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = this.getQFilters();
            ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(qFilters.size());
            ArrayList<QFilter> userFilter = new ArrayList<QFilter>(10);
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                if (MainSubListDataFilterUtil.templateProperties.contains(property)) {
                    userFilter.add(qFilter);
                    continue;
                }
                baseFilter.add(qFilter);
            }
            DynamicObjectCollection allRows = super.getData(start, 10000);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
                this.setQFilters(baseFilter);
            } else {
                this.setQFilters(qFilters);
            }
            QueryBuilder queryBuilder = this.getQueryBuilder();
            queryBuilder.setFilters(baseFilter.toArray(new QFilter[0]));
            this.setQueryBuilder(queryBuilder);
            if (CollectionUtils.isNotEmpty(userFilter)) {
                allRows = super.getData(0, this.getRealCount());
            }
            if (allRows == null || allRows.size() == 0) {
                MainSubModelExaminePlugin.this.getMainSubModelCacheHelper().cacheBillListIdAndIndexMap(allRows);
                return allRows;
            }
            MainSubModelExaminePlugin.this.getMainSubModelCacheHelper().cacheBillListIdAndIndexMap(allRows);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
                new BgmdMainSubModelSyncService().renderSyncInfoToBillList(allRows, this.subModelNumber, "eb_examine", userFilter);
            }
            ArrayList membInfoStrList = new ArrayList(16);
            for (DynamicObject row : allRows) {
                String formulaStr = row.getString("formula");
                ExamineServiceHelper.findMembInfoStr(membInfoStrList, (String)formulaStr);
            }
            Map dimMapMembNums = ExamineServiceHelper.mapDimMembNums(null, membInfoStrList, null, null);
            Map dimMembFullInfo = ExamineServiceHelper.qureyDimMembInfo((Map)dimMapMembNums, (long)MainSubModelExaminePlugin.this.getCurModelId());
            Map templateInfoMap = ExamineServiceImpl.getInstance().getTemplateInfoMap(MainSubModelExaminePlugin.this.getModelId());
            IModelCacheHelper modelCacheHelper = MainSubModelExaminePlugin.this.getIModelCacheHelper();
            for (DynamicObject row : allRows) {
                String formulaStr = row.getString("formula");
                String maindimension = row.getString("maindimension");
                String dimNum = org.apache.commons.lang.StringUtils.isBlank((String)maindimension) ? SysDimensionEnum.Account.getNumber() : maindimension.split("-")[1];
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                row.set("maindimension", (Object)dimension.getName());
                row.set("formula", (Object)ExamineServiceHelper.changeFormulaShow((String)formulaStr, (Map)dimMembFullInfo, (Map)templateInfoMap, (Dimension)modelCacheHelper.getDimension(dimNum)));
            }
            MainSubModelExaminePlugin.this.setUserSelect(allRows, start);
            this.getQueryResult().setDataCount(allRows.size());
            MainSubModelExaminePlugin.this.getView().getPageCache().put("realCount", allRows.size() + "");
            return allRows;
        }

        public int getRealCount() {
            String realCount = MainSubModelExaminePlugin.this.getView().getPageCache().get("realCount");
            if (StringUtils.isNotEmpty((String)realCount)) {
                return Integer.parseInt(realCount);
            }
            return super.getRealCount();
        }
    }
}

