/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubListDataFilterUtil;
import kd.epm.eb.formplugin.sonmodel.helper.MainSubModelCacheHelper;
import kd.epm.eb.formplugin.sonmodel.sync.service.BgmdMainSubModelSyncService;
import kd.epm.eb.formplugin.template.TemplateListDataProvider;
import org.apache.commons.collections4.CollectionUtils;

public class MainSubModelTemplateListDataProvider
extends TemplateListDataProvider {
    private String subModelNumber;
    private IFormView formView;
    private BillList billList;
    private MainSubModelCacheHelper mainSubModelCacheHelper;

    public MainSubModelTemplateListDataProvider(String subModelNumber, IFormView formView, BillList billList) {
        this.subModelNumber = subModelNumber;
        this.formView = formView;
        this.billList = billList;
    }

    public MainSubModelTemplateListDataProvider(IFormView formView, BillList billList) {
        this.formView = formView;
        this.billList = billList;
    }

    @Override
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection data = super.getData(start, 10000);
        List qFilters = this.getQFilters();
        ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(qFilters.size());
        ArrayList<QFilter> userFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if (MainSubListDataFilterUtil.templateProperties.contains(property)) {
                userFilter.add(qFilter);
                continue;
            }
            baseFilter.add(qFilter);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
            this.setQFilters(baseFilter);
        } else {
            this.setQFilters(qFilters);
        }
        QueryBuilder queryBuilder = this.getQueryBuilder();
        queryBuilder.setFilters(baseFilter.toArray(new QFilter[0]));
        this.setQueryBuilder(queryBuilder);
        if (CollectionUtils.isNotEmpty(userFilter)) {
            data = super.getData(0, this.getRealCount());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
            new BgmdMainSubModelSyncService().renderSyncInfoToBillList(data, this.subModelNumber, "eb_templateentity", userFilter);
        }
        this.setUserSelect(data, start);
        this.getQueryResult().setDataCount(data.size());
        this.formView.getPageCache().put("realCount", data.size() + "");
        return data;
    }

    public int getRealCount() {
        String realCount = this.formView.getPageCache().get("realCount");
        if (StringUtils.isNotEmpty((String)realCount)) {
            return Integer.parseInt(realCount);
        }
        return super.getRealCount();
    }

    private void setUserSelect(DynamicObjectCollection data, int startIndex) {
        if (this.formView == null) {
            return;
        }
        this.getMainSubModelCacheHelper().setUserSelect(data, this.billList, this.getMainSubModelCacheHelper(), startIndex);
    }

    protected Set<Long> getDefaultSelectIdsFromParam() {
        if (this.formView == null) {
            return Sets.newHashSet();
        }
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        Object dataSet = customParams.get("dataSet");
        if (dataSet != null) {
            return (Set)SerializationUtils.fromJsonString((String)dataSet.toString(), Set.class);
        }
        return Sets.newHashSet();
    }

    protected TreeView getLeftTreeView() {
        return (TreeView)this.formView.getControl("templatecatalogtree");
    }

    protected MainSubModelCacheHelper getMainSubModelCacheHelper() {
        String formId = this.formView.getFormShowParameter().getFormId();
        IFormView parentView = this.formView.getParentView();
        if (parentView == null) {
            String tips = ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u7684\u521b\u5efa\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"MainSubModelTemplateListDataProvider_001", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subModelNumber)) {
                tips = ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u7684\u540c\u6b65\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"MainSubModelTemplateListDataProvider_002", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            throw new KDBizException(tips);
        }
        if (this.mainSubModelCacheHelper == null) {
            this.mainSubModelCacheHelper = new MainSubModelCacheHelper(this.formView.getParentView().getPageCache(), formId);
        }
        return this.mainSubModelCacheHelper;
    }

    protected String getLeftTreeFocusNodeId(TreeView treeView) {
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode == null) {
            return "";
        }
        Object leftFocusTreeNodeId = focusNode.get("id");
        return leftFocusTreeNodeId == null ? "" : leftFocusTreeNodeId + "";
    }
}

