/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.SearchHelper;
import kd.epm.eb.business.utils.TreeEntryEntityUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimShowPropertyEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSelectFields;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSelectFieldsEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewShowProperyEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.sonmodel.MainSubModelMemberNode;
import kd.epm.eb.formplugin.sonmodel.helper.MainSubModelHelper;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class MainSubModelUtil {
    private static Log log = LogFactory.getLog(MainSubModelUtil.class);
    private static final List<String> proArr = Arrays.asList("number", "name", "aggoprt", "storagetype", "drcrdirect", "metricdatatype", "initdatabytime", "defaultmetricname", "ctview", "ctformula", "modifier", "modifytime");

    public static MainSubModelUtil getInstance() {
        return InnerClass.instance;
    }

    private MainSubModelUtil() {
    }

    public void modifyMainModel(DataModelImportParam importParam) {
        if (importParam.getMainSubImportParam().isMainSubModel() && !importParam.getMainSubImportParam().getSubSync().booleanValue()) {
            this.modifySubModelStatus(importParam.getToModelNumber());
            this.modifyModel(importParam);
        }
    }

    public void delPermUser(DataModelImportParam importParam) {
        Long userId;
        Long admin = importParam.getMainSubImportParam().getToMainSubModelAdmin();
        if (admin.compareTo(userId = UserUtils.getUserId()) != 0) {
            Object[] scheme = new Object[]{userId, IDUtils.toLong((Object)importParam.getToModelID())};
            String delUserperm = "delete from t_perm_userperm where fuserid = ? and forgid = ?";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)delUserperm, (Object[])scheme);
            String delUserpermdetail = "delete from t_perm_userpermdetail where fuserid = ? and fdimId = ?";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)delUserpermdetail, (Object[])scheme);
        }
    }

    private void modifyModel(DataModelImportParam importParam) {
        long admin = importParam.getMainSubImportParam().getToMainSubModelAdmin();
        int level = importParam.getMainSubImportParam().getParentLevel();
        int levelMainModel = level <= 0 ? 2 : level + 1;
        String updateSql = "update t_eb_model set fmodifierid = ?, fcreatorid = ?, flevel = ?, fparentnumber = ?, fdescription = ? where fid = ?";
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        Object[] obj = new Object[]{UserUtils.getUserId(), UserUtils.getUserId(), levelMainModel, importParam.getMainSubImportParam().getParentNumber(), importParam.getMainSubImportParam().getDescription(), importParam.getToModelID()};
        objs.add(obj);
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, objs);
        log.info("update t_eb_model :" + Arrays.toString(obj));
        if (level == 0) {
            updateSql = "update t_eb_model set flevel = ? where fshownumber = ?";
            objs = new ArrayList(16);
            obj = new Object[]{1, importParam.getMainSubImportParam().getParentNumber()};
            objs.add(obj);
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, objs);
        }
    }

    private void modifySubModelStatus(String number) {
        String updateSql = "update t_eb_mainsubmodel set fstatus = ? where fnumber = ?";
        Object[] obj = new Object[]{true, number};
        DB.execute((DBRoute)BgBaseConstant.epm, (String)updateSql, (Object[])obj);
        log.info("update t_eb_mainsubmodel :" + Arrays.toString(obj));
    }

    @Deprecated
    public Map<String, Set<Long>> getWholeTrees(Map<String, Set<Long>> memberMap, Long modelId) {
        HashMap<String, Set<Long>> wholeTrees = new HashMap<String, Set<Long>>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<String, Set<Long>> memberEntry : memberMap.entrySet()) {
            String dimKey = memberEntry.getKey();
            Set<Long> memberIds = memberEntry.getValue();
            if (memberIds == null || memberIds.isEmpty()) continue;
            Set<Long> allMembers = this.getWholeTree(dimKey, memberIds, modelCacheHelper);
            wholeTrees.put(dimKey, allMembers);
        }
        return wholeTrees;
    }

    public DimManagerInfo getDimManagerInfo(IFormView formView) {
        String _dimInfoStr = formView.getPageCache().get("dimInfo");
        if (_dimInfoStr != null) {
            return (DimManagerInfo)SerializationUtils.deSerializeFromBase64((String)_dimInfoStr);
        }
        return new DimManagerInfo();
    }

    @Deprecated
    public Set<Long> getWholeTree(String dimKey, Set<Long> memberIds, IModelCacheHelper modelCacheHelper) {
        HashSet<Long> allMembers = new HashSet<Long>(16);
        long dimKeyId = 0L;
        LinkedHashSet sortSet = new LinkedHashSet(memberIds.size());
        HashMap<Integer, HashSet<Object>> sortMap = new HashMap<Integer, HashSet<Object>>(16);
        Dimension dimension = modelCacheHelper.getDimension(dimKey);
        for (Long memberId : memberIds) {
            int n;
            HashSet<Object> longSet;
            Object member = modelCacheHelper.getMember(dimKey, null, memberId);
            if (member == null) {
                member = dimension.getStructOfMember(memberId);
            }
            if ((longSet = (HashSet<Object>)sortMap.get(n = member.getNumber().split("!").length)) == null) {
                longSet = new HashSet<Object>(16);
                longSet.add(member);
                sortMap.put(n, longSet);
                continue;
            }
            longSet.add(member);
        }
        Set integers = sortMap.keySet();
        ArrayList<Object> sortList = new ArrayList<Object>(integers.size());
        sortList.addAll(integers);
        sortList.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        for (Integer n : sortList) {
            sortSet.addAll((Collection)sortMap.get(n));
        }
        ArrayList<MainSubModelMemberNode> memberTrees = new ArrayList<MainSubModelMemberNode>(16);
        for (Member member : sortSet) {
            String number = member.getNumber();
            if (number.equals(dimKey)) {
                dimKeyId = member.getId();
                continue;
            }
            String memberLongNumber = member.getLongNumber();
            boolean replaceRoot = false;
            MainSubModelMemberNode memberRootNode = null;
            for (MainSubModelMemberNode memberTree : memberTrees) {
                String[] split1;
                String longNumber = memberTree.getLongNumber();
                String[] split = longNumber.split("!");
                if (split.length == (split1 = memberLongNumber.split("!")).length) continue;
                if (longNumber.contains(memberLongNumber)) {
                    replaceRoot = true;
                    memberRootNode = memberTree;
                    continue;
                }
                if (!memberLongNumber.contains(longNumber)) continue;
                memberRootNode = memberTree;
            }
            if (memberRootNode == null) {
                MainSubModelMemberNode memberTree = new MainSubModelMemberNode(member.getId(), number, memberLongNumber);
                memberTrees.add(memberTree);
                continue;
            }
            if (replaceRoot) {
                List<MainSubModelMemberNode> detailMembers = memberRootNode.getDetailMembers();
                if (detailMembers.size() == 0) {
                    MainSubModelMemberNode memberNode = new MainSubModelMemberNode(memberRootNode.getId(), memberRootNode.getNumber(), memberRootNode.getLongNumber());
                    detailMembers.add(memberNode);
                }
                memberRootNode.setId(member.getId());
                memberRootNode.setNumber(number);
                memberRootNode.setLongNumber(memberLongNumber);
                continue;
            }
            MainSubModelMemberNode memberNode = new MainSubModelMemberNode(member.getId(), number, memberLongNumber);
            memberRootNode.addDetailMember(memberNode);
        }
        for (MainSubModelMemberNode memberTree : memberTrees) {
            String longNumber = memberTree.getLongNumber();
            allMembers.add(memberTree.getId());
            String replaceNumber = longNumber + "!";
            List<MainSubModelMemberNode> detailMembers = memberTree.getDetailMembers();
            for (MainSubModelMemberNode detailMember : detailMembers) {
                String[] split;
                allMembers.add(detailMember.getId());
                String number = detailMember.getNumber();
                String memberLongNumber = detailMember.getLongNumber();
                String replace = memberLongNumber.replace(replaceNumber, "");
                for (String memberKey : split = replace.split("!")) {
                    Member member;
                    if (number.equals(memberKey) || (member = modelCacheHelper.getMemberByAnyView(dimKey, memberKey)) == null) continue;
                    allMembers.add(member.getId());
                }
            }
        }
        allMembers.add(dimKeyId);
        return allMembers;
    }

    public void searchAccount(long focusID, IFormView parameterView) {
        parameterView.getModel().beginInit();
        Long dimensionID = this.getAndCacheDimId(parameterView);
        String _defaultModelId = parameterView.getPageCache().get("KEY_MODEL_ID");
        Long defaultModelId = Long.valueOf(_defaultModelId);
        String menberentityid = "epm_accountmembertree";
        QFilter qcf = new QFilter("model", "=", (Object)defaultModelId);
        QFilter qcd = new QFilter("dimension", "=", (Object)dimensionID);
        QFilter qdataset = new QFilter("dataset", "=", (Object)Long.parseLong(this.getCurrentNodeId(parameterView)));
        QFilter qdroot = new QFilter("number", "=", (Object)"Account");
        QFilter[] memberFilters = new QFilter[]{qcf, qcd, qdataset.or(qdroot)};
        String selectMemberFields = this.getSelectMemberFields();
        DynamicObjectCollection members = QueryServiceHelper.query((String)this.getClass().getName(), (String)menberentityid, (String)selectMemberFields, (QFilter[])memberFilters, (String)"dseq");
        int memberSize = members.size();
        if (memberSize == 0) {
            return;
        }
        Set id = members.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(id) || !id.contains(focusID)) {
            return;
        }
        this.dealEbMembSearch(defaultModelId, dimensionID, String.valueOf(focusID), menberentityid, true, parameterView);
        parameterView.getModel().endInit();
        this.setFocusAndBackcolor(parameterView, focusID);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)parameterView.getControl("treeentryentity");
        DynamicObjectCollection entity = parameterView.getModel().getEntryEntity("treeentryentity");
        TreeView treeView = (TreeView)parameterView.getControl("treeviewap");
        String number = this.getAccountDimManagerInfo(parameterView).getDimension().getNumber();
        int entryEntityRow = MainSubModelUtil.getInstance().getEntryEntityRow(focusID, parameterView);
        new MainSubModelHelper().setDefaultSelectedData(false, entryEntityRow, parameterView, treeEntryGrid, treeView, parameterView.getModel(), entity, number);
        IFormView parentView = parameterView.getParentView();
        parentView.sendFormAction(parameterView);
    }

    protected DimManagerInfo getAccountDimManagerInfo(IFormView parameterView) {
        long selectMemberId = this.getSelectMemberId(parameterView);
        long modelId = this.getModelId(parameterView);
        long dimensionId = this.getAndCacheDimId(parameterView);
        DimManagerInfo dimInfo = new DimManagerInfo(modelId, dimensionId, selectMemberId);
        dimInfo.setDataset(this.getCurrentDatasetId(parameterView));
        return dimInfo;
    }

    private long getCurrentDatasetId(IFormView parameterView) {
        TreeView treeView = (TreeView)parameterView.getControl("treeviewap");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        TreeNode selectedNode = this.getSelectedNode(nodeId, parameterView);
        if (selectedNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"DataSetListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map dataMap = (Map)selectedNode.getData();
        if ("dataset".equals(dataMap.get("type"))) {
            return Long.parseLong(nodeId);
        }
        return 0L;
    }

    private TreeNode getSelectedNode(String nodeId, IFormView parameterView) {
        if (nodeId == null) {
            return null;
        }
        TreeNode root = this.getCacheLefTreeRoot(parameterView);
        return root.getTreeNode(nodeId, 20);
    }

    public TreeNode getCacheLefTreeRoot(IFormView parameterView) {
        String rootStr = parameterView.getPageCache().get("treelist");
        if (rootStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u6811\u7f13\u5b58\u83b7\u53d6\u5931\u8d25\u3002", (String)"DataSetListPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)rootStr);
        return root;
    }

    protected Long getSelectMemberId(IFormView parameterView) {
        int selectIndex = 0;
        TreeEntryGrid entryGrid = (TreeEntryGrid)parameterView.getControl("treeentryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows != null && rows.length > 0) {
            selectIndex = rows[rows.length - 1];
        }
        if (selectIndex < 0) {
            return 0L;
        }
        DynamicObject select = parameterView.getModel().getEntryRowEntity("treeentryentity", selectIndex);
        if (select != null) {
            return select.getLong("id");
        }
        return 0L;
    }

    private void setFocusAndBackcolor(IFormView parameterView, long focusID) {
        int entryEntityRow = MainSubModelUtil.getInstance().getEntryEntityRow(focusID, parameterView);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)parameterView.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        parameterView.updateView("treeentryentity");
        treeEntryGrid.selectRows(selectRows, entryEntityRow);
        treeEntryGrid.setRowBackcolor("#e5ffe5", new int[]{entryEntityRow});
    }

    public void dealEbMembSearch(Long model, Long dimension, String focusID, String entityname, boolean isCol, IFormView parameterView) {
        List parentlist = SearchHelper.getOrgParentNodeList((Long)model, (Long)dimension, (String)focusID, (String)entityname);
        HashSet<String> allShowRowid = new HashSet<String>();
        allShowRowid.add(String.valueOf(focusID));
        parentlist.add(0, focusID);
        List<Integer> matchRowIndex = MainSubModelUtil.removeExistNodeForSearchShow(parentlist, parameterView.getModel().getEntryEntity("treeentryentity"));
        if (parentlist.size() == 1) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)parameterView.getControl("treeentryentity");
            entryGrid.selectRows(matchRowIndex.get(matchRowIndex.size() - 1).intValue());
            matchRowIndex.remove(matchRowIndex.size() - 1);
            int[] pRowIndexs = new int[matchRowIndex.size()];
            for (int i = 0; i < matchRowIndex.size(); ++i) {
                pRowIndexs[i] = matchRowIndex.get(i);
            }
            entryGrid.expandOne(pRowIndexs);
        } else {
            parentlist.remove(0);
            QFilter qcd = new QFilter("dimension", "=", (Object)dimension);
            for (int i = parentlist.size() - 1; i >= 0; --i) {
                String parentid = (String)parentlist.get(i);
                QFilter qf1 = new QFilter("parent", "=", (Object)Long.parseLong(parentid));
                DynamicObjectCollection theSameLevel = QueryServiceHelper.query((String)entityname, (String)"id", (QFilter[])new QFilter[]{qcd, qf1});
                if (theSameLevel == null || theSameLevel.size() <= 0) continue;
                for (DynamicObject dy : theSameLevel) {
                    allShowRowid.add(dy.getString("id"));
                }
            }
            allShowRowid.add((String)parentlist.get(parentlist.size() - 1));
            if (CollectionUtils.isNotEmpty(matchRowIndex)) {
                this.insertAndRefreshTreeEntry(parameterView, allShowRowid, entityname, Long.parseLong(focusID), isCol, matchRowIndex.get(matchRowIndex.size() - 1), (String)parentlist.get(parentlist.size() - 1));
            }
        }
    }

    private void insertAndRefreshTreeEntry(IFormView parameterView, Set<String> allShowRowid, String entityname, long focusID, boolean col, int parentRow, String parentId) {
        QFilter qf2 = new QFilter("id", "in", (Object)allShowRowid.toArray());
        String selectFields = this.getSelectMemberFields();
        DynamicObjectCollection membercolls = QueryServiceHelper.query((String)entityname, (String)selectFields, (QFilter[])new QFilter[]{qf2});
        if (membercolls.size() == 0) {
            return;
        }
        List<String> properties = this.getPropertiesAndLeaf();
        int focusrow = SearchHelper.fillTreeEntryEntity((IDataModel)parameterView.getModel(), (DynamicObjectCollection)membercolls, properties, (String)String.valueOf(focusID), (int)parentRow, (String)parentId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)parameterView.getControl("treeentryentity");
        parameterView.updateView("treeentryentity");
        int[] eids = TreeEntryEntityUtils.focus((IDataModel)parameterView.getModel(), (int)focusrow);
        if (col) {
            treeEntry.collapse(0);
        }
        this.collapseExpNode(parentRow + 1, membercolls.size() - 1, treeEntry);
        treeEntry.expandOne(eids);
        treeEntry.selectRows(focusrow);
    }

    private List<String> getPropertiesAndLeaf() {
        List<String> list = this.getProperties();
        list.add("isleaf");
        return list;
    }

    private List<String> getProperties() {
        return proArr;
    }

    public static List<Integer> removeExistNodeForSearchShow(List<String> parentlist, DynamicObjectCollection currentRowObjs) {
        int lastIndex;
        int rowIndex = 0;
        int currentIndex = lastIndex = parentlist.size();
        ArrayList<Integer> pRowIndexs = new ArrayList<Integer>();
        if (!currentRowObjs.isEmpty()) {
            for (DynamicObject row : currentRowObjs) {
                String rowId = row.getString("id");
                if (parentlist.contains(rowId)) {
                    if (parentlist.indexOf(rowId) > currentIndex) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"DataSetListPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    pRowIndexs.add(rowIndex);
                    currentIndex = parentlist.indexOf(rowId);
                }
                if (currentIndex == 0) break;
                ++rowIndex;
            }
        }
        if (currentIndex == lastIndex - 1 && lastIndex != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"DataSetListPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int i = lastIndex - 1; i >= 0; --i) {
            if (currentIndex >= i) continue;
            parentlist.set(i, null);
        }
        parentlist.removeIf(Objects::isNull);
        return pRowIndexs;
    }

    protected String getSelectMemberFields() {
        return "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,isleaf,level ,description ,accounttype,drcrdirect";
    }

    private String getCurrentNodeId(IFormView parameterView) {
        TreeView treeView = (TreeView)parameterView.getControl("treeviewap");
        if (treeView != null) {
            return treeView.getTreeState().getFocusNodeId();
        }
        return "0";
    }

    public Long getAndCacheDimId(IFormView parameterView) {
        String dimId = parameterView.getPageCache().get("KEY_DIM_ID");
        if (dimId != null) {
            return Long.valueOf(dimId);
        }
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId(parameterView));
        QFilter numberQf = new QFilter("number", "=", (Object)"Account");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, numberQf});
        if (dynamicObject == null) {
            return 0L;
        }
        dimId = dynamicObject.getString("id");
        parameterView.getPageCache().put("KEY_DIM_ID", dimId);
        return Long.valueOf(dimId);
    }

    public Long getModelId(IFormView parameterView) {
        return UserSelectUtil.getF7SelectId((IFormView)parameterView, (String)"model");
    }

    public void searchMember(Long breakId, IFormView formView) {
        DynamicObjectCollection members = this.getAllSearchMember(formView);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(members.size());
        for (Object member : members) {
            map.put(member.getLong("id"), (DynamicObject)member);
        }
        Map<Long, List<DynamicObject>> parentKeyMap = members.stream().collect(Collectors.groupingBy(m -> m.getLong("parent")));
        for (Map.Entry entry : parentKeyMap.entrySet()) {
            ((List)entry.getValue()).sort(TreeEntryEntityUtils.getMembDseqComparator());
        }
        DynamicObject root = parentKeyMap.get(0L).get(0);
        for (DynamicObject member : members) {
            List<DynamicObject> noParentMembers;
            Long parentId = member.getLong("parent");
            if (parentId == 0L || map.containsKey(parentId) || (noParentMembers = parentKeyMap.get(parentId)) == null) continue;
            parentKeyMap.remove(parentId);
            Long rootId = root.getLong("id");
            List twolevel = parentKeyMap.computeIfAbsent(rootId, k -> new ArrayList(10));
            twolevel.addAll(noParentMembers);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(16);
        this.findHasLoadParent(map, breakId, arrayList, root.getLong("id"));
        ArrayList<Integer> expendRows = new ArrayList<Integer>(arrayList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl("treeentryentity");
        for (int i = arrayList.size() - 1; i > 0; --i) {
            Long parentId = (Long)arrayList.get(i);
            int rowIndex = this.getEntryEntityRow(parentId, formView);
            expendRows.add(rowIndex);
            this.expendOneEvevt(rowIndex, treeEntryGrid, formView);
        }
        int row = this.getEntryEntityRow((Long)arrayList.get(0), formView);
        int[] selectRows = treeEntryGrid.getSelectRows();
        formView.updateView("treeentryentity");
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        treeEntryGrid.selectRows(selectRows, row);
        treeEntryGrid.setRowBackcolor("#e5ffe5", new int[]{row});
        IFormView parentView = formView.getParentView();
        if (parentView != null) {
            parentView.sendFormAction(formView);
        }
    }

    private DynamicObjectCollection getAllSearchMember(IFormView formView) {
        DimManagerInfo dimInfo = this.getDimManagerInfo(formView);
        long modelId = dimInfo.getModel().getId();
        long dimensionId = dimInfo.getDimension().getId();
        String memberKey = dimInfo.getDimension().getMembermodel();
        Long viewId = dimInfo.getViewId();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimensionId);
        qfBuilder.add("enable", "=", (Object)"1");
        qfBuilder.add("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        String selectFields = "id,name,number,parent,dseq";
        if (this.isChangeType(dimInfo)) {
            if (IDUtils.isNull((Long)viewId)) {
                viewId = DimensionViewServiceHelper.getInstance().queryBaseViewId(Long.valueOf(modelId), Long.valueOf(dimensionId));
            }
            qfBuilder.add(new QFilter("view", "=", (Object)viewId).or("view", "=", (Object)0L));
        } else if (this.isEntity(dimInfo) && IDUtils.isNull((Long)viewId)) {
            qfBuilder.add(new QFilter("offsetsource", "!=", (Object)"2"));
        } else if (IDUtils.isNotNull((Long)viewId)) {
            qfBuilder.add("view", "=", (Object)viewId);
            memberKey = "eb_viewmember";
        }
        return QueryServiceHelper.query((String)memberKey, (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level , dseq");
    }

    public void expendOneEvevt(int row, TreeEntryGrid treeEntry, IFormView formView) {
        TreeNodeEvent treeNodeEvent = new TreeNodeEvent((Object)treeEntry);
        treeNodeEvent.setRowKey(row);
        this.queryTreeNodeChildren(treeNodeEvent, formView);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl("treeentryentity");
        DynamicObjectCollection entity = formView.getModel().getEntryEntity("treeentryentity");
        TreeView treeView = (TreeView)formView.getControl("viewtree");
        String number = this.getDimManagerInfo(formView).getDimension().getNumber();
        new MainSubModelHelper().setDefaultSelectedData(false, null, formView, treeEntryGrid, treeView, formView.getModel(), entity, number);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt, IFormView formView) {
        DynamicObject next;
        DimManagerInfo dimInfo = this.getDimManagerInfo(formView);
        int rowKey = evt.getRowKey();
        int entryRowCount = formView.getModel().getEntryRowCount("treeentryentity");
        DynamicObject parent = formView.getModel().getEntryRowEntity("treeentryentity", rowKey);
        if (parent == null) {
            return;
        }
        long parentId = parent.getLong("id");
        DynamicObject dynamicObject = next = rowKey + 2 > entryRowCount ? null : formView.getModel().getEntryRowEntity("treeentryentity", rowKey + 1);
        if (next != null && next.getLong("pid") == parentId && StringUtils.isNotEmpty((String)next.getString("number"))) {
            return;
        }
        QFBuilder builder = this.getQueryChildrenBuilder(dimInfo, parent);
        DynamicObjectCollection _members = QueryServiceHelper.query((String)this.getEntityNumber(dimInfo), (String)this.getSelectFields(dimInfo), (QFilter[])builder.toArray(), (String)"dseq,number");
        DynamicObject[] members = _members != null ? (DynamicObject[])_members.toArray((Object[])new DynamicObject[_members.size()]) : new DynamicObject[]{};
        TreeEntryEntityUtils.batchInsertTreeEntryRows((IDataModel)formView.getModel(), (DynamicObject[])members, (String[])this.getProperties(dimInfo), (int)rowKey, (Long)parentId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)formView.getControl("treeentryentity");
        int[] selectRows = treeEntry.getSelectRows();
        formView.updateView("treeentryentity");
        formView.getModel().updateCache();
        this.collapseExpNode(rowKey + 1, members.length, treeEntry);
        if (MainSubModelService.getInstance().isMainModel(formView)) {
            treeEntry.selectRows(selectRows, rowKey);
        } else {
            treeEntry.selectRows(rowKey);
        }
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    public QFBuilder getQueryChildrenBuilder(DimManagerInfo dimInfo, DynamicObject parent) {
        long viewId;
        long modelId = dimInfo.getModel().getId();
        long dimensionId = dimInfo.getDimension().getId();
        long parentId = parent.getLong("id");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dimensionId);
        builder.add("parent", "=", (Object)parentId);
        builder.add("enable", "=", (Object)"1");
        builder.add("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        long l = viewId = dimInfo.getView() != null ? dimInfo.getView().getId() : 0L;
        if (this.isChangeType(dimInfo)) {
            if (IDUtils.isNull((long)viewId)) {
                viewId = DimensionViewServiceHelper.getInstance().queryBaseViewId(Long.valueOf(modelId), Long.valueOf(dimInfo.getDimension().getId()));
            }
            builder.add(new QFilter("view", "=", (Object)viewId).or("view", "=", (Object)0L));
        } else if (dimInfo.getView() != null && IDUtils.isNotNull((long)viewId)) {
            builder.add("view", "=", (Object)viewId);
        } else if (this.isEntity(dimInfo) && dimInfo.getView() != null && IDUtils.isNull((long)viewId)) {
            builder.add(new QFilter("offsetsource", "!=", (Object)"2"));
        }
        return builder;
    }

    protected String[] getProperties(DimManagerInfo dimInfo) {
        ArrayList<String> showList = null;
        if (dimInfo.getView() != null && IDUtils.isNotNull((Long)dimInfo.getView().getId())) {
            showList = new ArrayList<String>(Arrays.asList(ViewShowProperyEnum.getShowList((String)dimInfo.getDimension().getMembermodel())));
        } else {
            DimShowPropertyEnum showProp = DimShowPropertyEnum.getEnumBySign((String)dimInfo.getDimension().getMembermodel());
            showList = new ArrayList<String>(Arrays.asList(showProp.getShowlist()));
        }
        if (dimInfo.getDimension().getNumber().equals(SysDimensionEnum.Entity.getNumber())) {
            showList.remove("orgcata");
        }
        return showList.toArray(new String[0]);
    }

    protected String getSelectFields(DimManagerInfo dimInfo) {
        String entityNumber = dimInfo.getDimension().getMembermodel();
        if (dimInfo.getView() == null || IDUtils.isNull((Long)dimInfo.getView().getId()) || this.isChangeType(dimInfo)) {
            return MemberSelectFields.getSelectFields((String)entityNumber);
        }
        return ViewMemberSelectFieldsEnum.getSelectFields((String)entityNumber);
    }

    public String getEntityNumber(DimManagerInfo dimInfo) {
        if (IDUtils.isNull((Long)dimInfo.getViewId()) || this.isChangeType(dimInfo)) {
            return dimInfo.getDimension().getMembermodel();
        }
        return "eb_viewmember";
    }

    public boolean isChangeType(@NotNull DimManagerInfo dimInfo) {
        return "ChangeType".equals(dimInfo.getDimension().getNumber());
    }

    public boolean isEntity(@NotNull DimManagerInfo dimInfo) {
        return "Entity".equals(dimInfo.getDimension().getNumber());
    }

    public int getEntryEntityRow(Long id, IFormView formView) {
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject object : entryEntity) {
            if (id.longValue() != object.getLong("id")) continue;
            return object.getInt("seq") - 1;
        }
        return -1;
    }

    public void findHasLoadParent(Map<Long, DynamicObject> map, Long id, List<Long> parentList, Long rootId) {
        parentList.add(id);
        DynamicObject object = map.get(id);
        if (object != null) {
            Long parentId = object.getLong("parent");
            if (parentId == 0L) {
                return;
            }
            DynamicObject parent = map.get(parentId);
            if (parent == null) {
                parentList.add(rootId);
                return;
            }
            this.findHasLoadParent(map, parentId, parentList, rootId);
        }
    }

    private static class InnerClass {
        private static final MainSubModelUtil instance = new MainSubModelUtil();

        private InnerClass() {
        }
    }
}

