/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.sonmodel.MainSubModelEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubModelBillListCache;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MainSubModelCacheHelper {
    private static final Log log = LogFactory.getLog(MainSubModelCacheHelper.class);
    private IPageCache parentPageCache;
    private String formId;
    private static final String CACHE_PREFIX_TEMPLATE = "templatePageCache";
    private static final String CACHE_PREFIX_BIZRULE = "bizrulePageCache";
    private static final String CACHE_PREFIX_EXAMINE = "examinePageCache";

    public IPageCache getParentPageCache() {
        return this.parentPageCache;
    }

    public void setParentPageCache(IPageCache parentPageCache) {
        this.parentPageCache = parentPageCache;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public MainSubModelCacheHelper(IPageCache parentPageCache, String formId) {
        this.parentPageCache = parentPageCache;
        this.formId = formId;
    }

    public void cacheUserSelectIds(Set<Long> userSelectIds) {
        String cacheKey = this.getPageCacheKey();
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            MainSubModelBillListCache mainSubModelBillListCache = this.getPageCacheEntity(cacheKey);
            if (mainSubModelBillListCache == null) {
                mainSubModelBillListCache = new MainSubModelBillListCache();
            }
            mainSubModelBillListCache.setUserSelectIds(userSelectIds);
            this.parentPageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)mainSubModelBillListCache));
        }
    }

    public void cacheDefaultSelectIds(Set<Long> defaultSelectIds) {
        String cacheKey = this.getPageCacheKey();
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            MainSubModelBillListCache mainSubModelBillListCache = this.getPageCacheEntity(cacheKey);
            if (mainSubModelBillListCache == null) {
                mainSubModelBillListCache = new MainSubModelBillListCache();
            }
            mainSubModelBillListCache.setDefaultSelectIds(defaultSelectIds);
            this.parentPageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)mainSubModelBillListCache));
        }
    }

    public Set<Long> getDefaultSelectIds() {
        String cacheKey = this.getPageCacheKey();
        String cacheStr = this.parentPageCache.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return Sets.newHashSet();
        }
        MainSubModelBillListCache mainSubModelBillListCache = (MainSubModelBillListCache)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        Set<Long> cacheSelectIds = mainSubModelBillListCache.getDefaultSelectIds();
        if (cacheSelectIds == null) {
            cacheSelectIds = new HashSet<Long>(16);
        }
        return cacheSelectIds;
    }

    public void cacheBillListIdAndIndexMap(DynamicObjectCollection allRows) {
        String cacheKey = this.getPageCacheKey();
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            return;
        }
        MainSubModelBillListCache mainSubModelBillListCache = this.getPageCacheEntity(cacheKey);
        if (mainSubModelBillListCache == null) {
            mainSubModelBillListCache = new MainSubModelBillListCache();
        }
        LinkedHashMap<Long, Integer> billListIdAndIndexMap = new LinkedHashMap<Long, Integer>(16);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)allRows)) {
            int index = 0;
            for (DynamicObject allRow : allRows) {
                billListIdAndIndexMap.put(allRow.getLong("id"), index++);
            }
        }
        mainSubModelBillListCache.setBillListIdAndIndexMap(billListIdAndIndexMap);
        this.parentPageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)mainSubModelBillListCache));
    }

    public Map<Long, Integer> getBillListIdAndIndexMap() {
        String cacheKey = this.getPageCacheKey();
        String cacheStr = this.parentPageCache.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return Maps.newLinkedHashMap();
        }
        MainSubModelBillListCache mainSubModelBillListCache = (MainSubModelBillListCache)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        Map<Long, Integer> billListIdAndIndexMap = mainSubModelBillListCache.getBillListIdAndIndexMap();
        if (billListIdAndIndexMap == null) {
            billListIdAndIndexMap = new LinkedHashMap<Long, Integer>(16);
        }
        return billListIdAndIndexMap;
    }

    public void addCacheUserSelectIds(Set<Long> userSelectIds) {
        String cacheKey = this.getPageCacheKey();
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            MainSubModelBillListCache mainSubModelBillListCache = this.getPageCacheEntity(cacheKey);
            if (mainSubModelBillListCache == null) {
                mainSubModelBillListCache = new MainSubModelBillListCache();
            }
            mainSubModelBillListCache.getUserSelectIds().addAll(userSelectIds);
            this.parentPageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)mainSubModelBillListCache));
        }
    }

    public String getPageCacheKey() {
        String formId = this.getFormId();
        String cacheKey = "";
        if (MainSubModelEnum.Template.getMemberTreemodel().equalsIgnoreCase(formId)) {
            cacheKey = CACHE_PREFIX_TEMPLATE;
        } else if (MainSubModelEnum.Bizrule.getMemberTreemodel().equalsIgnoreCase(formId)) {
            cacheKey = CACHE_PREFIX_BIZRULE;
        } else if (MainSubModelEnum.Examine.getMemberTreemodel().equalsIgnoreCase(formId)) {
            cacheKey = CACHE_PREFIX_EXAMINE;
        }
        return cacheKey;
    }

    public Set<Long> getCacheUserSelectIds() {
        String cacheKey = this.getPageCacheKey();
        String cacheStr = this.parentPageCache.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return Sets.newHashSet();
        }
        MainSubModelBillListCache mainSubModelBillListCache = (MainSubModelBillListCache)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        Set<Long> cacheSelectIds = mainSubModelBillListCache.getUserSelectIds();
        if (cacheSelectIds == null) {
            cacheSelectIds = new HashSet<Long>(16);
        }
        return cacheSelectIds;
    }

    public void cacheBillListSelect(ListSelectedRowCollection listSelectedRowCollection, BillList billList, MainSubModelCacheHelper mainSubModelCacheHelper) {
        HashSet<Long> userSelectIds = new HashSet<Long>(16);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listSelectedRowCollection)) {
            for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                userSelectIds.add(IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
            }
        }
        this.cacheBillListSelect(userSelectIds, billList, mainSubModelCacheHelper);
    }

    public void cacheBillListSelect(Set<Long> userSelectIds, BillList billList, MainSubModelCacheHelper mainSubModelCacheHelper) {
        ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
        Set<Long> cacheUserSelectIds = mainSubModelCacheHelper.getCacheUserSelectIds();
        for (ListSelectedRow selectedRow : currentListAllRowCollection) {
            cacheUserSelectIds.remove(IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
        }
        cacheUserSelectIds.addAll(userSelectIds);
        mainSubModelCacheHelper.cacheUserSelectIds(cacheUserSelectIds);
    }

    public Set<Long> setDefaultBillListSelect(DynamicObjectCollection data, BillList billList, MainSubModelCacheHelper mainSubModelCacheHelper, int startIndex) {
        HashSet<Long> newCacheUserSelectIds = new HashSet<Long>(16);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)data)) {
            return newCacheUserSelectIds;
        }
        if (billList == null) {
            return newCacheUserSelectIds;
        }
        if (mainSubModelCacheHelper == null) {
            return newCacheUserSelectIds;
        }
        Set<Long> cacheUserSelectIds = mainSubModelCacheHelper.getCacheUserSelectIds();
        ArrayList<Integer> selectIndexList = new ArrayList<Integer>(16);
        if (CollectionUtils.isNotEmpty(cacheUserSelectIds)) {
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)data.get(i);
                long id = dynamicObject.getLong("id");
                if (!cacheUserSelectIds.contains(id)) continue;
                selectIndexList.add(i + startIndex);
                newCacheUserSelectIds.add(id);
            }
        }
        int[] selectIndexs = new int[selectIndexList.size()];
        for (int i = 0; i < selectIndexList.size(); ++i) {
            selectIndexs[i] = (Integer)selectIndexList.get(i);
        }
        billList.clearSelection();
        billList.selectRows(selectIndexs);
        return newCacheUserSelectIds;
    }

    public void setUserSelect(DynamicObjectCollection data, BillList billList, MainSubModelCacheHelper mainSubModelCacheHelper, int startIndex) {
        this.setDefaultBillListSelect(data, billList, mainSubModelCacheHelper, startIndex);
    }

    public MainSubModelBillListCache getPageCacheEntity(String cacheKey) {
        String cacheStr = this.parentPageCache.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return null;
        }
        return (MainSubModelBillListCache)SerializationUtils.deSerializeFromBase64((String)cacheStr);
    }

    public void removePageCache() {
        this.parentPageCache.remove(this.getPageCacheKey());
    }

    public String getFormId() {
        return this.formId;
    }
}

