/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.sonmodel.MainSubModelEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class MainSubModelHelper {
    public static final String CACHE_PREFIX_DEFAULT = "defaultSelect";
    public static final String CACHE_PREFIX_CURRENT_TREE_SELECT = "currentTreeSelect";
    public static final String CACHE_PREFIX_USER_SELECT = "userSelect";
    public static final String CACHE_PREFIX_VIEW_RELATION = "viewRelation";
    public static final String CACHE_PREFIX_SELECT_ALL = "selectAll";
    public static final String CACHE_PREFIX_SCHEME_SELECT = "schemeSelect";
    private static final Log log = LogFactory.getLog(MainSubModelHelper.class);

    public Set<Long> getDimensionDefaultSelectIds(IFormView formView, String dimNumber, Map<String, Set<Long>> selectedDataIdMap) {
        Set longs;
        Map forbidCancelMap;
        HashSet<Long> selectDataIds = new HashSet<Long>(16);
        String forbidCancelIds = (String)formView.getFormShowParameter().getCustomParam("forbidCancelIds");
        if (StringUtils.isNotEmpty((String)forbidCancelIds) && (forbidCancelMap = (Map)SerializationUtils.deSerializeFromBase64((String)forbidCancelIds)) != null && CollectionUtils.isNotEmpty((Collection)(longs = (Set)forbidCancelMap.get(dimNumber)))) {
            selectDataIds.addAll(longs);
        }
        return selectDataIds;
    }

    private Set<String> getLeftTreeNodeAllChildIds(List<TreeNode> children) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(16);
        if (CollectionUtils.isEmpty(children)) {
            return result;
        }
        for (TreeNode child : children) {
            result.addAll(this.getLeftTreeNodeAllChildIds(child.getChildren()));
            result.add(child.getId());
        }
        return result;
    }

    private TreeNode getLeftTreeNode(String nodeId, TreeNode viewTreeRootNode) {
        if (StringUtils.equals((String)viewTreeRootNode.getId(), (String)nodeId)) {
            return viewTreeRootNode;
        }
        List children = viewTreeRootNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return null;
        }
        for (TreeNode child : children) {
            if (StringUtils.equals((String)child.getId(), (String)nodeId)) {
                return child;
            }
            TreeNode leftTreeNode = this.getLeftTreeNode(nodeId, child);
            if (leftTreeNode == null) continue;
            return leftTreeNode;
        }
        return null;
    }

    private TreeNode getViewTreeRootNode(IFormView formView) {
        return (TreeNode)SerializationUtils.deSerializeFromBase64((String)formView.getPageCache().get("viewTreeCache"));
    }

    public void setDefaultSelectedData(boolean isEntryRowClick, Integer currentRow, IFormView formView, TreeEntryGrid treeEntryGrid, TreeView treeView, IDataModel dataModel, DynamicObjectCollection entity, String dimNumber) {
        Set<Long> longs;
        Map<String, Set<Long>> viewRelationSelectIdMap;
        String cacheSelectedIdsKey = formView.getPageCache().get("currentNodeKey");
        if (treeView != null && treeView.getTreeState().getFocusNode() != null) {
            cacheSelectedIdsKey = treeView.getTreeState().getFocusNodeId();
        }
        if (StringUtils.isEmpty((String)cacheSelectedIdsKey)) {
            return;
        }
        Set<Long> cancelSelectIdSet = this.getCancelSelectId(treeEntryGrid, entity, dimNumber, treeView, cacheSelectedIdsKey);
        Map<String, Set<Long>> allSelectedIdMap = this.getAllSelectedIdMap(formView, dimNumber);
        Map<String, Set<Long>> defaultSelectMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_DEFAULT);
        Map<String, Set<Long>> viewRelationMap = null;
        if (!StringUtils.equals((String)dimNumber, (String)SysDimensionEnum.Account.getNumber())) {
            viewRelationMap = this.getViewRelationSelectIdMap(formView, dimNumber, allSelectedIdMap);
        }
        boolean cancelInDefault = false;
        log.info("mainSubModelSelectedAllCache:" + dimNumber + ":" + SerializationUtils.toJsonString(allSelectedIdMap));
        HashSet<Long> cacheSelectIds = new HashSet(16);
        if (allSelectedIdMap != null) {
            cacheSelectIds = allSelectedIdMap.get(cacheSelectedIdsKey);
        }
        if (cacheSelectIds == null) {
            cacheSelectIds = new HashSet(16);
        }
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (isEntryRowClick) {
            if (CollectionUtils.isNotEmpty(cancelSelectIdSet)) {
                cancelInDefault = this.checkDefaultSelect(defaultSelectMap, viewRelationMap, cacheSelectedIdsKey, cancelSelectIdSet, formView);
                if (!cancelInDefault) {
                    if (selectRows.length == 0) {
                        formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d6\u6d88\u9009\u62e9\u6839\u6210\u5458\u3002", (String)"MainSubModelDimension_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        DynamicObject dynamicObject = (DynamicObject)entity.get(0);
                        long rootId = 0L;
                        if (dynamicObject != null) {
                            rootId = dynamicObject.getLong("id");
                        }
                        if (cancelSelectIdSet.contains(rootId)) {
                            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d6\u6d88\u9009\u62e9\u6839\u6210\u5458\u3002", (String)"MainSubModelDimension_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                    }
                    cacheSelectIds.removeIf(cancelSelectIdSet::contains);
                }
            } else {
                for (int selectRow : selectRows) {
                    DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
                    cacheSelectIds.add(dynamicObject.getLong("id"));
                }
            }
            this.putSelectedIds(formView, dimNumber, cacheSelectedIdsKey, CACHE_PREFIX_USER_SELECT, cacheSelectIds);
            this.removeRelationSelectedIdMap(formView, cancelSelectIdSet, cacheSelectedIdsKey, cancelInDefault, dimNumber);
        }
        HashSet<Long> hashSet = new HashSet<Long>(16);
        if (!StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimNumber) && (viewRelationSelectIdMap = this.getViewRelationSelectIdMap(formView, dimNumber, allSelectedIdMap)) != null && CollectionUtils.isNotEmpty(longs = viewRelationSelectIdMap.get(cacheSelectedIdsKey))) {
            hashSet.addAll(longs);
        }
        ArrayList<Integer> selectIndexs = new ArrayList<Integer>(16);
        selectIndexs.add(0);
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            long id = dynamicObject.getLong("id");
            if (!cacheSelectIds.contains(id) && !hashSet.contains(id)) continue;
            selectIndexs.add(i);
        }
        int focusRow = 0;
        if (currentRow != null) {
            focusRow = currentRow;
        }
        if (CollectionUtils.isNotEmpty(cancelSelectIdSet)) {
            for (int i = 0; i < entity.size(); ++i) {
                long id = ((DynamicObject)entity.get(i)).getLong("id");
                if (!cancelSelectIdSet.contains(id)) continue;
                focusRow = i;
                break;
            }
        }
        if (focusRow == 0 && currentRow != null) {
            focusRow = currentRow;
        }
        int[] ints = selectIndexs.stream().mapToInt(t -> t).toArray();
        this.setTreeEntitySelect(ints, focusRow, treeEntryGrid, formView, cacheSelectedIdsKey, dimNumber, dataModel, entity);
    }

    public void putSelectedIds(IFormView formView, String dimNumber, String cacheSelectedIdsKey, String cacheKey, Set<Long> cacheSelectIds) {
        Map<String, Set<Long>> selectedIdMap = this.getSelectedIdMap(formView, dimNumber, cacheKey);
        if (selectedIdMap == null) {
            selectedIdMap = new HashMap<String, Set<Long>>(16);
        }
        selectedIdMap.put(cacheSelectedIdsKey, cacheSelectIds);
        this.setSelectedIdMap(formView, cacheKey, dimNumber, selectedIdMap);
    }

    public void addSelectedIdsCache(IFormView formView, String dimNumber, String cacheSelectedIdsKey, String cacheKey, Set<Long> cacheSelectIds) {
        Map<String, Set<Long>> selectedIdMap = this.getSelectedIdMap(formView, dimNumber, cacheKey);
        if (selectedIdMap == null) {
            selectedIdMap = new HashMap<String, Set<Long>>(16);
        }
        Set longs = selectedIdMap.computeIfAbsent(cacheSelectedIdsKey, t -> new HashSet(16));
        longs.addAll(cacheSelectIds);
        this.setSelectedIdMap(formView, cacheKey, dimNumber, selectedIdMap);
    }

    private void removeRelationSelectedIdMap(IFormView formView, Set<Long> cancelSelectIdSet, String cacheSelectedIdsKey, boolean cancelInDefault, String dimNumber) {
        if (!cancelInDefault) {
            this.removeSelectedIdMap(dimNumber, CACHE_PREFIX_USER_SELECT, formView, cacheSelectedIdsKey, cancelSelectIdSet);
            this.removeSelectedIdMap(dimNumber, CACHE_PREFIX_SCHEME_SELECT, formView, cacheSelectedIdsKey, cancelSelectIdSet);
            this.removeSelectedIdMap(dimNumber, CACHE_PREFIX_SELECT_ALL, formView, cacheSelectedIdsKey, cancelSelectIdSet);
        }
    }

    private void removeSelectedIdMap(String dimNumber, String cacheKey, IFormView formView, String leftFocusId, Set<Long> cancelIds) {
        Set<Long> value;
        Map<String, Set<Long>> selectedIdMap = this.getSelectedIdMap(formView, dimNumber, cacheKey);
        if (selectedIdMap != null && selectedIdMap.size() > 0 && CollectionUtils.isNotEmpty(cancelIds) && CollectionUtils.isNotEmpty(value = selectedIdMap.get(leftFocusId))) {
            value.removeIf(cancelIds::contains);
            this.setSelectedIdMap(formView, cacheKey, dimNumber, selectedIdMap);
        }
    }

    public boolean checkDefaultSelect(Map<String, Set<Long>> defaultSelectMap, Map<String, Set<Long>> viewRelationMap, String cacheSelectedIdsKey, Set<Long> cancelSelectIdSet, IFormView formView) {
        Set<Long> leftSelectId;
        boolean cancelInDefault = false;
        if (CollectionUtils.isEmpty(cancelSelectIdSet)) {
            return cancelInDefault;
        }
        if (defaultSelectMap != null && CollectionUtils.isNotEmpty(leftSelectId = defaultSelectMap.get(cacheSelectedIdsKey))) {
            for (Long cancelSelect : cancelSelectIdSet) {
                if (!leftSelectId.contains(cancelSelect)) continue;
                cancelInDefault = true;
                formView.showTipNotification(ResManager.loadKDString((String)"\u7531\u524d\u51e0\u6b65\u9ed8\u8ba4\u5e26\u51fa\u5f53\u524d\u9009\u4e2d\uff0c\u65e0\u6cd5\u53d6\u6d88\u9009\u62e9\u3002\u5982\u9700\u53d6\u6d88\u9009\u62e9\uff0c\u8bf7\u70b9\u51fb\u201c\u4e0a\u4e00\u6b65\u201d\u8fd4\u56de\u3002", (String)"MainSubModelDimension_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (viewRelationMap != null && !cancelInDefault && CollectionUtils.isNotEmpty(leftSelectId = viewRelationMap.get(cacheSelectedIdsKey))) {
            for (Long cancelSelect : cancelSelectIdSet) {
                if (!leftSelectId.contains(cancelSelect)) continue;
                cancelInDefault = true;
                formView.showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u5f15\u7528\u5e26\u51fa\u7684\u6210\u5458\uff0c\u65e0\u6cd5\u53d6\u6d88\u52fe\u9009\uff1b\u5982\u9700\u53d6\u6d88\u52fe\u9009\uff0c\u8bf7\u5148\u5c06\u89c6\u56fe\u5f15\u7528\u6210\u5458\u53d6\u6d88\u52fe\u9009\u3002", (String)"MainSubModelDimension_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        return cancelInDefault;
    }

    public void setTreeEntitySelect(int[] selectIndexArray, int focusIndex, TreeEntryGrid treeEntryGrid, IFormView formView, String leftFocusNodeId, String dimNumber, IDataModel dataModel, DynamicObjectCollection entity) {
        if (selectIndexArray == null || selectIndexArray.length == 0) {
            return;
        }
        treeEntryGrid.selectRows(selectIndexArray, focusIndex);
        for (int i = 0; i < entity.size(); ++i) {
            dataModel.setValue("select", (Object)false, i);
        }
        HashSet<Long> userSelectIds = new HashSet<Long>(16);
        for (int i : selectIndexArray) {
            dataModel.setValue("select", (Object)true, i);
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            userSelectIds.add(dynamicObject.getLong("id"));
        }
        this.putSelectedIds(formView, dimNumber, leftFocusNodeId, CACHE_PREFIX_CURRENT_TREE_SELECT, userSelectIds);
    }

    private Map<String, Set<Long>> getViewRelationMemberIds(IFormView formView, String dimNumber, String focusId, Map<String, Set<Long>> allSelectedIdMap) {
        TreeNode rootNode = this.getViewTreeRootNode(formView);
        Set<String> allChildIds = this.getLeftTreeNodeAllChildIds(rootNode.getChildren());
        long[] leftNodeIds = allChildIds.stream().mapToLong(IDUtils::toLong).toArray();
        DynamicObjectCollection dimensionViewList = QueryServiceHelper.query((String)"eb_dimensionview", (String)"number,id,model", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)leftNodeIds)});
        if (CollectionUtils.isEmpty((Collection)dimensionViewList)) {
            throw new KDBizException("query dimensionView error");
        }
        long modelId = ((DynamicObject)dimensionViewList.get(0)).getLong("model");
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Set<Long>> selectedIdMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> allViewMemberIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dimensionViewList) {
            String id = dynamicObject.getString("id");
            Set<Long> longs = allSelectedIdMap.get(id);
            if (!CollectionUtils.isNotEmpty(longs)) continue;
            allViewMemberIds.addAll(longs);
        }
        QFilter filter = new QFilter("id", "in", allViewMemberIds);
        DynamicObjectCollection query = this.queryViewMemberList(filter);
        for (DynamicObject dynamicObject : query) {
            Member sourceMember;
            Member member = orCreate.getMember(dimNumber, Long.valueOf(dynamicObject.getLong("view")), Long.valueOf(dynamicObject.getLong("memberid")));
            if (member == null || !IDUtils.isNotNull((Long)member.getRefViewId()) || !((sourceMember = orCreate.getMember(dimNumber, member.getRefViewId(), Long.valueOf(dynamicObject.getLong("memberid")))) instanceof ViewMember)) continue;
            Set longs = selectedIdMap.computeIfAbsent(String.valueOf(member.getRefViewId()), v -> new HashSet(16));
            longs.add(((ViewMember)sourceMember).getVid());
        }
        return selectedIdMap;
    }

    private DynamicObjectCollection queryViewMemberList(QFilter filter) {
        return QueryServiceHelper.query((String)"eb_viewmember", (String)"id, view,memberid,longnumber,refview", (QFilter[])filter.toArray());
    }

    public Map<String, Set<Long>> getAllSelectedIdMapToSave(IFormView formView, String dimNumber) {
        Map<String, Set<Long>> allSelectedIdMap = this.getAllSelectedIdMap(formView, dimNumber);
        Map<String, Set<Long>> viewRelationSelectIdMap = this.getViewRelationSelectIdMap(formView, dimNumber, allSelectedIdMap);
        this.mergeSelectMap(viewRelationSelectIdMap, allSelectedIdMap);
        return allSelectedIdMap;
    }

    public Map<String, Set<Long>> getAllSelectedIdMap(IFormView formView, String dimNumber) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        Map<String, Set<Long>> userSelectIdMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_USER_SELECT);
        Map<String, Set<Long>> userSelectIdAllMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_SELECT_ALL);
        Map<String, Set<Long>> defaultSelectIdEntityRelationMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_DEFAULT);
        Map<String, Set<Long>> schemeSelectIdEntityRelationMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_SCHEME_SELECT);
        this.mergeSelectMap(userSelectIdMap, result);
        this.mergeSelectMap(userSelectIdAllMap, result);
        this.mergeSelectMap(defaultSelectIdEntityRelationMap, result);
        this.mergeSelectMap(schemeSelectIdEntityRelationMap, result);
        return result;
    }

    public Map<String, Set<Long>> getViewRelationSelectIdMap(IFormView formView, String dimNumber, Map<String, Set<Long>> allSelectedIdMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> userSelectIdEntityRelationMap = new HashMap<String, Set<Long>>(16);
        TreeNode rootNode = this.getViewTreeRootNode(formView);
        Set<String> allChildIds = this.getLeftTreeNodeAllChildIds(rootNode.getChildren());
        for (String allChildId : allChildIds) {
            Map<String, Set<Long>> viewRelationMemberIds = this.getViewRelationMemberIds(formView, dimNumber, allChildId, allSelectedIdMap);
            this.mergeSelectMap(viewRelationMemberIds, userSelectIdEntityRelationMap);
        }
        this.mergeSelectMap(userSelectIdEntityRelationMap, result);
        return result;
    }

    public void mergeSelectMap(Map<String, Set<Long>> selectMap, Map<String, Set<Long>> toSelectMap) {
        if (selectMap != null) {
            for (Map.Entry<String, Set<Long>> entry : selectMap.entrySet()) {
                Set longs = toSelectMap.computeIfAbsent(entry.getKey(), t -> new HashSet(16));
                longs.addAll((Collection)entry.getValue());
            }
        }
    }

    public Map<String, Set<Long>> getSelectedIdMap(IFormView formView, String dimNumber, String prefix) {
        String userSelectIdsStr;
        String formId = formView.getFormShowParameter().getFormId();
        Map<String, Set<Long>> userSelectIdsMap = new HashMap<String, Set<Long>>(16);
        String cacheKey = formId + "#" + dimNumber;
        if (prefix != null) {
            cacheKey = formId + "#" + dimNumber + "#" + prefix;
        }
        if (StringUtils.isNotEmpty((String)(userSelectIdsStr = formView.getParentView().getPageCache().get(cacheKey)))) {
            userSelectIdsMap = (Map)SerializationUtils.deSerializeFromBase64((String)userSelectIdsStr);
        }
        return userSelectIdsMap;
    }

    public void setSelectedIdMap(IFormView formView, String prefix, String dimNumber, Map<String, Set<Long>> selectMap) {
        String formId = formView.getFormShowParameter().getFormId();
        String cacheKey = formId + "#" + dimNumber;
        if (prefix != null) {
            cacheKey = formId + "#" + dimNumber + "#" + prefix;
        }
        formView.getParentView().getPageCache().put(cacheKey, SerializationUtils.serializeToBase64(selectMap));
    }

    public void removeSelectedMap(String formId, IFormView formView, String dimNumber) {
        if (formId == null) {
            return;
        }
        if (StringUtils.equals((String)formId, (String)MainSubModelEnum.Account.getMemberTreemodel())) {
            dimNumber = SysDimensionEnum.Account.getNumber();
        }
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber);
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber + "#" + CACHE_PREFIX_DEFAULT);
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber + "#" + CACHE_PREFIX_CURRENT_TREE_SELECT);
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber + "#" + CACHE_PREFIX_SELECT_ALL);
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber + "#" + CACHE_PREFIX_SCHEME_SELECT);
        formView.getParentView().getPageCache().remove(formId + "#" + dimNumber + "#" + CACHE_PREFIX_USER_SELECT);
    }

    private String getCacheSelectedIdsKey(TreeView tree) {
        if (tree == null) {
            return "";
        }
        TreeView.TreeState state = tree.getTreeState();
        if (state == null) {
            return "";
        }
        Map focusNode = state.getFocusNode();
        if (focusNode == null) {
            return "";
        }
        Object id = focusNode.get("id");
        return this.getLeftFocusSelectIdsCacheKey(id);
    }

    private String getLeftFocusSelectIdsCacheKey(Object leftNodeId) {
        return leftNodeId == null ? "" : leftNodeId.toString();
    }

    public Set<Long> getCurrentMemberTreeSelect(TreeEntryGrid treeentryentity, DynamicObjectCollection entity) {
        int[] selectRows;
        HashSet<Long> result = new HashSet<Long>(16);
        if (treeentryentity == null) {
            return result;
        }
        for (int selectRow : selectRows = treeentryentity.getSelectRows()) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    public Set<Long> getCacheMemberTreeSelect(TreeView treeView, TreeEntryGrid treeentryentity, String dimNumber, String leftNodeId) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (treeView == null || treeentryentity == null) {
            return result;
        }
        IFormView formView = treeView.getView();
        Map<String, Set<Long>> userSelectMap = this.getSelectedIdMap(formView, dimNumber, CACHE_PREFIX_CURRENT_TREE_SELECT);
        if (userSelectMap != null) {
            return userSelectMap.get(leftNodeId);
        }
        return result;
    }

    public Set<Long> getCancelSelectId(TreeEntryGrid treeentryentity, DynamicObjectCollection entity, String dimNumber, TreeView treeView, String cacheSelectedIdsKey) {
        IFormView view = treeView.getView();
        String clearSelectAll = view.getPageCache().get("clearSelectAll");
        if (StringUtils.isNotEmpty((String)clearSelectAll)) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)clearSelectAll);
        }
        Set<Long> cacheMemberTreeSelect = this.getCacheMemberTreeSelect(treeView, treeentryentity, dimNumber, cacheSelectedIdsKey);
        if (CollectionUtils.isEmpty(cacheMemberTreeSelect)) {
            return new HashSet<Long>(16);
        }
        Set<Long> currentMemberTreeSelect = this.getCurrentMemberTreeSelect(treeentryentity, entity);
        if (CollectionUtils.isEmpty(currentMemberTreeSelect)) {
            HashSet<Long> result = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : entity) {
                long id = dynamicObject.getLong("id");
                if (!cacheMemberTreeSelect.contains(id)) continue;
                result.add(id);
            }
            return result;
        }
        cacheMemberTreeSelect.removeIf(currentMemberTreeSelect::contains);
        return cacheMemberTreeSelect;
    }
}

