/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelThread;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;

public class MainSubModelService {
    private static final Log log = LogFactory.getLog(MainSubModelService.class);

    public static MainSubModelService getInstance() {
        return InnerClass.instance;
    }

    private MainSubModelService() {
    }

    public List<Dimension> getUserDim(DynamicObjectCollection bizmodel, long modelId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Dimension> allDefUserDim = new HashMap<String, Dimension>(16);
        ArrayList allDimensionList = new ArrayList(16);
        bizmodel.forEach(d -> allDimensionList.addAll(orCreate.getDimensionListByBusModel(Long.valueOf(d.getLong("fbasedataid_id")))));
        for (Dimension dimension : allDimensionList) {
            if (!"epm_userdefinedmembertree".equals(dimension.getMemberModel())) continue;
            allDefUserDim.put(dimension.getNumber(), dimension);
        }
        LinkedList<Dimension> sortDim = new LinkedList<Dimension>();
        allDefUserDim.forEach((key, value) -> sortDim.add((Dimension)value));
        sortDim.sort(new Comparator<Dimension>(){

            @Override
            public int compare(Dimension o1, Dimension o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        return sortDim;
    }

    public DynamicObject getModelYearDataSource(long modelId) {
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.queryOne((String)"epm_model", (String)"id,datasource,startfy,presetyear", (QFilter[])qFilters);
    }

    public void checkSource(IFormView view, String ... flex) {
        if (this.isMainModel(view)) {
            view.setVisible(Boolean.valueOf(false), flex);
        }
    }

    public boolean isMainModel(IFormView view) {
        String source = (String)view.getFormShowParameter().getCustomParam("source");
        return StringUtils.equals((String)"eb_mainsubmodel", (String)source);
    }

    public void addQfilter(IFormView view, QFilter qFilter) {
        List bizmodel = (List)view.getFormShowParameter().getCustomParam("bizmodel");
        qFilter.and(new QFilter("dataset", "in", this.getDataSetId(bizmodel)));
    }

    public void addQfilter(IFormView view, List<QFilter> qFilter) {
        List bizmodel = (List)view.getFormShowParameter().getCustomParam("bizmodel");
        qFilter.add(new QFilter("dataset", "in", this.getDataSetId(bizmodel)));
    }

    public void addSubModelFilter(IFormView view, QFilter qFilter) {
        Object subModelNumber = view.getFormShowParameter().getCustomParam("subModelNumber");
        if (subModelNumber != null && StringUtils.isNotEmpty((String)String.valueOf(subModelNumber))) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)String.valueOf(subModelNumber))});
            qFilter.or("model", "=", (Object)dynamicObject.getLong("id"));
        }
    }

    public Set<Long> getDataSetId(List<Long> bizmodel) {
        QFBuilder qfBuilder = new QFBuilder("businessmodel", "in", bizmodel);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])qfBuilder.toArray());
        HashSet<Long> dataSet = new HashSet<Long>(query.size());
        query.forEach(p -> dataSet.add(p.getLong("id")));
        return dataSet;
    }

    public long getSourceModelId(IFormView view) {
        return (Long)view.getFormShowParameter().getCustomParam("modelId");
    }

    public Map<Long, DynamicObject> queryTemplate(Set<Long> collect) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(collect.size());
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", collect));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id,number,templatetype,data,dataset", (QFilter[])qfBuilder.toArray());
        Arrays.stream(load).forEach(p -> map.put(p.getLong("id"), (DynamicObject)p));
        return map;
    }

    public Map<Long, DynamicObject> queryExamine(Set<Long> collect) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(collect.size());
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", collect));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_examine", (String)"id,number,formula,rangediminfo,isconntemp,group.businessmodel.id ", (QFilter[])qfBuilder.toArray());
        Arrays.stream(load).forEach(p -> map.put(p.getLong("id"), (DynamicObject)p));
        return map;
    }

    public DynamicObject queryMainSubModel(String number) {
        QFBuilder qfBuilder = new QFBuilder(new QFilter("number", "=", (Object)number));
        return BusinessDataServiceHelper.loadSingle((String)"eb_mainsubmodel_base", (String)"id,name,number,bizmodel,entryentity", (QFilter[])qfBuilder.toArray());
    }

    public DynamicObject queryNumber(Long id, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("source", "=", (Object)"1");
        qfBuilder.add("dimension", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dimensionview", (String)"number", (QFilter[])qfBuilder.toArrays());
    }

    public DynamicObjectCollection queryViewMember(Set<Long> ids, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", ids));
        qfBuilder.add("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"eb_viewmember", (String)"id,view", (QFilter[])qfBuilder.toArray());
    }

    public String isExists(String number) {
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"MainSubModelService_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)number);
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_mainsubmodel_base", (String)"id", (QFilter[])qfBuilder.toArray());
        QFilter qFilter = new QFilter("shownumber", "=", (Object)number);
        if (object != null || QueryServiceHelper.exists((String)"epm_model", (QFilter[])new QFilter[]{qFilter})) {
            return ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u7f16\u7801\u4e0e\u7cfb\u7edf\u4e2d\u7684\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"MainSubModelService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public String isExistsTs(String number) {
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"MainSubModelService_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"eb_mainsubmodel_base", (QFilter[])new QFilter[]{qFilter})) {
            return ResManager.loadKDString((String)"\u5b50\u4f53\u7cfb\u7f16\u7801\u4e0e\u7cfb\u7edf\u4e2d\u7684\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"MainSubModelService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public long queryDimId(String number, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObject query = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])qfBuilder.toArray());
        if (query != null) {
            return query.getLong("id");
        }
        return 0L;
    }

    public String queryDimNumber(String number, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObject query = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])qfBuilder.toArray());
        if (query != null) {
            return query.getString("number");
        }
        return "";
    }

    public void addExamine(Set<Long> collect, Set<Long> examineMap, Long modelId) {
        DynamicObject[] dynamicObjects;
        QFBuilder qfBuilder = new QFBuilder(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("ebtemplates.fbasedataid_id", "in", collect));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"eb_examine", (String)"id", (QFilter[])qfBuilder.toArray())) {
            examineMap.add(dynamicObject.getLong("id"));
        }
    }

    public Set<Long> addBizrule(Set<Long> templateIds, Map<Long, Set<Long>> dataMap, Long modelId) {
        HashSet<Long> bizruleMap = new HashSet<Long>(16);
        ConcurrentHashMap<Long, List<Long>> tempRules = DataModelThread.getInstance().getBizByTemplate(templateIds, modelId);
        for (Map.Entry<Long, List<Long>> tempRule : tempRules.entrySet()) {
            if (tempRule.getValue().size() == 0) continue;
            dataMap.put(tempRule.getKey(), new HashSet(tempRule.getValue()));
            bizruleMap.addAll((Collection<Long>)tempRule.getValue());
        }
        return bizruleMap;
    }

    public DynamicObjectCollection querySubModel(Long mainModelId) {
        QFBuilder qfBuilder = new QFBuilder("mainmodel", "=", (Object)mainModelId);
        qfBuilder.and("status", "=", (Object)false);
        return QueryServiceHelper.query((String)"eb_mainsubmodel_base", (String)"id,name,number,mainmodel,text,startfy,modifier,modifytime,status", (QFilter[])qfBuilder.toArray());
    }

    public Set<Long> queryHasSubModel(Set<Long> mainModelIds) {
        HashSet<Long> mainIds = new HashSet<Long>(16);
        QFBuilder qfBuilder = new QFBuilder("mainmodel", "in", mainModelIds);
        qfBuilder.and("status", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_mainsubmodel_base", (String)"mainmodel", (QFilter[])qfBuilder.toArray());
        dynamicObjects.forEach(e -> mainIds.add(e.getLong("mainmodel")));
        return mainIds;
    }

    public Long queryDimViewId(Long dimension, Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("dimension", "=", (Object)dimension);
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("source", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id,number", (QFilter[])qfBuilder.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    public void deleteSubModel(Set<String> numbers) {
        QFBuilder qfBuilder = new QFBuilder("number", "in", numbers);
        DeleteServiceHelper.delete((String)"eb_mainsubmodel_base", (QFilter[])qfBuilder.toArray());
    }

    public DynamicObjectCollection queryAllBizModel(Long subModelId) {
        QFBuilder qfBuilder1 = new QFBuilder("model", "=", (Object)subModelId);
        return QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])qfBuilder1.toArray());
    }

    public DynamicObjectCollection queryAllMainModel(Set<String> mainBizNumber, Long mainId) {
        QFBuilder qfBuilder = new QFBuilder("number", "in", mainBizNumber);
        qfBuilder.add(new QFilter("model", "=", (Object)mainId));
        return QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
    }

    public DynamicObject querySubModel(String subNumber) {
        QFBuilder qfBuilder = new QFBuilder("shownumber", "=", (Object)subNumber);
        qfBuilder.and("reporttype", "=", (Object)"7");
        return QueryServiceHelper.queryOne((String)"epm_model", (String)"id, syncdate", (QFilter[])qfBuilder.toArrays());
    }

    public DynamicObject queryBizModelByNumber(Long id) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
    }

    public int queryModelLevel(Long mainModelId) {
        QFilter filter = new QFilter("id", "=", (Object)mainModelId);
        DynamicObject modelPerm = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id,level", (QFilter[])new QFilter[]{filter});
        return modelPerm.getInt("level");
    }

    public Set<Long> queryDataSetAndBusiness(Set<Long> accountSet) {
        HashSet<Long> dataSetId = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "in", accountSet);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,dataset", (QFilter[])filter.toArray());
        for (DynamicObject object : query) {
            Long dataId = object.getLong("dataset");
            dataSetId.add(dataId);
        }
        return dataSetId;
    }

    public List<String> getCommonDim() {
        return Arrays.asList("Entity", "Account", "Metric", "DataType", "ChangeType", "AuditTrail", "Currency");
    }

    public DynamicObject getMainSubModelId(String number) {
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)"eb_mainsubmodel_base", (String)this.getMainSubModelFiled(), (QFilter[])qfBuilder.toArray());
    }

    public String getMainSubModelFiled() {
        return "id,number,name,mainmodel,text,startfy,presetyear,datasource,foundway,admin,bizmodel,page,creator,createtime,modifier,modifytime,entryentity, reletype, reledataid,transportrange";
    }

    public Map<String, Long> queryCommonDims(long modelId, long busModelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List busModelDims = modelCache.getDimensionListByBusModel(Long.valueOf(busModelId));
        LinkedHashMap<String, Long> commonDims = new LinkedHashMap<String, Long>(12);
        for (Dimension busModelDim : busModelDims) {
            String dimNumber = busModelDim.getNumber();
            if (this.getCommonDim().contains(dimNumber)) {
                commonDims.put(dimNumber, busModelDim.getId());
            }
            if (commonDims.size() != this.getCommonDim().size()) continue;
            break;
        }
        return commonDims;
    }

    public Map<String, Long> queryDataSetDims(long modelId, long busModelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("businessmodel", "=", (Object)busModelId));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"entryentity.datasetdim", (QFilter[])qFilters.toArray(new QFilter[0]));
        LinkedHashMap<String, Long> deefineDims = new LinkedHashMap<String, Long>(16);
        if (load != null && load.length > 0) {
            for (DynamicObject ob : load) {
                List objects = ob.getDynamicObjectCollection("entryentity").stream().filter(o -> !o.getBoolean("datasetdim.issysdimension") || "InternalCompany".equals(o.getString("datasetdim.number"))).collect(Collectors.toList());
                for (DynamicObject object : objects) {
                    String number = object.getString("datasetdim.number");
                    if (deefineDims.containsKey(number)) continue;
                    deefineDims.put(number, object.getLong("datasetdim.id"));
                }
            }
        }
        return deefineDims;
    }

    public Map<String, Map<Long, Collection<String>>> getTemplateDimMap(String tempData, Long dataSetId) {
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)tempData);
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setDatasetID(dataSetId);
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        return templateModel.retrieveQuoteMembersWithViewInfo();
    }

    private static class InnerClass {
        private static final MainSubModelService instance = new MainSubModelService();

        private InnerClass() {
        }
    }
}

