/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.sync;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.formplugin.sonmodel.sync.constant.BgmdMainSubModelSyncConstant;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgmdMainSubModelSyncPlugin
extends AbstractBaseFormPlugin {
    private static final String LABEL_SYNC_DESC = "label_sync_desc";
    private static final String MAINMODEL = "mainmodel";
    private static final String SUBMODEL = "submodel";
    private static final String BTN_MODIFYSCHEMESYNC = "btn_modifyschemesync";
    private static final String BTN_ADDSYNC = "btn_addsync";
    private static final String SYNCADD = "syncadd";
    private static final String SYNCMODIFY = "syncmodify";
    private static final String SYNCDELETE = "syncdelete";
    private static final String SYNCTEMPLATE = "synctemplate";
    private static final String SYNCEXAMINE = "syncexamine";
    private static final String SYNCBIZRULE = "syncbizrule";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEnable();
        this.initPageData();
        this.setDefault();
    }

    private void setDefault() {
        this.getModel().setValue(SYNCMODIFY, (Object)true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MODIFYSCHEMESYNC, BTN_ADDSYNC});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Set limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser();
        if (CollectionUtils.isEmpty((Collection)limitedModelListByUser)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4f53\u7cfb\u540c\u6b65\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!limitedModelListByUser.contains(this.getMainModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e3b\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4f53\u7cfb\u540c\u6b65\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, Object> returnParamMap = new LinkedHashMap<String, Object>(16);
        returnParamMap.put("mainModelId", this.getMainModelId());
        returnParamMap.put("mainModelNumber", this.getMainModelNumber());
        returnParamMap.put("subModelId", this.getSubModelId());
        returnParamMap.put("subModelNumber", this.getSubModelNumber());
        returnParamMap.put("syncBizRule", this.getSyncBizRuleIndex());
        returnParamMap.put("syncExamine", this.getSyncExamineIndex());
        returnParamMap.put("syncTemplate", this.getSyncTemplateIndex());
        returnParamMap.put("syncAdd", this.getSyncAddIndex());
        returnParamMap.put("syncDelete", this.getSyncDeleteIndex());
        returnParamMap.put("syncModify", this.getSyncModifyIndex());
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_MODIFYSCHEMESYNC)) {
            returnParamMap.put("type", "modify");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_ADDSYNC)) {
            returnParamMap.put("type", "add");
        }
        this.getView().returnDataToParent(returnParamMap);
        this.getView().close();
    }

    private int getSyncBizRuleIndex() {
        return (Boolean)this.getModel().getValue(SYNCBIZRULE) != false ? 1 : 0;
    }

    private int getSyncExamineIndex() {
        return (Boolean)this.getModel().getValue(SYNCEXAMINE) != false ? 1 : 0;
    }

    private int getSyncTemplateIndex() {
        return (Boolean)this.getModel().getValue(SYNCTEMPLATE) != false ? 1 : 0;
    }

    private int getSyncAddIndex() {
        return (Boolean)this.getModel().getValue(SYNCADD) != false ? 1 : 0;
    }

    private int getSyncDeleteIndex() {
        return (Boolean)this.getModel().getValue(SYNCDELETE) != false ? 1 : 0;
    }

    private int getSyncModifyIndex() {
        return (Boolean)this.getModel().getValue(SYNCMODIFY) != false ? 1 : 0;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void handleModifySchemeSyncClick(EventObject evt) {
        LinkedHashMap<String, Object> returnParamMap = new LinkedHashMap<String, Object>(16);
        returnParamMap.put("mainModelId", this.getMainModelId());
        returnParamMap.put("mainModelNumber", this.getMainModelNumber());
        returnParamMap.put("subModelId", this.getSubModelId());
        returnParamMap.put("subModelNumber", this.getSubModelNumber());
        this.getView().returnDataToParent(returnParamMap);
        this.getView().close();
    }

    private Long getMainModelId() {
        Object value = this.getModel().getValue(MAINMODEL);
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    private String getMainModelNumber() {
        Object value = this.getModel().getValue(MAINMODEL);
        if (value == null) {
            return "";
        }
        return ((DynamicObject)value).getString("shownumber");
    }

    private String getSubModelNumber() {
        Object value = this.getModel().getValue(SUBMODEL);
        if (value == null) {
            return "";
        }
        return ((DynamicObject)value).getString("shownumber");
    }

    private Long getSubModelId() {
        Object value = this.getModel().getValue(SUBMODEL);
        if (value == null) {
            return 0L;
        }
        return ((DynamicObject)value).getLong("id");
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MAINMODEL, SUBMODEL});
    }

    private Map<Long, Long> getSubMainModelIdMap() {
        Object subMainModelIdMap = this.getView().getFormShowParameter().getCustomParam("subMainModelIdMap");
        if (subMainModelIdMap == null) {
            return Maps.newHashMap();
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)subMainModelIdMap.toString());
    }

    private void initPageData() {
        Label label = (Label)this.getControl(LABEL_SYNC_DESC);
        Button control = (Button)this.getControl(BTN_ADDSYNC);
        if (control == null) {
            label.setText(BgmdMainSubModelSyncConstant.SYNC_DESC_V1.loadKDString());
        } else {
            label.setText(BgmdMainSubModelSyncConstant.SYNC_DESC.loadKDString());
        }
        Map<Long, Long> subMainModelIdMap = this.getSubMainModelIdMap();
        if (subMainModelIdMap == null || subMainModelIdMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u540c\u6b65\u7684\u4e3b\u5b50\u4f53\u7cfb\u3002", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<Long, Long> entry : subMainModelIdMap.entrySet()) {
            Long key = entry.getKey();
            Long value = entry.getValue();
            this.getModel().setValue(MAINMODEL, (Object)value);
            this.getModel().setValue(SUBMODEL, (Object)key);
        }
    }
}

