/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.sync.schedule;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.formplugin.sonmodel.sync.service.BgmdMainSubModelSyncService;

public class BgmdMainSubModelSyncTask
extends AbstractTask {
    public static final String SYNCSUBMODELNUMBERKEY = "subModelNumberList";
    public static final String SYNC_EXAMINE = "syncExamine";
    public static final String SYNC_BIZRULE = "syncBizRule";
    public static final String SYNC_TEMPLATE = "syncTemplate";
    public static final String SYNC_ADD = "syncAdd";
    public static final String SYNC_DELETE = "syncDelete";
    public static final String SYNC_MODIFY = "syncModify";
    public static final String EXECUTEUSER = "executeuser";
    private static final Log log = LogFactory.getLog(BgmdMainSubModelSyncTask.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            log.error("params is null.");
            return;
        }
        if (!map.containsKey(SYNCSUBMODELNUMBERKEY)) {
            log.error("params SYNCSUBMODELNUMBERKEY is not exists.");
            return;
        }
        if (!map.containsKey(SYNC_EXAMINE)) {
            log.error("params SYNC_EXAMINE is not exists.");
            return;
        }
        if (!map.containsKey(SYNC_BIZRULE)) {
            log.error("params SYNC_BIZRULE is not exists.");
            return;
        }
        if (!map.containsKey(EXECUTEUSER)) {
            log.error("params EXECUTEUSER is not exists.");
            return;
        }
        Object subModelNumberListObj = map.get(SYNCSUBMODELNUMBERKEY);
        if (subModelNumberListObj == null) {
            log.error("params SYNCSUBMODELNUMBERKEY is not exists.");
            return;
        }
        Object syncExamineObj = map.get(SYNC_EXAMINE);
        if (syncExamineObj == null) {
            log.error("params SYNC_EXAMINE is not exists.");
            return;
        }
        Object syncBizRuleObj = map.get(SYNC_BIZRULE);
        if (syncBizRuleObj == null) {
            log.error("params SYNC_BIZRULE is not exists.");
            return;
        }
        Object syncTemplateObj = map.get(SYNC_TEMPLATE);
        if (syncTemplateObj == null) {
            log.error("params SYNC_TEMPLATE is not exists.");
            return;
        }
        Object syncAddObj = map.get(SYNC_ADD);
        if (syncAddObj == null) {
            log.error("params SYNC_ADD is not exists.");
            return;
        }
        Object syncDeleteObj = map.get(SYNC_DELETE);
        if (syncDeleteObj == null) {
            log.error("params SYNC_DELETE is not exists.");
            return;
        }
        Object syncModifyObj = map.get(SYNC_MODIFY);
        if (syncModifyObj == null) {
            log.error("params SYNC_MODIFY is not exists.");
            return;
        }
        Object executeUserNumber = map.get(EXECUTEUSER);
        DynamicObject executeUser = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)executeUserNumber.toString())});
        if (executeUser == null) {
            return;
        }
        long executeUserId = executeUser.getLong("id");
        String subModelNumberListStr = subModelNumberListObj.toString();
        String[] subModelNumberList = subModelNumberListStr.split(",");
        String syncExamineStr = syncExamineObj.toString();
        String[] syncExamineList = syncExamineStr.split(",");
        String syncBizRuleStr = syncBizRuleObj.toString();
        String[] syncBizRuleList = syncBizRuleStr.split(",");
        String syncTemplateStr = syncTemplateObj.toString();
        String[] syncTemplateList = syncTemplateStr.split(",");
        String syncAddStr = syncAddObj.toString();
        String[] syncAddList = syncAddStr.split(",");
        String syncDeleteStr = syncDeleteObj.toString();
        String[] syncDeleteList = syncDeleteStr.split(",");
        String syncModifyStr = syncModifyObj.toString();
        String[] syncModifyList = syncModifyStr.split(",");
        if (subModelNumberList.length != syncExamineList.length || subModelNumberList.length != syncBizRuleList.length || subModelNumberList.length != syncTemplateList.length) {
            log.error("params is error.");
            return;
        }
        if (subModelNumberList.length != syncAddList.length || subModelNumberList.length != syncDeleteList.length || subModelNumberList.length != syncModifyList.length) {
            log.error("params is error.");
            return;
        }
        boolean flag = true;
        HashSet<String> errorModelNumbers = new HashSet<String>(16);
        LinkedHashSet<String> errorInfo = new LinkedHashSet<String>(16);
        for (int i = 0; i < subModelNumberList.length; ++i) {
            String subModelNumber = subModelNumberList[i];
            String syncExamine = syncExamineList[i];
            String syncBizRule = syncBizRuleList[i];
            String syncTemplate = syncTemplateList[i];
            String syncAdd = syncAddList[i];
            String syncDelete = syncDeleteList[i];
            String syncModify = syncModifyList[i];
            BgmdMainSubModelSyncService.ModelSyncParam modelSyncParam = new BgmdMainSubModelSyncService.ModelSyncParam(subModelNumber, "1".equals(syncExamine), "1".equals(syncBizRule), "1".equals(syncTemplate), "1".equals(syncAdd), "1".equals(syncDelete), "1".equals(syncModify), executeUserId, true);
            try {
                BgmdMainSubModelSyncService.getInstance().modelSync(modelSyncParam);
                continue;
            }
            catch (Exception exception) {
                flag = false;
                errorModelNumbers.add(modelSyncParam.getSubModelNumber());
                errorInfo.add(exception.getMessage());
                log.error((Throwable)exception);
            }
        }
        if (!flag) {
            LinkedHashMap<String, Object> customData = new LinkedHashMap<String, Object>(16);
            customData.put("subModelNumbers", errorModelNumbers);
            customData.put("errorInfo", String.join((CharSequence)",", errorInfo));
            this.feedbackCustomdata(customData);
        }
        this.feedbackProgress(100);
    }

    public MessageHandler getMessageHandler() {
        return super.getMessageHandler();
    }
}

