/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.sync.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.sonmodel.MainSubModelEnum;
import kd.epm.eb.common.sonmodel.MainSubTransportRangeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.DataModelFormCommon;
import kd.epm.eb.formplugin.dataModelTrans.api.MainSubLoadModelJsonParam;
import kd.epm.eb.formplugin.dataModelTrans.api.MainSubModelTransApi;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelICUtil;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelViewUtil;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubConfig;
import kd.epm.eb.formplugin.rulemanage.utils.RuleRefMember;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubListDataFilterUtil;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import kd.epm.eb.formplugin.sonmodel.sync.constant.BgmdMainSubModelSyncConstant;
import kd.epm.eb.formplugin.sonmodel.sync.entity.BgmdMainSubModelLog;
import kd.epm.eb.formplugin.sonmodel.sync.enums.MainSubModelSyncStatusEnum;
import kd.epm.eb.formplugin.sonmodel.sync.enums.MainSubModelSyncTypeEnum;
import kd.epm.eb.formplugin.sonmodel.sync.service.BgmdMainSubModelSyncLogService;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.cache.TemplateCache;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgmdMainSubModelSyncService {
    private static final Log log = LogFactory.getLog(BgmdMainSubModelSyncService.class);

    public static BgmdMainSubModelSyncService getInstance() {
        return InnerClass.instance;
    }

    private Long queryModelDataSourceId(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return 0L;
        }
        QFilter filter = new QFilter("id", "=", (Object)modelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"datasource", (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("datasource");
    }

    public void modelSync(ModelSyncParam modelSyncParam) {
        Long subModelDataSourceId;
        if (modelSyncParam == null) {
            return;
        }
        String subModelNumber = modelSyncParam.getSubModelNumber();
        DynamicObject mainModelObj = this.queryMainModelObj(subModelNumber);
        if (mainModelObj == null) {
            return;
        }
        DynamicObject subModelObj = this.queryModelObj(subModelNumber);
        if (subModelObj == null) {
            return;
        }
        long mainModelId = mainModelObj.getLong("id");
        long subModelId = subModelObj.getLong("id");
        Long mainModelDataSourceId = this.queryModelDataSourceId(mainModelId);
        if (!mainModelDataSourceId.equals(subModelDataSourceId = this.queryModelDataSourceId(subModelId))) {
            this.addLog("0", "datasource not equal.");
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u5b50\u4f53\u7cfb\u6570\u636e\u6e90\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u3002", (String)"BgmdMainSubModelSyncService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser(null, (long)modelSyncParam.getExecuteUserId());
        if (CollectionUtils.isEmpty((Collection)limitedModelListByUser)) {
            this.addLog("1", "no model manager perm");
            return;
        }
        if (!limitedModelListByUser.contains(mainModelObj.getLong("id"))) {
            this.addLog("2", "no model manager perm");
            return;
        }
        DynamicObject mainSubModelBaseScheme = MainSubModelService.getInstance().getMainSubModelId(subModelNumber);
        if (mainSubModelBaseScheme == null) {
            return;
        }
        String foundway = mainSubModelBaseScheme.getString("foundway");
        if ("1".equalsIgnoreCase(foundway)) {
            this.syncSubModel(mainSubModelBaseScheme, mainModelObj, subModelObj, subModelNumber, null, OutputTypeEnum.ALL, modelSyncParam);
        } else if ("2".equalsIgnoreCase(foundway)) {
            DynamicObjectCollection bizmodel = mainSubModelBaseScheme.getDynamicObjectCollection("bizmodel");
            HashSet bizModelIdSet = new HashSet(bizmodel.size());
            bizmodel.forEach(p -> bizModelIdSet.add(((DynamicObject)p.get("fbasedataid")).getLong("id")));
            HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
            param.put("eb_businessmodel", bizModelIdSet);
            this.syncSubModel(mainSubModelBaseScheme, mainModelObj, subModelObj, subModelNumber, param, OutputTypeEnum.BIZMODEL, modelSyncParam);
        } else if ("3".equalsIgnoreCase(foundway)) {
            Object formId;
            HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
            HashMap<String, Set> paramTemp = new HashMap<String, Set>(16);
            DynamicObjectCollection entryentity = mainSubModelBaseScheme.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                for (DynamicObject dynamicObject : entryentity) {
                    String reletype = dynamicObject.getString("reletype");
                    long reledataid = dynamicObject.getLong("reledataid");
                    MainSubModelEnum enumByTree = MainSubModelEnum.getEnumByTree((String)reletype);
                    formId = enumByTree == null ? reletype : enumByTree.getEntity();
                    if (StringUtils.isBlank((CharSequence)formId) || DataModelTransEnum.custompropertyvalue.getFormID().equalsIgnoreCase((String)formId)) continue;
                    Set strings = paramTemp.computeIfAbsent((String)formId, t -> new HashSet(16));
                    strings.add(reledataid);
                }
            }
            for (Map.Entry entry : paramTemp.entrySet()) {
                Object viewMemberNumber3;
                formId = (String)entry.getKey();
                Set mainModelBaseDataIds = (Set)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)mainModelBaseDataIds)) continue;
                param.put((String)formId, mainModelBaseDataIds);
                Set<String> numbers = this.queryBaseDataNumberByIds((String)formId, mainModelBaseDataIds);
                Set<Long> subModelBaseDataIds = this.queryBaseDataIdSet((String)formId, numbers, subModelId);
                Set longs = param.computeIfAbsent((String)formId, t -> new HashSet(16));
                longs.addAll(subModelBaseDataIds);
                if (!StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.Entity.getFormID()) && !StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.userdefine.getFormID())) continue;
                QFilter filter = new QFilter("id", "in", (Object)mainModelBaseDataIds);
                DynamicObjectCollection viewMemberNumbers = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, view.id, view.number, dimension.number", (QFilter[])filter.toArray());
                HashSet<Long> viewMemberIdSet = new HashSet<Long>(16);
                HashSet<Long> dimensionViewIdSet = new HashSet<Long>(16);
                String viewNumber = "";
                String dimensionNumber = "";
                HashMap<String, Set> dimensionViewMemberNumMap = new HashMap<String, Set>(16);
                for (DynamicObject viewMemberNumber2 : viewMemberNumbers) {
                    viewMemberIdSet.add(viewMemberNumber2.getLong("id"));
                    dimensionViewIdSet.add(viewMemberNumber2.getLong("view.id"));
                    viewNumber = viewMemberNumber2.getString("view.number");
                    if (StringUtils.isBlank((CharSequence)dimensionNumber)) {
                        dimensionNumber = viewMemberNumber2.getString("dimension.number");
                    }
                    String number = viewMemberNumber2.getString("number");
                    Set strings = dimensionViewMemberNumMap.computeIfAbsent(viewNumber, t -> new HashSet(16));
                    strings.add(number);
                }
                for (Map.Entry stringSetEntry : dimensionViewMemberNumMap.entrySet()) {
                    viewNumber = (String)stringSetEntry.getKey();
                    Set value = (Set)stringSetEntry.getValue();
                    QFilter filter1 = new QFilter("model", "=", (Object)subModelId);
                    filter1.and("dimension.number", "=", (Object)dimensionNumber);
                    filter1.and("view.number", "=", (Object)viewNumber);
                    filter1.and("number", "in", (Object)value);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, view.id, view.number, dimension.number", (QFilter[])filter1.toArray());
                    for (DynamicObject dynamicObject : query) {
                        viewMemberIdSet.add(dynamicObject.getLong("id"));
                        dimensionViewIdSet.add(dynamicObject.getLong("view.id"));
                    }
                }
                Set strings1 = param.computeIfAbsent(DataModelTransEnum.viewmember.getFormID(), t -> new HashSet(16));
                strings1.addAll(viewMemberIdSet);
                Set strings2 = param.computeIfAbsent(DataModelTransEnum.dimensionview.getFormID(), t -> new HashSet(16));
                strings2.addAll(dimensionViewIdSet);
                QFilter filter1 = new QFilter("view.source", "=", (Object)"1");
                filter1.and("memberid", "in", (Object)mainModelBaseDataIds);
                viewMemberNumbers = QueryServiceHelper.query((String)"eb_viewmember", (String)"view.id", (QFilter[])filter.toArray());
                for (Object viewMemberNumber3 : viewMemberNumbers) {
                    dimensionViewIdSet.add(viewMemberNumber3.getLong("view.id"));
                }
                QFilter filter2 = new QFilter("view.source", "=", (Object)"1");
                filter2.and("memberid", "in", subModelBaseDataIds);
                viewMemberNumbers = QueryServiceHelper.query((String)"eb_viewmember", (String)"view.id", (QFilter[])filter.toArray());
                viewMemberNumber3 = viewMemberNumbers.iterator();
                while (viewMemberNumber3.hasNext()) {
                    DynamicObject viewMemberNumber4 = (DynamicObject)viewMemberNumber3.next();
                    dimensionViewIdSet.add(viewMemberNumber4.getLong("view.id"));
                }
                Set strings3 = param.computeIfAbsent(DataModelTransEnum.dimensionview.getFormID(), t -> new HashSet(16));
                strings3.addAll(dimensionViewIdSet);
            }
            DynamicObjectCollection bizmodel = mainSubModelBaseScheme.getDynamicObjectCollection("bizmodel");
            HashSet<Long> bizModelIdSet = new HashSet<Long>(bizmodel.size());
            for (DynamicObject dynamicObject : bizmodel) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                if (fbasedataid == null) continue;
                bizModelIdSet.add(fbasedataid.getLong("id"));
            }
            param.put("eb_businessmodel", bizModelIdSet);
            this.syncSubModel(mainSubModelBaseScheme, mainModelObj, subModelObj, subModelNumber, param, OutputTypeEnum.PARTIAL_SYNC, modelSyncParam);
        }
    }

    private Set<Long> queryBaseDataNumber(String baseDataType, Set<Long> baseDataIdSet) {
        DynamicObjectCollection query;
        String numberFlag = "id,number";
        if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(baseDataType)) {
            numberFlag = "id,code";
        }
        if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)baseDataType, (String)numberFlag, (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIdSet)})))) {
            return Sets.newHashSet();
        }
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : query) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private Set<String> queryBaseDataNumberByIds(String baseDataType, Set<Long> baseDataIdSet) {
        DynamicObjectCollection query;
        String numberFlag = "id,number";
        if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(baseDataType)) {
            numberFlag = "id,code";
        }
        if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)baseDataType, (String)numberFlag, (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIdSet)})))) {
            return Sets.newHashSet();
        }
        HashSet<String> result = new HashSet<String>(16);
        for (DynamicObject dynamicObject : query) {
            if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(baseDataType)) {
                result.add(dynamicObject.getString("code"));
                continue;
            }
            result.add(dynamicObject.getString("number"));
        }
        return result;
    }

    private void addLog(String key, String info) {
        log.info("----subModelSync:" + key + ":" + info);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void syncSubModel(DynamicObject mainSubModelBaseScheme, DynamicObject mainModelObj, DynamicObject subModelObj, String subModelNumber, Map<String, Set<Long>> param, OutputTypeEnum transTypeEnum, ModelSyncParam modelSyncParam) {
        this.addLog("subModelNumber", subModelNumber);
        if (mainModelObj == null || subModelObj == null || mainSubModelBaseScheme == null) {
            return;
        }
        mainModelId = mainModelObj.getLong("id");
        mainModelCacheHelper = ModelCacheContext.getOrCreate((Long)mainModelId);
        subModelId = subModelObj.getLong("id");
        subModelCacheHelper = ModelCacheContext.getOrCreate((Long)subModelId);
        subModelName = subModelObj.getString("name");
        subModelDataSourceId = subModelObj.getLong("datasource.id");
        syncdate = subModelObj.getDate("syncdate");
        syncstatus = subModelObj.getString("syncstatus");
        dLock = DLock.create((String)("/subModelSync/" + subModelId));
        var20_17 = null;
        try {
            subModelSyncLogListMap = null;
            newSyncDate = TimeServiceHelper.now();
            resultArr = new DataModelImportResult[1];
            mainSubLoadModelJsonParam = new MainSubLoadModelJsonParam();
            paramTemp = null;
            if (param != null) {
                mainModelBizModelIds = param.get(DataModelTransEnum.bizmodel.getFormID());
                if (CollectionUtils.isNotEmpty(mainModelBizModelIds)) {
                    filter = new QFilter("id", "in", mainModelBizModelIds);
                    query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, number", (QFilter[])filter.toArray());
                    subModelBizModelIds = new HashSet<Long>(16);
                    subModelBizModelNumbers = new HashSet<String>(16);
                    for (DynamicObject dynamicObject : query) {
                        number = dynamicObject.getString("number");
                        subModelBizModelNumbers.add(number);
                    }
                    if (CollectionUtils.isNotEmpty(subModelBizModelNumbers)) {
                        filter1 = new QFilter("model", "=", (Object)subModelId);
                        filter1.and("number", "in", subModelBizModelNumbers);
                        query1 = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])filter1.toArray());
                        for (DynamicObject dynamicObject : query1) {
                            subModelBizModelIds.add(dynamicObject.getLong("id"));
                        }
                    }
                    if (CollectionUtils.isNotEmpty(subModelBizModelIds)) {
                        longs = param.computeIfAbsent(DataModelTransEnum.bizmodel.getFormID(), (Function<String, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$7(java.lang.String ), (Ljava/lang/String;)Ljava/util/Set;)());
                        longs.addAll(subModelBizModelIds);
                    }
                }
                paramTemp = new HashMap<String, Set<Long>>(16);
                this.mergeParam(param, paramTemp);
            }
            mainSubLoadModelJsonParam.setParam(paramTemp);
            mainSubLoadModelJsonParam.setMainModelCacheHelper(mainModelCacheHelper);
            mainSubLoadModelJsonParam.setSubModelCacheHelper(subModelCacheHelper);
            mainSubLoadModelJsonParam.setTransType(transTypeEnum);
            mainSubLoadModelJsonParam.setSubModelSync(true);
            mainSubLoadModelJsonParam.setSyncSpecialFilter(false);
            mainSubLoadModelJsonParam.setMainModelId(mainModelId);
            b = dLock.tryLock();
            try {
                syncLogParam = new LinkedHashMap<MainSubModelSyncTypeEnum, Map<String, Set<String>>>(16);
                if (!b) {
                    exceptionInfo = ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u6b63\u5728\u540c\u6b65\uff0c\u8bf7\u52ff\u540c\u65f6\u8fdb\u884c\u3002", (String)"BgmdMainSubModelSyncService_2", (String)"epm-eb-formplugin", (Object[])new Object[]{subModelNumber});
                    exceptionErrorInfo = this.createExceptionErrorInfo(exceptionInfo, mainModelId, subModelId, newSyncDate, ModelSyncParam.access$100(modelSyncParam));
                    subModelSyncLogListMap = new HashMap<String, List<BgmdMainSubModelLog>>(16);
                    bgmdMainSubModelLogs = subModelSyncLogListMap.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY.getCode(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$8(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                    bgmdMainSubModelLogs.add(exceptionErrorInfo);
                    BgmdMainSubModelSyncLogService.getInstance().saveMainSubSyncLog(subModelSyncLogListMap, subModelId);
                    throw new KDBizException(exceptionInfo);
                }
                syncParam = new LinkedHashMap<MainSubModelSyncTypeEnum, Map<String, Set<Long>>>(16);
                addEditParamToUpdateSubModel = new HashMap<String, Set<String>>(16);
                if (transTypeEnum == OutputTypeEnum.ALL || transTypeEnum == OutputTypeEnum.BIZMODEL) {
                    mainSubLoadModelJsonParam.setTransType(transTypeEnum);
                    subModelJsonObjToGetModify = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                    this.getMainModelModifyData(subModelJsonObjToGetModify, syncParam, syncLogParam, addEditParamToUpdateSubModel, mainModelId, modelSyncParam);
                } else if (transTypeEnum == OutputTypeEnum.PARTIAL_SYNC) {
                    if (ModelSyncParam.access$200(modelSyncParam)) {
                        mainSubLoadModelJsonParam.setTransType(OutputTypeEnum.BIZMODEL);
                        subModelJsonObjToGetModify = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                    } else {
                        mainSubLoadModelJsonParam.setTransType(transTypeEnum);
                        subModelJsonObjToGetModify = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                    }
                    this.getMainModelModifyData(subModelJsonObjToGetModify, syncParam, syncLogParam, addEditParamToUpdateSubModel, mainModelId, modelSyncParam);
                }
                if (transTypeEnum == OutputTypeEnum.ALL || transTypeEnum == OutputTypeEnum.BIZMODEL) {
                    mainSubLoadModelJsonParam.setSubModelSync(false);
                    mainSubLoadModelJsonParam.setSyncSpecialFilter(true);
                    mainSubLoadModelJsonParam.setSubModelCacheHelper(mainModelCacheHelper);
                    mainSubLoadModelJsonParam.setSyncDate(syncdate);
                    mainSubLoadModelJsonParam.setTransType(transTypeEnum);
                    subModelJsonObjToGetAdd = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                    this.getMainModelAddData(subModelJsonObjToGetAdd, syncParam, syncLogParam, syncdate, modelSyncParam, transTypeEnum, subModelNumber, mainModelId);
                } else if (transTypeEnum == OutputTypeEnum.PARTIAL_SYNC) {
                    if (ModelSyncParam.access$200(modelSyncParam)) {
                        mainSubLoadModelJsonParam.setTransType(OutputTypeEnum.BIZMODEL);
                        mainSubLoadModelJsonParam.setSubModelSync(false);
                        mainSubLoadModelJsonParam.setSubModelCacheHelper(mainModelCacheHelper);
                        mainSubLoadModelJsonParam.setSyncSpecialFilter(true);
                        mainSubLoadModelJsonParam.setSyncDate(syncdate);
                        subModelJsonObjToGetAdd = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                        this.getMainModelAddData(subModelJsonObjToGetAdd, syncParam, syncLogParam, syncdate, modelSyncParam, OutputTypeEnum.BIZMODEL, subModelNumber, mainModelId);
                    } else {
                        mainSubLoadModelJsonParam.setTransType(transTypeEnum);
                        mainSubLoadModelJsonParam.setSubModelCacheHelper(mainModelCacheHelper);
                        mainSubLoadModelJsonParam.setSubModelSync(false);
                        mainSubLoadModelJsonParam.setSyncSpecialFilter(false);
                        mainSubLoadModelJsonParam.setSyncDate(null);
                        mainSubLoadModelJsonParam.setMainModelId(null);
                        subModelJsonObjFromScheme = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
                        this.getMainModelAddData(subModelJsonObjFromScheme, syncParam, syncLogParam, syncdate, modelSyncParam, transTypeEnum, subModelNumber, mainModelId);
                    }
                }
                syncErrorNumberMap = new LinkedHashMap<String, Map<String, String>>(16);
                relationParam = new HashMap<String, Map<Long, Map<String, Set<Long>>>>(16);
                entityByIc = new HashMap<Long, Set<Long>>(16);
                toSyncParam = this.getSyncRelationDataParam(syncParam, modelSyncParam, mainModelId, relationParam, entityByIc);
                toSyncJson = this.loadToSyncJson(toSyncParam, param, mainModelCacheHelper, transTypeEnum);
                this.completionNoneMemberForTemplate(toSyncJson, mainModelCacheHelper);
                if (toSyncJson != null) {
                    jsonObject = null;
                    if (relationParam.size() > 0 && syncErrorNumberMap.size() > 0) {
                        templateRelationParam = (Map)relationParam.get(DataModelTransEnum.templateentity.getFormID());
                        bizruleRelationParam = (Map)relationParam.get(DataModelTransEnum.bizruleset.getFormID());
                        examineRelationParam = (MainSubTransportRangeEnum[])relationParam.get(DataModelTransEnum.examine.getFormID());
                        removeTemplateHasErrorRelationData = this.getRemoveHasErrorRelationData(templateRelationParam, syncErrorNumberMap, DataModelTransEnum.templateentity);
                        removeBizRuleHasErrorRelationData = this.getRemoveHasErrorRelationData(bizruleRelationParam, syncErrorNumberMap, DataModelTransEnum.bizruleset);
                        removeExamineHasErrorRelationData = this.getRemoveHasErrorRelationData((Map<Long, Map<String, Set<Long>>>)examineRelationParam, syncErrorNumberMap, DataModelTransEnum.examine);
                        templateIds = toSyncParam.get(DataModelTransEnum.templateentity.getFormID());
                        bizRuleIds = toSyncParam.get(DataModelTransEnum.bizruleset.getFormID());
                        examineIds = toSyncParam.get(DataModelTransEnum.examine.getFormID());
                        needReLoad = false;
                        if (CollectionUtils.isNotEmpty(removeTemplateHasErrorRelationData) && CollectionUtils.isNotEmpty(templateIds)) {
                            needReLoad = true;
                            templateIds.removeIf((Predicate<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/Long;)Z)(removeTemplateHasErrorRelationData));
                        }
                        if (CollectionUtils.isNotEmpty(removeBizRuleHasErrorRelationData) && CollectionUtils.isNotEmpty(bizRuleIds)) {
                            needReLoad = true;
                            bizRuleIds.removeIf((Predicate<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/Long;)Z)(removeBizRuleHasErrorRelationData));
                        }
                        if (CollectionUtils.isNotEmpty(removeExamineHasErrorRelationData) && CollectionUtils.isNotEmpty(examineIds)) {
                            needReLoad = true;
                            examineIds.removeIf((Predicate<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/Long;)Z)(removeExamineHasErrorRelationData));
                        }
                        if (needReLoad) {
                            toSyncJson = this.loadToSyncJson(toSyncParam, param, mainModelCacheHelper, transTypeEnum);
                            syncErrorNumberMap = new HashMap<K, V>(16);
                        }
                    }
                    jsonObject = toSyncJson.getJSONObject(DataModelTransEnum.model.getFormID());
                    this.handleModelSync(jsonObject, DataModelTransEnum.model.getTableName().toLowerCase(), subModelCacheHelper, newSyncDate);
                    this.handleBaseDataSyncLevelSlip(toSyncJson, syncErrorNumberMap, subModelCacheHelper, mainModelCacheHelper);
                }
                BgmdMainSubModelSyncService.log.info("syncParam:" + subModelNumber + ":" + SerializationUtils.toJsonString(syncParam));
                BgmdMainSubModelSyncService.log.info("syncErrorNumberMap:" + subModelNumber + ":" + SerializationUtils.toJsonString(syncErrorNumberMap));
                BgmdMainSubModelSyncService.log.info("toSyncParam:" + subModelNumber + ":" + SerializationUtils.toJsonString(toSyncParam));
                transportrange = mainSubModelBaseScheme.getString("transportrange");
                excludeFormIds = new HashSet<String>(16);
                if (StringUtils.isNotBlank((CharSequence)transportrange)) {
                    split = transportrange.split(",");
                    for (MainSubTransportRangeEnum value : MainSubTransportRangeEnum.values()) {
                        if (!Arrays.stream(split).noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$syncSubModel$9(kd.epm.eb.common.sonmodel.MainSubTransportRangeEnum java.lang.String ), (Ljava/lang/String;)Z)((MainSubTransportRangeEnum)value)) || (mainSubModelEnum = value.getMainSubModelEnum()) == null) continue;
                        excludeFormIds.add(mainSubModelEnum.getEntity());
                    }
                }
                tx = TX.requiresNew((String)"syncSubModel");
                examineRelationParam = null;
                try {
                    try {
                        this.deleteSubModelSync((Map)syncParam.get((Object)MainSubModelSyncTypeEnum.SYNC_DELETE), syncErrorNumberMap, subModelId, subModelCacheHelper);
                        if (toSyncJson != null && toSyncJson.size() > 0) {
                            this.downLoadJsonFile(toSyncJson, "toSyncJson", ModelSyncParam.access$300(modelSyncParam));
                            importParam = MainSubModelTransApi.getInstance().importModel(toSyncJson, resultArr, subModelId, subModelNumber, subModelName, 0L, subModelDataSourceId, "1", true, newSyncDate, ModelSyncParam.access$100(modelSyncParam), 0, "", "", true, entityByIc, excludeFormIds);
                            errorTransFormDataDesc = importParam.getMainSubImportParam().getErrorTransFormDataDesc();
                            if (errorTransFormDataDesc != null && errorTransFormDataDesc.size() > 0) {
                                for (Map.Entry entry : errorTransFormDataDesc.entrySet()) {
                                    formId = (String)entry.getKey();
                                    map = (Map)entry.getValue();
                                    errorDescMap = syncErrorNumberMap.computeIfAbsent(formId, (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$10(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)());
                                    for (Map.Entry<K, V> stringSetEntry : map.entrySet()) {
                                        errorDescMap.put(stringSetEntry.getKey(), String.join((CharSequence)";", (Iterable)stringSetEntry.getValue()));
                                    }
                                }
                            }
                            if (addEditParamToUpdateSubModel.size() > 0) {
                                for (Map.Entry entry : addEditParamToUpdateSubModel.entrySet()) {
                                    value = (Set)entry.getValue();
                                    key = (String)entry.getKey();
                                    enumByFormID = DataModelTransEnum.getEnumByFormID(key);
                                    if (enumByFormID == null) continue;
                                    tableName = enumByFormID.getTableName();
                                    filterModelField = enumByFormID.getFilterModelField();
                                    this.updateSyncMainNumber(subModelId, filterModelField, tableName, enumByFormID.getFnumber(), value);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        BgmdMainSubModelSyncService.log.error((Throwable)exception);
                        tx.markRollback();
                        throw exception;
                    }
                }
                catch (Throwable exception) {
                    examineRelationParam = exception;
                    throw exception;
                }
                finally {
                    if (tx != null) {
                        if (examineRelationParam != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable exception) {
                                examineRelationParam.addSuppressed(exception);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                for (DataModelImportResult dataModelImportResult : resultArr) {
                    if (dataModelImportResult == null || (tipInfoMap = dataModelImportResult.getTipInfoMap()).size() <= 0) continue;
                    for (Map.Entry<String, Map<String, List<Object>>> entry : tipInfoMap.entrySet()) {
                        tableName = entry.getKey();
                        enumByTableName = DataModelTransEnum.getEnumByTableName(tableName);
                        if (enumByTableName == null) continue;
                        formId = enumByTableName.getFormID();
                        map = syncErrorNumberMap.computeIfAbsent((String)formId, (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$11(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)());
                        value = entry.getValue();
                        for (Map.Entry<String, List<Object>> stringListEntry : value.entrySet()) {
                            number = stringListEntry.getKey();
                            errorDesc = stringListEntry.getValue();
                            s = (String)map.get(number);
                            if (StringUtils.isBlank((CharSequence)s)) {
                                map.put(number, String.join((CharSequence)";", errorDesc.toArray(new String[0])));
                                continue;
                            }
                            errorDesc.add(s);
                            map.put(number, String.join((CharSequence)";", errorDesc.toArray(new String[0])));
                        }
                    }
                }
                subModelSyncLogListMap = this.createSubModelSyncLogList(syncLogParam, syncErrorNumberMap, excludeFormIds, mainModelId, subModelId, ModelSyncParam.access$100(modelSyncParam), newSyncDate);
                tipInfos = resultArr[0].getTipInfos();
                if (tipInfos.size() > 0) {
                    errorInfo = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5b58\u5728\u9519\u8bef\u7684\u5173\u8054\u6570\u636e\uff0c\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u4e0d\u5b8c\u6574\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BgmdMainSubModelSyncService_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    exceptionErrorInfo = this.createExceptionErrorInfo(errorInfo, mainModelId, subModelId, newSyncDate, ModelSyncParam.access$100(modelSyncParam));
                    bgmdMainSubModelLogs = subModelSyncLogListMap.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY.getCode(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$12(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                    bgmdMainSubModelLogs.add(exceptionErrorInfo);
                }
                if (subModelSyncLogListMap.size() <= 0) ** GOTO lbl260
                successLogs = subModelSyncLogListMap.get("0");
                errorLogs = subModelSyncLogListMap.get("1");
                if (CollectionUtils.isNotEmpty(successLogs) && CollectionUtils.isNotEmpty(errorLogs)) {
                    this.updateModelSyncStatus(MainSubModelSyncStatusEnum.SYNC_SUCCESS_PART.getCode(), subModelId, newSyncDate);
                    BgmdMainSubModelSyncLogService.getInstance().saveMainSubSyncLog(subModelSyncLogListMap, subModelId);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b50\u4f53\u7cfb\u201c%1\u201d\u90e8\u5206\u540c\u6b65\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"BgmdMainSubModelSyncService_5", (String)"epm-eb-formplugin", (Object[])new Object[]{subModelNumber}));
                }
                if (CollectionUtils.isEmpty(errorLogs)) {
                    BgmdMainSubModelSyncLogService.getInstance().saveMainSubSyncLog(subModelSyncLogListMap, subModelId);
                    this.updateModelSyncStatus(MainSubModelSyncStatusEnum.SYNC_SUCCESS.getCode(), subModelId, newSyncDate);
                } else {
                    BgmdMainSubModelSyncLogService.getInstance().saveMainSubSyncLog(subModelSyncLogListMap, subModelId);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b50\u4f53\u7cfb\u201c%1\u201d\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"BgmdMainSubModelSyncService_6", (String)"epm-eb-formplugin", (Object[])new Object[]{subModelNumber}));
lbl260:
                    // 1 sources

                    this.updateModelSyncStatus(syncstatus, subModelId, syncdate);
                }
            }
            catch (Exception exception) {
                BgmdMainSubModelSyncService.log.error("sycmodel excption:");
                BgmdMainSubModelSyncService.log.error((Throwable)exception);
                exceptionInfo = ResManager.loadKDString((String)"\u5176\u4ed6\u539f\u56e0", (String)"BgmdMainSubModelSyncService_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (!(exception instanceof KDBizException)) {
                    exceptionInfo = exceptionInfo + "traceId:[" + RequestContext.get().getTraceId() + "]";
                    exceptionLog = this.createExceptionErrorInfo(exceptionInfo, mainModelId, subModelId, newSyncDate, ModelSyncParam.access$100(modelSyncParam));
                    if (subModelSyncLogListMap == null) {
                        subModelSyncLogListMap = new HashMap<K, V>(16);
                    }
                    bgmdMainSubModelLogs = subModelSyncLogListMap.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY.getCode(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$syncSubModel$13(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                    bgmdMainSubModelLogs.add(exceptionLog);
                    BgmdMainSubModelSyncLogService.getInstance().saveMainSubSyncLog(subModelSyncLogListMap, subModelId);
                    this.updateModelSyncStatus(MainSubModelSyncStatusEnum.SYNC_FAILED.getCode(), subModelId, null);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b50\u4f53\u7cfb\u201c%1\u201d\u540c\u6b65\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"BgmdMainSubModelSyncService_7", (String)"epm-eb-formplugin", (Object[])new Object[]{subModelNumber}));
                }
                throw exception;
            }
            finally {
                if (b) {
                    dLock.unlock();
                }
                TemplateCache.remove();
            }
        }
        catch (Throwable var21_20) {
            var20_17 = var21_20;
            throw var21_20;
        }
        finally {
            if (dLock != null) {
                if (var20_17 != null) {
                    try {
                        dLock.close();
                    }
                    catch (Throwable var21_19) {
                        var20_17.addSuppressed(var21_19);
                    }
                } else {
                    dLock.close();
                }
            }
        }
    }

    private void completionNoneMemberForTemplate(JSONObject toSyncJson, IModelCacheHelper mainModelCacheHelper) {
        if (toSyncJson == null || mainModelCacheHelper == null) {
            log.info("completionNoneMemberForTemplate param is null.");
            return;
        }
        JSONObject templateJsonObj = toSyncJson.getJSONObject(DataModelTransEnum.templateentity.getFormID());
        if (templateJsonObj == null) {
            return;
        }
        JSONArray jsonArray = templateJsonObj.getJSONArray(DataModelTransEnum.templateentity.getTableName());
        if (jsonArray == null) {
            return;
        }
        int index = 0;
        HashMap<Long, List> datasetDimensionListMap = new HashMap<Long, List>(16);
        for (Object o : jsonArray) {
            IViewPointDimensionEntry iViewPointDimensionEntry2;
            IDimension dimension;
            if (index++ == 0) continue;
            JSONObject object = (JSONObject)o;
            String fdata = object.getString("FDATA");
            Long fdataset = object.getLong("FDATASETID");
            if (StringUtils.isBlank((CharSequence)fdata) || IDUtils.isEmptyLong((Long)fdataset).booleanValue()) continue;
            List dims = datasetDimensionListMap.computeIfAbsent(fdataset, t -> mainModelCacheHelper.getDimensionList(fdataset));
            Map viewIds = mainModelCacheHelper.getViewsByDataSet(fdataset);
            String ftemplatetype = object.getString("FTEMPLATETYPE");
            ITemplateModel templateModel = null;
            if (BgTemplateTypeEnum.EBFIX.getNumber().equals(ftemplatetype)) {
                templateModel = FixtemplateSerializerUtil.read((String)fdata);
            } else if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(ftemplatetype)) {
                templateModel = TemplateModelJSONUtil.parseITemplateModel((String)fdata);
            }
            if (templateModel == null) continue;
            List pagemembentry = templateModel.getPagemembentry();
            List rowcolDims = templateModel.getRowcolDims();
            List viewpointmembentry = templateModel.getViewpointmembentry();
            HashSet<String> inTemplateDimNumbers = new HashSet<String>(16);
            if (CollectionUtils.isNotEmpty((Collection)pagemembentry)) {
                for (IPageDimensionEntry iPageDimensionEntry : pagemembentry) {
                    if (iPageDimensionEntry == null || (dimension = iPageDimensionEntry.getDimension()) == null) continue;
                    inTemplateDimNumbers.add(dimension.getNumber());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)rowcolDims)) {
                for (String rowcolDim : rowcolDims) {
                    if (rowcolDim == null) continue;
                    inTemplateDimNumbers.add(rowcolDim);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)viewpointmembentry)) {
                for (IViewPointDimensionEntry iViewPointDimensionEntry2 : viewpointmembentry) {
                    if (iViewPointDimensionEntry2 == null || (dimension = iViewPointDimensionEntry2.getDimension()) == null) continue;
                    inTemplateDimNumbers.add(dimension.getNumber());
                }
            }
            boolean flag = false;
            iViewPointDimensionEntry2 = dims.iterator();
            while (iViewPointDimensionEntry2.hasNext()) {
                Dimension newDim = (Dimension)iViewPointDimensionEntry2.next();
                if (newDim == null || inTemplateDimNumbers.contains(newDim.getNumber())) continue;
                DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
                DefaultDimension dimension2 = new DefaultDimension();
                dimension2.setId(newDim.getId());
                dimension2.setNumber(newDim.getNumber());
                dimension2.setShortNumber(newDim.getShortNumber());
                dimension2.setName(newDim.getName());
                dimension2.setDSeq(Integer.valueOf(newDim.getSeq()));
                DefaultDimMember dimensionMember = new DefaultDimMember();
                Member member = mainModelCacheHelper.getMember(dimension2.getNumber(), (Long)viewIds.get(dimension2.getNumber()), newDim.getShortNumber() + "None");
                if (member != null) {
                    dimensionMember.setId(member.getId());
                    dimensionMember.setNumber(member.getNumber());
                    dimensionMember.setName(member.getName());
                }
                viewPointDimensionEntry.setDimension((IDimension)dimension2);
                viewPointDimensionEntry.setMember((IDimensionMember)dimensionMember);
                templateModel.getViewpointmembentry().add(viewPointDimensionEntry);
                flag = true;
            }
            if (!flag) continue;
            String newFData = null;
            if (BgTemplateTypeEnum.EBFIX.getNumber().equals(ftemplatetype)) {
                newFData = FixtemplateSerializerUtil.toJson((ITemplateModel)templateModel);
            } else if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(ftemplatetype)) {
                newFData = TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel);
            }
            if (newFData == null) continue;
            object.put("FDATA", (Object)newFData);
        }
    }

    private Set<Long> getRemoveHasErrorRelationData(Map<Long, Map<String, Set<Long>>> templateRelationParam, Map<String, Map<String, String>> syncErrorNumberMap, DataModelTransEnum dataModelTransEnum) {
        HashSet<Long> toRemoveTemplateIds = new HashSet<Long>(16);
        if (templateRelationParam != null && templateRelationParam.size() > 0) {
            Map templateErrorMap = syncErrorNumberMap.computeIfAbsent(dataModelTransEnum.getFormID(), t -> new HashMap(16));
            QFilter filter1 = new QFilter("id", "in", templateRelationParam.keySet());
            DynamicObjectCollection query1 = QueryServiceHelper.query((String)dataModelTransEnum.getFormID(), (String)"id, number", (QFilter[])filter1.toArray());
            HashMap<Long, String> templateIdNumberMap = new HashMap<Long, String>(16);
            for (DynamicObject dynamicObject : query1) {
                templateIdNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
            }
            for (Map.Entry<Long, Map<String, Set<Long>>> entry : templateRelationParam.entrySet()) {
                Map.Entry<String, Set<Long>> stringSetEntry;
                String formId;
                Map<String, String> errorNumberMap;
                Long templateId = entry.getKey();
                String templateNumber = (String)templateIdNumberMap.get(templateId);
                ArrayList<String> errorDescList = new ArrayList<String>(16);
                Map<String, Set<Long>> value = entry.getValue();
                Iterator<Map.Entry<String, Set<Long>>> iterator = value.entrySet().iterator();
                while (iterator.hasNext() && (errorNumberMap = syncErrorNumberMap.get(formId = (stringSetEntry = iterator.next()).getKey())) != null) {
                    Set<Long> relationIds = stringSetEntry.getValue();
                    QFilter filter = new QFilter("id", "in", relationIds);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)"number", (QFilter[])filter.toArray());
                    for (DynamicObject dynamicObject : query) {
                        String number = dynamicObject.getString("number");
                        String errorInfo = errorNumberMap.get(number);
                        toRemoveTemplateIds.add(templateId);
                        errorDescList.add(number + ":" + errorInfo);
                    }
                }
                if (!CollectionUtils.isNotEmpty(errorDescList)) continue;
                templateErrorMap.put(templateNumber, String.join((CharSequence)";", errorDescList));
            }
        }
        return toRemoveTemplateIds;
    }

    private void downLoadJsonFile(JSONObject jsonObject, String logFileName, IFormView formView) {
        if (formView != null && ((Boolean)formView.getModel().getValue("isdownloadjsonfile")).booleanValue()) {
            DynamicObject mainmodel = (DynamicObject)formView.getModel().getValue("mainmodel");
            String mainModelNumber = mainmodel.getString("shownumber");
            DataModelFormCommon.downLoadJsonFile(jsonObject, mainModelNumber + "!" + logFileName, formView);
        }
    }

    private BgmdMainSubModelLog createExceptionErrorInfo(String exceptionInfo, Long mainModelId, Long subModelId, Date newSyncDate, Long executeUserId) {
        BgmdMainSubModelLog exceptionLog = new BgmdMainSubModelLog(this.createGlobalId(), mainModelId, subModelId, "", "", "", newSyncDate, "1", executeUserId);
        exceptionLog.setSyncfailedreason(exceptionInfo);
        return exceptionLog;
    }

    private JSONObject loadToSyncJson(Map<String, Set<Long>> toSyncParam, Map<String, Set<Long>> param, IModelCacheHelper mainModelCacheHelper, OutputTypeEnum transTypeEnum) {
        JSONObject toSyncJson = null;
        Long mainModelId = mainModelCacheHelper.getModelobj().getId();
        if (toSyncParam.size() > 0) {
            if (transTypeEnum != OutputTypeEnum.ALL && param != null) {
                Set<Long> bizModelIdSet = param.get(DataModelTransEnum.bizmodel.getFormID());
                Set<Long> datasetIds = this.queryDatasetNumberList(bizModelIdSet, mainModelId);
                toSyncParam.computeIfAbsent("eb_dataset", t -> new HashSet(16)).addAll(datasetIds);
            }
            MainSubLoadModelJsonParam mainSubLoadModelJsonParam = new MainSubLoadModelJsonParam();
            mainSubLoadModelJsonParam.setParam(toSyncParam);
            mainSubLoadModelJsonParam.setMainModelCacheHelper(mainModelCacheHelper);
            mainSubLoadModelJsonParam.setSubModelCacheHelper(mainModelCacheHelper);
            mainSubLoadModelJsonParam.setTransType(OutputTypeEnum.PARTIAL);
            mainSubLoadModelJsonParam.setSubModelSync(false);
            mainSubLoadModelJsonParam.setSyncSpecialFilter(false);
            mainSubLoadModelJsonParam.setSyncDate(null);
            mainSubLoadModelJsonParam.setMainModelId(null);
            toSyncJson = MainSubModelTransApi.getInstance().loadModelJson(mainSubLoadModelJsonParam);
        }
        return toSyncJson;
    }

    private Map<String, Set<Long>> getSyncRelationDataParam(Map<MainSubModelSyncTypeEnum, Map<String, Set<Long>>> syncParam, ModelSyncParam modelSyncParam, Long mainModelId, Map<String, Map<Long, Map<String, Set<Long>>>> relationDataMap, Map<Long, Set<Long>> entityByIc) {
        Set modifyViewIds;
        LinkedHashMap<String, Set<Long>> param1;
        if (syncParam == null || syncParam.size() == 0) {
            return new HashMap<String, Set<Long>>(16);
        }
        LinkedHashMap<String, Set<Long>> toSyncParam = new LinkedHashMap<String, Set<Long>>(16);
        Map addParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_ADD, t -> new LinkedHashMap(16));
        Map emptyParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY, t -> new LinkedHashMap(16));
        Map modifyParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY, t -> new LinkedHashMap(16));
        Map addEditParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY_ADD, t -> new LinkedHashMap(16));
        HashMap<Long, Set<String>> icEntityViewIdMap = new HashMap<Long, Set<String>>(16);
        if (modelSyncParam.isSyncBizRule()) {
            param1 = new LinkedHashMap<String, Set<Long>>(16);
            this.mergeParam(addParam, param1);
            this.mergeParam(emptyParam, param1);
            this.mergeParam(addEditParam, param1);
            this.mergeParam(modifyParam, param1);
            Map<Long, Map<String, Set<Long>>> bizRuleRelationData = this.getBizRuleRelationData(param1, icEntityViewIdMap, mainModelId);
            this.mergeParam(param1, toSyncParam);
            relationDataMap.put(DataModelTransEnum.bizruleset.getFormID(), bizRuleRelationData);
        }
        if (modelSyncParam.isSyncExamine()) {
            param1 = new LinkedHashMap(16);
            this.mergeParam(addParam, param1);
            this.mergeParam(emptyParam, param1);
            this.mergeParam(addEditParam, param1);
            this.mergeParam(modifyParam, param1);
            Map<Long, Map<String, Set<Long>>> examineRelationData = this.getExamineRelationData(param1, icEntityViewIdMap, mainModelId);
            this.mergeParam(param1, toSyncParam);
            relationDataMap.put(DataModelTransEnum.examine.getFormID(), examineRelationData);
        }
        param1 = new LinkedHashMap(16);
        this.mergeParam(addParam, param1);
        this.mergeParam(emptyParam, param1);
        this.mergeParam(addEditParam, param1);
        this.mergeParam(modifyParam, param1);
        Map<Long, Map<String, Set<Long>>> templateRelationData = this.getTemplateRelationData(param1, icEntityViewIdMap, mainModelId);
        this.mergeParam(param1, toSyncParam);
        relationDataMap.put(DataModelTransEnum.templateentity.getFormID(), templateRelationData);
        DataModelViewUtil.getInstance().getViewAndDataSetDefaultIds(mainModelId, toSyncParam);
        Set viewMemberIds = (Set)toSyncParam.get(DataModelTransEnum.viewmember.getFormID());
        if (CollectionUtils.isNotEmpty((Collection)viewMemberIds)) {
            HashMap<Long, Set> viewEntityIdMap = new HashMap<Long, Set>(16);
            QFilter filter = new QFilter("id", "in", (Object)viewMemberIds);
            DynamicObjectCollection query = QueryServiceHelper.query((String)DataModelTransEnum.viewmember.getFormID(), (String)"id, memberid, dimension.number, view", (QFilter[])filter.toArray());
            Object formId = "";
            for (DynamicObject dynamicObject : query) {
                long memberid = dynamicObject.getLong("memberid");
                String dimensionNum = dynamicObject.getString("dimension.number");
                long view = dynamicObject.getLong("view");
                Set longs1 = toSyncParam.computeIfAbsent(DataModelTransEnum.dimensionview.getFormID(), t -> new HashSet(16));
                longs1.add(view);
                SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimensionNum);
                formId = enumByNumber == null ? DataModelTransEnum.userdefine.getFormID() : enumByNumber.getMemberTreemodel();
                Set longs = toSyncParam.computeIfAbsent((String)formId, t -> new HashSet(16));
                longs.add(memberid);
                if (!DataModelTransEnum.Entity.getFormID().equalsIgnoreCase((String)formId)) continue;
                Set longs2 = viewEntityIdMap.computeIfAbsent(view, t -> new HashSet(16));
                long id = dynamicObject.getLong("id");
                longs2.add(id);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(modifyViewIds = (Set)modifyParam.get(DataModelTransEnum.dimensionview.getFormID())))) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_membersaveselect", (String)"memberid,dimension.number", (QFilter[])new QFilter("view", "in", (Object)modifyViewIds).toArray());
            for (DynamicObject dynamicObject : query) {
                String dimensionNumber = dynamicObject.getString("dimension.number");
                long memberId = dynamicObject.getLong("memberid");
                SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimensionNumber);
                String formId = enumByNumber == null ? DataModelTransEnum.userdefine.getFormID() : enumByNumber.getMemberTreemodel();
                Set memberIds = toSyncParam.computeIfAbsent(formId, v -> new HashSet(16));
                memberIds.add(memberId);
            }
        }
        if (icEntityViewIdMap.size() > 0) {
            Map<Long, Set<Long>> entityByICs = DataModelICUtil.getInstance().getEntityByICs(mainModelId, icEntityViewIdMap);
            entityByIc.putAll(entityByICs);
            Long baseIcViewId = DataModelICUtil.getInstance().getOneBaseViewId(mainModelId, "IC_E001");
            Set<Long> longs = entityByIc.get(baseIcViewId);
            if (CollectionUtils.isNotEmpty(longs)) {
                entityByIc.put(0L, longs);
            }
            Set dimensionViewIds = toSyncParam.computeIfAbsent(DataModelTransEnum.dimensionview.getFormID(), t -> new HashSet(16));
            dimensionViewIds.addAll(entityByICs.keySet());
            Set entityIds = toSyncParam.computeIfAbsent(DataModelTransEnum.Entity.getFormID(), t -> new HashSet(16));
            HashSet ids = new HashSet(16);
            for (Map.Entry<Long, Set<Long>> entry : entityByICs.entrySet()) {
                ids.addAll(entry.getValue());
            }
            entityIds.addAll(ids);
            Set viewIds = toSyncParam.computeIfAbsent(DataModelTransEnum.viewmember.getFormID(), t -> new HashSet(16));
            viewIds.addAll(ids);
        }
        return toSyncParam;
    }

    private Set<Long> queryDatasetNumberList(Set<Long> bizModelIdSet, Long mainModelId) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(bizModelIdSet) || IDUtils.isEmptyLong((Long)mainModelId).booleanValue()) {
            return result;
        }
        QFilter filter = new QFilter("model", "=", (Object)mainModelId);
        filter.and("businessmodel.id", "in", bizModelIdSet);
        DynamicObjectCollection datasetList = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)datasetList)) {
            return result;
        }
        for (DynamicObject dynamicObject : datasetList) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private void updateSyncMainNumber(Long subModelId, String filterModelField, String tableName, String fnumber, Set<String> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update " + tableName + " set fsyncmainnumber = ' ' where " + filterModelField + " = " + subModelId + " and ", new Object[0]);
        sqlBuilder.appendIn(fnumber, numbers.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    private void mergeParam(Map<String, Set<Long>> param, Map<String, Set<Long>> toParam) {
        for (Map.Entry<String, Set<Long>> entry : param.entrySet()) {
            String key = entry.getKey();
            Set<Long> value = entry.getValue();
            Set strings = toParam.computeIfAbsent(key, t -> new HashSet(16));
            strings.addAll(value);
        }
    }

    private void updateModelSyncStatus(String syncStatus, Long modelId, Date syncDate) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        if (syncDate != null) {
            dynamicObject.set("syncdate", (Object)syncDate);
        }
        if (syncStatus != null) {
            dynamicObject.set("syncstatus", (Object)syncStatus);
        }
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private Map<Long, Map<String, Set<Long>>> getExamineRelationData(Map<String, Set<Long>> param, Map<Long, Set<String>> entityViewIdMap, Long mainModelId) {
        HashMap<Long, Map<String, Set<Long>>> relationParam = new HashMap<Long, Map<String, Set<Long>>>(16);
        Set<Long> examineIdSet = param.get(DataModelTransEnum.examine.getFormID());
        if (CollectionUtils.isEmpty(examineIdSet)) {
            return relationParam;
        }
        QFilter qFilter = new QFilter("id", "in", examineIdSet);
        qFilter.and(new QFilter("model", "=", (Object)mainModelId));
        DynamicObjectCollection examineList = QueryServiceHelper.query((String)DataModelTransEnum.examine.getFormID(), (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)examineList)) {
            return relationParam;
        }
        Map examineDisTemplate = ExamineServiceImpl.getInstance().getExamineDisTemplate(examineIdSet, "t_eb_examine_temp");
        for (Map.Entry entry : examineDisTemplate.entrySet()) {
            Set value = (Set)entry.getValue();
            Set longs = param.computeIfAbsent(DataModelTransEnum.templateentity.getFormID(), t -> new HashSet(16));
            longs.addAll(value);
        }
        IModelCacheHelper mainModelCacheHelper = ModelCacheContext.getOrCreate((Long)mainModelId);
        Map<Long, DynamicObject> map = MainSubModelService.getInstance().queryExamine(examineIdSet);
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            DynamicObject value1 = entry.getValue();
            long id = value1.getLong("id");
            Map stringSetMap = relationParam.computeIfAbsent(id, t -> new HashMap(16));
            Map singDims = ExamineServiceHelper.parseDimViewRangeStr2Map((Long)mainModelId, (Long)entry.getValue().getLong("group.businessmodel.id"), (String)entry.getValue().getString("rangediminfo"), (String)entry.getValue().getString("formula"));
            for (Map.Entry entry1 : singDims.entrySet()) {
                String dimNumber = (String)entry1.getKey();
                Map value = (Map)entry1.getValue();
                for (Map.Entry longSetEntry : value.entrySet()) {
                    Long viewId = (Long)longSetEntry.getKey();
                    Set numberSet = (Set)longSetEntry.getValue();
                    this.addRelationMember(dimNumber, numberSet, mainModelCacheHelper, viewId, param, entityViewIdMap, stringSetMap);
                }
            }
        }
        return relationParam;
    }

    private Map<Long, Map<String, Set<Long>>> getTemplateRelationData(Map<String, Set<Long>> param, Map<Long, Set<String>> entityViewIdMap, Long mainModelId) {
        HashMap<Long, Map<String, Set<Long>>> relationParam = new HashMap<Long, Map<String, Set<Long>>>(16);
        if (param == null || param.size() == 0) {
            return relationParam;
        }
        Set<Long> templateIdSet = param.get(DataModelTransEnum.templateentity.getFormID());
        if (CollectionUtils.isEmpty(templateIdSet)) {
            return relationParam;
        }
        IModelCacheHelper mainModelCacheHelper = ModelCacheContext.getOrCreate((Long)mainModelId);
        QFilter qFilter = new QFilter("id", "in", templateIdSet);
        qFilter.and(new QFilter("model", "=", (Object)mainModelId));
        DynamicObjectCollection templateList = QueryServiceHelper.query((String)DataModelTransEnum.templateentity.getFormID(), (String)"id, data,dataset", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return relationParam;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)mainModelId)});
        HashSet<Long> viewIdsFromDb = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                viewIdsFromDb.add(dynamicObject.getLong("id"));
            }
        }
        for (DynamicObject templateObj : templateList) {
            ITemplateModel iTemplateModel;
            long dataset = templateObj.getLong("dataset");
            String data = templateObj.getString("data");
            long id = templateObj.getLong("id");
            if (!StringUtils.isNotBlank((CharSequence)data) || (iTemplateModel = TemplateModelJSONUtil.parseITemplateModel((String)data)) == null) continue;
            Map stringSetMap = relationParam.computeIfAbsent(id, t -> new HashMap(16));
            Map<String, Map<Long, Collection<String>>> stringCollectionMap = MainSubModelService.getInstance().getTemplateDimMap(data, dataset);
            for (Map.Entry<String, Map<Long, Collection<String>>> entry : stringCollectionMap.entrySet()) {
                String dimNum = entry.getKey();
                Map<Long, Collection<String>> value = entry.getValue();
                for (Map.Entry<Long, Collection<String>> entry1 : value.entrySet()) {
                    Long viewId = entry1.getKey();
                    if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue() && CollectionUtils.isNotEmpty(viewIdsFromDb) && !viewIdsFromDb.contains(viewId)) {
                        log.info("mainsubmodel getTemplateRelationData viewId:" + viewId + " is not exist");
                        continue;
                    }
                    Collection<String> memberNumber = entry1.getValue();
                    this.addRelationMember(dimNum, memberNumber, mainModelCacheHelper, viewId, param, entityViewIdMap, stringSetMap);
                }
            }
        }
        return relationParam;
    }

    private Map<Long, Map<String, Set<Long>>> getBizRuleRelationData(Map<String, Set<Long>> param, Map<Long, Set<String>> entityViewIdMap, Long mainModelId) {
        HashMap<Long, Map<String, Set<Long>>> relationParam = new HashMap<Long, Map<String, Set<Long>>>(16);
        if (param == null || param.size() == 0) {
            return relationParam;
        }
        Set<Long> ruleIdList = param.get(DataModelTransEnum.bizruleset.getFormID());
        if (CollectionUtils.isEmpty(ruleIdList)) {
            return relationParam;
        }
        QFilter qFilter = new QFilter("id", "in", ruleIdList);
        qFilter.and(new QFilter("model", "=", (Object)mainModelId));
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"eb_bizruleset", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Long> ruleIds = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)ruleList)) {
            ruleIds.addAll(ruleList.stream().map(t -> t.getLong("id")).collect(Collectors.toList()));
        }
        IModelCacheHelper mainModelCacheHelper = ModelCacheContext.getOrCreate((Long)mainModelId);
        List<RuleRefMember> ruleRefMemberList = RuleUtils.getRuleRefMember(mainModelId, ruleIds);
        if (CollectionUtils.isNotEmpty(ruleRefMemberList)) {
            for (RuleRefMember ruleRefMember : ruleRefMemberList) {
                Map<String, RuleRefMember.RuleViewRefMember> refMemberMap = ruleRefMember.getRefMemberMap();
                Long ruleId = ruleRefMember.getRuleId();
                Map stringSetMap = relationParam.computeIfAbsent(ruleId, t -> new HashMap(16));
                for (Map.Entry<String, RuleRefMember.RuleViewRefMember> entry : refMemberMap.entrySet()) {
                    String dimNumber = entry.getKey();
                    RuleRefMember.RuleViewRefMember value = entry.getValue();
                    Long viewId = value.getViewId();
                    Set<String> memberNums = value.getMembers();
                    this.addRelationMember(dimNumber, memberNums, mainModelCacheHelper, viewId, param, entityViewIdMap, stringSetMap);
                }
            }
        }
        return relationParam;
    }

    private void addRelationMember(String dimNum, Collection<String> memberNums, IModelCacheHelper mainModelCacheHelper, Long viewId, Map<String, Set<Long>> param, Map<Long, Set<String>> entityViewIdMap, Map<String, Set<Long>> relationParam) {
        String formId = "";
        SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimNum);
        formId = enumByNumber != null ? enumByNumber.getMemberTreemodel() : DataModelTransEnum.userdefine.getFormID();
        List members = null;
        members = SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimNum) ? mainModelCacheHelper.getMembers(dimNum, null, memberNums) : mainModelCacheHelper.getMembers(dimNum, viewId, memberNums);
        HashSet<Long> memberIds = new HashSet<Long>(16);
        for (Member member : members) {
            memberIds.add(member.getId());
            Set strings = param.computeIfAbsent(formId, t -> new HashSet(16));
            strings.add(member.getId());
            Set longs = relationParam.computeIfAbsent(formId, t -> new HashSet(16));
            longs.add(member.getId());
            if (!DataModelTransEnum.InternalCompany.getFormID().equalsIgnoreCase(formId)) continue;
            Set strings1 = entityViewIdMap.computeIfAbsent(viewId, t -> new HashSet(16));
            strings1.add(member.getId() + "");
        }
        if (!SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimNum)) {
            Set<Long> viewMemberIds = this.queryViewMemberIds(mainModelCacheHelper.getModelobj().getId(), viewId, memberIds);
            Set longs = param.computeIfAbsent(DataModelTransEnum.viewmember.getFormID(), t -> new HashSet(16));
            longs.addAll(viewMemberIds);
            Set longs1 = relationParam.computeIfAbsent(DataModelTransEnum.viewmember.getFormID(), t -> new HashSet(16));
            longs1.addAll(viewMemberIds);
        }
    }

    private Set<Long> queryViewMemberIds(Long modelId, Long viewId, Set<Long> memberIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("view", "=", (Object)viewId);
        filter.and("memberid", "in", memberIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id", (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : query) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private Set<Long> queryBaseDataIdSet(String formId, Set<String> numberSet, Long modelId) {
        HashSet<Long> result = new HashSet<Long>(16);
        String numberFlag = "number";
        if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(formId)) {
            numberFlag = "code";
        }
        if (DataModelTransEnum.custompropertyvalue.getFormID().equalsIgnoreCase(formId)) {
            return new HashSet<Long>(16);
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter(numberFlag, "in", numberSet));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return result;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private Long createGlobalId() {
        return DB.genGlobalLongId();
    }

    private Map<String, List<BgmdMainSubModelLog>> createSubModelSyncLogList(Map<MainSubModelSyncTypeEnum, Map<String, Set<String>>> syncLogParam, Map<String, Map<String, String>> syncErrorNumberMap, Set<String> excludeFormIds, Long mainModelId, Long subModelId, Long syncUserId, Date syncDate) {
        HashMap<String, List<BgmdMainSubModelLog>> result = new HashMap<String, List<BgmdMainSubModelLog>>(16);
        if (syncLogParam == null || syncLogParam.size() == 0) {
            return result;
        }
        LinkedHashMap<Long, String> userDimensionIdNameMap = new LinkedHashMap<Long, String>(16);
        for (Map.Entry<MainSubModelSyncTypeEnum, Map<String, Set<String>>> entryType : syncLogParam.entrySet()) {
            MainSubModelSyncTypeEnum key = entryType.getKey();
            Map<String, Set<String>> value = entryType.getValue();
            Long id = this.createGlobalId();
            for (Map.Entry<String, Set<String>> entry : value.entrySet()) {
                DataModelTransEnum dataModelTransEnum;
                String formId = entry.getKey();
                if (excludeFormIds.contains(formId) || (dataModelTransEnum = DataModelTransEnum.getEnumByFormID(formId)) == null) continue;
                String moduleName = dataModelTransEnum.getChineseName();
                if (dataModelTransEnum == DataModelTransEnum.dimensionvariable) {
                    moduleName = ResManager.loadKDString((String)"\u53d8\u91cf-\u7ef4\u5ea6", (String)"DataModelTransEnum_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (dataModelTransEnum == DataModelTransEnum.periodvariable) {
                    moduleName = ResManager.loadKDString((String)"\u53d8\u91cf", (String)"DataModelTransEnum_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                Set<String> numberSet = entry.getValue();
                Map<String, String> errorCodeDescMap = null;
                if (syncErrorNumberMap != null) {
                    errorCodeDescMap = syncErrorNumberMap.get(formId);
                }
                for (String number : numberSet) {
                    String syncbasedata;
                    if (StringUtils.equalsIgnoreCase((CharSequence)DataModelTransEnum.userdefine.getFormID(), (CharSequence)formId)) {
                        Long dimensionId = IDUtils.toLong((Object)number.split("#")[0]);
                        syncbasedata = number.split("#")[1];
                        String dimensionName = (String)userDimensionIdNameMap.get(dimensionId);
                        if (StringUtils.isBlank((CharSequence)dimensionName)) {
                            dimensionName = this.queryDimensionName(dimensionId);
                            userDimensionIdNameMap.put(dimensionId, dimensionName);
                        }
                        moduleName = dimensionName;
                    } else {
                        syncbasedata = number;
                    }
                    String errorDesc = null;
                    if (errorCodeDescMap != null) {
                        errorDesc = StringUtils.isNotEmpty((CharSequence)number) && number.contains("#") && number.split("#").length == 2 ? errorCodeDescMap.get(number.split("#")[1]) : errorCodeDescMap.get(number);
                    }
                    String syncStatus = StringUtils.isNotBlank(errorDesc) ? "1" : "0";
                    BgmdMainSubModelLog bgmdMainSubModelLog = new BgmdMainSubModelLog(id, mainModelId, subModelId, moduleName, syncbasedata, key.getNumber(), syncDate, syncStatus, syncUserId);
                    bgmdMainSubModelLog.setSyncfailedreason(errorDesc);
                    List bgmdMainSubModelLogs = result.computeIfAbsent(syncStatus, t -> new ArrayList(16));
                    bgmdMainSubModelLogs.add(bgmdMainSubModelLog);
                }
            }
        }
        return result;
    }

    private String queryDimensionName(Long dimensionId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimensionId)});
        if (dynamicObject == null) {
            return "";
        }
        return ((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue();
    }

    private void handleMainModifyDataForHasSyncStatus(JSONObject jsonObjectValue, Map<MainSubModelSyncTypeEnum, Map<String, Set<Long>>> syncParam, Map<MainSubModelSyncTypeEnum, Map<String, Set<String>>> syncLogParam, Map<String, Set<String>> addEditParamToUpdateSubModel, Long mainModelId, ModelSyncParam modelSyncParam, Set<Long> icEntityDimensionIds) {
        Map modifyParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY, t -> new LinkedHashMap(16));
        Map deleteParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_DELETE, t -> new LinkedHashMap(16));
        Map addEditParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY_ADD, t -> new LinkedHashMap(16));
        Map modifyParamLog = syncLogParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY, t -> new LinkedHashMap(16));
        Map deleteParamLog = syncLogParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_DELETE, t -> new LinkedHashMap(16));
        Map addEditParamLog = syncLogParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_MODIFY_ADD, t -> new LinkedHashMap(16));
        HashMap<String, Set> addEditNumberParam = new HashMap<String, Set>(16);
        for (Map.Entry stringObjectEntry : jsonObjectValue.entrySet()) {
            String tableName = (String)stringObjectEntry.getKey();
            DataModelTransEnum enumByTableName = DataModelTransEnum.getEnumByTableName(tableName);
            if (enumByTableName == null) continue;
            String formIdName = enumByTableName.getFormID();
            String numberFlag = enumByTableName.getFnumber().toUpperCase();
            if (DataModelTransEnum.custompropertyvalue == enumByTableName) {
                numberFlag = "FNUMBER";
            }
            if (StringUtils.isBlank((CharSequence)formIdName) || StringUtils.equalsIgnoreCase((CharSequence)formIdName, (CharSequence)DataModelTransEnum.model.getFormID()) || !DMMainSubConfig.subModelSyncFormIds.contains(formIdName)) continue;
            Object valueArrayObj = stringObjectEntry.getValue();
            if (valueArrayObj instanceof JSONArray) {
                JSONArray valueArray = (JSONArray)valueArrayObj;
                for (Object o : valueArray) {
                    Set strings;
                    String fsyncmainnumber;
                    JSONObject valueJson = (JSONObject)o;
                    String fnumber = valueJson.getString(numberFlag);
                    if (StringUtils.isBlank((CharSequence)fnumber)) continue;
                    long fid = valueJson.getLong("FID");
                    String fsyncstatus = valueJson.getString("FSYNCSTATUS");
                    if (DataModelTransEnum.viewmember.getFormID().equalsIgnoreCase(formIdName)) {
                        Long dimensionId = valueJson.getLong("FDIMENSIONID");
                        if (icEntityDimensionIds != null && icEntityDimensionIds.size() > 0 && icEntityDimensionIds.contains(dimensionId)) continue;
                    }
                    if (valueJson.containsKey((Object)"FSYNCMAINNUMBER") && StringUtils.isNotBlank((CharSequence)(fsyncmainnumber = valueJson.getString("FSYNCMAINNUMBER"))) && modelSyncParam.isSyncModify()) {
                        if (!modelSyncParam.isSyncExamine() && DataModelTransEnum.examine.getFormID().equalsIgnoreCase(formIdName) || !modelSyncParam.isSyncTemplate() && DataModelTransEnum.templateentity.getFormID().equalsIgnoreCase(formIdName)) continue;
                        Set strings2 = addEditNumberParam.computeIfAbsent(formIdName, t -> new HashSet(16));
                        strings2.add(fsyncmainnumber);
                        Set strings1 = addEditParamToUpdateSubModel.computeIfAbsent(formIdName, t -> new HashSet(16));
                        strings1.add(fnumber);
                        this.addLogParam(addEditParamLog, formIdName, fsyncmainnumber, valueJson);
                        continue;
                    }
                    if ("2".equalsIgnoreCase(fsyncstatus)) {
                        if (!modelSyncParam.isSyncDelete() || !modelSyncParam.isSyncBizRule() && DataModelTransEnum.bizruleset.getFormID().equalsIgnoreCase(formIdName) || !modelSyncParam.isSyncExamine() && DataModelTransEnum.examine.getFormID().equalsIgnoreCase(formIdName) || !modelSyncParam.isSyncTemplate() && DataModelTransEnum.templateentity.getFormID().equalsIgnoreCase(formIdName)) continue;
                        strings = deleteParam.computeIfAbsent(formIdName, t -> new HashSet(16));
                        strings.add(fid);
                        this.addLogParam(deleteParamLog, formIdName, fnumber, valueJson);
                        continue;
                    }
                    if (!"3".equalsIgnoreCase(fsyncstatus) || !modelSyncParam.isSyncModify() || !modelSyncParam.isSyncBizRule() && DataModelTransEnum.bizruleset.getFormID().equalsIgnoreCase(formIdName) || !modelSyncParam.isSyncExamine() && DataModelTransEnum.examine.getFormID().equalsIgnoreCase(formIdName) || !modelSyncParam.isSyncTemplate() && DataModelTransEnum.templateentity.getFormID().equalsIgnoreCase(formIdName)) continue;
                    strings = modifyParam.computeIfAbsent(formIdName, t -> new HashSet(16));
                    strings.add(fid);
                    this.addLogParam(modifyParamLog, formIdName, fnumber, valueJson);
                }
            }
            if (modifyParam.size() > 0) {
                Set subModelBaseDataIds = (Set)modifyParam.get(formIdName);
                numberFlag = "number";
                if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(formIdName)) {
                    numberFlag = "code";
                }
                String selectFields = "";
                selectFields = DataModelTransEnum.viewmember.getFormID().equalsIgnoreCase(formIdName) ? selectFields + numberFlag + ",view.number,dimension.number" : selectFields + numberFlag;
                QFilter filter = new QFilter("id", "in", (Object)subModelBaseDataIds);
                DynamicObjectCollection query = QueryServiceHelper.query((String)formIdName, (String)selectFields, (QFilter[])filter.toArray());
                HashSet<String> mainModelBaseDataNumbers = new HashSet<String>(16);
                HashMap<String, Set> dimensionViewNumberMap = new HashMap<String, Set>(16);
                if (DataModelTransEnum.viewmember.getFormID().equalsIgnoreCase(formIdName)) {
                    Object dynamicObject2;
                    for (Object dynamicObject2 : query) {
                        String dimNum = dynamicObject2.getString("dimension.number");
                        String viewNumber = dynamicObject2.getString("view.number");
                        String number = dynamicObject2.getString(numberFlag);
                        Set strings = dimensionViewNumberMap.computeIfAbsent(dimNum + "#" + viewNumber, t -> new HashSet(16));
                        strings.add(number);
                    }
                    HashSet ids = new HashSet(16);
                    dynamicObject2 = dimensionViewNumberMap.entrySet().iterator();
                    while (dynamicObject2.hasNext()) {
                        Map.Entry entry1 = (Map.Entry)dynamicObject2.next();
                        String key = (String)entry1.getKey();
                        Set value = (Set)entry1.getValue();
                        String dimNum = key.split("#")[0];
                        String viewNum = key.split("#")[1];
                        QFilter filter1 = new QFilter("model", "=", (Object)mainModelId);
                        filter1.and("dimension.number", "=", (Object)dimNum);
                        filter1.and("view.number", "=", (Object)viewNum);
                        filter1.and("number", "in", (Object)value);
                        DynamicObjectCollection id = QueryServiceHelper.query((String)"eb_viewmember", (String)"id", (QFilter[])filter1.toArray());
                        for (DynamicObject dynamicObject3 : id) {
                            ids.add(dynamicObject3.getLong("id"));
                        }
                        modifyParam.put(formIdName, ids);
                    }
                } else {
                    for (Object dynamicObject2 : query) {
                        if (DataModelTransEnum.examinecategory.getFormID().equalsIgnoreCase(formIdName)) {
                            mainModelBaseDataNumbers.add(dynamicObject2.getString("code"));
                            continue;
                        }
                        mainModelBaseDataNumbers.add(dynamicObject2.getString("number"));
                    }
                    Set<Long> longs1 = this.queryBaseDataIdSet(formIdName, mainModelBaseDataNumbers, mainModelId);
                    modifyParam.put(formIdName, longs1);
                }
            }
            if (addEditNumberParam.size() <= 0) continue;
            Set value = (Set)addEditNumberParam.get(formIdName);
            Set<Long> longs = this.queryBaseDataIdSet(formIdName, value, mainModelId);
            Set longs1 = addEditParam.computeIfAbsent(formIdName, t -> new HashSet(16));
            longs1.addAll(longs);
        }
    }

    private void addLogParam(Map<String, Set<String>> syncLogParam, String formId, String fnumber, JSONObject valueJson) {
        if (StringUtils.equalsIgnoreCase((CharSequence)DataModelTransEnum.userdefine.getFormID(), (CharSequence)formId)) {
            Set strings = syncLogParam.computeIfAbsent(formId, t -> new HashSet(16));
            String dimensionid = valueJson.getString("FDIMENSIONID");
            strings.add(dimensionid + "#" + fnumber);
        } else {
            Set strings = syncLogParam.computeIfAbsent(formId, t -> new HashSet(16));
            strings.add(fnumber);
        }
    }

    private Set<Long> queryIcEntityDimensionIds() {
        HashSet<Long> result = new HashSet<Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("membertable", "=", (Object)SysDimensionEnum.InternalCompany.getMemberTreetable())});
        for (DynamicObject dynamicObject : query) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    public void getMainModelModifyData(JSONObject subModelJsonObj, Map<MainSubModelSyncTypeEnum, Map<String, Set<Long>>> syncParam, Map<MainSubModelSyncTypeEnum, Map<String, Set<String>>> syncLogParam, Map<String, Set<String>> addEditParamToUpdateSubModel, Long mainModelId, ModelSyncParam modelSyncParam) {
        Set<Long> icEntityDimensionIds = this.queryIcEntityDimensionIds();
        for (Map.Entry entry : subModelJsonObj.entrySet()) {
            String formId = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JSONObject)) continue;
            JSONObject jsonObjectValue = (JSONObject)value;
            if (!DMMainSubConfig.subModelSyncFormIds.contains(formId) || StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.InternalCompany.getFormID())) continue;
            this.handleMainModifyDataForHasSyncStatus(jsonObjectValue, syncParam, syncLogParam, addEditParamToUpdateSubModel, mainModelId, modelSyncParam, icEntityDimensionIds);
        }
    }

    public void getMainModelAddData(JSONObject jsonObject, Map<MainSubModelSyncTypeEnum, Map<String, Set<Long>>> syncParam, Map<MainSubModelSyncTypeEnum, Map<String, Set<String>>> syncLogParam, Date syncdate, ModelSyncParam modelSyncParam, OutputTypeEnum transTypeEnum, String subModelNumber, Long mainModelId) {
        Map addParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_ADD, t -> new LinkedHashMap(16));
        Map emptyParam = syncParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY, t -> new LinkedHashMap(16));
        Map addParamLog = syncLogParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_ADD, t -> new LinkedHashMap(16));
        Map emptyParamLog = syncLogParam.computeIfAbsent(MainSubModelSyncTypeEnum.SYNC_EMPTY, t -> new LinkedHashMap(16));
        Set<Long> icEntityDimensionIds = this.queryIcEntityDimensionIds();
        for (Map.Entry entry : jsonObject.entrySet()) {
            DataModelTransEnum dataModelTransEnum;
            String tableName;
            Object value;
            String formId = (String)entry.getKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.InternalCompany.getFormID()) || StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.model.getFormID()) || (value = entry.getValue()) == null || StringUtils.isBlank((CharSequence)(tableName = DataModelTransEnum.getTableNameByFormID(formId))) || (dataModelTransEnum = DataModelTransEnum.getEnumByTableName(tableName)) == null) continue;
            String FnumberFlag = dataModelTransEnum.getFnumber().toUpperCase();
            String numberFlag = "number";
            if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.examinecategory.getFormID())) {
                numberFlag = "code";
            }
            if (!DMMainSubConfig.subModelSyncFormIds.contains(formId) || DataModelTransEnum.model.getFormID().equalsIgnoreCase(formId)) continue;
            JSONObject jsonObjectValue = (JSONObject)value;
            LinkedHashSet<String> numbers = new LinkedHashSet<String>(16);
            HashMap<Long, Set> subModelViewMemberNumberMap = null;
            HashMap<String, Long> subModelViewNumberIdMap = new HashMap<String, Long>(16);
            HashMap<Long, String> mainModelViewIdNumberMap = new HashMap<Long, String>(16);
            if (transTypeEnum == OutputTypeEnum.PARTIAL_SYNC || StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) {
                DynamicObjectCollection collection;
                ArrayList<String> selectFields = new ArrayList<String>(16);
                selectFields.add(numberFlag);
                if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) {
                    selectFields.add("view");
                    selectFields.add("view.number");
                    selectFields.add("view.dimension.number");
                }
                if (CollectionUtils.isNotEmpty((Collection)(collection = QueryServiceHelper.query((String)formId, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{new QFilter("model.number", "=", (Object)subModelNumber)})))) {
                    subModelViewMemberNumberMap = new HashMap<Long, Set>(16);
                    for (Object dynamicObject : collection) {
                        String number = dynamicObject.getString(numberFlag);
                        numbers.add(number);
                        if (!StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) continue;
                        long view = dynamicObject.getLong("view");
                        subModelViewNumberIdMap.put(dynamicObject.getString("view.number") + dynamicObject.getString("view.dimension.number"), view);
                        Set strings = subModelViewMemberNumberMap.computeIfAbsent(view, t -> new HashSet(16));
                        strings.add(number);
                    }
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) {
                    Object dynamicObject;
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id, number,dimension.number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)mainModelId)});
                    dynamicObject = query.iterator();
                    while (dynamicObject.hasNext()) {
                        DynamicObject dynamicObject2 = (DynamicObject)dynamicObject.next();
                        mainModelViewIdNumberMap.put(dynamicObject2.getLong("id"), dynamicObject2.getString("number") + dynamicObject2.getString("dimension.number"));
                    }
                }
            }
            for (Map.Entry stringObjectEntry : jsonObjectValue.entrySet()) {
                Object valueArrayObj = stringObjectEntry.getValue();
                if (!(valueArrayObj instanceof JSONArray)) continue;
                JSONArray valueArray = (JSONArray)valueArrayObj;
                for (Object o : valueArray) {
                    Set strings;
                    JSONObject valueJson = (JSONObject)o;
                    if (!valueJson.containsKey((Object)FnumberFlag)) continue;
                    String fnumber = valueJson.getString(FnumberFlag);
                    Long fid = valueJson.getLong("FID");
                    if (StringUtils.isBlank((CharSequence)fnumber)) continue;
                    Date fcreatedate = valueJson.getDate("FCREATEDATE");
                    if (fcreatedate == null) {
                        fcreatedate = valueJson.getDate("FCREATETIME");
                    }
                    if (fcreatedate == null) {
                        Date fmodifydate = valueJson.getDate("FMODIFYDATE");
                        if (fmodifydate == null) {
                            fmodifydate = valueJson.getDate("FMODIFYTIME");
                        }
                        fcreatedate = fmodifydate;
                    }
                    if (fcreatedate == null) continue;
                    if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) {
                        Long dimensionId = valueJson.getLong("FDIMENSIONID");
                        if (icEntityDimensionIds.size() > 0 && icEntityDimensionIds.contains(dimensionId)) continue;
                        Set emptyViewNumbers = emptyParam.computeIfAbsent(formId, t -> new HashSet(16));
                        if (subModelViewMemberNumberMap != null) {
                            Long mainViewId = valueJson.getLong("FVIEWID");
                            String mainViewNumber = null;
                            if (mainViewId != null) {
                                mainViewNumber = (String)mainModelViewIdNumberMap.get(mainViewId);
                            }
                            Long subViewId = null;
                            if (mainViewNumber != null) {
                                subViewId = (Long)subModelViewNumberIdMap.get(mainViewNumber);
                            }
                            if (subViewId != null) {
                                Set strings2 = (Set)subModelViewMemberNumberMap.get(subViewId);
                                if (strings2.contains(fnumber)) continue;
                                emptyViewNumbers.add(fid);
                                this.addLogParam(emptyParamLog, formId, fnumber, valueJson);
                                continue;
                            }
                            emptyViewNumbers.add(fid);
                            this.addLogParam(emptyParamLog, formId, fnumber, valueJson);
                            continue;
                        }
                        emptyViewNumbers.add(fid);
                        this.addLogParam(emptyParamLog, formId, fnumber, valueJson);
                        continue;
                    }
                    if (transTypeEnum == OutputTypeEnum.PARTIAL_SYNC && !numbers.contains(fnumber)) {
                        strings = emptyParam.computeIfAbsent(formId, t -> new HashSet(16));
                        strings.add(fid);
                        this.addLogParam(emptyParamLog, formId, fnumber, valueJson);
                        continue;
                    }
                    if (fcreatedate.getTime() <= syncdate.getTime() || StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID()) || !modelSyncParam.isSyncAdd() || !modelSyncParam.isSyncBizRule() && DataModelTransEnum.bizruleset.getFormID().equalsIgnoreCase(formId) || !modelSyncParam.isSyncExamine() && DataModelTransEnum.examine.getFormID().equalsIgnoreCase(formId) || !modelSyncParam.isSyncTemplate() && DataModelTransEnum.templateentity.getFormID().equalsIgnoreCase(formId)) continue;
                    strings = addParam.computeIfAbsent(formId, t -> new HashSet(16));
                    strings.add(fid);
                    this.addLogParam(addParamLog, formId, fnumber, valueJson);
                }
            }
        }
    }

    private Map<String, List<String>> checkTemplateIsReferenced(Set<Long> idSet) {
        DynamicObjectCollection query;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        if (CollectionUtils.isEmpty(idSet)) {
            return result;
        }
        QFilter filter = new QFilter("id", "in", idSet);
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
        DynamicObjectCollection templateList = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return result;
        }
        for (DynamicObject dynamicObject : templateList) {
            idNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        Set toDeleteTemplateIds = idNumberMap.keySet();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_task", (String)"name, entryentity.templateid", (QFilter[])new QFilter[]{new QFilter("entryentity.templateid", "in", toDeleteTemplateIds)});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (Object dynamicObject : dynamicObjects) {
                Long templateId = dynamicObject.getLong("entryentity.templateid");
                List errorResultList = result.computeIfAbsent((String)idNumberMap.get(templateId), (Function<String, List<String>>)((Function<String, List>)t -> new ArrayList(16)));
                errorResultList.add(ResManager.loadKDString((String)"\u6240\u9009\u6a21\u677f\u5df2\u88ab\u4efb\u52a1\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTemplateListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObjects.stream().map(e -> e.getString("name")).collect(Collectors.toSet())}));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_rollconfig", (String)"rolltemplate.fbasedataid", (QFilter[])new QFilter[]{new QFilter("rolltemplate.fbasedataid", "in", toDeleteTemplateIds)})))) {
            for (DynamicObject dynamicObject : query) {
                Long templateId = dynamicObject.getLong("rolltemplate.fbasedataid");
                List errorResultList = result.computeIfAbsent((String)idNumberMap.get(templateId), (Function<String, List<String>>)((Function<String, List>)t -> new ArrayList(16)));
                errorResultList.add(ResManager.loadKDString((String)"\u6240\u9009\u6a21\u677f\u5df2\u88ab\u6eda\u52a8\u9884\u7b97\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTemplateListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)"eb_templateorg", (String)"template", (QFilter[])new QFilter[]{new QFilter("template", "in", toDeleteTemplateIds)});
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"templateid", (QFilter[])new QFilter[]{new QFilter("templateid", "in", toDeleteTemplateIds)});
        if (CollectionUtils.isNotEmpty((Collection)query1) || CollectionUtils.isNotEmpty((Collection)query2)) {
            List errorResultList;
            Long templateId;
            for (DynamicObject dynamicObject : query1) {
                templateId = dynamicObject.getLong("template");
                errorResultList = result.computeIfAbsent((String)idNumberMap.get(templateId), (Function<String, List<String>>)((Function<String, List>)t -> new ArrayList(16)));
                errorResultList.add(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u7f16\u5236\u65b9\u6848\u6216\u9884\u7b97\u6a21\u677f\u6743\u9650\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTemplateListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject dynamicObject : query2) {
                templateId = dynamicObject.getLong("templateid");
                errorResultList = result.computeIfAbsent((String)idNumberMap.get(templateId), (Function<String, List<String>>)((Function<String, List>)t -> new ArrayList(16)));
                errorResultList.add(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u7f16\u5236\u65b9\u6848\u6216\u9884\u7b97\u6a21\u677f\u6743\u9650\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTemplateListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private void deleteSubModelSync(Map<String, Set<Long>> deleteParam, Map<String, Map<String, String>> syncErrorNumberMap, Long subModelId, IModelCacheHelper subModelCacheHelper) {
        if (deleteParam == null || deleteParam.size() <= 0) {
            return;
        }
        LinkedHashMap<Long, CheckQuote> checkQuoteMap = new LinkedHashMap<Long, CheckQuote>(16);
        String entityHasInnerOrOutOrgErrorInfo = ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5728\u5b50\u4f53\u7cfb\u4e2d\u5b58\u5728\u5f80\u6765\u7ec4\u7ec7\uff0c\u540c\u6b65\u5220\u9664\u5931\u8d25\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        for (Map.Entry<String, Set<Long>> entry : deleteParam.entrySet()) {
            String errorInfo;
            DataModelTransEnum dataModelTransEnum;
            String formId = entry.getKey();
            Set<Long> idSet = entry.getValue();
            if (StringUtils.equals((CharSequence)DataModelTransEnum.model.getFormID(), (CharSequence)formId) || CollectionUtils.isEmpty(idSet) || (dataModelTransEnum = DataModelTransEnum.getEnumByFormID(formId)) == null) continue;
            HashSet<Long> toDeleteParentIds = new HashSet<Long>(16);
            Iterator<Long> iterator = idSet.iterator();
            if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)DataModelTransEnum.viewmember.getFormID())) {
                DynamicObject dynamicObject;
                QFilter filter = new QFilter("id", "in", idSet);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, view, parent, memberid, dimension.number, dimension, isouterorg,isinnerorg", (QFilter[])filter.toArray());
                HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(16);
                Iterator iterator2 = query.iterator();
                while (iterator2.hasNext()) {
                    dynamicObject = (DynamicObject)iterator2.next();
                    hashMap.put(dynamicObject.getLong("id"), dynamicObject);
                }
                while (iterator.hasNext()) {
                    Long next = iterator.next();
                    dynamicObject = (DynamicObject)hashMap.get(next);
                    if (dynamicObject == null) continue;
                    String baseDataNum = dynamicObject.getString("number");
                    boolean isouterorg = dynamicObject.getBoolean("isouterorg");
                    boolean isinnerorg = dynamicObject.getBoolean("isinnerorg");
                    if (!isouterorg && !isinnerorg) continue;
                    Map map = syncErrorNumberMap.computeIfAbsent(formId, t -> new HashMap(16));
                    String errorInfoStr = (String)map.get(baseDataNum);
                    if (StringUtils.isBlank((CharSequence)errorInfoStr)) {
                        map.put(baseDataNum, entityHasInnerOrOutOrgErrorInfo);
                    } else {
                        errorInfo = String.join((CharSequence)";", entityHasInnerOrOutOrgErrorInfo, errorInfoStr);
                        map.put(baseDataNum, errorInfo);
                    }
                    iterator.remove();
                }
            }
            if (DataModelTransEnum.templateentity.getFormID().equalsIgnoreCase(formId)) {
                Map<String, List<String>> errorIdMap = this.checkTemplateIsReferenced(idSet);
                for (Map.Entry entry2 : errorIdMap.entrySet()) {
                    Map map = syncErrorNumberMap.computeIfAbsent(formId, t -> new HashMap(16));
                    String key = (String)entry2.getKey();
                    List value = (List)entry2.getValue();
                    map.computeIfAbsent(key, t -> String.join((CharSequence)";", value));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)iterator.next().toString())) continue;
                    iterator.remove();
                }
            } else if (!DataModelTransEnum.examine.getFormID().equalsIgnoreCase(formId) && !DataModelTransEnum.bizruleset.getFormID().equalsIgnoreCase(formId)) {
                SysDimensionEnum enumByMemberTreemodel = SysDimensionEnum.getEnumByMemberTreemodel((String)formId);
                if (DataModelTransEnum.userdefine.getFormID().equalsIgnoreCase(formId)) {
                    Object dynamicObject22;
                    QFilter filter = new QFilter("id", "in", idSet);
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)formId, (String)"id, dimension", (QFilter[])filter.toArray());
                    HashMap<Long, Set> userdefineDimensionIdsMap = new HashMap<Long, Set>(16);
                    for (Object dynamicObject22 : dynamicObjectCollection) {
                        long dimension = dynamicObject22.getLong("dimension");
                        long id = dynamicObject22.getLong("id");
                        Set longs = userdefineDimensionIdsMap.computeIfAbsent(dimension, t -> new HashSet(16));
                        longs.add(id);
                    }
                    Set hasQuoteIds = null;
                    dynamicObject22 = userdefineDimensionIdsMap.entrySet().iterator();
                    while (dynamicObject22.hasNext()) {
                        Map.Entry entry1 = (Map.Entry)dynamicObject22.next();
                        Long dimensionId = (Long)entry1.getKey();
                        Set value = (Set)entry1.getValue();
                        QFilter filter2 = new QFilter("id", "in", idSet);
                        DynamicObjectCollection query2 = QueryServiceHelper.query((String)formId, (String)"id, number, parent", (QFilter[])filter2.toArray());
                        HashMap<Long, DynamicObject> wantToDeleteMap = new HashMap<Long, DynamicObject>(16);
                        for (DynamicObject dynamicObject3 : query2) {
                            wantToDeleteMap.put(dynamicObject3.getLong("id"), dynamicObject3);
                        }
                        CheckQuote checkQuote = checkQuoteMap.computeIfAbsent(dimensionId, t -> QuoteBuilder.build((Long)subModelId, (Long)dimensionId, (Set)value));
                        checkQuote.setCheckChild(true);
                        hasQuoteIds = MemberQuote.get().checkQuote(checkQuote);
                        QuoteCheckResult quoteCheckResult = MemberQuote.get().checkQuoteResult(checkQuote);
                        errorInfo = quoteCheckResult.getMsg();
                        this.removeMemberIdIfHasQuote(hasQuoteIds, wantToDeleteMap, iterator, formId, toDeleteParentIds, errorInfo, syncErrorNumberMap);
                    }
                } else if (enumByMemberTreemodel != null) {
                    String number = enumByMemberTreemodel.getNumber();
                    Dimension dimension = subModelCacheHelper.getDimension(number);
                    Set hasQuoteIds = null;
                    QFilter filter = new QFilter("id", "in", idSet);
                    String selectFields = "id, number, parent";
                    if (DataModelTransEnum.Entity.getFormID().equalsIgnoreCase(formId)) {
                        selectFields = selectFields + ", isouterorg, isinnerorg";
                    }
                    DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])filter.toArray());
                    HashMap<Long, DynamicObject> wantToDeleteMap = new HashMap<Long, DynamicObject>(16);
                    for (DynamicObject dynamicObject : query) {
                        wantToDeleteMap.put(dynamicObject.getLong("id"), dynamicObject);
                    }
                    if (dimension != null) {
                        CheckQuote checkQuote = checkQuoteMap.computeIfAbsent(dimension.getId(), t -> QuoteBuilder.build((Long)subModelId, (Long)dimension.getId(), (Set)idSet));
                        checkQuote.setCheckChild(true);
                        hasQuoteIds = MemberQuote.get().checkQuote(checkQuote);
                        QuoteCheckResult quoteCheckResult = MemberQuote.get().checkQuoteResult(checkQuote);
                        errorInfo = quoteCheckResult.getMsg();
                        this.removeMemberIdIfHasQuote(hasQuoteIds, wantToDeleteMap, iterator, formId, toDeleteParentIds, errorInfo, syncErrorNumberMap);
                        if (DataModelTransEnum.Entity.getFormID().equalsIgnoreCase(formId)) {
                            while (iterator.hasNext()) {
                                Long next = iterator.next();
                                DynamicObject dynamicObject = (DynamicObject)wantToDeleteMap.get(next);
                                if (dynamicObject == null) continue;
                                String baseDataNum = dynamicObject.getString("number");
                                boolean isouterorg = dynamicObject.getBoolean("isouterorg");
                                boolean isinnerorg = dynamicObject.getBoolean("isinnerorg");
                                if (!isouterorg && !isinnerorg) continue;
                                Map map = syncErrorNumberMap.computeIfAbsent(formId, t -> new HashMap(16));
                                String errorInfoStr = (String)map.get(baseDataNum);
                                if (StringUtils.isBlank((CharSequence)errorInfoStr)) {
                                    map.put(baseDataNum, entityHasInnerOrOutOrgErrorInfo);
                                } else {
                                    errorInfo = String.join((CharSequence)";", entityHasInnerOrOutOrgErrorInfo, errorInfoStr);
                                    map.put(baseDataNum, errorInfo);
                                }
                                iterator.remove();
                            }
                        }
                    }
                }
            }
            String tableName = dataModelTransEnum.getTableName();
            if (CollectionUtils.isNotEmpty(idSet)) {
                String subModelNumber = subModelCacheHelper.getModelobj().getNumber();
                if (CollectionUtils.isNotEmpty(idSet)) {
                    Set<Long> set = this.queryDeleteMainSubModelBaseRele(subModelNumber, idSet);
                    this.deleteMainSubModelBaseRele(set);
                }
                this.deleteSubModelData(dataModelTransEnum, idSet);
            }
            this.updateParentIsLeaf(toDeleteParentIds, formId, tableName);
        }
    }

    private void updateParentIsLeaf(Set<Long> toDeleteParentIds, String formId, String tableName) {
        if (CollectionUtils.isNotEmpty(toDeleteParentIds)) {
            DynamicObjectCollection parent = QueryServiceHelper.query((String)formId, (String)"id, parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", toDeleteParentIds)});
            if (CollectionUtils.isEmpty((Collection)parent)) {
                this.updateMemberToLeaf(toDeleteParentIds, tableName);
            } else {
                HashSet<Long> toUpdateParentIds = new HashSet<Long>(16);
                HashSet<Long> hasParentIds = new HashSet<Long>(16);
                for (DynamicObject dynamicObject : parent) {
                    long parentId = dynamicObject.getLong("parent");
                    hasParentIds.add(parentId);
                }
                for (Long toDeleteParentId : toDeleteParentIds) {
                    if (hasParentIds.contains(toDeleteParentId)) continue;
                    toUpdateParentIds.add(toDeleteParentId);
                }
                this.updateMemberToLeaf(toUpdateParentIds, tableName);
            }
        }
    }

    private void removeMemberIdIfHasQuote(Set<Long> hasQuoteIds, Map<Long, DynamicObject> wantToDeleteMap, Iterator<Long> iterator, String formId, Set<Long> toDeleteParentIds, String errorInfo, Map<String, Map<String, String>> syncErrorNumberMap) {
        if (CollectionUtils.isNotEmpty(hasQuoteIds)) {
            while (iterator.hasNext()) {
                Long id = iterator.next();
                DynamicObject dynamicObject = wantToDeleteMap.get(id);
                if (dynamicObject == null) continue;
                String baseDataNum = dynamicObject.getString("number");
                long parent = dynamicObject.getLong("parent");
                if (hasQuoteIds.contains(id)) {
                    Map map = syncErrorNumberMap.computeIfAbsent(formId, t -> new HashMap(16));
                    String errorInfoStr = (String)map.get(baseDataNum);
                    if (StringUtils.isBlank((CharSequence)errorInfoStr)) {
                        map.put(baseDataNum, errorInfo);
                    } else {
                        errorInfo = String.join((CharSequence)";", errorInfo, errorInfoStr);
                        map.put(baseDataNum, errorInfo);
                    }
                    iterator.remove();
                    continue;
                }
                toDeleteParentIds.add(parent);
            }
        }
    }

    private Set<Long> queryDeleteMainSubModelBaseRele(String subModelNumber, Set<Long> toDeleteReleDataIds) {
        HashSet<Long> toDeleteMainSubModelBaseReleIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fentryid from t_eb_mainsubmodel a, t_eb_mainsubmodel_rele b where a.fid = b.fid and a.fnumber = '" + subModelNumber + "' and ", new Object[0]);
        sqlBuilder.appendIn(" b.freledataid ", toDeleteReleDataIds.toArray());
        DataSet dataSet = DB.queryDataSet((String)"queryMainSubModelBase", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        while (dataSet != null && dataSet.hasNext()) {
            Row next = dataSet.next();
            Long fid = next.getLong("fentryid");
            toDeleteMainSubModelBaseReleIds.add(fid);
        }
        return toDeleteMainSubModelBaseReleIds;
    }

    private void deleteMainSubModelBaseRele(Set<Long> toDeleteMainSubModelBaseReleIds) {
        if (CollectionUtils.isNotEmpty(toDeleteMainSubModelBaseReleIds)) {
            SqlBuilder deleteBuilder = new SqlBuilder();
            deleteBuilder.append("delete from t_eb_mainsubmodel_rele where ", new Object[0]);
            deleteBuilder.appendIn(" fentryid ", toDeleteMainSubModelBaseReleIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)deleteBuilder);
        }
    }

    private void updateMemberToLeaf(Set<Long> ids, String tableName) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update " + tableName + " set fisleaf = '1' where ", new Object[0]);
        sqlBuilder.appendIn(" fid ", ids.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    private void deleteSubModelData(DataModelTransEnum enumByTableName, Set<Long> idSet) {
        if (CollectionUtils.isEmpty(idSet)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", idSet);
        DeleteServiceHelper.delete((String)enumByTableName.getFormID(), (QFilter[])filter.toArray());
    }

    private void handleBaseDataSyncLevelSlip(JSONObject toSyncJson, Map<String, Map<String, String>> syncErrorNumberMap, IModelCacheHelper subModelCacheHelper, IModelCacheHelper mainModelCacheHelper) {
        if (toSyncJson == null || subModelCacheHelper == null) {
            return;
        }
        String tableName = null;
        JSONObject jsonObject = null;
        for (SysDimensionEnum value : SysDimensionEnum.values()) {
            String formId = value.getMemberTreemodel();
            jsonObject = toSyncJson.getJSONObject(formId);
            DataModelTransEnum enumByFormID = DataModelTransEnum.getEnumByFormID(formId);
            if (enumByFormID == null) continue;
            tableName = enumByFormID.getTableName().toLowerCase();
            this.handleDimSlip(jsonObject, syncErrorNumberMap, tableName, subModelCacheHelper, mainModelCacheHelper);
        }
        jsonObject = toSyncJson.getJSONObject(DataModelTransEnum.viewmember.getFormID());
        tableName = DataModelTransEnum.viewmember.getTableName().toLowerCase();
        this.handleViewMemberSlip(jsonObject, tableName, subModelCacheHelper.getModelobj().getId(), mainModelCacheHelper);
    }

    private void handleModelSync(JSONObject modelJson, String tableName, IModelCacheHelper subModelCacheHelper, Date syncDate) {
        if (modelJson == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        JSONArray jsonArray = modelJson.getJSONArray(tableName);
        DynamicObject subModelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"level", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subModelCacheHelper.getModelobj().getId())});
        if (subModelObj != null) {
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                if (!jsonObject.containsKey((Object)"FID")) continue;
                jsonObject.put("FLEVEL", subModelObj.get("level"));
                jsonObject.put("FSYNCDATE", (Object)syncDate);
            }
        }
    }

    private void handleViewMemberSlip(JSONObject viewMemberJsonFromMain, String tableName, Long subModelId, IModelCacheHelper mainModelCacheHelper) {
        if (viewMemberJsonFromMain == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        Long mainModelId = mainModelCacheHelper.getModelobj().getId();
        JSONArray jsonArray = viewMemberJsonFromMain.getJSONArray(tableName);
        HashMap<Long, Set> viewIddInJson = new HashMap<Long, Set>(16);
        for (Object o : jsonArray) {
            JSONObject next = (JSONObject)o;
            if (!next.containsKey((Object)"FID") || !next.containsKey((Object)"FVIEWID")) continue;
            Long fviewid = next.getLong("FVIEWID");
            Long fid = next.getLong("FID");
            Set longs = viewIddInJson.computeIfAbsent(fviewid, t -> new HashSet(16));
            longs.add(fid);
        }
        QFilter subModelFilter = new QFilter("model", "=", (Object)subModelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"dimension.number, number, id", (QFilter[])subModelFilter.toArray());
        HashMap<String, Map> subDimensionViewMap = new HashMap<String, Map>(16);
        for (DynamicObject dynamicObject : query) {
            Map dimension = subDimensionViewMap.computeIfAbsent(dynamicObject.getString("dimension.number"), t -> new HashMap(16));
            dimension.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
        }
        QFilter mainModelFilter = new QFilter("model", "=", (Object)mainModelId);
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)"eb_dimensionview", (String)"dimension.number, number, id", (QFilter[])mainModelFilter.toArray());
        HashMap<String, Map> mainDimensionViewMap = new HashMap<String, Map>(16);
        for (DynamicObject dynamicObject : query1) {
            Map dimensionIdMap = mainDimensionViewMap.computeIfAbsent(dynamicObject.getString("dimension.number"), t -> new HashMap(16));
            dimensionIdMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        Iterator iterator = jsonArray.iterator();
        HashSet<Long> parentMemberIdSet = new HashSet<Long>(16);
        while (iterator.hasNext()) {
            QFilter filter2;
            DynamicObjectCollection mainModelParentCollection;
            Dimension mainDimension;
            JSONObject next = (JSONObject)iterator.next();
            if (!next.containsKey((Object)"FID") || !next.containsKey((Object)"FVIEWID")) continue;
            Long fviewid = next.getLong("FVIEWID");
            Long fdimensionid = next.getLong("FDIMENSIONID");
            Long fparentid = next.getLong("FPARENTID");
            Set longs = (Set)viewIddInJson.get(fviewid);
            if (CollectionUtils.isNotEmpty((Collection)longs) && longs.contains(fparentid) || (mainDimension = mainModelCacheHelper.getDimension(fdimensionid)) == null || CollectionUtils.isEmpty((Collection)(mainModelParentCollection = QueryServiceHelper.query((String)"eb_viewmember", (String)"number, id", (QFilter[])(filter2 = new QFilter("id", "=", (Object)fparentid)).toArray())))) continue;
            String mainMemberNumber = ((DynamicObject)mainModelParentCollection.get(0)).getString("number");
            Map mainDimensionViewIdMap = (Map)mainDimensionViewMap.get(mainDimension.getNumber());
            Map subViewIdMap = (Map)subDimensionViewMap.get(mainDimension.getNumber());
            String fnumber = next.getString("FNUMBER");
            if (mainDimensionViewIdMap == null || subViewIdMap == null) continue;
            String viewNumber = (String)mainDimensionViewIdMap.get(fviewid);
            Long subViewId = (Long)subViewIdMap.get(viewNumber);
            if (IDUtils.isNotEmptyLong((Long)subViewId).booleanValue()) {
                QFilter filter3 = new QFilter("number", "=", (Object)mainMemberNumber);
                filter3.and("view", "=", (Object)subViewId);
                filter3.and(subModelFilter);
                DynamicObjectCollection subParentMemberCollection = QueryServiceHelper.query((String)"eb_viewmember", (String)"number, id, longnumber,level", (QFilter[])filter3.toArray());
                QFilter filter4 = new QFilter("view", "=", (Object)subViewId);
                filter4.and("number", "=", (Object)mainDimension.getNumber());
                filter4.and(subModelFilter);
                DynamicObjectCollection rootMemberCollection = QueryServiceHelper.query((String)"eb_viewmember", (String)"number, id, longnumber, level", (QFilter[])filter4.toArray());
                if (CollectionUtils.isNotEmpty((Collection)subParentMemberCollection)) {
                    next.put("FPARENTID", (Object)((DynamicObject)subParentMemberCollection.get(0)).getLong("id"));
                    next.put("FLONGNUMBER", (Object)(((DynamicObject)subParentMemberCollection.get(0)).getString("longnumber") + "!" + fnumber));
                    next.put("FLEVEL", (Object)(((DynamicObject)subParentMemberCollection.get(0)).getInt("level") + 1));
                    parentMemberIdSet.add(((DynamicObject)subParentMemberCollection.get(0)).getLong("id"));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)rootMemberCollection)) continue;
                next.put("FPARENTID", (Object)((DynamicObject)rootMemberCollection.get(0)).getLong("id"));
                next.put("FLONGNUMBER", (Object)(mainDimension.getNumber() + "!" + fnumber));
                next.put("FLEVEL", (Object)2);
                parentMemberIdSet.add(((DynamicObject)rootMemberCollection.get(0)).getLong("id"));
                continue;
            }
            Member parent = mainModelCacheHelper.getMember(mainDimension.getNumber(), fviewid, mainMemberNumber);
            Long id = parent.getId();
            if (longs.contains(id)) {
                next.put("FPARENTID", (Object)parent.getId());
                next.put("FLONGNUMBER", (Object)(parent.getLongNumber() + "!" + fnumber));
                next.put("FLEVEL", (Object)(parent.getLevel() + 1));
                parentMemberIdSet.add(parent.getId());
                continue;
            }
            Member root = mainModelCacheHelper.getMember(mainDimension.getNumber(), fviewid, SysDimensionEnum.Entity.getNumber());
            next.put("FPARENTID", (Object)root.getId());
            next.put("FLONGNUMBER", (Object)(root.getLongNumber() + "!" + fnumber));
            next.put("FLEVEL", (Object)(root.getLevel() + 1));
            parentMemberIdSet.add(root.getId());
        }
        if (CollectionUtils.isNotEmpty(parentMemberIdSet)) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update " + tableName + " set fisleaf = '0' where ", new Object[0]);
            sqlBuilder.appendIn(" fid ", parentMemberIdSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
    }

    private void handleDimSlip(JSONObject dimJson, Map<String, Map<String, String>> syncErrorNumberMap, String tableName, IModelCacheHelper subModelCacheHelper, IModelCacheHelper mainModelCacheHelper) {
        Dimension subModelDimension;
        Long fdimensionid;
        Dimension dimension;
        Long parentId;
        String fparentid;
        if (dimJson == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        JSONArray jsonArray = dimJson.getJSONArray(tableName);
        DataModelTransEnum enumByTableName = DataModelTransEnum.getEnumByTableName(tableName);
        if (enumByTableName == null) {
            return;
        }
        String numberFlag = enumByTableName.getFnumber().toUpperCase();
        Long subModelId = subModelCacheHelper.getModelobj().getId();
        LinkedHashMap<Long, CheckQuote> checkQuoteMap = new LinkedHashMap<Long, CheckQuote>(16);
        Member rootMember = null;
        HashSet<Long> parentMemberIdSet = new HashSet<Long>(16);
        HashSet<Long> idsInJson = new HashSet<Long>(16);
        HashMap<Long, Set> dimCheckQuoteParentIdSetMap = new HashMap<Long, Set>(16);
        for (Object o : jsonArray) {
            Member subModelMember;
            Member mainModelMember;
            Member subModelParentMember;
            String fidStr;
            Long fid;
            JSONObject jSONObject = (JSONObject)o;
            if (!jSONObject.containsKey((Object)"FID") || IDUtils.isEmptyLong((Long)(fid = IDUtils.toLong((Object)(fidStr = jSONObject.getString("FID"))))).booleanValue()) continue;
            idsInJson.add(fid);
            fparentid = jSONObject.getString("FPARENTID");
            parentId = IDUtils.toLong((Object)fparentid);
            if (IDUtils.isEmptyLong((Long)parentId).booleanValue() || (dimension = mainModelCacheHelper.getDimension(fdimensionid = jSONObject.getLong("FDIMENSIONID"))) == null || (subModelDimension = subModelCacheHelper.getDimension(dimension.getNumber())) == null) continue;
            Member mainModelParentMember = dimension.getStructOfMember(parentId);
            if (mainModelParentMember != null && (subModelParentMember = subModelDimension.getStructOfMember(mainModelParentMember.getNumber())) != null) {
                Set longs = dimCheckQuoteParentIdSetMap.computeIfAbsent(subModelDimension.getId(), t -> new HashSet(16));
                longs.add(subModelParentMember.getId());
            }
            if ((mainModelMember = dimension.getStructOfMember(fid)) == null || (subModelMember = subModelDimension.getStructOfMember(mainModelMember.getNumber())) == null) continue;
            Set longs = dimCheckQuoteParentIdSetMap.computeIfAbsent(subModelDimension.getId(), t -> new HashSet(16));
            longs.add(subModelMember.getId());
        }
        HashMap<Long, Set> hasQuoteMemberIdSetMap = new HashMap<Long, Set>(16);
        for (Map.Entry entry : dimCheckQuoteParentIdSetMap.entrySet()) {
            Long dimensionId = (Long)entry.getKey();
            Set parentIdSet = (Set)entry.getValue();
            CheckQuote checkQuote = checkQuoteMap.computeIfAbsent(dimensionId, t -> QuoteBuilder.build((Long)subModelId, (Long)dimensionId, (Set)parentIdSet));
            Set longs = MemberQuote.get().checkDataQuote(checkQuote);
            Set longs1 = hasQuoteMemberIdSetMap.computeIfAbsent(dimensionId, t -> new HashSet(16));
            longs1.addAll(longs);
        }
        String errorDesc = ResManager.loadKDString((String)"\u6b64\u6210\u5458\u5728\u5b50\u4f53\u7cfb\u7684\u4e2d\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u540c\u6b65\u8be5\u6210\u5458\u5c06\u5b50\u4f53\u7cfb\u7684\u6210\u5458\u66f4\u65b0\u4e3a\u975e\u660e\u7ec6\u3002", (String)"BgmdMainSubModelSyncService_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            JSONObject jsonObject = (JSONObject)o;
            if (!jsonObject.containsKey((Object)"FID") || IDUtils.isEmptyLong((Long)(parentId = IDUtils.toLong((Object)(fparentid = jsonObject.getString("FPARENTID"))))).booleanValue() || (dimension = mainModelCacheHelper.getDimension(fdimensionid = jsonObject.getLong("FDIMENSIONID"))) == null || (subModelDimension = subModelCacheHelper.getDimension(dimension.getNumber())) == null) continue;
            String dimensionNumber = dimension.getNumber();
            if (rootMember == null) {
                QFilter filter = new QFilter("model", "=", (Object)subModelId);
                filter.and(new QFilter("number", "=", (Object)dimensionNumber));
                DynamicObject rootMemberObj = QueryServiceHelper.queryOne((String)enumByTableName.getFormID(), (String)"id", (QFilter[])new QFilter[]{filter});
                if (rootMemberObj != null) {
                    rootMember = subModelDimension.getStructOfMember(Long.valueOf(rootMemberObj.getLong("id")));
                }
            }
            Long rootMemberId = 0L;
            if (rootMember != null) {
                rootMemberId = rootMember.getId();
            }
            String fnumber = jsonObject.getString(numberFlag);
            if (!idsInJson.contains(parentId)) {
                Member mainModelParentMember = dimension.getStructOfMember(parentId);
                if (mainModelParentMember != null) {
                    Member subModelParentMember = subModelDimension.getStructOfMember(mainModelParentMember.getNumber());
                    if (subModelParentMember == null) {
                        jsonObject.put("FPARENTID", (Object)rootMemberId);
                        jsonObject.put("FLONGNUMBER", (Object)(dimensionNumber + "!" + fnumber));
                        jsonObject.put("FLEVEL", (Object)2);
                        parentMemberIdSet.add(rootMemberId);
                    } else {
                        Set longs = (Set)hasQuoteMemberIdSetMap.get(subModelDimension.getId());
                        if (CollectionUtils.isNotEmpty((Collection)longs) && longs.contains(subModelParentMember.getId())) {
                            Map map = syncErrorNumberMap.computeIfAbsent(enumByTableName.getFormID(), t -> new HashMap(16));
                            String errorInfoStr = (String)map.get(fnumber);
                            if (StringUtils.isBlank((CharSequence)errorInfoStr)) {
                                map.put(fnumber, errorDesc);
                            } else {
                                map.put(fnumber, String.join((CharSequence)";", errorInfoStr, errorDesc));
                            }
                            iterator.remove();
                            continue;
                        }
                        jsonObject.put("FPARENTID", (Object)subModelParentMember.getId());
                        jsonObject.put("FLONGNUMBER", (Object)(subModelParentMember.getLongNumber() + "!" + fnumber));
                        jsonObject.put("FLEVEL", (Object)(subModelParentMember.getLevel() + 1));
                        parentMemberIdSet.add(subModelParentMember.getId());
                    }
                } else {
                    jsonObject.put("FPARENTID", (Object)rootMemberId);
                    jsonObject.put("FLONGNUMBER", (Object)(dimensionNumber + "!" + fnumber));
                    jsonObject.put("FLEVEL", (Object)2);
                    parentMemberIdSet.add(rootMemberId);
                }
            } else {
                Set longs;
                Member subModelParentMember;
                long subModelParentId = 0L;
                Member mainModelParentMember = dimension.getStructOfMember(parentId);
                if (mainModelParentMember != null && (subModelParentMember = subModelDimension.getStructOfMember(mainModelParentMember.getNumber())) != null) {
                    subModelParentId = subModelParentMember.getId();
                }
                if (CollectionUtils.isNotEmpty((Collection)(longs = (Set)hasQuoteMemberIdSetMap.get(subModelDimension.getId()))) && IDUtils.isNotEmptyLong((Long)subModelParentId).booleanValue() && longs.contains(subModelParentId)) {
                    Map map = syncErrorNumberMap.computeIfAbsent(enumByTableName.getFormID(), t -> new HashMap(16));
                    String errorInfoStr = (String)map.get(fnumber);
                    if (StringUtils.isBlank((CharSequence)errorInfoStr)) {
                        map.put(fnumber, errorDesc);
                    } else {
                        map.put(fnumber, String.join((CharSequence)";", errorInfoStr, errorDesc));
                    }
                    iterator.remove();
                }
            }
            String fisleaf = jsonObject.getString("FISLEAF");
            if (!StringUtils.equals((CharSequence)fisleaf, (CharSequence)"0")) continue;
        }
        if (CollectionUtils.isNotEmpty(parentMemberIdSet)) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update " + tableName + " set fisleaf = '0' where ", new Object[0]);
            sqlBuilder.appendIn(" fid ", parentMemberIdSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
    }

    public DynamicObject queryModelObj(String modelNumber) {
        if (StringUtils.isBlank((CharSequence)modelNumber)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"epm_model", (String)"id, shownumber, name, parentnumber, datasource.id, syncstatus, syncdate", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
    }

    public DynamicObject queryMainModelObj(String subModelNumber) {
        if (StringUtils.isBlank((CharSequence)subModelNumber)) {
            return null;
        }
        try {
            DynamicObject subModelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"parentnumber, id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)subModelNumber)});
            if (subModelObj == null) {
                return null;
            }
            String mainModelNumber = subModelObj.getString("parentnumber");
            return QueryServiceHelper.queryOne((String)"epm_model", (String)"id, shownumber, name, parentnumber, syncstatus, syncdate", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)mainModelNumber)});
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return null;
        }
    }

    public static String getSyncStatusDesc(String syncStatus) {
        return BgmdMainSubModelSyncConstant.CHANGE_TYPE_DESC_MAP.get(syncStatus);
    }

    public static DynamicObject[] querySubModelSyncInfo(String subModelNumber, String formId, String selectedFields) {
        QFilter filter = new QFilter("model.shownumber", "=", (Object)subModelNumber);
        String fields = "number, name, syncdate, syncstatus, syncmainnumber";
        if (StringUtils.isNotBlank((CharSequence)selectedFields)) {
            fields = selectedFields;
            if (DMMainSubConfig.subModelCanEditNumberFormIdSet.contains(formId)) {
                fields = fields + ",syncmainnumber";
            }
        }
        return BusinessDataServiceHelper.load((String)formId, (String)fields, (QFilter[])filter.toArray());
    }

    public static Map<String, DynamicObject> getSyncInfoMap(String subModelNumber, String formId, String selectedFields) {
        LinkedHashMap<String, DynamicObject> syncInfoMap = new LinkedHashMap<String, DynamicObject>(16);
        DynamicObject[] dynamicObjects = BgmdMainSubModelSyncService.querySubModelSyncInfo(subModelNumber, formId, selectedFields);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String number = dynamicObject.getString("number");
                syncInfoMap.put(number, dynamicObject);
            }
        }
        return syncInfoMap;
    }

    public void renderSyncInfoToBillList(DynamicObjectCollection data, String subModelNumber, String formId, List<QFilter> userFilter) {
        Object syncstatus;
        DynamicObject dynamicObject = data.addNew();
        HashSet<String> names = null;
        Map<String, DynamicObject> syncInfoMap = null;
        HashMap<String, DynamicObject> mainNumberMap = null;
        if (StringUtils.isNotBlank((CharSequence)subModelNumber)) {
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            names = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("fseq".equalsIgnoreCase(name)) continue;
                names.add(name);
            }
            syncInfoMap = BgmdMainSubModelSyncService.getSyncInfoMap(subModelNumber, formId, String.join((CharSequence)",", names));
            mainNumberMap = new HashMap<String, DynamicObject>(16);
            for (Map.Entry<String, DynamicObject> entry : syncInfoMap.entrySet()) {
                String string;
                DynamicObject value = entry.getValue();
                if (!value.containsProperty("syncmainnumber") || !StringUtils.isNotBlank((CharSequence)(string = value.getString("syncmainnumber")))) continue;
                mainNumberMap.put(string, value);
            }
            data.remove((Object)dynamicObject);
        }
        Date syncdate = this.getSubModelSyncDate(subModelNumber);
        ArrayList<DynamicObject> newDataList = new ArrayList<DynamicObject>(16);
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            if (syncInfoMap == null) continue;
            String string = row.getString("number");
            DynamicObject subObj = syncInfoMap.get(string);
            if (subObj != null) {
                syncstatus = subObj.get("syncstatus");
                Object subSyncdate = subObj.get("syncdate");
                if (!StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)String.valueOf(syncstatus))) {
                    row.set("syncstatus", syncstatus);
                } else {
                    row.set("syncstatus", (Object)"");
                }
                row.set("syncdate", subSyncdate);
            } else {
                Date createdate = null;
                if (row.containsProperty("createdate")) {
                    createdate = row.getDate("createdate");
                }
                if (createdate == null && row.containsProperty("createtime")) {
                    createdate = row.getDate("createtime");
                }
                if (mainNumberMap != null && mainNumberMap.size() > 0) {
                    DynamicObject modifyMainNumber = (DynamicObject)mainNumberMap.get(string);
                    if (modifyMainNumber != null) {
                        row.set("syncstatus", (Object)"5");
                    } else if (syncdate != null && createdate != null && createdate.getTime() > syncdate.getTime()) {
                        row.set("syncstatus", (Object)"4");
                    }
                } else if (syncdate != null && createdate != null && createdate.getTime() > syncdate.getTime()) {
                    row.set("syncstatus", (Object)"4");
                }
            }
            if (StringUtils.equals((CharSequence)String.valueOf(row.get("syncstatus")), (CharSequence)"1")) {
                row.set("syncstatus", (Object)"");
            }
            newDataList.add(row);
            iterator.remove();
        }
        if (syncInfoMap != null && names != null) {
            for (Map.Entry entry : syncInfoMap.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                syncstatus = value.get("syncstatus");
                if (!StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)syncstatus.toString())) continue;
                DynamicObject row = data.addNew();
                for (String name : names) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"syncstatus", (CharSequence)name)) {
                        row.set("syncstatus", (Object)"2");
                        continue;
                    }
                    row.set(name, value.get(name));
                }
            }
        }
        if (names != null) {
            for (DynamicObject dynamicObject2 : newDataList) {
                DynamicObject row = data.addNew();
                for (String name : names) {
                    row.set(name, dynamicObject2.get(name));
                }
            }
        }
        MainSubListDataFilterUtil.filterDataByUserFilter(userFilter, data, formId);
    }

    public DynamicObject[] renderDimMemberSyncList(String subModelNumber, DynamicObject[] members, Long viewId, String dimensionNum, String formId, String selectFields, String orderBy) {
        DynamicObjectCollection query;
        if (members == null || members.length == 0) {
            return members;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        result.addAll(Arrays.asList(members));
        Date syncdate = new BgmdMainSubModelSyncService().getSubModelSyncDate(subModelNumber);
        QFilter filter = new QFilter("model.shownumber", "=", (Object)subModelNumber);
        if (!DMMainSubConfig.subModelSyncFormIds.contains(formId)) {
            return members;
        }
        filter.and("syncstatus", "in", (Object)new Object[]{"2", "3"});
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue() && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)})))) {
            String viewNumber = ((DynamicObject)query.get(0)).getString("number");
            filter.and("view.number", "=", (Object)viewNumber);
        }
        filter.and("dimension.number", "=", (Object)dimensionNum);
        DynamicObjectCollection load = new DynamicObjectCollection();
        if (SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimensionNum)) {
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)formId, (String)selectFields, (QFilter[])filter.toArray(), (String)orderBy);
            load.addAll((Collection)Arrays.stream(loads).collect(Collectors.toList()));
        } else {
            load = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])filter.toArray(), (String)orderBy);
        }
        HashMap<String, DynamicObject> subMemberMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> subSyncDeleteMap = new HashMap<String, DynamicObject>(16);
        if (load != null && load.size() > 0) {
            for (DynamicObject dynamicObject : load) {
                String number = dynamicObject.getString("number");
                subMemberMap.put(number, dynamicObject);
                String syncstatus = dynamicObject.getString("syncstatus");
                if (!StringUtils.equalsIgnoreCase((CharSequence)syncstatus, (CharSequence)"2")) continue;
                subSyncDeleteMap.put(number, dynamicObject);
            }
        }
        for (DynamicObject member : members) {
            DynamicObject dynamicObject;
            String mainMemberNumber = member.getString("number");
            Date createDate = null;
            if (member.containsProperty("createtime")) {
                createDate = member.getDate("createtime");
            }
            if (createDate == null && member.containsProperty("createdate")) {
                createDate = member.getDate("createdate");
            }
            if (createDate == null && member.containsProperty("modifytime")) {
                createDate = member.getDate("modifytime");
            }
            if (createDate == null && member.containsProperty("modifydate")) {
                createDate = member.getDate("modifydate");
            }
            if ((dynamicObject = (DynamicObject)subMemberMap.get(mainMemberNumber)) != null) {
                String syncstatus = dynamicObject.getString("syncstatus");
                Date subSyncDate = dynamicObject.getDate("syncdate");
                member.set("syncstatus", (Object)syncstatus);
                member.set("syncdate", (Object)subSyncDate);
                continue;
            }
            if (syncdate == null || createDate == null || createDate.getTime() <= syncdate.getTime()) continue;
            member.set("syncstatus", (Object)"4");
        }
        if (subSyncDeleteMap.size() > 0) {
            for (Map.Entry entry : subSyncDeleteMap.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                if (SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimensionNum)) {
                    value.set("parent", (Object)members[0]);
                } else {
                    value.set("parent", (Object)members[0].getLong("id"));
                }
                value.set("syncstatus", (Object)"2");
                value.set("syncdate", (Object)value.getDate("syncdate"));
                value.set("isleaf", (Object)Boolean.TRUE);
                result.add(value);
            }
        }
        return result.toArray(new DynamicObject[0]);
    }

    public Date getSubModelSyncDate(String subModelNumber) {
        Date syncdate = null;
        DynamicObject subModel = QueryServiceHelper.queryOne((String)"epm_model", (String)"syncdate", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)subModelNumber)});
        if (subModel != null) {
            syncdate = subModel.getDate("syncdate");
        }
        return syncdate;
    }

    private static /* synthetic */ List lambda$syncSubModel$13(String t) {
        return new ArrayList(16);
    }

    private static /* synthetic */ List lambda$syncSubModel$12(String t) {
        return new ArrayList(16);
    }

    private static /* synthetic */ Map lambda$syncSubModel$11(String t) {
        return new HashMap(16);
    }

    private static /* synthetic */ Map lambda$syncSubModel$10(String t) {
        return new HashMap(16);
    }

    private static /* synthetic */ boolean lambda$syncSubModel$9(MainSubTransportRangeEnum value, String t) {
        return value.getCode().equals(t);
    }

    private static /* synthetic */ List lambda$syncSubModel$8(String t) {
        return new ArrayList(16);
    }

    private static /* synthetic */ Set lambda$syncSubModel$7(String t) {
        return new HashSet(16);
    }

    public static class ModelSyncParam {
        private String subModelNumber;
        private boolean isSyncExamine = true;
        private boolean isSyncBizRule = true;
        private boolean isSyncTemplate = true;
        private boolean isSyncAdd = true;
        private boolean isSyncDelete = true;
        private boolean isSyncModify = true;
        private Long executeUserId;
        private IFormView formView = null;
        private boolean isAddSync = false;

        public ModelSyncParam(String subModelNumber, boolean isSyncExamine, boolean isSyncBizRule, boolean isSyncTemplate, boolean isSyncAdd, boolean isSyncDelete, boolean isSyncModify, Long executeUserId, boolean isAddSync) {
            this.subModelNumber = subModelNumber;
            this.isSyncExamine = isSyncExamine;
            this.isSyncBizRule = isSyncBizRule;
            this.isSyncTemplate = isSyncTemplate;
            this.isSyncAdd = isSyncAdd;
            this.isSyncDelete = isSyncDelete;
            this.isSyncModify = isSyncModify;
            this.executeUserId = executeUserId;
            this.isAddSync = isAddSync;
        }

        public ModelSyncParam(String subModelNumber, boolean isSyncExamine, boolean isSyncBizRule, Long executeUserId, boolean isAddSync) {
            this.subModelNumber = subModelNumber;
            this.isSyncBizRule = isSyncBizRule;
            this.isSyncExamine = isSyncExamine;
            this.executeUserId = executeUserId;
            this.isAddSync = isAddSync;
        }

        public ModelSyncParam(String subModelNumber, boolean isSyncExamine, boolean isSyncBizRule, Long executeUserId, IFormView formView, boolean isAddSync) {
            this.subModelNumber = subModelNumber;
            this.isSyncBizRule = isSyncBizRule;
            this.isSyncExamine = isSyncExamine;
            this.executeUserId = executeUserId;
            this.isAddSync = isAddSync;
            this.formView = formView;
        }

        public ModelSyncParam(String subModelNumber, boolean isSyncExamine, boolean isSyncBizRule, Long executeUserId, IFormView formView) {
            this.subModelNumber = subModelNumber;
            this.isSyncBizRule = isSyncBizRule;
            this.isSyncExamine = isSyncExamine;
            this.executeUserId = executeUserId;
            this.formView = formView;
        }

        public boolean isSyncTemplate() {
            return this.isSyncTemplate;
        }

        public void setSyncTemplate(boolean syncTemplate) {
            this.isSyncTemplate = syncTemplate;
        }

        public boolean isSyncAdd() {
            return this.isSyncAdd;
        }

        public void setSyncAdd(boolean syncAdd) {
            this.isSyncAdd = syncAdd;
        }

        public boolean isSyncDelete() {
            return this.isSyncDelete;
        }

        public void setSyncDelete(boolean syncDelete) {
            this.isSyncDelete = syncDelete;
        }

        public boolean isSyncModify() {
            return this.isSyncModify;
        }

        public void setSyncModify(boolean syncModify) {
            this.isSyncModify = syncModify;
        }

        public boolean isAddSync() {
            return this.isAddSync;
        }

        public void setAddSync(boolean addSync) {
            this.isAddSync = addSync;
        }

        public IFormView getFormView() {
            return this.formView;
        }

        public void setFormView(IFormView formView) {
            this.formView = formView;
        }

        public Long getExecuteUserId() {
            return this.executeUserId;
        }

        public void setExecuteUserId(Long executeUserId) {
            this.executeUserId = executeUserId;
        }

        public String getSubModelNumber() {
            return this.subModelNumber;
        }

        public void setSubModelNumber(String subModelNumber) {
            this.subModelNumber = subModelNumber;
        }

        public boolean isSyncExamine() {
            return this.isSyncExamine;
        }

        public void setSyncExamine(boolean syncExamine) {
            this.isSyncExamine = syncExamine;
        }

        public boolean isSyncBizRule() {
            return this.isSyncBizRule;
        }

        public void setSyncBizRule(boolean syncBizRule) {
            this.isSyncBizRule = syncBizRule;
        }

        static /* synthetic */ Long access$100(ModelSyncParam x0) {
            return x0.executeUserId;
        }

        static /* synthetic */ boolean access$200(ModelSyncParam x0) {
            return x0.isAddSync;
        }

        static /* synthetic */ IFormView access$300(ModelSyncParam x0) {
            return x0.formView;
        }
    }

    private static class InnerClass {
        private static final BgmdMainSubModelSyncService instance = new BgmdMainSubModelSyncService();

        private InnerClass() {
        }
    }
}

