/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.sonmodel.sync.service;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.sonmodel.MainSubControlRangeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MainSubSyncSchemeService {
    private static final Log log = LogFactory.getLog(MainSubSyncSchemeService.class);
    private static final MainSubSyncSchemeService instance = new MainSubSyncSchemeService();
    public static final String CONTROLDIM = "controldim";
    public static final String CONTROLTYPE = "controltype";
    public static final String CONTROLRANGE = "controlrange";

    public static MainSubSyncSchemeService getInstance() {
        return instance;
    }

    public void initControlType(IFormView formView, Long mainModelId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (IDUtils.isEmptyLong((Long)mainModelId).booleanValue() || formView == null) {
            log.info("getControlDimNums return.");
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)mainModelId);
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name", (QFilter[])qFilter.toArray(), (String)"dseq");
        if (CollectionUtils.isNotEmpty((Collection)dimensions)) {
            for (DynamicObject dimension : dimensions) {
                String number = dimension.getString("number");
                if (SysDimensionEnum.getEnumByNumber((String)number) != null && !kd.epm.eb.common.utils.StringUtils.equals((String)number, (String)SysDimensionEnum.Entity.getNumber()) && !kd.epm.eb.common.utils.StringUtils.equals((String)number, (String)SysDimensionEnum.Account.getNumber())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(dimension.getString("name")));
                comboItem.setValue(number);
                items.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)formView.getControl(CONTROLTYPE);
            comboEdit.setComboItems(items);
        }
    }

    public void setControlDim(IFormView formView, String subModelNumber) {
        if (formView == null) {
            return;
        }
        formView.setVisible(Boolean.valueOf(false), new String[]{CONTROLRANGE, CONTROLTYPE});
        formView.getModel().setValue(CONTROLDIM, (Object)false);
        formView.getModel().setValue(CONTROLRANGE, (Object)MainSubControlRangeEnum.part_dim.getCode());
        if (StringUtils.isNotBlank((CharSequence)subModelNumber)) {
            QFilter qFilter = new QFilter("number", "=", (Object)subModelNumber);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_mainsubmodel_base", (String)"controldim,controltype,controlrange", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                formView.getModel().setValue(CONTROLDIM, (Object)false);
            } else {
                boolean controldim = dynamicObject.getBoolean(CONTROLDIM);
                formView.getModel().setValue(CONTROLDIM, (Object)controldim);
                if (controldim) {
                    formView.setVisible(Boolean.valueOf(true), new String[]{CONTROLRANGE});
                    String controlrange = dynamicObject.getString(CONTROLRANGE);
                    if (MainSubControlRangeEnum.all_dim.getCode().equals(controlrange) || MainSubControlRangeEnum.part_dim.getCode().equals(controlrange)) {
                        formView.getModel().setValue(CONTROLRANGE, (Object)controlrange);
                    }
                    if (MainSubControlRangeEnum.part_dim.getCode().equals(controlrange)) {
                        String controltype = dynamicObject.getString(CONTROLTYPE);
                        if (StringUtils.isNotBlank((CharSequence)controltype)) {
                            formView.getModel().setValue(CONTROLTYPE, (Object)controltype);
                        }
                        formView.setVisible(Boolean.valueOf(true), new String[]{CONTROLTYPE});
                    }
                }
            }
        }
    }

    public void controlDimPropChange(IFormView formView, Object newValue) {
        if (newValue instanceof Boolean && formView != null) {
            boolean controldim = (Boolean)newValue;
            if (controldim) {
                Object controlrange = formView.getModel().getValue(CONTROLRANGE);
                formView.setVisible(Boolean.valueOf(MainSubControlRangeEnum.part_dim.getCode().equals(controlrange)), new String[]{CONTROLTYPE});
                formView.setVisible(Boolean.valueOf(true), new String[]{CONTROLRANGE});
            } else {
                formView.setVisible(Boolean.valueOf(false), new String[]{CONTROLRANGE, CONTROLTYPE});
            }
        }
    }

    public void controlRangePropChange(IFormView formView, Object newValue) {
        if (newValue instanceof String && formView != null) {
            formView.setVisible(Boolean.valueOf(MainSubControlRangeEnum.part_dim.getCode().equals(newValue.toString())), new String[]{CONTROLTYPE});
        }
    }

    public String controlTypePropChange(Object newValue) {
        String result = null;
        if (newValue != null && StringUtils.isNotBlank((CharSequence)newValue.toString())) {
            result = newValue.toString().substring(1, newValue.toString().length() - 1);
        }
        return result;
    }

    public void setControlInfoToSave(DynamicObject toSaveObject, Boolean controlDim, String controlRange, String controlType) {
        if (toSaveObject == null) {
            return;
        }
        toSaveObject.set(CONTROLDIM, (Object)controlDim);
        if (controlDim != null && controlDim.booleanValue()) {
            toSaveObject.set(CONTROLRANGE, (Object)controlRange);
            if (MainSubControlRangeEnum.all_dim.getCode().equals(controlRange)) {
                controlType = "";
            }
            toSaveObject.set(CONTROLTYPE, (Object)controlType);
        } else {
            toSaveObject.set(CONTROLTYPE, (Object)"");
            toSaveObject.set(CONTROLRANGE, (Object)MainSubControlRangeEnum.part_dim.getCode());
        }
    }
}

