/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.common.utils.task.TaskDispatchService;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgMyTaskTransferRecordPlugin
extends AbstractFormPlugin {
    protected static final Log log = LogFactory.getLog(BgMyTaskTransferRecordPlugin.class);
    private static final String BTN_AUDIT = "btn_audit";
    private static final String BTN_UNAUDIT = "btn_unaudit";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setUserInfo();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_AUDIT, BTN_UNAUDIT});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_AUDIT.equals(itemKey)) {
            Long transferUserId = this.getModel().getDataEntity().getLong("transfer_user.id");
            DynamicObject[] taskProcessArr = this.getTaskProcessList();
            HashSet<String> auditTaskSet = new HashSet<String>(taskProcessArr.length);
            for (DynamicObject taskProcess : taskProcessArr) {
                DynamicObjectCollection executors = taskProcess.getDynamicObjectCollection("executors");
                Set oldExecutorIds = executors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
                if (oldExecutorIds.contains(transferUserId)) continue;
                String taskName = taskProcess.getString("task.name");
                String orgName = taskProcess.getString("org.name");
                auditTaskSet.add(taskName + "-" + orgName);
            }
            if (!auditTaskSet.isEmpty()) {
                String msg = String.join((CharSequence)",", auditTaskSet);
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u4efb\u52a1\uff1a%1\uff0c\u6267\u884c\u4eba\u5df2\u53d8\u66f4\uff0c\u65e0\u6cd5\u8f6c\u4ea4\u3002", (String)"BgMyTaskTransferRecordPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{msg}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pass_confirm", (IFormPlugin)this));
            } else {
                this.doPass();
            }
        } else if (BTN_UNAUDIT.equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("eb_tasktransfer_reject");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u8bf4\u660e", (String)"BgMyTaskTransferRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reject_callback"));
            this.getView().showForm(parameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("reject_callback".equals(actionId)) {
            this.updateBillStatus(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_AUDIT, BTN_UNAUDIT});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9a73\u56de\u6210\u529f\u3002", (String)"BgMyTaskTransferRecordPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            String taskPackageNames = this.getTaskPackageNames();
            EpmThreadPools.CommPools.execute(() -> this.sendMessage(false, taskPackageNames, (String)returnData));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("pass_confirm".equals(callBackId) && MessageBoxResult.Yes == result) {
            this.doPass();
        }
    }

    private void updateBillStatus(boolean isPass) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set("billstatus", (Object)(isPass ? "B" : "C"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private void doPass() {
        this.updateTaskExecutor();
        this.updateTaskDecoExecutor();
        this.updateBillStatus(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_AUDIT, BTN_UNAUDIT});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u610f\u6210\u529f\u3002", (String)"BgMyTaskTransferRecordPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String taskPackageNames = this.getTaskPackageNames();
        this.saveLog(taskPackageNames);
        EpmThreadPools.CommPools.execute(() -> this.sendMessage(true, taskPackageNames, ""));
    }

    private String getTaskPackageNames() {
        DynamicObjectCollection entityRows = this.getModel().getEntryEntity("entryentity");
        HashSet<String> taskPackageNameSet = new HashSet<String>(entityRows.size());
        for (DynamicObject entityRow : entityRows) {
            taskPackageNameSet.add(entityRow.getString("task_package.name"));
        }
        return String.join((CharSequence)",", taskPackageNameSet);
    }

    private void saveLog(String taskPackageNames) {
        Long transferUserId = this.getModel().getDataEntity().getLong("transfer_user.id");
        UserInfo transferUser = UserUtils.getUserInfo((Long)transferUserId);
        String transferUserName = transferUser == null ? "" : transferUser.getName();
        this.writeLog(null, "save", new MultiLangEnumBridge("\u6211\u6267\u884c\u7684\u4efb\u52a1\u8f6c\u4ea4", "BgMyTaskTransferRecordPlugin_9", "epm-eb-formplugin"), new MultiLangEnumBridge("%1$s\u540c\u610f\u4e86%2$s\u8f6c\u4ea4\u7684\u4efb\u52a1%3$s", "BgMyTaskTransferRecordPlugin_10", "epm-eb-formplugin"), new String[]{RequestContext.get().getUserName(), transferUserName, taskPackageNames});
    }

    private void updateTaskExecutor() {
        DynamicObject[] taskProcessArr;
        Long transferUserId = this.getModel().getDataEntity().getLong("transfer_user.id");
        Long executorId = this.getModel().getDataEntity().getLong("executor.id");
        for (DynamicObject taskProcess : taskProcessArr = this.getTaskProcessList()) {
            DynamicObjectCollection executors = taskProcess.getDynamicObjectCollection("executors");
            Set oldExecutorIds = executors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!oldExecutorIds.remove(transferUserId)) {
                log.info("[BgMyTaskTransferRecordPlugin] taskProcess#{} old executors not contains transferUser#{}", (Object)taskProcess.getLong("id"), (Object)transferUserId);
                continue;
            }
            executors.clear();
            oldExecutorIds.add(executorId);
            for (Long userid : oldExecutorIds) {
                DynamicObject executor = executors.addNew();
                executor.set("fbasedataid_id", (Object)userid);
            }
        }
        SaveServiceHelper.save((DynamicObject[])taskProcessArr);
    }

    private void updateTaskDecoExecutor() {
        Long transferUserId = this.getModel().getDataEntity().getLong("transfer_user.id");
        Long executorId = this.getModel().getDataEntity().getLong("executor.id");
        DynamicObjectCollection entityRows = this.getModel().getEntryEntity("entryentity");
        HashSet<String> taskOrgSet = new HashSet<String>(entityRows.size());
        for (DynamicObject entityRow : entityRows) {
            Long taskId = entityRow.getLong("task.id");
            Long orgId = entityRow.getLong("entity.id");
            taskOrgSet.add(taskId + "_" + orgId);
        }
        HashSet<Long> oldExecutors = new HashSet<Long>(1);
        oldExecutors.add(transferUserId);
        TaskDecomposeService taskDecomposeService = TaskDecomposeService.getInstance();
        List decomposeIds = taskDecomposeService.queryDecomposeByTaskAndOrg(taskOrgSet);
        taskDecomposeService.updateDecompose(oldExecutors, executorId, decomposeIds);
        taskDecomposeService.updateApproveBill(decomposeIds, executorId, (Set)Sets.newHashSet((Object[])new Long[]{transferUserId}));
        TaskDispatchService.getInstance().updateTaskDispatchExecutors(oldExecutors, executorId, taskOrgSet);
    }

    private void setUserInfo() {
        String position;
        DynamicObject user = (DynamicObject)this.getModel().getValue("transfer_user");
        if (user == null) {
            return;
        }
        Long userId = user.getLong("id");
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        Image pic = (Image)this.getControl("userpic");
        pic.setUrl((String)userPics.get(userId));
        String phone = user.getString("phone");
        Label phoneLab = (Label)this.getControl("lab_phone");
        phoneLab.setText(phone);
        DynamicObjectCollection entryColl = user.getDynamicObjectCollection("entryentity");
        if (entryColl.isEmpty()) {
            return;
        }
        DynamicObject department = ((DynamicObject)entryColl.get(0)).getDynamicObject("dpt");
        if (department == null) {
            return;
        }
        Label deptLab = (Label)this.getControl("lab_dept");
        deptLab.setText(department.getString("name"));
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)department.getLong("id"));
        if (company != null) {
            Label companyLab = (Label)this.getControl("lab_company");
            companyLab.setText((String)company.get("name"));
        }
        if ((position = ((DynamicObject)entryColl.get(0)).getString("position")) != null) {
            Label positionLab = (Label)this.getControl("lab_position");
            positionLab.setText(position);
        }
    }

    private void sendMessage(boolean isPass, String taskPackageNames, String rejectReason) {
        LocaleString title = new LocaleString();
        title.setLocaleValue(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u5236\u4efb\u52a1\u8f6c\u4ea4\u7ed3\u679c", (String)"BgMyTaskTransferRecordPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        StringBuilder msgContent = new StringBuilder();
        if (isPass) {
            msgContent.append(ResManager.loadResFormat((String)"%1\u540c\u610f\u4e86%2\u7684\u4efb\u52a1\u8f6c\u4ea4", (String)"BgMyTaskTransferRecordPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName(), taskPackageNames}));
        } else {
            msgContent.append(ResManager.loadResFormat((String)"%1\u9a73\u56de\u4e86%2\u7684\u4efb\u52a1\u8f6c\u4ea4", (String)"BgMyTaskTransferRecordPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName(), taskPackageNames})).append("\n");
            msgContent.append(ResManager.loadResFormat((String)"\u9a73\u56de\u539f\u56e0\uff1a%1", (String)"BgMyTaskTransferRecordPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{rejectReason}));
        }
        LocaleString content = new LocaleString();
        content.setLocaleValue(msgContent.toString());
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u4ea4", (String)"BgTaskTransferSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Long transferUserId = this.getModel().getDataEntity().getLong("transfer_user.id");
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(transferUserId);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setMessageTag((ILocaleString)tag);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private DynamicObject[] getTaskProcessList() {
        DynamicObjectCollection entityRows = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> taskIds = new HashSet<Long>(entityRows.size());
        HashSet<Long> orgIds = new HashSet<Long>(entityRows.size());
        for (DynamicObject entityRow : entityRows) {
            Long taskId = entityRow.getLong("task.id");
            taskIds.add(taskId);
            Long orgId = entityRow.getLong("entity.id");
            orgIds.add(orgId);
        }
        QFilter qFilter = new QFilter("task.id", "in", taskIds);
        qFilter.and(new QFilter("org.id", "in", orgIds));
        return BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"task.id,task.name,org.id,org.name,executors", (QFilter[])qFilter.toArray());
    }
}

